/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2019-10-23 09:55:13 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_frmt_form_entry` (
  `entry_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `form_id` bigint(20) unsigned NOT NULL,
  `is_spam` tinyint(1) NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`entry_id`),
  KEY `entry_is_spam` (`is_spam`),
  KEY `entry_type` (`entry_type`),
  KEY `entry_form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_frmt_form_entry_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`),
  KEY `meta_entry_id` (`entry_id`),
  KEY `meta_key_object` (`entry_id`,`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_frmt_form_views` (
  `view_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned NOT NULL,
  `page_id` bigint(20) unsigned NOT NULL,
  `ip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`view_id`),
  KEY `view_form_id` (`form_id`),
  KEY `view_ip` (`ip`),
  KEY `view_form_object` (`form_id`,`view_id`),
  KEY `view_form_object_ip` (`form_id`,`view_id`,`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=197 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2825 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2488 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "WordPress komentátor", "wapuu@wordpress.example", "https://wordpress.org/", "", "2019-08-20 11:24:57", "2019-08-20 09:24:57", "Zdravím, tohle je komentář.\nChcete-li začít se schvalováním, úpravami a mazáním komentářů, pak si prohlédněte sekci Komentáře na nástěnce.\nProfilové obrázky komentujících vám přináší služba <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("4", "20190827_bavseastuduj", "0b1f6ef6232dc0275294_20190828115042", "100", "2019-08-28 11:51:06", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-08-28 11:50:42\";s:7:\"Version\";s:6:\"1.3.18\";s:9:\"VersionWP\";s:5:\"5.2.2\";s:9:\"VersionDB\";s:7:\"10.1.19\";s:10:\"VersionPHP\";s:5:\"7.3.1\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:21:\"20190827_bavseastuduj\";s:4:\"Hash\";s:35:\"0b1f6ef6232dc0275294_20190828115042\";s:8:\"NameHash\";s:57:\"20190827_bavseastuduj_0b1f6ef6232dc0275294_20190828115042\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:78:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://bavse.pulary.cz/wp-snapshots/\";s:8:\"ScanFile\";s:67:\"20190827_bavseastuduj_0b1f6ef6232dc0275294_20190828115042_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"42.50 sec.\";s:7:\"ExeSize\";s:7:\"59.37KB\";s:7:\"ZipSize\";s:7:\"45.87MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:69:\"20190827_bavseastuduj_0b1f6ef6232dc0275294_20190828115042_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:61:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz\";s:4:\"Size\";i:48092965;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:5024;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:70:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-admin\";i:1;s:80:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/uploads\";i:2;s:82:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/languages\";i:3;s:79:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/themes\";i:4;s:73:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:61:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz\";i:1;s:72:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:73:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:71:\"20190827_bavseastuduj_0b1f6ef6232dc0275294_20190828115042_installer.php\";s:4:\"Size\";i:60796;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:736280;s:4:\"File\";s:70:\"20190827_bavseastuduj_0b1f6ef6232dc0275294_20190828115042_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:2:{i:0;s:18:\"utf8mb4_unicode_ci\";i:1;s:17:\"latin1_swedish_ci\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:13:\"d159802_bavse\";s:15:\"tablesBaseCount\";i:16;s:16:\"tablesFinalCount\";i:16;s:14:\"tablesRowCount\";s:5:\"1,544\";s:16:\"tablesSizeOnDisk\";s:6:\"1.63MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:7:\"10.1.19\";s:14:\"versionComment\";s:19:\"Source distribution\";s:18:\"tableWiseRowCounts\";a:16:{s:14:\"wp_commentmeta\";s:1:\"0\";s:11:\"wp_comments\";s:1:\"1\";s:22:\"wp_duplicator_packages\";s:1:\"1\";s:18:\"wp_frmt_form_entry\";s:1:\"3\";s:23:\"wp_frmt_form_entry_meta\";s:1:\"3\";s:18:\"wp_frmt_form_views\";s:3:\"169\";s:8:\"wp_links\";s:1:\"0\";s:10:\"wp_options\";s:3:\"160\";s:11:\"wp_postmeta\";s:4:\"1092\";s:8:\"wp_posts\";s:2:\"86\";s:21:\"wp_term_relationships\";s:1:\"1\";s:16:\"wp_term_taxonomy\";s:1:\"1\";s:11:\"wp_termmeta\";s:1:\"0\";s:8:\"wp_terms\";s:1:\"1\";s:11:\"wp_usermeta\";s:2:\"36\";s:8:\"wp_users\";s:1:\"2\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:149:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-snapshots/tmp/20190827_bavseastuduj_0b1f6ef6232dc0275294_20190828115042_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-08-28 11:50:42\";s:7:\"Version\";s:6:\"1.3.18\";s:9:\"VersionWP\";s:5:\"5.2.2\";s:9:\"VersionDB\";s:7:\"10.1.19\";s:10:\"VersionPHP\";s:5:\"7.3.1\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20190827_bavseastuduj\";s:4:\"Hash\";s:35:\"0b1f6ef6232dc0275294_20190828115042\";s:8:\"NameHash\";s:57:\"20190827_bavseastuduj_0b1f6ef6232dc0275294_20190828115042\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:78:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://bavse.pulary.cz/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";r:76;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:137;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("5", "20190827_bavseastuduj", "035c2581335d5fa32920_20191023095446", "21", "2019-10-23 09:55:13", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-10-23 09:54:46\";s:7:\"Version\";s:6:\"1.3.22\";s:9:\"VersionWP\";s:5:\"5.2.4\";s:9:\"VersionDB\";s:7:\"10.1.19\";s:10:\"VersionPHP\";s:5:\"7.3.1\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:5;s:4:\"Name\";s:21:\"20190827_bavseastuduj\";s:4:\"Hash\";s:35:\"035c2581335d5fa32920_20191023095446\";s:8:\"NameHash\";s:57:\"20190827_bavseastuduj_035c2581335d5fa32920_20191023095446\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:78:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://bavse.pulary.cz/wp-snapshots/\";s:8:\"ScanFile\";s:67:\"20190827_bavseastuduj_035c2581335d5fa32920_20191023095446_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.3\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:69:\"20190827_bavseastuduj_035c2581335d5fa32920_20191023095446_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:61:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-10-23 09:54:46\";s:7:\"Version\";s:6:\"1.3.22\";s:9:\"VersionWP\";s:5:\"5.2.4\";s:9:\"VersionDB\";s:7:\"10.1.19\";s:10:\"VersionPHP\";s:5:\"7.3.1\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20190827_bavseastuduj\";s:4:\"Hash\";s:35:\"035c2581335d5fa32920_20191023095446\";s:8:\"NameHash\";s:57:\"20190827_bavseastuduj_035c2581335d5fa32920_20191023095446\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:78:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://bavse.pulary.cz/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:71:\"20190827_bavseastuduj_035c2581335d5fa32920_20191023095446_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:70:\"20190827_bavseastuduj_035c2581335d5fa32920_20191023095446_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:1:{s:14:\"wp_commentmeta\";s:1:\"0\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:149:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-snapshots/tmp/20190827_bavseastuduj_035c2581335d5fa32920_20191023095446_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:70:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-admin\";i:1;s:80:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/uploads\";i:2;s:82:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/languages\";i:3;s:79:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/themes\";i:4;s:73:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:61:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz\";i:1;s:72:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content\";}}s:9:\"Installer\";r:86;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:130;}");

/* INSERT TABLE DATA: wp_frmt_form_entry */
INSERT INTO `wp_frmt_form_entry` VALUES("1", "quizzes", "63", "0", "2019-08-21 15:03:37");
INSERT INTO `wp_frmt_form_entry` VALUES("2", "quizzes", "63", "0", "2019-08-21 15:20:37");
INSERT INTO `wp_frmt_form_entry` VALUES("3", "quizzes", "63", "0", "2019-08-27 12:40:29");
INSERT INTO `wp_frmt_form_entry` VALUES("4", "quizzes", "63", "0", "2019-09-09 20:26:40");

/* INSERT TABLE DATA: wp_frmt_form_entry_meta */
INSERT INTO `wp_frmt_form_entry_meta` VALUES("1", "1", "entry", "a:3:{i:0;a:3:{s:8:\"question\";s:9:\"Otázka 1\";s:6:\"answer\";s:1:\"2\";s:9:\"isCorrect\";b:0;}i:1;a:3:{s:8:\"question\";s:9:\"Otázka 2\";s:6:\"answer\";s:1:\"2\";s:9:\"isCorrect\";b:1;}i:2;a:3:{s:8:\"question\";s:9:\"Otázka 3\";s:6:\"answer\";s:1:\"1\";s:9:\"isCorrect\";b:1;}}", "2019-08-21 15:03:37", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_entry_meta` VALUES("2", "2", "entry", "a:3:{i:0;a:3:{s:8:\"question\";s:9:\"Otázka 1\";s:6:\"answer\";s:1:\"1\";s:9:\"isCorrect\";b:0;}i:1;a:3:{s:8:\"question\";s:9:\"Otázka 2\";s:6:\"answer\";s:1:\"3\";s:9:\"isCorrect\";b:0;}i:2;a:3:{s:8:\"question\";s:9:\"Otázka 3\";s:6:\"answer\";s:1:\"1\";s:9:\"isCorrect\";b:1;}}", "2019-08-21 15:20:37", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_entry_meta` VALUES("3", "3", "entry", "a:3:{i:0;a:3:{s:8:\"question\";s:9:\"Otázka 1\";s:6:\"answer\";s:1:\"1\";s:9:\"isCorrect\";b:0;}i:1;a:3:{s:8:\"question\";s:9:\"Otázka 2\";s:6:\"answer\";s:1:\"2\";s:9:\"isCorrect\";b:1;}i:2;a:3:{s:8:\"question\";s:9:\"Otázka 3\";s:6:\"answer\";s:1:\"3\";s:9:\"isCorrect\";b:0;}}", "2019-08-27 12:40:29", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_entry_meta` VALUES("4", "4", "entry", "a:3:{i:0;a:3:{s:8:\"question\";s:9:\"Otázka 1\";s:6:\"answer\";s:1:\"1\";s:9:\"isCorrect\";b:0;}i:1;a:3:{s:8:\"question\";s:9:\"Otázka 2\";s:6:\"answer\";s:1:\"2\";s:9:\"isCorrect\";b:1;}i:2;a:3:{s:8:\"question\";s:9:\"Otázka 3\";s:6:\"answer\";s:1:\"1\";s:9:\"isCorrect\";b:1;}}", "2019-09-09 20:26:40", "0000-00-00 00:00:00");

/* INSERT TABLE DATA: wp_frmt_form_views */
INSERT INTO `wp_frmt_form_views` VALUES("1", "62", "8", NULL, "1", "2019-08-21 15:00:04", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("2", "62", "8", NULL, "1", "2019-08-21 15:00:12", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("3", "63", "8", NULL, "50", "2019-08-21 15:03:29", "2019-08-22 13:16:53");
INSERT INTO `wp_frmt_form_views` VALUES("4", "63", "8", NULL, "1", "2019-08-21 15:03:53", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("5", "63", "8", NULL, "13", "2019-08-23 08:55:23", "2019-08-23 12:59:49");
INSERT INTO `wp_frmt_form_views` VALUES("6", "63", "8", NULL, "1", "2019-08-23 08:57:15", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("7", "63", "8", NULL, "1", "2019-08-23 08:57:42", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("8", "63", "8", NULL, "193", "2019-08-27 09:26:44", "2019-08-28 08:15:39");
INSERT INTO `wp_frmt_form_views` VALUES("9", "63", "8", NULL, "1", "2019-08-27 09:27:23", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("10", "63", "8", NULL, "1", "2019-08-27 09:27:56", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("11", "63", "8", NULL, "1", "2019-08-27 09:28:47", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("12", "63", "8", NULL, "1", "2019-08-27 09:29:55", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("13", "63", "8", NULL, "1", "2019-08-27 09:30:20", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("14", "63", "8", NULL, "1", "2019-08-27 09:30:42", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("15", "63", "8", NULL, "1", "2019-08-27 09:30:45", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("16", "63", "8", NULL, "1", "2019-08-27 09:31:22", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("17", "63", "8", NULL, "1", "2019-08-27 09:32:49", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("18", "63", "8", NULL, "1", "2019-08-27 09:33:11", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("19", "63", "8", NULL, "1", "2019-08-27 09:33:24", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("20", "63", "8", NULL, "1", "2019-08-27 09:33:42", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("21", "63", "8", NULL, "1", "2019-08-27 09:33:48", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("22", "63", "8", NULL, "1", "2019-08-27 09:33:58", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("23", "63", "8", NULL, "1", "2019-08-27 09:34:06", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("24", "63", "8", NULL, "1", "2019-08-27 09:34:40", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("25", "63", "8", NULL, "1", "2019-08-27 09:35:25", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("26", "63", "8", NULL, "2", "2019-08-27 10:17:24", "2019-08-28 11:52:11");
INSERT INTO `wp_frmt_form_views` VALUES("27", "63", "8", NULL, "1", "2019-08-27 10:18:08", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("28", "63", "8", NULL, "1", "2019-08-27 10:19:04", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("29", "63", "8", NULL, "1", "2019-08-27 10:19:37", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("30", "63", "8", NULL, "1", "2019-08-27 10:19:46", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("31", "63", "8", NULL, "1", "2019-08-27 10:20:34", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("32", "63", "8", NULL, "1", "2019-08-27 10:20:47", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("33", "63", "8", NULL, "1", "2019-08-27 10:20:58", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("34", "63", "8", NULL, "1", "2019-08-27 10:21:04", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("35", "63", "8", NULL, "1", "2019-08-27 10:21:22", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("36", "63", "8", NULL, "1", "2019-08-27 10:21:52", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("37", "63", "8", NULL, "1", "2019-08-27 10:22:04", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("38", "63", "8", NULL, "1", "2019-08-27 10:22:29", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("39", "63", "8", NULL, "1", "2019-08-27 10:24:14", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("40", "63", "8", NULL, "1", "2019-08-27 10:24:28", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("41", "63", "8", NULL, "1", "2019-08-27 10:24:45", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("42", "63", "8", NULL, "1", "2019-08-27 10:24:52", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("43", "63", "8", NULL, "1", "2019-08-27 10:25:14", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("44", "63", "8", NULL, "1", "2019-08-27 10:25:27", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("45", "63", "8", NULL, "1", "2019-08-27 10:25:45", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("46", "63", "8", NULL, "1", "2019-08-27 10:25:58", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("47", "63", "8", NULL, "1", "2019-08-27 10:26:14", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("48", "63", "8", NULL, "1", "2019-08-27 10:26:46", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("49", "63", "8", NULL, "1", "2019-08-27 10:29:15", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("50", "63", "8", NULL, "1", "2019-08-27 10:29:37", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("51", "63", "8", NULL, "1", "2019-08-27 10:30:00", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("52", "63", "8", NULL, "1", "2019-08-27 10:30:23", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("53", "63", "8", NULL, "1", "2019-08-27 10:31:14", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("54", "63", "8", NULL, "1", "2019-08-27 10:31:27", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("55", "63", "8", NULL, "1", "2019-08-27 10:31:43", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("56", "63", "8", NULL, "1", "2019-08-27 10:32:10", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("57", "63", "8", NULL, "1", "2019-08-27 10:32:51", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("58", "63", "8", NULL, "1", "2019-08-27 10:33:23", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("59", "63", "8", NULL, "1", "2019-08-27 10:33:37", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("60", "63", "8", NULL, "1", "2019-08-27 10:34:05", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("61", "63", "8", NULL, "1", "2019-08-27 10:35:07", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("62", "63", "8", NULL, "1", "2019-08-27 10:35:36", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("63", "63", "8", NULL, "1", "2019-08-27 10:36:32", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("64", "63", "8", NULL, "1", "2019-08-27 10:37:18", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("65", "63", "8", NULL, "1", "2019-08-27 10:37:54", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("66", "63", "8", NULL, "1", "2019-08-27 10:38:05", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("67", "63", "8", NULL, "1", "2019-08-27 10:38:14", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("68", "63", "8", NULL, "1", "2019-08-27 10:38:43", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("69", "63", "8", NULL, "1", "2019-08-27 10:38:59", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("70", "63", "8", NULL, "1", "2019-08-27 10:39:34", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("71", "63", "8", NULL, "1", "2019-08-27 10:39:44", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("72", "63", "8", NULL, "1", "2019-08-27 10:39:51", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("73", "63", "8", NULL, "1", "2019-08-27 10:40:20", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("74", "63", "8", NULL, "1", "2019-08-27 10:40:54", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("75", "63", "8", NULL, "1", "2019-08-27 10:41:09", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("76", "63", "8", NULL, "1", "2019-08-27 10:41:37", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("77", "63", "8", NULL, "1", "2019-08-27 10:41:52", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("78", "63", "8", NULL, "1", "2019-08-27 10:42:03", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("79", "63", "8", NULL, "1", "2019-08-27 10:42:30", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("80", "63", "8", NULL, "1", "2019-08-27 10:44:02", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("81", "63", "8", NULL, "1", "2019-08-27 10:45:33", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("82", "63", "8", NULL, "1", "2019-08-27 10:45:36", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("83", "63", "8", NULL, "1", "2019-08-27 10:47:05", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("84", "63", "8", NULL, "1", "2019-08-27 10:47:08", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("85", "63", "8", NULL, "1", "2019-08-27 10:47:23", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("86", "63", "8", NULL, "1", "2019-08-27 10:47:29", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("87", "63", "8", NULL, "1", "2019-08-27 10:49:02", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("88", "63", "8", NULL, "1", "2019-08-27 10:49:14", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("89", "63", "8", NULL, "1", "2019-08-27 10:49:27", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("90", "63", "8", NULL, "1", "2019-08-27 10:50:02", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("91", "63", "8", NULL, "1", "2019-08-27 10:50:12", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("92", "63", "8", NULL, "1", "2019-08-27 10:50:51", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("93", "63", "8", NULL, "1", "2019-08-27 10:51:02", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("94", "63", "8", NULL, "1", "2019-08-27 10:51:19", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("95", "63", "8", NULL, "1", "2019-08-27 10:51:54", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("96", "63", "8", NULL, "1", "2019-08-27 10:52:48", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("97", "63", "8", NULL, "1", "2019-08-27 10:53:10", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("98", "63", "8", NULL, "1", "2019-08-27 10:53:23", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("99", "63", "8", NULL, "1", "2019-08-27 10:53:42", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("100", "63", "8", NULL, "1", "2019-08-27 10:54:30", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("101", "63", "8", NULL, "1", "2019-08-27 10:54:44", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("102", "63", "8", NULL, "1", "2019-08-27 10:55:13", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("103", "63", "8", NULL, "1", "2019-08-27 10:55:16", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("104", "63", "8", NULL, "1", "2019-08-27 10:55:35", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("105", "63", "8", NULL, "1", "2019-08-27 10:55:43", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("106", "63", "8", NULL, "1", "2019-08-27 10:55:59", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("107", "63", "8", NULL, "1", "2019-08-27 10:56:06", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("108", "63", "8", NULL, "1", "2019-08-27 10:56:22", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("109", "63", "8", NULL, "1", "2019-08-27 10:56:37", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("110", "63", "8", NULL, "1", "2019-08-27 10:57:26", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("111", "63", "8", NULL, "1", "2019-08-27 10:58:09", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("112", "63", "8", NULL, "1", "2019-08-27 10:58:24", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("113", "63", "8", NULL, "1", "2019-08-27 10:58:45", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("114", "63", "8", NULL, "1", "2019-08-27 10:59:37", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("115", "63", "8", NULL, "1", "2019-08-27 10:59:49", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("116", "63", "8", NULL, "1", "2019-08-27 11:00:03", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("117", "63", "8", NULL, "1", "2019-08-27 11:00:29", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("118", "63", "8", NULL, "1", "2019-08-27 11:00:46", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("119", "63", "8", NULL, "1", "2019-08-27 11:01:03", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("120", "63", "8", NULL, "1", "2019-08-27 11:01:15", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("121", "63", "8", NULL, "1", "2019-08-27 11:01:25", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("122", "63", "8", NULL, "1", "2019-08-27 11:02:05", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("123", "63", "8", NULL, "1", "2019-08-27 11:02:12", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("124", "63", "8", NULL, "1", "2019-08-27 11:02:22", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("125", "63", "8", NULL, "1", "2019-08-27 11:02:31", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("126", "63", "8", NULL, "1", "2019-08-27 11:02:39", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("127", "63", "8", NULL, "1", "2019-08-27 11:02:49", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("128", "63", "8", NULL, "1", "2019-08-27 11:02:56", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("129", "63", "8", NULL, "1", "2019-08-27 11:03:04", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("130", "63", "8", NULL, "1", "2019-08-27 11:03:14", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("131", "63", "8", NULL, "1", "2019-08-27 11:03:25", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("132", "63", "8", NULL, "1", "2019-08-27 11:03:56", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("133", "63", "8", NULL, "1", "2019-08-27 11:11:48", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("134", "63", "8", NULL, "1", "2019-08-27 11:11:53", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("135", "63", "8", NULL, "1", "2019-08-27 11:12:35", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("136", "63", "8", NULL, "1", "2019-08-27 11:13:03", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("137", "63", "8", NULL, "1", "2019-08-27 11:13:17", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("138", "63", "8", NULL, "1", "2019-08-27 11:13:52", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("139", "63", "8", NULL, "1", "2019-08-27 11:14:09", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("140", "63", "8", NULL, "1", "2019-08-27 11:14:28", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("141", "63", "8", NULL, "1", "2019-08-27 11:14:47", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("142", "63", "8", NULL, "1", "2019-08-27 11:15:19", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("143", "63", "8", NULL, "1", "2019-08-27 11:16:39", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("144", "63", "8", NULL, "1", "2019-08-27 11:17:10", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("145", "63", "8", NULL, "1", "2019-08-27 11:17:29", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("146", "63", "8", NULL, "1", "2019-08-27 11:18:02", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("147", "63", "8", NULL, "1", "2019-08-27 11:18:47", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("148", "63", "8", NULL, "1", "2019-08-27 11:19:11", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("149", "63", "8", NULL, "1", "2019-08-27 11:19:59", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("150", "63", "8", NULL, "1", "2019-08-27 11:20:44", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("151", "63", "8", NULL, "1", "2019-08-27 11:20:57", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("152", "63", "8", NULL, "1", "2019-08-27 11:21:12", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("153", "63", "8", NULL, "1", "2019-08-27 11:21:36", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("154", "63", "8", NULL, "1", "2019-08-27 11:21:38", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("155", "63", "8", NULL, "1", "2019-08-27 11:22:05", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("156", "63", "8", NULL, "1", "2019-08-27 11:22:21", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("157", "63", "8", NULL, "1", "2019-08-27 11:22:56", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("158", "63", "8", NULL, "1", "2019-08-27 11:23:06", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("159", "63", "8", NULL, "1", "2019-08-27 11:23:14", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("160", "63", "8", NULL, "1", "2019-08-27 11:23:27", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("161", "63", "8", NULL, "1", "2019-08-27 11:23:50", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("162", "63", "8", NULL, "1", "2019-08-27 11:24:22", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("163", "63", "8", NULL, "1", "2019-08-27 11:24:45", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("164", "63", "8", NULL, "1", "2019-08-27 11:24:53", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("165", "63", "8", NULL, "1", "2019-08-27 11:25:09", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("166", "63", "8", NULL, "1", "2019-08-27 11:25:18", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("167", "63", "8", NULL, "1", "2019-08-27 11:26:28", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("168", "63", "8", NULL, "1", "2019-08-27 11:26:38", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("169", "63", "8", NULL, "3", "2019-08-28 13:47:20", "2019-08-28 20:49:08");
INSERT INTO `wp_frmt_form_views` VALUES("170", "63", "8", NULL, "8", "2019-09-01 20:45:32", "2019-09-02 21:14:45");
INSERT INTO `wp_frmt_form_views` VALUES("171", "63", "8", NULL, "3", "2019-09-03 08:31:15", "2019-09-04 07:53:35");
INSERT INTO `wp_frmt_form_views` VALUES("172", "63", "8", NULL, "1", "2019-09-03 09:06:32", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("173", "63", "8", NULL, "1", "2019-09-05 12:22:22", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("174", "63", "8", NULL, "5", "2019-09-08 10:13:48", "2019-09-09 09:33:56");
INSERT INTO `wp_frmt_form_views` VALUES("175", "63", "8", NULL, "9", "2019-09-09 13:00:47", "2019-09-10 09:52:02");
INSERT INTO `wp_frmt_form_views` VALUES("176", "63", "8", NULL, "1", "2019-09-09 13:52:56", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("177", "63", "8", NULL, "22", "2019-09-10 22:45:14", "2019-09-11 21:49:23");
INSERT INTO `wp_frmt_form_views` VALUES("178", "63", "8", NULL, "1", "2019-09-12 10:46:48", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("179", "63", "8", NULL, "1", "2019-09-13 13:15:11", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("180", "63", "8", NULL, "4", "2019-09-16 14:56:36", "2019-09-17 13:17:52");
INSERT INTO `wp_frmt_form_views` VALUES("181", "63", "8", NULL, "1", "2019-09-16 14:57:04", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("182", "63", "8", NULL, "1", "2019-09-16 16:35:44", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("183", "63", "8", NULL, "2", "2019-09-18 21:03:43", "2019-09-19 12:06:13");
INSERT INTO `wp_frmt_form_views` VALUES("184", "63", "8", NULL, "1", "2019-09-24 12:07:09", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("185", "63", "8", NULL, "1", "2019-09-24 12:07:28", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("186", "63", "8", NULL, "1", "2019-09-24 12:07:33", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("187", "63", "8", NULL, "1", "2019-09-29 16:54:40", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("188", "63", "8", NULL, "23", "2019-10-01 09:24:41", "2019-10-02 10:11:23");
INSERT INTO `wp_frmt_form_views` VALUES("189", "63", "8", NULL, "3", "2019-10-02 15:27:49", "2019-10-02 20:25:44");
INSERT INTO `wp_frmt_form_views` VALUES("190", "63", "8", NULL, "1", "2019-10-04 08:18:10", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("191", "63", "8", NULL, "4", "2019-10-07 20:47:29", "2019-10-08 15:55:14");
INSERT INTO `wp_frmt_form_views` VALUES("192", "63", "8", NULL, "1", "2019-10-07 20:49:51", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("193", "63", "8", NULL, "1", "2019-10-07 21:05:56", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("194", "63", "8", NULL, "5", "2019-10-09 13:06:38", "2019-10-10 11:19:18");
INSERT INTO `wp_frmt_form_views` VALUES("195", "63", "8", NULL, "1", "2019-10-09 13:18:54", "0000-00-00 00:00:00");
INSERT INTO `wp_frmt_form_views` VALUES("196", "63", "8", NULL, "2", "2019-10-10 16:01:35", "2019-10-11 10:09:51");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://bavse.pulary.cz", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://bavse.pulary.cz", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Bav se a studuj", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "SPŠ a OA Bruntál", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "pavelkocan@pulary.cz", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j. n. Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "G:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "j. n. Y, G:i", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:97:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:18:\"^entries/([^/]+)/?\";s:29:\"index.php?entries=$matches[1]\";s:42:\"archives/(\\d+)(?:/(\\d+))?/entries/(\\d+)/?$\";s:60:\"index.php?p=$matches[1]&page=$matches[2]&entries=$matches[3]\";s:38:\"(.?.+?)(?:/([0-9]+))?/entries/(\\d+)/?$\";s:60:\"index.php?p=$matches[1]&page=$matches[2]&entries=$matches[3]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/entries/(\\d+)/?$\";s:101:\"index.php?year=$matches[1]&monthnum=$matches[2]&name=$matches[3]&page=$matches[4]&entries=$matches[5]\";s:75:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/entries/(\\d+)/?$\";s:117:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]&entries=$matches[6]\";s:26:\"(.?.+?)/entries(/(.*))?/?$\";s:50:\"index.php?pagename=$matches[1]&entries=$matches[3]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=8&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:5:{i:0;s:34:\"advanced-custom-fields-pro/acf.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:4;s:25:\"duplicator/duplicator.php\";i:6;s:31:\"posts-in-page/posts_in_page.php\";i:7;s:41:\"wordpress-importer/wordpress-importer.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:94:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/themes/sps/header.php\";i:2;s:100:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/themes/sps/header-white.php\";i:3;s:93:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/themes/sps/style.css\";i:4;s:98:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/themes/sps/css/layout.css\";i:5;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "understrap", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "sps", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "44719", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:1:{s:33:\"classic-editor/classic-editor.php\";a:2:{i:0;s:14:\"Classic_Editor\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Europe/Prague", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "8", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("93", "initial_db_version", "44719", "yes");
INSERT INTO `wp_options` VALUES("94", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("95", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("96", "WPLANG", "cs_CZ", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "sidebars_widgets", "a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:13:\"right-sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:12:\"left-sidebar\";a:0:{}s:4:\"hero\";a:0:{}s:10:\"herocanvas\";a:0:{}s:10:\"statichero\";a:0:{}s:10:\"footerfull\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("103", "cron", "a:7:{i:1571824701;a:1:{s:42:\"forminator_general_data_protection_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1571826301;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1571865901;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1571909099;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1571909119;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1571909121;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("116", "theme_mods_twentynineteen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1566293226;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("136", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("143", "current_theme", "UnderStrap Child", "yes");
INSERT INTO `wp_options` VALUES("144", "theme_mods_sps", "a:6:{i:0;b:0;s:28:\"understrap_posts_index_style\";s:7:\"default\";s:27:\"understrap_sidebar_position\";s:5:\"right\";s:25:\"understrap_container_type\";s:9:\"container\";s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("145", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("150", "recently_activated", "a:3:{s:36:\"contact-form-7/wp-contact-form-7.php\";i:1571124509;s:60:\"cf7-conditional-fields/contact-form-7-conditional-fields.php\";i:1571124500;s:25:\"forminator/forminator.php\";i:1571124481;}", "yes");
INSERT INTO `wp_options` VALUES("151", "duplicator_settings", "a:15:{s:7:\"version\";s:6:\"1.3.22\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";s:1:\"1\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"1\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:5;}", "yes");
INSERT INTO `wp_options` VALUES("152", "duplicator_version_plugin", "1.3.22", "yes");
INSERT INTO `wp_options` VALUES("153", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("154", "acf_version", "5.8.3", "yes");
INSERT INTO `wp_options` VALUES("179", "acf_pro_license", "YToyOntzOjM6ImtleSI7czo3NjoiYjNKa1pYSmZhV1E5TVRZM05EUXpmSFI1Y0dVOVpHVjJaV3h2Y0dWeWZHUmhkR1U5TWpBeE9TMHdPQzB3T1NBd09UbzBOem94TXc9PSI7czozOiJ1cmwiO3M6MjI6Imh0dHA6Ly9iYXZzZS5wdWxhcnkuY3oiO30=", "yes");
INSERT INTO `wp_options` VALUES("222", "wpcf7cf_options", "a:4:{s:9:\"animation\";s:3:\"yes\";s:16:\"animation_intime\";i:200;s:17:\"animation_outtime\";i:200;s:16:\"notice_dismissed\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("228", "forminator_version", "1.8.1", "yes");
INSERT INTO `wp_options` VALUES("229", "widget_forminator_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("231", "forminator_entries_export_schedule", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("543", "forminator_posts_map", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("553", "duplicator_package_active", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-10-23 09:54:46\";s:7:\"Version\";s:6:\"1.3.22\";s:9:\"VersionWP\";s:5:\"5.2.4\";s:9:\"VersionDB\";s:7:\"10.1.19\";s:10:\"VersionPHP\";s:5:\"7.3.1\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20190827_bavseastuduj\";s:4:\"Hash\";s:35:\"035c2581335d5fa32920_20191023095446\";s:8:\"NameHash\";s:57:\"20190827_bavseastuduj_035c2581335d5fa32920_20191023095446\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:78:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://bavse.pulary.cz/wp-snapshots/\";s:8:\"ScanFile\";s:67:\"20190827_bavseastuduj_035c2581335d5fa32920_20191023095446_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:61:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-10-23 09:54:46\";s:7:\"Version\";s:6:\"1.3.22\";s:9:\"VersionWP\";s:5:\"5.2.4\";s:9:\"VersionDB\";s:7:\"10.1.19\";s:10:\"VersionPHP\";s:5:\"7.3.1\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20190827_bavseastuduj\";s:4:\"Hash\";s:35:\"035c2581335d5fa32920_20191023095446\";s:8:\"NameHash\";s:57:\"20190827_bavseastuduj_035c2581335d5fa32920_20191023095446\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:78:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-snapshots/tmp\";s:8:\"StoreURL\";s:36:\"http://bavse.pulary.cz/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:63;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";s:1:\"1\";}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:70:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-admin\";i:1;s:80:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/uploads\";i:2;s:82:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/languages\";i:3;s:79:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content/themes\";i:4;s:73:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:61:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz\";i:1;s:72:\"/data/web/virtuals/159802/virtual/www/domains/bavse.pulary.cz/wp-content\";}}s:9:\"Installer\";r:86;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:128;}", "yes");
INSERT INTO `wp_options` VALUES("559", "duplicator_ui_view_state", "a:6:{s:19:\"dup-pack-build-try1\";s:1:\"1\";s:19:\"dup-pack-build-try2\";s:1:\"1\";s:19:\"dup-pack-build-try3\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:22:\"dup-pack-storage-panel\";s:1:\"0\";}", "yes");
INSERT INTO `wp_options` VALUES("834", "duplicator_exe_safe_mode", "", "yes");
INSERT INTO `wp_options` VALUES("1013", "theme_mods_understrap", "a:4:{s:28:\"understrap_posts_index_style\";s:7:\"default\";s:27:\"understrap_sidebar_position\";s:5:\"right\";s:25:\"understrap_container_type\";s:9:\"container\";s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("1073", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"pavelkocan@pulary.cz\";s:7:\"version\";s:5:\"5.2.4\";s:9:\"timestamp\";i:1571135638;}", "no");
INSERT INTO `wp_options` VALUES("1418", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2703", "new_admin_email", "pavelkocan@pulary.cz", "yes");
INSERT INTO `wp_options` VALUES("2772", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/cs_CZ/wordpress-5.2.4.zip\";s:6:\"locale\";s:5:\"cs_CZ\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/cs_CZ/wordpress-5.2.4.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.2.4\";s:7:\"version\";s:5:\"5.2.4\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1571824425;s:15:\"version_checked\";s:5:\"5.2.4\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("2773", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1571824428;s:7:\"checked\";a:2:{s:3:\"sps\";s:3:\"1.0\";s:10:\"understrap\";s:5:\"0.9.4\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("2782", "_site_transient_timeout_browser_9db3130d7a841f814d9f11db63c4a9e2", "1572249857", "no");
INSERT INTO `wp_options` VALUES("2783", "_site_transient_browser_9db3130d7a841f814d9f11db63c4a9e2", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"77.0.3865.120\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("2784", "_site_transient_timeout_php_check_90e738eca301c4d89366b1a4d15fe37f", "1572249857", "no");
INSERT INTO `wp_options` VALUES("2785", "_site_transient_php_check_90e738eca301c4d89366b1a4d15fe37f", "a:5:{s:19:\"recommended_version\";s:3:\"7.3\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("2798", "_transient_is_multi_author", "0", "yes");
INSERT INTO `wp_options` VALUES("2806", "_transient_timeout_acf_plugin_updates", "1571997227", "no");
INSERT INTO `wp_options` VALUES("2807", "_transient_acf_plugin_updates", "a:4:{s:7:\"plugins\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";a:8:{s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"plugin\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"new_version\";s:5:\"5.8.5\";s:3:\"url\";s:36:\"https://www.advancedcustomfields.com\";s:6:\"tested\";s:3:\"5.2\";s:7:\"package\";s:243:\"https://connect.advancedcustomfields.com/v2/plugins/download?token=eyJwIjoicHJvIiwiayI6ImIzSmtaWEpmYVdROU1UWTNORFF6ZkhSNWNHVTlaR1YyWld4dmNHVnlmR1JoZEdVOU1qQXhPUzB3T0Mwd09TQXdPVG8wTnpveE13PT0iLCJ3cF91cmwiOiJodHRwOlwvXC9iYXZzZS5wdWxhcnkuY3oifQ==\";s:5:\"icons\";a:1:{s:7:\"default\";s:63:\"https://ps.w.org/advanced-custom-fields/assets/icon-256x256.png\";}s:7:\"banners\";a:2:{s:3:\"low\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=1729102\";s:4:\"high\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=1729099\";}}}s:10:\"expiration\";i:172800;s:6:\"status\";i:1;s:7:\"checked\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"5.8.3\";}}", "no");
INSERT INTO `wp_options` VALUES("2808", "_site_transient_timeout_theme_roots", "1571826228", "no");
INSERT INTO `wp_options` VALUES("2809", "_site_transient_theme_roots", "a:2:{s:3:\"sps\";s:7:\"/themes\";s:10:\"understrap\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_options` VALUES("2810", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1571824429;s:7:\"checked\";a:5:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"5.8.3\";s:33:\"classic-editor/classic-editor.php\";s:3:\"1.5\";s:25:\"duplicator/duplicator.php\";s:6:\"1.3.22\";s:31:\"posts-in-page/posts_in_page.php\";s:5:\"1.4.4\";s:41:\"wordpress-importer/wordpress-importer.php\";s:5:\"0.6.4\";}s:8:\"response\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"plugin\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"new_version\";s:5:\"5.8.5\";s:3:\"url\";s:36:\"https://www.advancedcustomfields.com\";s:6:\"tested\";s:3:\"5.2\";s:7:\"package\";s:243:\"https://connect.advancedcustomfields.com/v2/plugins/download?token=eyJwIjoicHJvIiwiayI6ImIzSmtaWEpmYVdROU1UWTNORFF6ZkhSNWNHVTlaR1YyWld4dmNHVnlmR1JoZEdVOU1qQXhPUzB3T0Mwd09TQXdPVG8wTnpveE13PT0iLCJ3cF91cmwiOiJodHRwOlwvXC9iYXZzZS5wdWxhcnkuY3oifQ==\";s:5:\"icons\";a:1:{s:7:\"default\";s:63:\"https://ps.w.org/advanced-custom-fields/assets/icon-256x256.png\";}s:7:\"banners\";a:2:{s:3:\"low\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=1729102\";s:4:\"high\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=1729099\";}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:4:{s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/classic-editor.1.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.3.22\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.3.22.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2083921\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2083921\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}}s:31:\"posts-in-page/posts_in_page.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:27:\"w.org/plugins/posts-in-page\";s:4:\"slug\";s:13:\"posts-in-page\";s:6:\"plugin\";s:31:\"posts-in-page/posts_in_page.php\";s:11:\"new_version\";s:5:\"1.4.4\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/posts-in-page/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/posts-in-page.1.4.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/posts-in-page/assets/icon-256x256.png?rev=1596190\";s:2:\"1x\";s:66:\"https://ps.w.org/posts-in-page/assets/icon-128x128.png?rev=1596190\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/posts-in-page/assets/banner-772x250.png?rev=1596190\";}s:11:\"banners_rtl\";a:0:{}}s:41:\"wordpress-importer/wordpress-importer.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:32:\"w.org/plugins/wordpress-importer\";s:4:\"slug\";s:18:\"wordpress-importer\";s:6:\"plugin\";s:41:\"wordpress-importer/wordpress-importer.php\";s:11:\"new_version\";s:5:\"0.6.4\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/wordpress-importer.0.6.4.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:71:\"https://ps.w.org/wordpress-importer/assets/icon-256x256.png?rev=1908375\";s:2:\"1x\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";s:3:\"svg\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-importer/assets/banner-772x250.png?rev=547654\";}s:11:\"banners_rtl\";a:0:{}}}}", "no");
INSERT INTO `wp_options` VALUES("2811", "_site_transient_timeout_community-events-f34d4117d04d734fb919fa5e3d890aec", "1571867633", "no");
INSERT INTO `wp_options` VALUES("2812", "_site_transient_community-events-f34d4117d04d734fb919fa5e3d890aec", "a:3:{s:9:\"sandboxed\";b:0;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"95.173.82.0\";}s:6:\"events\";a:3:{i:0;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:13:\"WordCamp Brno\";s:3:\"url\";s:30:\"https://2019.brno.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2019-10-26 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:20:\"Brno, Czech Republic\";s:7:\"country\";s:2:\"CZ\";s:8:\"latitude\";d:49.1877269;s:9:\"longitude\";d:16.5822699;}}i:1;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:16:\"WordCamp Łódź\";s:3:\"url\";s:30:\"https://2019.lodz.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2019-11-23 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:15:\"Łódź, Poland\";s:7:\"country\";s:2:\"PL\";s:8:\"latitude\";d:51.7592506;s:9:\"longitude\";d:19.4691237;}}i:2;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:15:\"WordCamp Prague\";s:3:\"url\";s:32:\"https://2020.prague.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2020-02-29 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:22:\"Prague, Czech Republic\";s:7:\"country\";s:2:\"CZ\";s:8:\"latitude\";d:50.0490092;s:9:\"longitude\";d:14.4400399;}}}}", "no");
INSERT INTO `wp_options` VALUES("2813", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1571867633", "no");
INSERT INTO `wp_options` VALUES("2814", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"News –  – WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Oct 2019 20:08:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://wordpress.org/?v=5.3-RC2-46574\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"WordPress 5.3 RC2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2019/10/wordpress-5-3-rc2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Oct 2019 20:08:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7425\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:376:\"The second release candidate for WordPress 5.3 is now available! WordPress 5.3 is currently scheduled to be released on November 12 2019, but we need your help to get there—if you haven’t tried 5.3 yet, now is the time! There are two ways to test the WordPress 5.3 release candidate: Try the&#160;WordPress Beta Tester&#160;plugin (choose the “bleeding edge [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Francesca Marano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3770:\"\n<p>The second release candidate for WordPress 5.3 is now available!</p>\n\n\n\n<p>WordPress 5.3 is currently scheduled to be released on <strong><a href=\"https://make.wordpress.org/core/5-3/\">November 12 2019</a></strong>, but we need <em>your</em> help to get there—if you haven’t tried 5.3 yet, now is the time!</p>\n\n\n\n<p>There are two ways to test the WordPress 5.3 release candidate:</p>\n\n\n\n<ul><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option)</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.3-RC2.zip\">download the release candidate here</a>&nbsp;(zip).</li></ul>\n\n\n\n<p>For details about what to expect in WordPress 5.3, please see the&nbsp;<a href=\"https://wordpress.org/news/2019/10/wordpress-5-3-release-candidate/\">first release candidate post</a>.</p>\n\n\n\n<p>Release Candidate 2 contains improvements to the new About page, and <a href=\"https://core.trac.wordpress.org/query?id=48381%2C48363%2C48022%2C48304%2C48379%2C48087%2C47699&amp;milestone=5.3&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">10 fixes</a> for the following bugs and regressions:</p>\n\n\n\n<ul><li>Three bugs contained in RC1 within the block editor have been fixed (see #<a href=\"https://core.trac.wordpress.org/ticket/48381\">48381</a>).</li><li>A bug has been fixed where links within comments did not get the correct <code>rel</code> attribute (see #<a href=\"https://core.trac.wordpress.org/ticket/48022\">48022</a>).</li><li>The <code>scaled-</code> string has been added to file names when images are downsized if determined &#8220;BIG&#8221; (see #<a href=\"https://core.trac.wordpress.org/ticket/48304\">48304</a>).</li><li>The buttons group layout has been fixed in IE11 (see #<a href=\"https://core.trac.wordpress.org/ticket/48087\">48087</a>).</li><li>A bug with <code>boolean</code> <code>false</code> meta values in the REST API has been fixed (see #<a href=\"https://core.trac.wordpress.org/ticket/48363\">48363</a>).</li><li>The error code encountered when the native PHP JSON extension is missing has been adjusted to be unique (see #<a href=\"https://core.trac.wordpress.org/ticket/47699\">47699</a>).</li><li>When uploading files, HTTP error code support has been expanded to include all 5xx errors (see #<a href=\"https://core.trac.wordpress.org/ticket/48379\">48379</a>).</li></ul>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.3 and update the&nbsp;<em>Tested up to</em>&nbsp;version in the readme to 5.3. If you find compatibility problems, please be sure to post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>&nbsp;so we can figure those out before the final release.</p>\n\n\n\n<p>The&nbsp;<a href=\"https://make.wordpress.org/core/2019/10/17/wordpress-5-3-field-guide/\">WordPress 5.3 Field Guide</a>&nbsp;has also been published, which details the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n\n\n\n<p><em><strong>If you think you’ve found a bug</strong>, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7425\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:64:\"\n		\n		\n				\n				\n		\n				\n		\n\n		\n				\n								\n							\n		\n							\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Empowering Generations of Digital Natives\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wordpress.org/news/2019/10/empowering-generations-of-digital-natives/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wordpress.org/news/2019/10/empowering-generations-of-digital-natives/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Oct 2019 20:03:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"digital citizenship week\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7413\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"Technology is changing faster each year. Digital literacy can vary between ages but there are lots of ways different generations can work together and empower each as digital citizens. No matter whether you’re a parent or caregiver, teacher or mentor, it’s hard to know the best way to teach younger generations the skills needed to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Yvette Sonneveld\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8968:\"\n<p>Technology is changing faster each year. Digital literacy can vary between ages but there are lots of ways different generations can work together and empower each as digital citizens.</p>\n\n\n\n<p>No matter whether you’re a parent or caregiver, teacher or mentor, it’s hard to know the best way to teach younger generations the skills needed to be an excellent digital citizen. If you’re not confident about your own tech skills, you may wonder how you can help younger generations become savvy digital citizens. But using technology responsibly is about more than just technical skills. By collaborating across generations, you can also strengthen all your family members’ skills, and offer a shared understanding of what the internet can provide and how to use it to help your neighborhoods and wider society.&nbsp;<br></p>\n\n\n\n<h2>Taking Gen Z Beyond Digital Savvy</h2>\n\n\n\n<h3>Open up the dialogue</h3>\n\n\n\n<p>Even if you’re not fully confident in your own tech skills, you can help develop digital citizenship skills in others. If you feel comfortable during everyday conversation, you could describe a tech situation you have come across and ask family members if they have ever experienced something similar. You can give them a chance to share how they handled it or how it made them feel. This can help encourage them to think critically and to react with empathy. And being asked for advice can make them feel appreciated and empowered. But opening up the conversation can also be as simple as asking if they’ve seen anything online lately that they found interesting or wanted to talk about.</p>\n\n\n\n<h3>Share access to free and affordable training</h3>\n\n\n\n<p>Open source content management systems have made online publishing accessible to a more diverse group of people. Dozens of content platforms offer hands-on training at no or low cost. <a href=\"https://wordpress.tv/\">WordPress.tv</a>, <a href=\"https://www.linkedin.com/learning/topics/wordpress\">LinkedIn Learning</a>, and others have low-cost video libraries with thousands of recorded talks and workshops and the WordPress Training team have excellent downloadable lesson plans and materials. These platforms not only feature content that helps develop tech and content creation skills but also content around ethics, diversity and community building.&nbsp;&nbsp;</p>\n\n\n\n<h3>Find a sense of community and belonging</h3>\n\n\n\n<p>One of the disadvantages of increased digitalization is that <a href=\"https://www.theatlantic.com/magazine/archive/2017/09/has-the-smartphone-destroyed-a-generation/534198/\">younger generations and us all may spend less time hanging out in-person.</a> Digital time spent with others is no replacement for in-person interactions. The awareness and mutual understanding which comes from back and forth interaction is needed for positive interpersonal skills. This is hard to replace in digital communities and those skills can only be learned with lots of hands-on practice.&nbsp;</p>\n\n\n\n<h3>Learn the many benefits of volunteering&nbsp;</h3>\n\n\n\n<p>There are WordPress events across the world that provide a great place to learn new skills to share with your families and friends. Some work with schools and colleges to offer special events which are open to all ages. There are also plenty of small ways to volunteer with the WordPress project that can be done at home to practice new skills.</p>\n\n\n\n<p>In addition to attending events where you can learn skills and hang out with others with similar interests, the WordPress ecosystem offers countless opportunities to be actively involved. Professionals, hobbyists, and learners all make a difference by contributing to the ongoing creation of the WordPress platform. Together these people, who are known as contributors, form the <a href=\"https://make.wordpress.org/\">WordPress open source community.</a>&nbsp;</p>\n\n\n\n<h4>WordPress is created by volunteer contributors</h4>\n\n\n\n<p>Not only are these contributors creating an amazingly flexible platform for all to use, it is an environment where you can continue to improve your skills, both technical and interpersonal. Open-source software projects can introduce you to people you would otherwise not get the chance to meet, locally and internationally. If you have a zest for learning, and for finding others to connect with, WordPress has many ways to meet contributors in person!</p>\n\n\n\n<h4>WordPress events are organized by volunteers</h4>\n\n\n\n<p>WordPress community events are volunteer-run. This can be a great way to give back to the project and practice all sorts of skills. Talk to your local event about how you could get involved and if you would like to bring older teenagers and young adults with you. You will not need any pre-existing tech skills to attend these events but they are a great way to discover areas you might want to learn more about.&nbsp;</p>\n\n\n\n<h4>Contributor days offer a great opportunity to get involved</h4>\n\n\n\n<p>These events are specially designed to help you get involved in building the open-source WordPress platform. You can collaborate with other members of its community and find areas that are right for you to use and grow your skills. All of the tasks you will discover at an event can be continued at home and some are easy to get other family members involved in learning and adding in ideas.&nbsp;</p>\n\n\n\n<p>Contributors come from all sorts of backgrounds and locations, some may live near you and others thousands of miles away. Working alongside lots of different cultures and countries can open up new ideas for young people letting them learn new ways of doing things and discover different perspectives. All those different perspectives can cause misunderstandings. But being involved in a global learning community is a great way to practice communicating across cultural boundaries.&nbsp;</p>\n\n\n\n<h4>Getting involved can be rewarding in many (unexpected) ways</h4>\n\n\n\n<p>The most rewarding part of actively taking part in WordPress events is making budding friendships. New connections often turn into long-lasting friendships that are likely to continue for years to come, both online and offline. With a global community, these friendships can potentially lead to lots of international adventures too!</p>\n\n\n\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Getting ready for the <a href=\"https://twitter.com/WordCampBTN?ref_src=twsrc%5Etfw\">@WordCampBTN</a>. I&#8217;ve got my 5kg backpack and one-way ticket to London in a few days <img src=\"https://s.w.org/images/core/emoji/12.0.0-1/72x72/1f929.png\" alt=\"🤩\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> What shall I do after? <img src=\"https://s.w.org/images/core/emoji/12.0.0-1/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://t.co/cdQqeyNWif\">pic.twitter.com/cdQqeyNWif</a></p>— Sabrina Zeidan going to #WCKyiv (@sabrina_zeidan) <a href=\"https://twitter.com/sabrina_zeidan/status/1160265428473712640?ref_src=twsrc%5Etfw\">August 10, 2019</a></blockquote>\n\n\n\n<h3>Make our digital world safer and more inclusive</h3>\n\n\n\n<p>Befriending people from a wide variety of cultures and backgrounds can be an enriching experience in itself. It can also help you make us make more informed decisions. The more we interact with a diverse range of people, the more empathic we become. Some of the most valuable learning that can be offered to Gen Z (and probably to all of us at times) is that what we come across in fast-moving digital communities isn’t always the entire view.&nbsp;</p>\n\n\n\n<h2>All things considered….</h2>\n\n\n\n<p>Anyone who is a digital native may not need encouragement to obtain tech skills. But they may not be aware that digital communities are still communities and <a href=\"https://wordpress.org/news/2019/10/responsible-participation-in-online-communities/\">we need to use the same sorts of people skills for both offline and online locations</a>. Opening up conversations about situations they may experience online that may require them to (re)act responsibly, can encourage them to think critically and act with empathy. Compared to previous generations, digital natives spend substantially more time by themselves while using devices, so encouraging them to join real-life communities, such as WordPress, could be the first step to learning what it means to be a good digital citizen!&nbsp; </p>\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p><a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>, <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>, <a href=\'https://profiles.wordpress.org/yvettesonneveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>yvettesonneveld</a> &amp; <a href=\'https://profiles.wordpress.org/annemariedh/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annemariedh</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://wordpress.org/news/2019/10/empowering-generations-of-digital-natives/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7413\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 5.3 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2019/10/wordpress-5-3-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Oct 2019 21:18:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7397\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"The first release candidate for WordPress 5.3 is now available! This is an important milestone as we progress toward the WordPress 5.3 release date. “Release Candidate” means that the new version is ready for release, but with millions of users and thousands of plugins and themes, it’s possible something was missed. WordPress 5.3 is currently [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Francesca Marano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3144:\"\n<p>The first release candidate for WordPress 5.3 is now available!</p>\n\n\n\n<p>This is an important milestone as we progress toward the WordPress 5.3 release date. “Release Candidate” means that the new version is ready for release, but with millions of users and thousands of plugins and themes, it’s possible something was missed. WordPress 5.3 is currently scheduled to be released&nbsp;on&nbsp;<strong>November 12, 2019</strong>, but we need&nbsp;<em>your</em>&nbsp;help to get there—if you haven’t tried 5.3 yet, <strong>now is the time</strong>!</p>\n\n\n\n<p>There are two ways to test the WordPress 5.3 release candidate: </p>\n\n\n\n<ul><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option)</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.3-RC1.zip\">download the release candidate here</a>&nbsp;(zip).</li></ul>\n\n\n\n<h2>What’s in WordPress 5.3?</h2>\n\n\n\n<p>WordPress 5.3 expands and refines the <strong>Block Editor</strong> introduced in WordPress 5.0 with <strong>new blocks, more intuitive interactions, and improved accessibility</strong>. New features in the editor increase design freedoms, provide additional layout options and style variations to allow designers complete control over the look of a site.</p>\n\n\n\n<p>This release also introduces the <strong>Twenty Twenty</strong> theme giving the user more design flexibility and integration with the Block Editor. </p>\n\n\n\n<p>In addition, WordPress 5.3 allows developers to work with <strong>dates and timezones</strong> in a more reliable way and prepares the software to work with <strong>PHP 7.4</strong> to be release later this year. </p>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.3 and update the&nbsp;<em>Tested up to</em>&nbsp;version in the readme file to 5.3. If you find compatibility problems, please be sure to post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>&nbsp;so we can figure those out before the final release.</p>\n\n\n\n<p>The&nbsp;WordPress 5.3 Field Guide&nbsp;will be published within the next 24 hours with a more detailed dive into the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a>&nbsp;This release also marks the&nbsp;<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a>&nbsp;point of the 5.3 release schedule.</p>\n\n\n\n<p><em><strong>If you think you’ve found a bug</strong>, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7397\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n				\n		\n				\n		\n		\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Responsible Participation In Online Communities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wordpress.org/news/2019/10/responsible-participation-in-online-communities/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Oct 2019 19:41:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:24:\"digital citizenship week\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"open source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7386\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:365:\"In our first article in this series, we highlighted the WordPress mission to democratize publishing. WordPress introduced a tool to independent and small publishers who did not have the resources of the larger publishing platforms. Access to a free content management system to create websites has empowered thousands of people to find their voice online. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Yvette Sonneveld\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9139:\"\n<p>In our <a href=\"https://wordpress.org/news/2019/10/becoming-better-digital-citizens-through-open-source/\">first article in this series</a>, we highlighted the WordPress mission to democratize publishing. WordPress introduced a tool to independent and small publishers who did not have the resources of the larger publishing platforms. Access to a free content management system to create websites has empowered thousands of people to find their voice online. People have been able to share their enthusiasm for hobbies, causes, products and much more. Through these different voices, we can encourage understanding, spark creativity, and create environments where collaboration can happen. But as we build more digital communities, it&#8217;s easy to forget that online safety is a group effort.</p>\n\n\n\n<p>Digital literacy is also part of being a good digital citizen, but it’s more than just being able to do basic actions with your mobile device. Digital literacy refers to the range of skills needed to do online research, set up web accounts, and find solutions for fixing devices among other things. But to be able to enjoy more of the digital world safely and responsibly &#8211; to be a good digital citizen &#8211; we need to be able to:&nbsp;</p>\n\n\n\n<ul><li><strong>navigate</strong> vast amounts of information without getting overwhelmed;</li><li><strong>evaluate</strong> a variety of perspectives;</li><li><strong>connect</strong> with people with respect and empathy;</li><li><strong>create</strong>, curate and share information.</li></ul>\n\n\n\n<p>We will need our offline analytical and social skills to make that happen.&nbsp;</p>\n\n\n\n<h2>Here’s some best practices our community members have shared!</h2>\n\n\n\n<h3>Online or offline, let empathy be your compass</h3>\n\n\n\n<p>The hardest part about all of this is the anonymity of online interactions. Without that face-to-face feedback of saying something mean to another person&#8217;s face, it&#8217;s easy to upset the people you&#8217;re trying to communicate with.</p>\n\n\n\n<p>In our daily lives in the offline world, comments may be more tempered and slow to anger  in disagreements. Visual cues will help us determine how a remark is perceived. That, in turn, helps us adjust our behaviour Action, reaction, it’s how we learn best.</p>\n\n\n\n<p>Online, however, the experience is different. A keyboard does not protest if we type angry, hate-filled messages. A screen does not show any signs of being hurt. The lack of physical human presence combined with the anonymity of online alter-egos can be a formula for disrespectful and unfriendly behavior. It is good to remind ourselves that behind the avatars, nicknames and handles are real people. The same empathy we display in our in-person interactions should apply online as well.</p>\n\n\n\n<h3>Critically evaluate your sources&nbsp;</h3>\n\n\n\n<p>We all have times when we consume information with limited research and fact-checking. For some of us, it feels like there’s no time to research and compare sources when faced by a sea of online information. For others, there may be uncertainty about where to start and what to consider. But, without a bit of skepticism and analytical thinking, we run the risk of creating narrow or incorrect understanding of the world. With a little effort we can curb the sharing of fake news and biased information, particularly on topics that are new to us or that we’re not familiar with.</p>\n\n\n\n<p>Misinformation can spread like wildfire. Ask these simple questions to evaluate information online:&nbsp;</p>\n\n\n\n<ul><li>who is the source of the information?</li><li>is it plausible?</li><li>is the information fact or just an opinion?</li></ul>\n\n\n\n<h3>Own our content</h3>\n\n\n\n<p>In this day and age, it’s never been easier to just copy, paste and publish somebody else&#8217;s content. That doesn’t mean that we should! Publishing content that is not truly ‘yours’ in wording and tone of voice is unlikely to build a connection with the right audience. But, just as important, using someone else’s content may breach copyright and potentially intellectual property rights. </p>\n\n\n\n<p>For more information about intellectual property, <a href=\"https://www.wipo.int/about-ip/en/\">visit the World Intellectual Property Organization website</a>.</p>\n\n\n\n<h3>Don’t breeze past terms and conditions</h3>\n\n\n\n<p>Have you ever signed up for an online service (to help you distribute published content or accept payments) that was offered at no cost? In our fast-paced digital lives, we tend to want to breeze past terms and conditions or warning information and often miss important information about what will happen with our data. </p>\n\n\n\n<p>When we are given a contract on paper, we tend to read and re-read it, giving it a greater priority of our time. We may send it to other people for a second opinion or seek further review before signing. Remarkably, we rarely do that with online agreements. As a result, we may be putting our online privacy and security at risk. (WordPress uses a <a href=\"https://make.wordpress.org/community/handbook/wordcamp-organizer/planning-details/gpl-primer/\">GPL license</a>, and only collects usage data that we never share ever.).</p>\n\n\n\n<h3>Keep your website safe and healthy</h3>\n\n\n\n<p>If you would like to own your voice online, you also need to protect your reputation by securing your publishing platform. Websites can face security attacks. Hackers may seek to obtain access through insecure settings, outdated plugins and old software versions, and in extreme cases can try to scam your visitors. And leaking customer data, may even lead to legal consequences.</p>\n\n\n\n<p>On top of that, websites ‘flagged’ for security issues, can lead to high bounce rates and eventual loss of search rankings. This can all affect how search engines rate or even block your site. </p>\n\n\n\n<p>Good practices to keep your website safe include changing your safe password regularly, installing security software, an SSL certificate and keeping the core software, plugins and themes up to date. This will not guarantee that you will keep hackers out, so always keep several backups of your site, ideally both offline and online.</p>\n\n\n\n<p>That is just website security in a tiny nutshell. If you would like to learn more about keeping websites safe, you may want to check out some of these resources and many more videos at WordPress.tv.</p>\n\n\n\n<h2>Join in and help make the web a better place!</h2>\n\n\n\n<p>As part of Digital Citizenship Week, we would like to encourage you to learn and share skills with your colleagues, friends and family members. That way, we all become more informed of potential issues and how to reduce the risks. Together we can make it easier to navigate the web more effectively and securely!</p>\n\n\n\n<h3>Additional resources</h3>\n\n\n\n<h4>Site health check</h4>\n\n\n\n<p>WordPress 5.2 introduced pages in the admin interface to help users run health checks on their sites. They can be found under the Tools menu.</p>\n\n\n\n<h4>Security and SSL&nbsp;</h4>\n\n\n\n<ul><li><a href=\"https://wordpress.tv/2019/01/23/victor-santoyo-security-and-ssl-whats-the-difference/\">Video recording of a presentation by Victor Santoyo about website security and SSL</a>.</li><li><a href=\"https://wordpress.tv/2017/08/31/jessica-gardner-ssl-what-it-is-how-to-do-it-and-why-you-should-care/\">Video recording of a presentation by Jessica Gardner about why you should care about SSL and how to use it.</a></li><li><a href=\"https://wordpress.tv/2018/02/03/adam-warner-the-personal-and-website-security-mindset/\">Video recording of a presentation by Adam Warner about the personal and website security mindset</a>.</li><li><a href=\"https://wordpress.tv/2018/07/05/miriam-schwab-content-security-policies-a-whole-new-way-of-securing-your-website-that-no-one-knows/\">Video recording of a presentation by Miriam Schwab about content security policies</a>.</li><li><a href=\"https://en.support.wordpress.com/https-ssl/\">More information about SSL licenses on WordPress.com</a>.</li><li><a href=\"https://wordpress.org/plugins/search/SSL\">SSL plugins in the WordPress plugin repository</a>.</li></ul>\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p><a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>, <a href=\'https://profiles.wordpress.org/yvettesonneveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>yvettesonneveld</a>, <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>,  <a href=\'https://profiles.wordpress.org/muzhdekad/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>muzhdekad</a> <a href=\'https://profiles.wordpress.org/alexdenning/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>alexdenning</a>,&nbsp;<a href=\'https://profiles.wordpress.org/natashadrewnicki/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>natashadrewnicki</a>, <a href=\'https://profiles.wordpress.org/oglekler/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>oglekler</a>, and Daria Gogoleva.</p>\n\n\n\n<p><br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7386\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 5.2.4 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2019/10/wordpress-5-2-4-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Oct 2019 21:54:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7372\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"WordPress 5.2.4 is now available! This security release fixes 6 security issues. WordPress versions 5.2.3 and earlier are affected by these bugs, which are fixed in version 5.2.4. Updated versions of WordPress 5.1 and earlier are also available for any users who have not yet updated to 5.2. Security Updates Props to&#160;Evan Ricafort&#160;for finding an [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3652:\"\n<p><a href=\"https://wordpress.org/wordpress-5.2.4.zip\">WordPress 5.2.4</a> is now available! This security release fixes 6 security issues.<br><br>WordPress versions 5.2.3 and earlier are affected by these bugs, which are fixed in version 5.2.4. Updated versions of WordPress 5.1 and earlier are also available for any users who have not yet updated to 5.2.</p>\n\n\n\n<h3>Security Updates</h3>\n\n\n\n<ul><li>Props to&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://evanricafort.com/\">Evan Ricafort</a>&nbsp;for finding an issue where stored XSS (cross-site scripting) could be added via the Customizer.</li><li>Props to&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://codesymphony.co/\">J.D. Grimes</a>&nbsp;who found and disclosed a method of viewing unauthenticated posts.</li><li>Props to&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://weston.ruter.net/\">Weston Ruter</a>&nbsp;for finding a way to create a stored XSS to inject Javascript into style tags.</li><li>Props to David Newman for highlighting a method to poison the cache of JSON GET requests via the Vary: Origin header.</li><li>Props to <a href=\"http://eugenekolo.com/\">Eugene Kolodenker</a> who found a server-side request forgery in the way that URLs are validated.</li><li>Props to Ben Bidner of the WordPress Security Team who discovered issues related to referrer validation in the admin.</li></ul>\n\n\n\n<p>Thank you to all of the reporters for <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">privately disclosing</a> the vulnerabilities, which gave us time to fix them before WordPress sites could be attacked.</p>\n\n\n\n<p>For more info, browse the full list of changes on Trac or check out the Version&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://wordpress.org/support/wordpress-version/version-5-2-4/\">5.2.4 documentation page</a>.<br><br>WordPress 5.2.4 is a short-cycle security release. The next major release will be&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://make.wordpress.org/core/5-3/\">version 5.3</a>.<br><br>You can <a href=\"https://wordpress.org/wordpress-5.2.4.zip\">download WordPress 5.2.4</a> or visit <code>Dashboard → Updates</code> and click <code>Update Now</code>. Sites that support automatic background updates have already started to update automatically.<br><br>In addition to the security researchers mentioned above, thank you to everyone who contributed to WordPress 5.2.4:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/darthhexx\">darthhexx</a>, <a href=\"https://profiles.wordpress.org/davidbinda\">David Binovec</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/jeffpaul\">Jeff Paul</a>, <a href=\"https://profiles.wordpress.org/nickdaugherty\">Nick Daugherty</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sstoqnov\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">Garth Mortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, and <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7372\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:54:\"\n		\n		\n				\n		\n				\n		\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Becoming Better Digital Citizens Through Open Source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wordpress.org/news/2019/10/becoming-better-digital-citizens-through-open-source/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Oct 2019 07:31:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"digital citizenship week\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"open source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7353\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:340:\"The WordPress Project is on a mission to democratize publishing. As WordPress empowers more people to participate in the digital space, we have the opportunity to make sure that everyone can participate safely and responsibly. Today marks the start of Digital Citizenship Week. We are going to share how open source can be used as [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Yvette Sonneveld\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9031:\"\n<p>The WordPress Project is on a mission to democratize publishing. As WordPress empowers more people to participate in the digital space, we have the opportunity to make sure that everyone can participate safely and responsibly. Today marks the start of Digital Citizenship Week. We are going to share how open source can be used as a tool for learners (regardless of age) to practice and model the essential parts of being a good digital citizen.</p>\n\n\n\n<h2>What is digital citizenship?</h2>\n\n\n\n<p>The digital landscape constantly changes and this affects the way we use the internet. New platforms emerge, people find different ways to spread information, communities form, grow and fade away every day. The concepts and practice of promoting civil discourse, critical thinking and safe use of the internet still remain central. And that is exactly what digital citizenship is about.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><em>“Put simply, digital citizenship is a lot like citizenship in any other community &#8212; the knowledge of how to engage with digital communities you’re part of in a way that is thoughtful, safe, and makes appropriate use of the technology.”</em></p><cite><em>Josepha Haden, Executive Director WordPress Project</em></cite></blockquote>\n\n\n\n<h2>Who is a digital citizen?</h2>\n\n\n\n<p>Digital Citizenship is for all age groups. Anyone who uses the internet on a computer, mobile device or a TV is a digital citizen. You don’t have to be tech-savvy already, maybe you are taking your first steps with technology. Digital Citizenship Week is a chance to reflect together on our impact on the digital world. It can help us to make our consumption more considered and our interaction friendlier. It enables us to make a positive difference to those around us.</p>\n\n\n\n<p>All of us can strive (or learn) to become better digital citizens. It can be affected by the access those teaching have had to digital skills and good practice. Adult education classes and community tech hubs play a part in basic tech skill development. Unfortunately, these are not always accessible to those in less populated geographic locations.&nbsp;</p>\n\n\n\n<p>Open source communities like WordPress already make a difference in encouraging the principles of digital citizenship, from sharing tech skills to improving security knowledge. They give people an opportunity to learn alongside their peers and many of the resources are available regardless of location, resources, or skills.</p>\n\n\n\n<ul><li>WordPress Meetups &#8212; locally-based, informal learning sessions &#8212; typically take place monthly on weekday evenings. </li><li>WordCamps are city-based conferences that take place in cities worldwide. These events usually last 1-3 days and are organized and run by volunteers.</li><li>The talks are also recorded and made available on the free, online library <a href=\"https://wordpress.tv/\">WordPress.tv</a>. These can be watched from the comfort of your own home, office or during informal get-togethers.</li></ul>\n\n\n\n<h3>What can we do as part of the WordPress community?</h3>\n\n\n\n<p>Digital citizenship skills, like many other skills needed in this tech-focused world, should be kept up-to-date. Open source communities offer unparalleled opportunities to do this and are available in countries across the world. As part of our role as members of WordPress and other communities, we can pass on such skills to others. For instance by working alongside people who have had limited experience of digital skills. Or by finding new ways of making this knowledge sharing fun and accessible.&nbsp;</p>\n\n\n\n<p><strong>Here are just a few of the ways we do and can make an even greater difference:</strong></p>\n\n\n\n<ul><li>as bloggers and writers, we can be more aware of how to write content responsibly.</li><li>as designers, we can think more about how different people will view, understand and respond to the designs and visuals we create or use.</li><li>as developers, we can build systems that make it easier for all users to find information and accomplish their goals, to be secure while visiting our sites, and to model good security and practice.</li><li>as community members, through organizing events like <a href=\"https://www.meetup.com/pro/wordpress\">WordPress Meetups</a> and <a href=\"https://central.wordcamp.org\">WordCamps</a>, we are helping equip those who may not have had access to digital literacy or who lack the confidence to put it into place or share with their family and colleagues. Through these events, the online videos and other resources on <a href=\"https://wordpress.tv/\">WordPress.tv</a> and through the <a href=\"https://make.wordpress.org/\">Make WordPress teams</a>, we are already making a difference every day.</li><li>as individuals, the way we communicate in the community and listen to each other is equally important. This is a vital part of how we grow and model positive digital citizens. Through growing our positive digital skills and a better understanding of online etiquette and challenges, we can make our immediate and wider digital world a more positive and useful environment.</li><li>making it easier to document and share knowledge.</li><li>emphasizing how skills learned within the community can be used in other parts of our digital lives.</li><li>creating and becoming ambassadors for Digital Citizenship.</li></ul>\n\n\n\n<p>You can also get involved with specific events that have grown out of the wider WordPress project, championed by enthusiasts and those wanting to improve specific digital skills and bring wider benefits to society.</p>\n\n\n\n<h2>Community-driven Events</h2>\n\n\n\n<p>For example, <a href=\"https://wptranslationday.org\"><strong>WordPress Translation Day</strong></a> in 2019 had 81 local events worldwide. Running for 24-hours, individuals with language skills translated aspects of the platform into multiple languages with a total of 1181 projects modified. An amazing 221 new translators joined on the day. In addition, there was a live stream with talks, panel discussions, interviews, and sharing of tips and skills to help others learn how to translate. Volunteers are now planning the event for 2020!<br><br><a href=\"https://make.wordpress.org/polyglots/2019/03/01/global-wordpress-translation-day-4-is-coming/\">Stories of how people came together for WordPress Translation Day</a></p>\n\n\n\n<figure class=\"wp-block-embed-wordpress-tv wp-block-embed is-type-video wp-embed-aspect-4-3 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe width=\'632\' height=\'395\' src=\'https://videopress.com/embed/aiWzATgh?hd=0\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script>\n</div><figcaption><br>Interviews with some of the participants from a previous WordPress Translation Day giving a flavour of how volunteers developed this event.</figcaption></figure>\n\n\n\n<p><strong>Do_action days</strong> are WordPress events organized in local communities to help give charities their own online presence. Each event involves members of the local WordPress community, planning and building new websites for selected local organizations in one day. Some take place in a working day, others on weekends.&nbsp;</p>\n\n\n\n<figure class=\"wp-block-embed-wordpress-tv wp-block-embed is-type-video wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe width=\'632\' height=\'356\' src=\'https://videopress.com/embed/xVwMpeOd?hd=0\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script>\n</div><figcaption>Volunteer Tess Coughlan-Allen talking about how people came together for the first do_action in Europe to help local charities. </figcaption></figure>\n\n\n\n<p><a href=\"https://doaction.org\">Find the next do_action hackaton nearby your home town.</a></p>\n\n\n\n<h3>Improving digital skills through WordPress</h3>\n\n\n\n<figure class=\"wp-block-embed-wordpress-tv wp-block-embed is-type-video wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe width=\'632\' height=\'356\' src=\'https://videopress.com/embed/vwE1MunB?hd=0\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script>\n</div><figcaption><br>In this video clip, Josepha talks about the Digital Divide and what current technological trends mean for it in the future. She explores what it takes to be literate in the digital landscape and how WordPress can be used to build and perfect those skills.</figcaption></figure>\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p>Thanks to <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a> for researching and writing this article and <a href=\'https://profiles.wordpress.org/yvettesonneveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>yvettesonneveld</a> for her supporting work in this series.<br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7353\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.3 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2019/10/wordpress-5-3-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Oct 2019 20:58:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7312\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:357:\"WordPress 5.3 Beta 3 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version. You can test the WordPress 5.3 beta in two ways: Try the&#160;WordPress Beta Tester&#160;plugin (choose the “bleeding edge nightlies” option) [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Francesca Marano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3765:\"\n<p>WordPress 5.3 Beta 3 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>You can test the WordPress 5.3 beta in two ways:</p>\n\n\n\n<ul><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option)</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.3-beta3.zip\">download the beta here</a>&nbsp;(zip). </li></ul>\n\n\n\n<p>WordPress 5.3 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-3/\">November 12, 2019</a>, and we need your help to get there.</p>\n\n\n\n<p>Thanks to the testing and feedback from everyone who tested <a href=\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-2/\">beta 2</a> (and&nbsp;<a href=\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-1/\">beta 1</a>) over&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F01%2F2019..10%2F08%2F2019&amp;milestone=5.3&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">60 tickets have been closed</a>&nbsp;in the past week. </p>\n\n\n\n<h2>Some highlights </h2>\n\n\n\n<ul><li>Fixes and enhancements in the admin interface changes introduced in previous 5.3 beta releases.</li><li>Wording changes in login screen (<a href=\"https://core.trac.wordpress.org/ticket/43037\">#43037</a>).</li><li>Improved accessibility in media upload modal (<a href=\"https://core.trac.wordpress.org/ticket/47149\">#47149</a>).</li><li>Changes in the way the new error handling with images works (<a href=\"https://core.trac.wordpress.org/ticket/48200\">#48200</a>).</li><li>MediaElement.js has been updated from 4.2.6 to 4.2.13 (<a href=\"https://core.trac.wordpress.org/ticket/46681\">#46681</a>). The script is now also being loaded in the footer again. This fixes a regression that happened two years ago, so might be worth noting (<a href=\"https://core.trac.wordpress.org/ticket/44484\">#44484</a>).</li><li>Update to the REST API media endpoint to allow resuming of uploads (<a href=\"https://core.trac.wordpress.org/ticket/47987\">#47987</a>).</li></ul>\n\n\n\n<p>In addition to these, Beta 3 landed a number of small consistency and polish changes to the REST API, including an improvement to the permissions check used when editing comments, a fix for post type controller caching edge cases, and most importantly, the ability to use the _embed parameter to access the full data for a post using the /wp/v2/search endpoint.</p>\n\n\n\n<h2>Developer notes</h2>\n\n\n\n<p>WordPress 5.3 has lots of refinements to polish the developer experience. To keep up, subscribe to the&nbsp;<a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a>&nbsp;and pay special attention to the&nbsp;<a href=\"https://make.wordpress.org/core/tag/5-3+dev-notes/\">developer notes</a>&nbsp;tag for updates on those and other changes that could affect your products.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help us translate WordPress into more than 100 languages</a>!</p>\n\n\n\n<p>If you think you’ve found a bug, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>&nbsp;where you can also find a list of&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7312\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"People of WordPress: Alice Orru\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wordpress.org/news/2019/10/people-of-wordpress-alice-orru/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 05 Oct 2019 04:24:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"heropress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Interviews\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7288\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:376:\"You’ve probably heard that WordPress is open-source software, and may know that it’s created and run by volunteers. WordPress enthusiasts share many examples of how WordPress changed people’s lives for the better. This monthly series shares some of those lesser-known, amazing stories. Meet Alice Orru, from Sardinia, Italy. Alice Orru was born in Sardinia, an [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Yvette Sonneveld\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10122:\"\n<p><em>You’ve probably heard that WordPress is open-source software, and may know that it’s created and run by volunteers. WordPress enthusiasts share many examples of how WordPress changed people’s lives for the better. This monthly series shares some of those lesser-known, amazing stories.</em></p>\n\n\n\n<h2><strong>Meet Alice Orru, from Sardinia, Italy.</strong></h2>\n\n\n\n<p>Alice Orru was born in Sardinia, an island in the middle of the Mediterranean Sea. As a child, she dreamt of becoming a flight attendant, traveling the world, and speaking many foreign languages.</p>\n\n\n\n<p>Unable to meet the height requirements of her chosen profession, Orru ended up choosing a different path in life, following the Italian mantra: “You have to study something that will guarantee a stable and secure job for life.”</p>\n\n\n\n<p>The unemployment rate in Sardinia is very high, a challenge shared throughout the surrounding islands. In addition to that, Alice wasn’t that keen on having the same job all her life, as her parents had.</p>\n\n\n\n<p>When Orru was 22 she moved to Siena, Tuscany, to finish her studies. That is when she created her first personal blog. The website was built on an Italian platform named Tiscali, which she later migrated to WordPress.com.</p>\n\n\n\n<p>After 2 years in Tuscany Orru moved to Strasbourg, France. She studied French and worked several jobs while living there. Her first serious job was in Milan &#8211; working 40 hours/week in the marketing department of a large, international company. She found herself surrounded by ambitious colleagues and a boss who constantly requested extra —unpaid— working hours per day.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img src=\"https://i0.wp.com/wordpress.org/news/files/2019/10/IMG_2672.jpg?fit=632%2C422&amp;ssl=1\" alt=\"Alice Orru\" class=\"wp-image-7291\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2019/10/IMG_2672.jpg?w=1920&amp;ssl=1 1920w, https://i0.wp.com/wordpress.org/news/files/2019/10/IMG_2672.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2019/10/IMG_2672.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2019/10/IMG_2672.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2019/10/IMG_2672.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2019/10/IMG_2672.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" /><figcaption>Alice Orru</figcaption></figure>\n\n\n\n<h2>Choices, choices, choices&#8230;</h2>\n\n\n\n<p>Alice gave up blogging because she wasn’t feeling inspired enough to write. She questioned whether she really wanted to do that job forever; working 10 hours per day under the neon lights of an office. It forced her to set aside her dreams for the time being, and for a while, she mainly lived for the weekends.</p>\n\n\n\n<p>Alice decided to leave the job and moved to Barcelona, Spain, all by herself, in 2012.</p>\n\n\n\n<p>After a few months of intense Spanish learning at the university, she found a job in an international clinic as a “Patient Coordinator.” Orru assisted international patients coming to Barcelona for their treatments. She acted as their translator, interpreter and administrative consultant.&nbsp;</p>\n\n\n\n<p>Patients came from Italy, France, England, Morocco, Senegal, and several other countries. Alice was so inspired by some of their stories, that she started to write again: She dusted off her WordPress blog and filled it with stories about her new life in Barcelona and some of the women she met at the clinic. “I was feeling stronger and more independent than ever,” Orru expressed.</p>\n\n\n\n<h2>Technical issues led to unexpected opportunities</h2>\n\n\n\n<p>In the summer of 2015, Alice was writing on her blog and got stuck with a technical problem. While she was searching through the WordPress.com documentation, she saw a pop-up in the bottom right corner of her screen. It was a staff member of Automattic, checking if she needed help. They chatted for a few minutes and the problem was solved. Alice left the chat with one question, though: how did that person on chat find a support job with WordPress?</p>\n\n\n\n<p>Alice found the official WordPress job page: <a href=\"http://jobs.wordpress.net/\"><strong>jobs.wordpress.net</strong></a> and noticed a job offer that caught her attention: WP Media, a French startup, was looking for a polyglot and remote customer service teammate for one of their plugins, WP Rocket. She read their requirements: fluency in English, French and possibly other languages, excellent experience with WordPress, and some coding skills.</p>\n\n\n\n<p>She knew she didn’t meet all the requirements, but could speak 4 languages, and she had a WordPress blog. She didn’t know anything about PHP, though. Orru had been a WordPress.com user for years and knew she was ready to learn more.</p>\n\n\n\n<p>Orru wrote a cover letter and sent her CV. A Skype interview was conducted and several days later she received the news that she had gotten the job!&nbsp;</p>\n\n\n\n<h2><strong>A steep learning curve</strong></h2>\n\n\n\n<p>The early days in her new job were intense. Alice felt inexperienced but was supported by her teammates. She started studying and reading everything about WordPress for beginners. Initially, she answered easy tickets from customers. All the while her teammates were sending useful material to read, setting up video-calls for 1 to 1 training, and encouraging her the entire time.</p>\n\n\n\n<p>Soon, Orru was replying to customers whose first language was either Spanish or Italian in their native language. This was much appreciated and resulted in several happy comments. Until that moment the plugin’s support had been offered only in English and French.</p>\n\n\n\n<h2><strong>Finding her way in the WordPress community</strong></h2>\n\n\n\n<p>At WordCamp Paris 2016, one of Alice’s teammates introduced her to how the WordPress community collaborated and kept in contact through Slack.</p>\n\n\n\n<p>“You speak multiple languages, why don’t you try to contribute to the polyglots team?” he asked.</p>\n\n\n\n<p>Alice knew very little about contributing to WordPress. She had only been working for WP Media for 6 months and didn’t feel ready to dive into a new challenge and start also contributing to WordPress.</p>\n\n\n\n<p>Yet, curiosity led her to join both the local Italian and the global WordPress Community on Slack. For the first few months, she mainly observed what was happening the channels. Then, she attended WordCamp Milan and met some members of the Italian Polyglots team.</p>\n\n\n\n<p>It was love at first string! Laura, one of the <a href=\"https://make.wordpress.org/polyglots/teams/?locale=it_IT\"><strong>General Translation Editors</strong></a> (GTE) for Italy, taught her how to start contributing and translating, following the polyglots guidelines. She also told her about the Italian community’s big efforts to work together, consistently, to boost and grow WordPress related events in Italy.</p>\n\n\n\n<p>With her teammates’ encouragement, Orru applied to WordCamps as a speaker and gave her first talk in December 2016 at WordCamp Barcelona. After that, she both spoke at WordCamp Torino on April 2017 and at WordCamp Europe in 2017.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img src=\"https://i2.wp.com/wordpress.org/news/files/2019/10/aliceorru-wordcamp-europe.jpg?fit=632%2C356&amp;ssl=1\" alt=\"\" class=\"wp-image-7292\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2019/10/aliceorru-wordcamp-europe.jpg?w=1280&amp;ssl=1 1280w, https://i2.wp.com/wordpress.org/news/files/2019/10/aliceorru-wordcamp-europe.jpg?resize=300%2C169&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2019/10/aliceorru-wordcamp-europe.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2019/10/aliceorru-wordcamp-europe.jpg?resize=768%2C432&amp;ssl=1 768w\" sizes=\"(max-width: 632px) 100vw, 632px\" /><figcaption>Alice Orru speaking at WordCamp Europe, in Paris, in 2017</figcaption></figure>\n\n\n\n<h2><strong>Dreams evolve, all the time!</strong></h2>\n\n\n\n<p>Orru knows that her experiences are not just due to luck. She used her previous skills and passions and adapted them to a new career and life path.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>“We all have some skills; and if we don’t know which they are exactly, we should take some time to make a list of the things we’re really good at. With that in mind, just try. Apply. Get involved. Don’t get stuck in the feeling of &#8216;I can’t do it because I don’t know enough&#8217;. So that&#8217;s what I did. Without even realizing it, I started putting into reality the dream of the little girl who was born on an island and wanted to travel and speak different languages.WordPress made this possible.  I’m now part of a big community, and I am proud of it.&#8221;</p><cite>Alice Orru</cite></blockquote>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignleft is-resized\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2019/07/heropress_large_white_logo.jpg?resize=109%2C82&#038;ssl=1\" alt=\"\" class=\"wp-image-7025\" width=\"109\" height=\"82\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2019/07/heropress_large_white_logo.jpg?w=1024&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2019/07/heropress_large_white_logo.jpg?resize=300%2C225&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2019/07/heropress_large_white_logo.jpg?resize=768%2C576&amp;ssl=1 768w\" sizes=\"(max-width: 109px) 100vw, 109px\" data-recalc-dims=\"1\" /></figure></div>\n\n\n\n<p><em>This post is based on an article originally published on HeroPress.com, a community initiative created by <a href=\"https://profiles.wordpress.org/topher1kenobe/\">Topher DeRosia</a>. HeroPress highlights people in the WordPress community who have overcome barriers and whose stories would otherwise go unheard.</em></p>\n\n\n\n<p><em>Meet more WordPress community members over at </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7288\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"The Month in WordPress: September 2019\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2019/10/the-month-in-wordpress-september-2019/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Oct 2019 08:05:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7280\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:338:\"September has been a particularly busy month in the WordPress community—a lot of important work has been done as everyone in the project works towards an upcoming major release. Read on to find out more about this and everything else that has been going on over the past month. WordPress 5.2.3 Security and Maintenance Release [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7586:\"\n<p>September has been a particularly busy month in the WordPress community—a lot of important work has been done as everyone in the project works towards an upcoming major release. Read on to find out more about this and everything else that has been going on over the past month.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 5.2.3 Security and Maintenance Release</h2>\n\n\n\n<p>Early in September, <a href=\"https://wordpress.org/news/2019/09/wordpress-5-2-3-security-and-maintenance-release/\">version 5.2.3 of WordPress was released</a> as a security and maintenance release. Sixty-two individuals contributed to its 29 fixes and enhancements.</p>\n\n\n\n<p>The security issues fixed in this release owe thanks to numerous people who disclosed them responsibly. You can read more about the vulnerability reporting process <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">in the Core handbook</a>.</p>\n\n\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>WordPress 5.3 Enters Beta</h2>\n\n\n\n<p>WhileWordPress 5.3 is slated for release on November 12, it has already entered the beta phase with <a href=\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-2/\">the second beta release being made available</a> at the end of September. As this is a major release, it will feature a number of new features and enhancements, including <a href=\"https://make.wordpress.org/core/2019/09/19/whats-new-in-gutenberg-18-september/\">significant improvements to the block editor</a>, <a href=\"https://make.wordpress.org/core/2019/09/25/whats-new-in-site-health-for-wordpress-5-3/\">updates to the Site Health component</a>, <a href=\"https://make.wordpress.org/core/2019/09/24/new-block-apis-in-wordpress-5-3/\">new block APIs</a>, <a href=\"https://make.wordpress.org/core/2019/09/23/core-widgets-new-aria-current-attribute-in-wordpress-5-3/\">accessibility updates</a>, and <a href=\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-1/\">much more</a>.</p>\n\n\n\n<p>You can test the 5.3 beta release by installing <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">the WordPress Beta Tester plugin</a> on any WordPress site, although as this is software that is currently in development, we don’t recommend installing it on a live site.</p>\n\n\n\n<p>Want to get involved in building this release? <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">Test the beta</a>, follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Date/Time Component Improvements</h2>\n\n\n\n<p>For over a year, contributors involved in <a href=\"https://make.wordpress.org/core/components/date-time/\">the Date/Time component</a> of WordPress Core have been working hard on the “wp_date” project. The goal of this project is to fix and streamline the way that Core handles times and dates throughout the platform.</p>\n\n\n\n<p>This ambitious project has seen incremental changes over the last few Core releases. The upcoming 5.3 release <a href=\"https://make.wordpress.org/core/2019/09/23/date-time-improvements-wp-5-3/\">will include the final and most significant changes</a> to the component, bringing much-needed stability to time handling in WordPress Core.</p>\n\n\n\n<p>Want to get involved in the Date/Time component of WordPress Core? <a href=\"https://make.wordpress.org/core/components/date-time/\">Learn more about it</a>, follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, and join the #core-datetime channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>New Theme Review Team Structure</h2>\n\n\n\n<p>After recent discussions around the goals of the Theme Review team, <a href=\"https://make.wordpress.org/themes/2019/09/24/new-theme-review-team-structure/\">some changes have been made</a> to the leadership structure of the team. The team leads are now ‘representatives’ of different areas of the work that they do. This flat structure allows for representatives to work in more loosely defined areas so they contribute to the team in more diverse ways, and helps the team to be more focused on setting and achieving their goals. The new structure is outlined <a href=\"https://make.wordpress.org/themes/handbook/about/members/\">in the team handbook</a>.</p>\n\n\n\n<p>Want to get involved in reviewing themes for WordPress? Follow <a href=\"https://make.wordpress.org/themes/\">the Theme Review team blog</a>, and join the #themereview channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>New Default Theme: Twenty Twenty</h2>\n\n\n\n<p>The upcoming 5.3 release will also include <a href=\"https://make.wordpress.org/core/2019/09/06/introducing-twenty-twenty/\">a new default theme for WordPress</a>, <em>Twenty Twenty</em>. This theme will have a strong focus on readability and accessibility while being optimized for the block editor that first shipped with WordPress 5.0.</p>\n\n\n\n<p>Development of <em>Twenty Twenty</em> has been going quickly, with <a href=\"https://make.wordpress.org/core/2019/09/30/twenty-twenty-update/\">a recent update</a> showing more of the design and layouts that you can expect when the theme is released with WordPress 5.3 in November.</p>\n\n\n\n<p>Want to get involved in building <em>Twenty Twenty</em>? You can <a href=\"https://github.com/WordPress/twentytwenty\">contribute on GitHub</a>, follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li>The Gutenberg project has continued to see regular updates with <a href=\"https://make.wordpress.org/core/2019/09/19/whats-new-in-gutenberg-18-september/\">the latest version</a> set to be included in WordPress 5.3.</li><li>Members of the Community Team <a href=\"https://make.wordpress.org/community/2019/09/13/call-for-participants-creating-a-welcoming-and-diverse-space-online-workshop-on-sun-oct-6/\">will run a workshop</a> to help event organizers create welcoming and diverse spaces for attendees.&nbsp;</li><li>There are some <a href=\"https://make.wordpress.org/updates/2019/09/20/wordpress-user-pro-survey-11-questions-and-a-script/\">proposed updates for the annual WordPress user survey</a> that need community feedback.</li><li><a href=\"https://make.wordpress.org/docs/2019/09/23/summary-for-helphub-meeting-23-september-2019/\">Work continues on the HelpHub project</a> where contributors are moving documentation to the updated support portal.</li><li>The Gutenberg team performed further usability tests in August, <a href=\"https://make.wordpress.org/test/2019/09/06/gutenberg-usability-testing-for-august-2019/\">with some interesting results</a>.</li><li><a href=\"https://buddypress.org/2019/09/buddypress-5-0-0-le-gusto/\">Version 5.0 of BuddyPress was released</a> near the end of this month, featuring a new REST API, improved group management, and other enhancements.</li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7280\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.3 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 30 Sep 2019 21:43:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7262\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:321:\"WordPress 5.3 Beta 2 is now available! This software is still in development, so we don’t recommend running it on a production site. Consider setting up a test site to play with the new version. You can test the WordPress 5.3 beta in two ways: Try the WordPress Beta Tester plugin (choose the “bleeding edge [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Francesca Marano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3037:\"\n<p>WordPress 5.3 Beta 2 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong> so we don’t recommend running it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>You can test the WordPress 5.3 beta in two ways:</p>\n\n\n\n<ul><li>Try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (choose the “bleeding edge nightlies” option)</li><li>Or <a href=\"https://wordpress.org/wordpress-5.3-beta2.zip\">download the beta here</a> (zip).</li></ul>\n\n\n\n<p>WordPress 5.3 is slated for release on <a href=\"https://make.wordpress.org/core/5-3/\">November 12, 2019</a>, and we need your help to get there. </p>\n\n\n\n<p>Thanks to the testing and feedback from everyone who tested <a href=\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-1/\">beta 1</a>, over <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=09%2F24%2F2019..&amp;milestone=5.3&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">45 tickets have been closed</a>&nbsp;since then. </p>\n\n\n\n<h2>Some highlights</h2>\n\n\n\n<ul><li>Work continues on the <strong>block editor</strong>.</li><li>Bugs fixed on<strong> Twenty Twenty</strong>.</li><li><strong>Accessibility</strong> bugs fixes and enhancements on the interface changes introduced with 5.3 beta 1:<ul><li>Iterate on the admin interface</li><li>Reduce potential backward compatibility issues</li><li>Improve consistency between admin screens and the block editor</li><li>Better text zoom management</li></ul></li><li>Support <code>rel=\"ugc\"</code> attribute value in comments (<a href=\"https://core.trac.wordpress.org/ticket/48022\">#48022</a>) &#8211; this particular ticket shows the WordPress project ability to integrate quick solutions to things that are changing unexpectedly – like Google new features.</li></ul>\n\n\n\n<h2>Developer notes</h2>\n\n\n\n<p>WordPress 5.3 has lots of refinements to polish the developer experience. To keep up, subscribe to the&nbsp;<a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a>&nbsp;and pay special attention to the&nbsp;<a href=\"https://make.wordpress.org/core/tag/5-3+dev-notes/\">developers notes</a>&nbsp;for updates on those and other changes that could affect your products.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help us translate WordPress into more than 100 languages</a>!</p>\n\n\n\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a> where you can also find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.<br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7262\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 23 Oct 2019 09:53:53 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 22 Oct 2019 20:08:05 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20190827113608\";}", "no");
INSERT INTO `wp_options` VALUES("2815", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1571867633", "no");
INSERT INTO `wp_options` VALUES("2816", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1571824433", "no");
INSERT INTO `wp_options` VALUES("2817", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1571867634", "no");
INSERT INTO `wp_options` VALUES("2818", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"WordPress.org blog: WordPress 5.3 RC2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7425\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2019/10/wordpress-5-3-rc2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3728:\"<p>The second release candidate for WordPress 5.3 is now available!</p>\n\n\n\n<p>WordPress 5.3 is currently scheduled to be released on <strong><a href=\"https://make.wordpress.org/core/5-3/\">November 12 2019</a></strong>, but we need <em>your</em> help to get there—if you haven’t tried 5.3 yet, now is the time!</p>\n\n\n\n<p>There are two ways to test the WordPress 5.3 release candidate:</p>\n\n\n\n<ul><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option)</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.3-RC2.zip\">download the release candidate here</a>&nbsp;(zip).</li></ul>\n\n\n\n<p>For details about what to expect in WordPress 5.3, please see the&nbsp;<a href=\"https://wordpress.org/news/2019/10/wordpress-5-3-release-candidate/\">first release candidate post</a>.</p>\n\n\n\n<p>Release Candidate 2 contains improvements to the new About page, and <a href=\"https://core.trac.wordpress.org/query?id=48381%2C48363%2C48022%2C48304%2C48379%2C48087%2C47699&milestone=5.3&group=component&col=id&col=summary&col=status&col=owner&col=type&col=priority&col=milestone&order=priority\">10 fixes</a> for the following bugs and regressions:</p>\n\n\n\n<ul><li>Three bugs contained in RC1 within the block editor have been fixed (see #<a href=\"https://core.trac.wordpress.org/ticket/48381\">48381</a>).</li><li>A bug has been fixed where links within comments did not get the correct <code>rel</code> attribute (see #<a href=\"https://core.trac.wordpress.org/ticket/48022\">48022</a>).</li><li>The <code>scaled-</code> string has been added to file names when images are downsized if determined &#8220;BIG&#8221; (see #<a href=\"https://core.trac.wordpress.org/ticket/48304\">48304</a>).</li><li>The buttons group layout has been fixed in IE11 (see #<a href=\"https://core.trac.wordpress.org/ticket/48087\">48087</a>).</li><li>A bug with <code>boolean</code> <code>false</code> meta values in the REST API has been fixed (see #<a href=\"https://core.trac.wordpress.org/ticket/48363\">48363</a>).</li><li>The error code encountered when the native PHP JSON extension is missing has been adjusted to be unique (see #<a href=\"https://core.trac.wordpress.org/ticket/47699\">47699</a>).</li><li>When uploading files, HTTP error code support has been expanded to include all 5xx errors (see #<a href=\"https://core.trac.wordpress.org/ticket/48379\">48379</a>).</li></ul>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.3 and update the&nbsp;<em>Tested up to</em>&nbsp;version in the readme to 5.3. If you find compatibility problems, please be sure to post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>&nbsp;so we can figure those out before the final release.</p>\n\n\n\n<p>The&nbsp;<a href=\"https://make.wordpress.org/core/2019/10/17/wordpress-5-3-field-guide/\">WordPress 5.3 Field Guide</a>&nbsp;has also been published, which details the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n\n\n\n<p><em><strong>If you think you’ve found a bug</strong>, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Oct 2019 20:08:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Francesca Marano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: Gutenberg 6.7 Introduces Storybook and Gradient Backgrounds\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=95081\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/gutenberg-6-7-introduces-storybook-and-gradient-backgrounds\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4533:\"<p>The Gutenberg team released version 6.7 of the Gutenberg plugin last week.  The <a href=\"https://make.wordpress.org/core/2019/10/16/whats-new-in-gutenberg-16-october/\">announcement post</a> listed a little over three dozen bug fixes and several enhancements to existing features.  The most notable features included in the update are Storybook support and gradient backgrounds for the button block.</p>\n\n\n\n<p>All of the bug fixes included in Gutenberg 6.7 were ported to the first <a href=\"https://wordpress.org/news/2019/10/wordpress-5-3-release-candidate/\">WordPress 5.3 release candidate</a>.  WordPress 5.3 is expected to be released on or around November 12.</p>\n\n\n\n<p>This release also includes updates for experimental features, which can be enabled via the &#8220;Experiments&#8221; screen under the &#8220;Gutenberg&#8221; admin menu. The experimental nav menu block received alignment fixes and now only shows nested menu items when the parent item is selected.</p>\n\n\n\n<h2>First Implementation of Gradient Backgrounds</h2>\n\n\n\n<div class=\"wp-block-image\"><img />Adding a gradient to a button block.</div>\n\n\n\n<p>Version 6.7 introduces a new gradient background feature for the button block.  The long-term plan is to make gradient backgrounds available to other blocks.  The button block is a good testbed for the feature before moving forward with other blocks.</p>\n\n\n\n<p>The problem with introducing gradients is that the team didn&#8217;t go far enough with theme support early in the process.  This is par for the course with Gutenberg development.  New features are implemented without knowing exactly how themes fit into the picture.  It is only after the feature is implemented that theme support is patched on.  Often, this leads to theme authors scrambling to keep up.  It would be better for the feature and the theme support to be developed in tandem with feedback from more theme authors in the process.</p>\n\n\n\n<p>At this stage, gradients are useless in most theme designs, which have custom color schemes that are unlikely to match Gutenberg&#8217;s gradient colors.  At best, the gradients look OK with stock WordPress.  At worst, they&#8217;re garish and an assault on the eyeballs.  Starting with theme support would have at least offered theme authors a chance to make this a better experience for users.</p>\n\n\n\n<p>There is an open <a href=\"https://github.com/WordPress/gutenberg/pull/17841\">pull request on GitHub</a> to introduce theme support.  Theme authors may be able to add custom gradients by version 6.8.</p>\n\n\n\n<p>In the future, this should be a powerful feature that allows users via custom theme gradients to create some unique designs for their posts and pages.  For now, it is only in the &#8220;fun experiment&#8221; stage.</p>\n\n\n\n<h2>Storybook for Developers</h2>\n\n\n\n<div class=\"wp-block-image\"><img />Gutenberg button component stories.</div>\n\n\n\n<p>The Gutenberg development team introduced <a href=\"https://storybook.js.org\">Storybook</a> support for Gutenberg.  Developers can test Storybook support via the <a href=\"https://wordpress.github.io/gutenberg/design-system/components/\">Gutenberg Storybook page</a>.</p>\n\n\n\n<p>Storybook is a development and testing environment for user interfaces.  It allows developers to create, test, and showcase components in an isolated environment apart from the primary platform or application.  This essentially allows developers to build components without the dependencies of the platform before porting them over.  A story within the Storybook system represents the visual state of a component.  Storybooks are collections of stories.</p>\n\n\n\n<p>The Storybook support uses the <a href=\"https://github.com/storybookjs/storybook/tree/next/addons/knobs\">Knobs add-on</a>, which allows developers to edit props dynamically via the Storybook UI.  The <a href=\"https://wordpress.github.io/gutenberg/design-system/components/?path=/story/dashicon--default\">dashicons component</a> is a good place to test this out.  Currently, it accepts values for the icon name, color, and size.</p>\n\n\n\n<p>Marcus Kazmierczak, a principal engineer working on special projects at Automattic, wrote a tutorial and shared a YouTube video on how to <a href=\"https://mkaz.blog/code/coding-a-storybook-story/\">create a story for Gutenberg components</a>.  </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>For developers wanting to be involved, there are many <a href=\"https://github.com/WordPress/gutenberg/issues/17973\">components that still need a story</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Oct 2019 17:17:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Coming in WordPress 5.3: What is the PHP Spread Operator?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=95062\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wptavern.com/coming-in-wordpress-5-3-what-is-the-php-spread-operator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6962:\"<p>On October 9, Juliette Reinders Folmer announced on the core WordPress blog that <a href=\"https://make.wordpress.org/core/2019/10/09/wp-5-3-introducing-the-spread-operator/\">WordPress 5.3 will use the spread operator</a>.  The spread operator was one of the <a href=\"https://www.php.net/manual/en/migration56.new-features.php\">new features</a> made available in PHP 5.6, a version released in 2014.</p>\n\n\n\n<p>WordPress <a href=\"https://wptavern.com/wordpress-ends-support-for-php-5-2-5-5-bumps-minimum-required-php-version-to-5-6\">abandoned PHP 5.2 &#8211; 5.5</a> with the release of WordPress 5.2.  This means the core team can start taking advantage of relatively new features, or at least 5-year-old features.  For plugin and theme developers who maintain the same minimum version support as WordPress, they can also start exploring this feature.</p>\n\n\n\n<p>PHP 5.6 introduced two new methods of using the spread operator:</p>\n\n\n\n<ul><li>A Parameter in variadic functions.</li><li>Function argument unpacking of arrays and traversable objects.</li></ul>\n\n\n\n<p>This feature shouldn&#8217;t be confused with unpacking inside of arrays, which is only <a href=\"https://wptavern.com/first-look-at-php-7-4-for-wordpress-developers\">available in PHP 7.4</a>.</p>\n\n\n\n<p>The change in WordPress 5.3 is not expected to affect themes and plugins except in the rare case that a developer is overloading the <code>wpdb::prepare()</code> method.  Developers should <a href=\"https://make.wordpress.org/core/2019/10/09/wp-5-3-introducing-the-spread-operator/\">read the announcement post</a> to dive into what code has changed in core WordPress.</p>\n\n\n\n<p>Developers should check their plugins and themes with debugging enabled in a test environment to check for any notices.  There may be cases where the function signature doesn&#8217;t match.</p>\n\n\n\n<p>The spread operator is a tool, and like any tool, it should be used when it makes sense.  Because it is a language construct, it does offer speed improvements over traditional methods of using a PHP function.</p>\n\n\n\n<p>The remainder of this post will dive into the using the spread operator to help teach WordPress developers how it works.</p>\n\n\n\n<h2>Creating a Variadic Function with the Spread Operator</h2>\n\n\n\n<p>Variadic functions are PHP functions that accept a variable number of arguments passed in.  They have existed for years.  However, they can be confusing without solid inline documentation from the developer who wrote the code.  </p>\n\n\n\n<p>In the past, developers would need to use the <code>func_get_args()</code>, <code>func_get_arg()</code>, or <code>func_num_args()</code> functions to work with variadic functions.  In PHP 5.6, developers can use a parameter such as <code>...$var_name</code> to represent a variable number of parameters.</p>\n\n\n\n<p>Take a look at the following multiplication function. It will accept one, two, three, or even more numbers and multiply each.</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\nfunction tavern_multiply( ...$numbers ) {\n\n    $total = 1;\n\n    foreach ( $numbers as $number ) {\n        $total = $total * intval( $number );\n    }\n\n    return $total;\n}\n</pre>\n\n\n<p>If we use that function as shown below, it will display <code>1024</code>:</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\necho tavern_multiply( 2, 4, 8, 16 );\n</pre>\n\n\n<p>This is simple to do with the spread operator.</p>\n\n\n\n<h2>Unpacking Arrays as Function Arguments</h2>\n\n\n\n<p>PHP 5.6 allows developers to unpack arrays and traversable objects as function arguments.  To explain how this works, look at the following multiplication function for multiplying three numbers together.</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\nfunction tavern_multiply_three( $x, $y, $z ) {\n        return $x * $y * $z;\n}\n</pre>\n\n\n<p>Generally, you would need to manually pass the <code>$x</code>, <code>$y</code>, and <code>$z</code> parameters directly.  However, there are cases in real-world projects where the data (numbers in this case) would already exist within an array such as:</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\n$numbers = [ 3, 6, 9 ];\n</pre>\n\n\n<p>Prior to PHP 5.6, you would need to split that array and pass each value to the function as shown in the following snippet.</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\necho tavern_multiply_three( $numbers[0], $numbers[1], $numbers[2] );\n</pre>\n\n\n<p>With PHP 5.6, you can simply pass in <code>...$numbers</code> like so:</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\necho tavern_multiply_three( ...$numbers );\n</pre>\n\n\n<p>Both methods work and will output <code>162</code>.  However, the second method is easier to read and is less prone to typos because it uses fewer characters.</p>\n\n\n\n<h2>Comparing Code Changes in WordPress</h2>\n\n\n\n<p>For a more practical example, let&#8217;s compare a real-world code change in WordPress and how using the spread operator improves the code over other methods.  We can do this by looking at the core <code>current_user_can()</code> function.</p>\n\n\n\n<p>First, see how the code is written in WordPress 5.2 and earlier. </p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\nfunction current_user_can( $capability ) {\n    $current_user = wp_get_current_user();\n\n    if ( empty( $current_user ) ) {\n        return false;\n    }\n\n    $args = array_slice( func_get_args(), 1 );\n    $args = array_merge( array( $capability ), $args );\n\n    return call_user_func_array( array( $current_user, \'has_cap\' ), $args );\n}\n</pre>\n\n\n<p>Without looking at the full function, most developers would assume that <code>$capability</code> is the only accepted parameter for this function.  However, the function accepts a variable number of parameters.  Previously, WordPress had to use <code>func_get_args()</code> to get all the parameters, slice the array, and merge everything back together.</p>\n\n\n\n<p>It is inelegant coding, but it got the job done for old versions of PHP.</p>\n\n\n\n<p>Now compare what the same function looks like in WordPress 5.3.  First, you can see the <code>...$args</code> parameter clearly in the function statement.  You can also see there is no need for the clever coding to pass along a variable number of arguments.</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\nfunction current_user_can( $capability, ...$args ) {\n    $current_user = wp_get_current_user();\n\n    if ( empty( $current_user ) ) {\n        return false;\n    }\n\n    return $current_user-&gt;has_cap( $capability, ...$args );\n}\n</pre>\n\n\n<p>The change in WordPress 5.3 is a massive improvement in readability in comparison to earlier versions.  It is nice to see these types of improvements to the core code.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Oct 2019 16:43:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Product Reviews in the WordPress Ecosystem: Honesty and Genuine Experiences\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94992\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wptavern.com/product-reviews-in-the-wordpress-ecosystem-honesty-and-genuine-experiences\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8398:\"<p><em>I don&#8217;t write fluff pieces. I call &#8217;em like I see &#8217;em. If your project is a dumpster fire, I&#8217;m going to say it&#8217;s a dumpster fire.</em></p>\n\n\n\n<p>Whenever someone comes to me in hopes that I review their product, I give them some form of the preceding paragraph.  It doesn&#8217;t matter if it is a plugin, theme, web host, or some other product.  What matters is that I write my review with honesty and offer my genuine opinion about the thing they built.</p>\n\n\n\n<p>I rarely read most product reviews in the WordPress community anymore.  Far too often the reviewers are not offering their genuine experience with a product.  You get something like &#8220;XYZ is a multi-purpose theme that is built for…yadda, yadda, yadda…&#8221;  <em>Yawn</em>.  It reads as if publishers are trying to sell a product.  If you dig deep enough, you realize that is what many are doing (<em>hello, affiliate links</em>).</p>\n\n\n\n<p>I also have it on good authority (I&#8217;ve seen some of the email exchanges) that a lot of money exchanges hands behinds the scenes for reviews.  Most of the time, publishers are not writing a review of the product.  They are selling you their dreams of a continued working relationship with the product maker.</p>\n\n\n\n<p>There&#8217;s nothing wrong with affiliate links if a publisher loves a product.  There&#8217;s no issue with paid reviews if such reviews are honest experiences with the product.  There&#8217;s also no problem with writing a love letter to your favorite plugin and theme with no financial incentive.</p>\n\n\n\n<p>However, what I generally see are shallow reviews at best.  Many, dare I say most, reviews are not genuine.  They are certainly not real journalism.</p>\n\n\n\n<p>The best place to find genuine reviews are from the user ratings on WordPress.org, assuming the plugin or theme is available there.  Users tend to not hold back, particularly if their review is negative.</p>\n\n\n\n<p>It is tough as an artist (yes, I consider all programmers artists).  I&#8217;ve been on the receiving end of negative reviews of things I&#8217;ve built.  You learn to grow thick skin after a decade of putting your art out into the world.  </p>\n\n\n\n<p>When I was younger, I tended to be a bit hot-headed whenever I got a bad review for something I had built.  After pouring my heart and soul into a project, it cut deep to read a negative review.  I wasn&#8217;t always the most gracious receiver of such reviews.  There are responses I wish I could take back.  Looking at those times now, I wish I would have been more open to hearing what the reviewer was saying.  Even if I disagreed with every word, it did not mean that the person wasn&#8217;t providing me something of value with their review.  </p>\n\n\n\n<p>With age and I hope a little more wisdom, I usually give myself time to think about what someone is saying before I respond.  I allow my thoughts time to develop and mature.  Often, it turns out, critical reviews are far more helpful in making better art than all the five-star ratings in the world.</p>\n\n\n\n<p>When I took the writing position at WP Tavern, I wanted to bring a review format to the website that is missing within our community.  I wanted to do reviews based on my experience as both a user and a developer.  I admit that I was not prepared for a negative reaction to what was in part a negative review.  As always, I gave myself time to read and think over what some commenters were saying.  This article is my response.</p>\n\n\n\n<h2>Reviews Are About Personal Experience</h2>\n\n\n\n<p>One of the things I learned early on as a writer is to not second guess myself, especially when writing an opinion piece.  It is not good for one&#8217;s mental health.</p>\n\n\n\n<p>An opinion piece is about the moment.  It is raw.  It is passionate.</p>\n\n\n\n<p>Writers&#8217; opinions may change over time.  They are human and have the freedom to change their minds later.  However, an opinion-based story should reflect that single moment in time and what the author&#8217;s feelings are at that moment.</p>\n\n\n\n<p>There&#8217;s a common (and wholly incorrect) notion that journalism should be nothing more than facts, that subjectivity is not allowed.  Throughout the several hundred years that some form of journalism has existed, there has never existed a point where the whole of the field was objective.  Even in the early days of U.S. journalism, my country&#8217;s founders published articles in newspapers to sway public opinion on ratifying the U.S. Constitution.  </p>\n\n\n\n<p>Reporting, which is one form of journalism, does not represent the whole.  It is the most objective form of journalism in which the reporter simply tells the news to readers.  We certainly do plenty of that at the Tavern.  However, other forms like editorials, features, and reviews are as important.  These forms take a different approach.</p>\n\n\n\n<p>Reviews are the unwieldy beasts of journalism.  They are hard to tame.  They&#8217;re not always pretty.  However, they should always be true to their nature.  They can bring out angry hoards of fanboys down on the critic (ever read the comments of a critical review of an Apple product?).</p>\n\n\n\n<p>Honest reviews are about personal experience.  If a film critic dislikes the latest movie in the Marvel Cinematic Universe, it is that critic&#8217;s duty to write about their experience watching it.  The reviewer has an obligation to not huddle in fear of Iron Man fanatics who will inevitably send <em>ad hominem</em> attacks his way.  Holding back one&#8217;s opinion within a review is the ultimate sin of a critic.</p>\n\n\n\n<p>Like with any products or forms of art, WordPress plugins and themes are not immune to this same criticism.  Such criticism is even more important when the software costs money and potential buyers may be looking for genuine reviews.</p>\n\n\n\n<p>Disagreement with a review is OK.  Disagreements are more interesting than everyone nodding their heads in unison.  What a boring world it would be if we were all in agreement.</p>\n\n\n\n<p>However, I did want to address comments on my previous review about it being <em>unfair</em>, specifically the unfairness of my personal experience.  It&#8217;s that personal experience that makes a review genuine.  Not everyone&#8217;s experience will be the same.  One person&#8217;s one-star rating does not discount another&#8217;s five stars.  They are equally valid because they represent different experiences.</p>\n\n\n\n<h2>Developers Are Users Too</h2>\n\n\n\n<p>There&#8217;s a common idea in the WordPress community that developers are not users, that our experiences don&#8217;t count because our knowledge and skillsets are more advanced than the average.  At first glance, the argument makes some sense.  However, after giving it some serious thought, I reject the notion.</p>\n\n\n\n<p><em>Martin Scorsese can&#8217;t criticize films because he makes films.  There&#8217;s no way he can feel what the average person does at the cinema.</em></p>\n\n\n\n<p><em>Beyoncé can&#8217;t judge a music competition because she&#8217;s a singer.  She&#8217;s not listening with the ears of a normal human.</em></p>\n\n\n\n<p>Wait; that&#8217;s not right, is it?</p>\n\n\n\n<p>Why is it that developers&#8217; opinions are so easily discounted when they are critical of user experience?  I use WordPress, different themes, and various plugins every day.  I use those that make me happy or serve essential functions.  I don&#8217;t necessarily pick plugins out because I like their code.  I use them because I too am a user in every way that a non-developer is a user.  Having the ability to articulate the problems from a different viewpoint doesn&#8217;t change that.</p>\n\n\n\n<p>In many ways, developers can provide more useful software reviews than &#8220;average&#8221; users because we have some past experience solving the same problems.</p>\n\n\n\n<h2>Offering a Genuine Review</h2>\n\n\n\n<p>One thing you will always get from me is honesty.  When I review a WordPress-related product, you will always read about my personal experience.</p>\n\n\n\n<p>I was fully prepared to say that <em>the gloves are coming off</em>, but the gloves have always been off.  I will never hold back criticism.  I&#8217;m always ready to pile on the praise too.</p>\n\n\n\n<p>But, I won&#8217;t lie to you.</p>\n\n\n\n<p>Who&#8217;s ready to have their theme or plugin reviewed next?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Oct 2019 16:42:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Chilean News Publication El Soberano First to Launch on Newspack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=95023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/chilean-news-publication-el-soberano-first-to-launch-on-newspack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9309:\"<div class=\"wp-block-image\"><img />El Soberano homepage on the Newspack platform.</div>\n\n\n\n<p>Nine months after the <a href=\"https://en.blog.wordpress.com/2019/01/14/newspack-by-wordpress-com/\">announcement of Newspack</a> by WordPress.com, the Chilean news site <a href=\"https://elsoberano.org\">El Soberano</a> became the first publication to launch on the new platform.  On October 16, the small news team <a href=\"https://newspack.blog/2019/10/17/first-publisher-relaunches-using-newspack/\">relaunched with a fresh design</a> powered by the Newspack theme and its newsroom-focused plugins.</p>\n\n\n\n<p>Newspack is a project of Automattic, the parent company of WordPress.com.  Its goal is to work with leaders in the news industry to create a platform that brings WordPress to more newsrooms.  This year, the team behind Newspack has worked with several publications to address obstacles in journalism on the web.</p>\n\n\n\n<p>The Newspack team was primarily advised by <a href=\"https://newspack.blog/2019/04/03/newspack-chooses-12-publishers-new-platform/\">12 publications during their first phase</a>.  Most of those publications are based in the U.S., but a few, such as El Soberano, are from other countries.  The Daily Maverick from Johannesburg, South Africa, and Reveal from the Center for Investigative Reporting from California came on as advisers from the outset.  However, they may also launch on Newspack sometime in the coming months.</p>\n\n\n\n<p>&#8220;We had 10 sites that we&#8217;re going to launch as soon as possible,&#8221; said Steve Beatty, head of Newspack Communications.  &#8220;Of the 10, one dropped out as they changed publishers. So that leaves El Soberano and eight others, and those eight should launch in the coming weeks &#8212; certainly by year&#8217;s end. We&#8217;ve got the next few queued up.&#8221;</p>\n\n\n\n<p>During the initial phase, Beatty said the team was looking for small to medium-sized newsrooms that were covering local news or niche publications.  The development hurdles would likely have been much higher starting with large organizations.</p>\n\n\n\n<p>&#8220;We wanted newsroom leaders who were willing to experiment and try something bold and different, knowing that there was a very real chance of growing pains,&#8221; said Beatty. &#8220;The partners in our pilot newsrooms have been incredibly helpful, patient, understanding and cheerful. I&#8217;m not sure we screened for all that in the application process, but it&#8217;s worked out quite well.&#8221;</p>\n\n\n\n<h2>El Soberano is a Fitting Launch Partner</h2>\n\n\n\n<div class=\"wp-block-image\"><img />Content Director Roberto Bruna (left) and Executive Director Ana Arriagada (right).</div>\n\n\n\n<p>WordPress.com claims its &#8220;mission is to democratize publishing one website at a time.&#8221;  El Soberano, based in Santiago, is a smaller news publication with three people on the current full-time staff.  Their goal is to connect citizens with organizations that will help defend their rights.  The publication covers social movements within the country and to be an outlet for independent journalism.</p>\n\n\n\n<p>&#8220;In our news outlet we believe that only the organized people are sovereign of their destiny,&#8221; said Roberto Bruna, Content Director at El Soberano.  &#8220;Our name &#8216;El Soberano&#8217; is all about <em>el pueblo soberano</em>, the &#8216;sovereign people&#8217; in English.  For us, individual rights and freedoms are crucial. Then, things like a secular state and civil rights, such as the legalization of cannabis, homoparental adoption or the right to a safe abortion, are things we report about.&#8221;</p>\n\n\n\n<p>Bruna further defined the publication&#8217;s goals.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>In El Soberano we defend an environment free of contamination; equal opportunities for women, ending the precariousness of their lives; a real pension system for citizens; sexual dissidence, to guarantee their equal rights and inclusion; a new development model based on innovation and knowledge; a secular state and freedom with critical thinking; urban planning and good housing solutions; consumers and a healthy and sustainable market and, finally, mechanisms that aim to create truly democratic constitutions for our countries.</p></blockquote>\n\n\n\n<p>El Soberano does not give space for other interest groups because such groups have the means to make their opinions publicly available.  Instead, its mission is to report on social issues directly from citizens.  &#8220;In them lies the power of decision regarding the direction that our democracies must take,&#8221; said Bruna.</p>\n\n\n\n<h2>Launching El Soberano with Newspack</h2>\n\n\n\n<p>As one of the first publications to launch with a new system, it&#8217;s tough to be a pioneer when a lot is riding on success.  Ana Arriagada, Executive Director of El Soberano, was ready to take the news website to the next level after three years.</p>\n\n\n\n<p>&#8220;When we decided to take the next step and transform El Soberano into a sustainable environment, it was a great achievement for us to be chosen for the Newspack pilot with other eleven news outlets,&#8221; said Arriagada.  &#8220;We were the only news site in Spanish and from Latin America, so we felt very proud.&#8221;</p>\n\n\n\n<p>Arriagada has worked with the Newspack development team over the past six months to help guide them on what tools are needed to run a newsroom.</p>\n\n\n\n<p>The decision to apply for the Newspack pilot program was in part due to avoiding pitfalls they had seen with other digital media websites.  &#8220;Friends with their websites hijacked by a former &#8216;friend&#8217; developer when they try to move to a new platform, custom developments that only the author understood, huge invoices for maintenance hours, or even spending months working on a design that was not possible at the end,&#8221; said Arriagada.  They wanted to avoid other problems such as taking too long to apply changes to the homepage in the fast-paced world of journalism where new stories should be front and center.</p>\n\n\n\n<p>Arriagada said such problems were resolved with Newspack and their team can concentrate on editorial and revenue generation.</p>\n\n\n\n<p>El Soberano originally launched on WordPress.com in January 2016.  Arriagada said it was nearly impossible to find a good selection of templates that were built specifically to solve the problems of the news industry.  &#8220;In Newspack we have the chance to combine different content blocks adapted to our needs, showing content in flexible ways,&#8221; said Arriagada.  &#8220;Now we have tools designed to generate revenue with the experience and best practices from world-class digital media.&#8221;</p>\n\n\n\n<p>Arriagada called working with the Newspack team a &#8220;journey of discovery.&#8221;  In the beginning, it wasn&#8217;t clear how the team would use the information they were collecting from El Soberano and other publications or how the team would resolve issues based on the information provided.  Eventually, they received design proposals, which allowed them to get a feel for what they wanted and to further provide feedback to the Newspack team.</p>\n\n\n\n<p>&#8220;Later, we received the access to the platform where we were able to play around, putting things in order, creating and implementing what we were looking for,&#8221; said Arriagada. &#8220;More feedback, corrections, hopes, and dreams.&#8221;</p>\n\n\n\n<p>She said that working with the <a href=\"https://github.com/Automattic/newspack-blocks\">Content Blocks</a> system allowed her team to better create and assemble their homepage and articles.  &#8220;But maybe the most interesting thing for us,&#8221; said Arriagada, &#8220;was that Newspack team and other news sites from the pilot program proposed things that we don&#8217;t consider for our site, such as an ultra-flexible donation system or workflow systems. We see a lot of power in that collaborative way to develop a product.&#8221;</p>\n\n\n\n<h2>The Future of Newspack</h2>\n\n\n\n<p>Newspack launched <a href=\"https://wptavern.com/newspack-opens-up-application-process-for-phase-two\">phase two of its program</a> in July, which sought to bring 50 more newsrooms to the platform.  The new publications should be announced shortly.</p>\n\n\n\n<p>&#8220;Both the initial pilot group and this group of 50 (or so) are part of the one-year development period, which ends on February 29,&#8221; said Beatty.  &#8220;We&#8217;re still determining what will happen on March 1. We&#8217;ll have a better sense of that when we start working with the 50 and see how quickly we can turn them around.&#8221;</p>\n\n\n\n<p>Like much of Automattic&#8217;s work, it is open source and freely available to the public.  Newspack is a collection of packages to create a platform for newsrooms.  Of note are the following repositories.</p>\n\n\n\n<ul><li><a href=\"https://github.com/Automattic/newspack-theme\">Newspack Theme</a></li><li><a href=\"https://github.com/Automattic/newspack-plugin\">Newspack Plugin</a></li><li><a href=\"https://github.com/Automattic/newspack-blocks\">Newspack Blocks</a></li></ul>\n\n\n\n<p>Developers can find all eight plugins from the <a href=\"https://github.com/Automattic?q=newspack\">Automattic GitHub page</a> if they want to give them a spin.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Oct 2019 17:56:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WordPress.org blog: Empowering Generations of Digital Natives\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7413\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wordpress.org/news/2019/10/empowering-generations-of-digital-natives/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8892:\"<p>Technology is changing faster each year. Digital literacy can vary between ages but there are lots of ways different generations can work together and empower each as digital citizens.</p>\n\n\n\n<p>No matter whether you’re a parent or caregiver, teacher or mentor, it’s hard to know the best way to teach younger generations the skills needed to be an excellent digital citizen. If you’re not confident about your own tech skills, you may wonder how you can help younger generations become savvy digital citizens. But using technology responsibly is about more than just technical skills. By collaborating across generations, you can also strengthen all your family members’ skills, and offer a shared understanding of what the internet can provide and how to use it to help your neighborhoods and wider society.&nbsp;<br /></p>\n\n\n\n<h2>Taking Gen Z Beyond Digital Savvy</h2>\n\n\n\n<h3>Open up the dialogue</h3>\n\n\n\n<p>Even if you’re not fully confident in your own tech skills, you can help develop digital citizenship skills in others. If you feel comfortable during everyday conversation, you could describe a tech situation you have come across and ask family members if they have ever experienced something similar. You can give them a chance to share how they handled it or how it made them feel. This can help encourage them to think critically and to react with empathy. And being asked for advice can make them feel appreciated and empowered. But opening up the conversation can also be as simple as asking if they’ve seen anything online lately that they found interesting or wanted to talk about.</p>\n\n\n\n<h3>Share access to free and affordable training</h3>\n\n\n\n<p>Open source content management systems have made online publishing accessible to a more diverse group of people. Dozens of content platforms offer hands-on training at no or low cost. <a href=\"https://wordpress.tv/\">WordPress.tv</a>, <a href=\"https://www.linkedin.com/learning/topics/wordpress\">LinkedIn Learning</a>, and others have low-cost video libraries with thousands of recorded talks and workshops and the WordPress Training team have excellent downloadable lesson plans and materials. These platforms not only feature content that helps develop tech and content creation skills but also content around ethics, diversity and community building.&nbsp;&nbsp;</p>\n\n\n\n<h3>Find a sense of community and belonging</h3>\n\n\n\n<p>One of the disadvantages of increased digitalization is that <a href=\"https://www.theatlantic.com/magazine/archive/2017/09/has-the-smartphone-destroyed-a-generation/534198/\">younger generations and us all may spend less time hanging out in-person.</a> Digital time spent with others is no replacement for in-person interactions. The awareness and mutual understanding which comes from back and forth interaction is needed for positive interpersonal skills. This is hard to replace in digital communities and those skills can only be learned with lots of hands-on practice.&nbsp;</p>\n\n\n\n<h3>Learn the many benefits of volunteering&nbsp;</h3>\n\n\n\n<p>There are WordPress events across the world that provide a great place to learn new skills to share with your families and friends. Some work with schools and colleges to offer special events which are open to all ages. There are also plenty of small ways to volunteer with the WordPress project that can be done at home to practice new skills.</p>\n\n\n\n<p>In addition to attending events where you can learn skills and hang out with others with similar interests, the WordPress ecosystem offers countless opportunities to be actively involved. Professionals, hobbyists, and learners all make a difference by contributing to the ongoing creation of the WordPress platform. Together these people, who are known as contributors, form the <a href=\"https://make.wordpress.org/\">WordPress open source community.</a>&nbsp;</p>\n\n\n\n<h4>WordPress is created by volunteer contributors</h4>\n\n\n\n<p>Not only are these contributors creating an amazingly flexible platform for all to use, it is an environment where you can continue to improve your skills, both technical and interpersonal. Open-source software projects can introduce you to people you would otherwise not get the chance to meet, locally and internationally. If you have a zest for learning, and for finding others to connect with, WordPress has many ways to meet contributors in person!</p>\n\n\n\n<h4>WordPress events are organized by volunteers</h4>\n\n\n\n<p>WordPress community events are volunteer-run. This can be a great way to give back to the project and practice all sorts of skills. Talk to your local event about how you could get involved and if you would like to bring older teenagers and young adults with you. You will not need any pre-existing tech skills to attend these events but they are a great way to discover areas you might want to learn more about.&nbsp;</p>\n\n\n\n<h4>Contributor days offer a great opportunity to get involved</h4>\n\n\n\n<p>These events are specially designed to help you get involved in building the open-source WordPress platform. You can collaborate with other members of its community and find areas that are right for you to use and grow your skills. All of the tasks you will discover at an event can be continued at home and some are easy to get other family members involved in learning and adding in ideas.&nbsp;</p>\n\n\n\n<p>Contributors come from all sorts of backgrounds and locations, some may live near you and others thousands of miles away. Working alongside lots of different cultures and countries can open up new ideas for young people letting them learn new ways of doing things and discover different perspectives. All those different perspectives can cause misunderstandings. But being involved in a global learning community is a great way to practice communicating across cultural boundaries.&nbsp;</p>\n\n\n\n<h4>Getting involved can be rewarding in many (unexpected) ways</h4>\n\n\n\n<p>The most rewarding part of actively taking part in WordPress events is making budding friendships. New connections often turn into long-lasting friendships that are likely to continue for years to come, both online and offline. With a global community, these friendships can potentially lead to lots of international adventures too!</p>\n\n\n\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Getting ready for the <a href=\"https://twitter.com/WordCampBTN?ref_src=twsrc%5Etfw\">@WordCampBTN</a>. I&#8217;ve got my 5kg backpack and one-way ticket to London in a few days <img src=\"https://s.w.org/images/core/emoji/12.0.0-1/72x72/1f929.png\" alt=\"🤩\" class=\"wp-smiley\" /> What shall I do after? <img src=\"https://s.w.org/images/core/emoji/12.0.0-1/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" /> <a href=\"https://t.co/cdQqeyNWif\">pic.twitter.com/cdQqeyNWif</a></p>— Sabrina Zeidan going to #WCKyiv (@sabrina_zeidan) <a href=\"https://twitter.com/sabrina_zeidan/status/1160265428473712640?ref_src=twsrc%5Etfw\">August 10, 2019</a></blockquote>\n\n\n\n<h3>Make our digital world safer and more inclusive</h3>\n\n\n\n<p>Befriending people from a wide variety of cultures and backgrounds can be an enriching experience in itself. It can also help you make us make more informed decisions. The more we interact with a diverse range of people, the more empathic we become. Some of the most valuable learning that can be offered to Gen Z (and probably to all of us at times) is that what we come across in fast-moving digital communities isn’t always the entire view.&nbsp;</p>\n\n\n\n<h2>All things considered….</h2>\n\n\n\n<p>Anyone who is a digital native may not need encouragement to obtain tech skills. But they may not be aware that digital communities are still communities and <a href=\"https://wordpress.org/news/2019/10/responsible-participation-in-online-communities/\">we need to use the same sorts of people skills for both offline and online locations</a>. Opening up conversations about situations they may experience online that may require them to (re)act responsibly, can encourage them to think critically and act with empathy. Compared to previous generations, digital natives spend substantially more time by themselves while using devices, so encouraging them to join real-life communities, such as WordPress, could be the first step to learning what it means to be a good digital citizen!&nbsp; </p>\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/webcommsat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>webcommsat</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chanthaboune</a>, <a href=\"https://profiles.wordpress.org/yvettesonneveld/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yvettesonneveld</a> &amp; <a href=\"https://profiles.wordpress.org/annemariedh/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>annemariedh</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Oct 2019 20:03:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Yvette Sonneveld\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: Mark Davies Joins Automattic as Chief Financial Officer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=95009\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wptavern.com/mark-davies-joins-automattic-as-chief-financial-officer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4364:\"<p>Automattic, the company behind WordPress.com, WooCommerce, and various other products, announced earlier today that Mark Davies has joined the team as its Chief Financial Officer (CFO).  This news comes fresh off the heels of Automattic&#8217;s <a href=\"https://wptavern.com/automattic-acquires-tumblr-plans-to-rebuild-the-backend-powered-by-wordpress\">acquisition of Tumblr</a> in August and a <a href=\"https://wptavern.com/automattic-raises-300m-in-series-d-investment-round-valuation-jumps-to-3-billion\">$300 million Series D investment</a> from Salesforce Ventures in September.  The investment round gave the company a $3 billion valuation after the funding.</p>\n\n\n\n<p>Davies graduated from Western Washington University with a bachelor&#8217;s degree in accounting and earned his MBA in finance at Arizona State University.  He has since worked for large companies in key roles.  Prior to taking the position with Automattic, Davies served as the CFO at Vivint, a North American smart home technology company.</p>\n\n\n\n<p>Vivint was founded in 1999 and claims over $1 billion in annual revenue.  In 2012, The Blackstone Group <a href=\"https://www.reuters.com/article/us-blackstone-acquisition/blackstone-buys-security-firm-vivint-for-over-2-billion-idUSBRE88I0LF20120919\">purchased the company for over $2 billion</a>.  Davies came on board in 2013 and would have played a large role in growing the company&#8217;s annual revenue.</p>\n\n\n\n<p>Vivint announced on October 15 that Davies <a href=\"http://investors.vivint.com/press-releases/press-release-details/2019/Vivint-Smart-Home-Announces-CFO-Transition/default.aspx\">was leaving the company</a>.  &#8220;Mark has created a talented and experienced finance team with a solid track record of growth and financial discipline,&#8221; said Todd Pedersen, co-founder and CEO of Vivint Smart Home. &#8220;We thank him for his six years with the company and wish him the best in his next role.&#8221;</p>\n\n\n\n<p>Before joining Vivint, Davies served as president of global business services with Alcoa.  He was also a member of the Alcoa Executive Council.  Prior to that position, he spent 12 years at Dell Inc. in various roles.  His most recent position was as the managing vice president of strategic programs.  He earlier served as the CFO of Dell&#8217;s Global Consumer Group, which is a $14 billion enterprise with operations across the world.  He held positions with Applied Materials and HP earlier in his career.</p>\n\n\n\n<p>Davies should play a key role in helping Automattic grow beyond its current levels of revenue.  He has the credentials and experience to do so.</p>\n\n\n\n<p>&#8220;Automattic is creating the operating system for the web, from websites to ecommerce to social networks,&#8221; said Matt Mullenweg, founder and CEO of Automattic and co-founder of WordPress. &#8220;As we zoom past 1,100 employees in over 70 countries, we wanted a financial leader with experience taking businesses from hundreds of millions in revenue to billions and even tens of billions, as Mark has. I&#8217;m excited about working alongside such an experienced leader day-to-day to build one of the defining technology companies of this era.&#8221;</p>\n\n\n\n<p>Mullenweg if often cited saying that he would like to see WordPress have an 85% share of the web.  Currently, WordPress runs over 34% of the top 10 million websites.  Automattic would certainly play a role in pushing the platform toward that lofty goal.  He and David Heinemeier Hansson <a href=\"https://wptavern.com/matt-mullenweg-and-david-heinemeier-hansson-discuss-wordpress-market-share-monopolies-and-power-in-open-source-communities\">discussed the dynamics of power</a> in open source communities and whether such a goal was healthy for the web earlier this month.  In the discussion, Mullenweg clarified that 85% was a &#8220;trailing indicator&#8221; rather than a goal.</p>\n\n\n\n<p>Stuart West served as Automattic&#8217;s CFO for the last seven years.  He will continue working within the company, but there is no word on what that new role is. &#8220;I want to thank Stu for his significant contributions to Automattic during his seven and a half years as CFO,&#8221; said Mullenweg. &#8220;He built a talented finance team during a period of 10x growth in staff and revenue and played an essential role in the success of our company.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Oct 2019 15:49:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: New Automattic CFO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=50302\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://ma.tt/2019/10/new-automattic-cfo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:975:\"<p>As <a href=\"https://venturebeat.com/2019/10/16/automattic-nabs-vivint-cfo-to-chase-steep-revenue-growth/\">Venturebeat has picked up</a>, Mark Davies will be leaving <a href=\"https://www.vivint.com/\">Vivint</a> and joining <a href=\"https://automattic.com/\">the merry band</a>. <span>Automattic is creating the operating system for the web, from <a href=\"https://wordpress.com/\">websites</a> to <a href=\"https://woocommerce.com/\">ecommerce</a> to <a href=\"https://tumblr.com/\">social networks</a>. As we zoom past 1,100 employees in over 70 countries, we wanted a financial leader with experience taking businesses from hundreds of millions in revenue to billions (Vivint) and even tens of billions (Alcoa and Dell), <a href=\"https://www.linkedin.com/in/mark-davies-14937a3/\">as Mark has</a>. I’m excited about working alongside such an experienced leader day-to-day to build what I hope will become one of the defining technology companies of the open web era.</span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Oct 2019 15:28:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WordPress.org blog: WordPress 5.3 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7397\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2019/10/wordpress-5-3-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3142:\"<p>The first release candidate for WordPress 5.3 is now available!</p>\n\n\n\n<p>This is an important milestone as we progress toward the WordPress 5.3 release date. “Release Candidate” means that the new version is ready for release, but with millions of users and thousands of plugins and themes, it’s possible something was missed. WordPress 5.3 is currently scheduled to be released&nbsp;on&nbsp;<strong>November 12, 2019</strong>, but we need&nbsp;<em>your</em>&nbsp;help to get there—if you haven’t tried 5.3 yet, <strong>now is the time</strong>!</p>\n\n\n\n<p>There are two ways to test the WordPress 5.3 release candidate: </p>\n\n\n\n<ul><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option)</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.3-RC1.zip\">download the release candidate here</a>&nbsp;(zip).</li></ul>\n\n\n\n<h2>What’s in WordPress 5.3?</h2>\n\n\n\n<p>WordPress 5.3 expands and refines the <strong>Block Editor</strong> introduced in WordPress 5.0 with <strong>new blocks, more intuitive interactions, and improved accessibility</strong>. New features in the editor increase design freedoms, provide additional layout options and style variations to allow designers complete control over the look of a site.</p>\n\n\n\n<p>This release also introduces the <strong>Twenty Twenty</strong> theme giving the user more design flexibility and integration with the Block Editor. </p>\n\n\n\n<p>In addition, WordPress 5.3 allows developers to work with <strong>dates and timezones</strong> in a more reliable way and prepares the software to work with <strong>PHP 7.4</strong> to be release later this year. </p>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.3 and update the&nbsp;<em>Tested up to</em>&nbsp;version in the readme file to 5.3. If you find compatibility problems, please be sure to post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>&nbsp;so we can figure those out before the final release.</p>\n\n\n\n<p>The&nbsp;WordPress 5.3 Field Guide&nbsp;will be published within the next 24 hours with a more detailed dive into the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a>&nbsp;This release also marks the&nbsp;<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a>&nbsp;point of the 5.3 release schedule.</p>\n\n\n\n<p><em><strong>If you think you’ve found a bug</strong>, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Oct 2019 21:18:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Francesca Marano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WordPress.org blog: Responsible Participation In Online Communities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7386\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wordpress.org/news/2019/10/responsible-participation-in-online-communities/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9139:\"<p>In our <a href=\"https://wordpress.org/news/2019/10/becoming-better-digital-citizens-through-open-source/\">first article in this series</a>, we highlighted the WordPress mission to democratize publishing. WordPress introduced a tool to independent and small publishers who did not have the resources of the larger publishing platforms. Access to a free content management system to create websites has empowered thousands of people to find their voice online. People have been able to share their enthusiasm for hobbies, causes, products and much more. Through these different voices, we can encourage understanding, spark creativity, and create environments where collaboration can happen. But as we build more digital communities, it&#8217;s easy to forget that online safety is a group effort.</p>\n\n\n\n<p>Digital literacy is also part of being a good digital citizen, but it’s more than just being able to do basic actions with your mobile device. Digital literacy refers to the range of skills needed to do online research, set up web accounts, and find solutions for fixing devices among other things. But to be able to enjoy more of the digital world safely and responsibly &#8211; to be a good digital citizen &#8211; we need to be able to:&nbsp;</p>\n\n\n\n<ul><li><strong>navigate</strong> vast amounts of information without getting overwhelmed;</li><li><strong>evaluate</strong> a variety of perspectives;</li><li><strong>connect</strong> with people with respect and empathy;</li><li><strong>create</strong>, curate and share information.</li></ul>\n\n\n\n<p>We will need our offline analytical and social skills to make that happen.&nbsp;</p>\n\n\n\n<h2>Here’s some best practices our community members have shared!</h2>\n\n\n\n<h3>Online or offline, let empathy be your compass</h3>\n\n\n\n<p>The hardest part about all of this is the anonymity of online interactions. Without that face-to-face feedback of saying something mean to another person&#8217;s face, it&#8217;s easy to upset the people you&#8217;re trying to communicate with.</p>\n\n\n\n<p>In our daily lives in the offline world, comments may be more tempered and slow to anger  in disagreements. Visual cues will help us determine how a remark is perceived. That, in turn, helps us adjust our behaviour Action, reaction, it’s how we learn best.</p>\n\n\n\n<p>Online, however, the experience is different. A keyboard does not protest if we type angry, hate-filled messages. A screen does not show any signs of being hurt. The lack of physical human presence combined with the anonymity of online alter-egos can be a formula for disrespectful and unfriendly behavior. It is good to remind ourselves that behind the avatars, nicknames and handles are real people. The same empathy we display in our in-person interactions should apply online as well.</p>\n\n\n\n<h3>Critically evaluate your sources&nbsp;</h3>\n\n\n\n<p>We all have times when we consume information with limited research and fact-checking. For some of us, it feels like there’s no time to research and compare sources when faced by a sea of online information. For others, there may be uncertainty about where to start and what to consider. But, without a bit of skepticism and analytical thinking, we run the risk of creating narrow or incorrect understanding of the world. With a little effort we can curb the sharing of fake news and biased information, particularly on topics that are new to us or that we’re not familiar with.</p>\n\n\n\n<p>Misinformation can spread like wildfire. Ask these simple questions to evaluate information online:&nbsp;</p>\n\n\n\n<ul><li>who is the source of the information?</li><li>is it plausible?</li><li>is the information fact or just an opinion?</li></ul>\n\n\n\n<h3>Own our content</h3>\n\n\n\n<p>In this day and age, it’s never been easier to just copy, paste and publish somebody else&#8217;s content. That doesn’t mean that we should! Publishing content that is not truly ‘yours’ in wording and tone of voice is unlikely to build a connection with the right audience. But, just as important, using someone else’s content may breach copyright and potentially intellectual property rights. </p>\n\n\n\n<p>For more information about intellectual property, <a href=\"https://www.wipo.int/about-ip/en/\">visit the World Intellectual Property Organization website</a>.</p>\n\n\n\n<h3>Don’t breeze past terms and conditions</h3>\n\n\n\n<p>Have you ever signed up for an online service (to help you distribute published content or accept payments) that was offered at no cost? In our fast-paced digital lives, we tend to want to breeze past terms and conditions or warning information and often miss important information about what will happen with our data. </p>\n\n\n\n<p>When we are given a contract on paper, we tend to read and re-read it, giving it a greater priority of our time. We may send it to other people for a second opinion or seek further review before signing. Remarkably, we rarely do that with online agreements. As a result, we may be putting our online privacy and security at risk. (WordPress uses a <a href=\"https://make.wordpress.org/community/handbook/wordcamp-organizer/planning-details/gpl-primer/\">GPL license</a>, and only collects usage data that we never share ever.).</p>\n\n\n\n<h3>Keep your website safe and healthy</h3>\n\n\n\n<p>If you would like to own your voice online, you also need to protect your reputation by securing your publishing platform. Websites can face security attacks. Hackers may seek to obtain access through insecure settings, outdated plugins and old software versions, and in extreme cases can try to scam your visitors. And leaking customer data, may even lead to legal consequences.</p>\n\n\n\n<p>On top of that, websites ‘flagged’ for security issues, can lead to high bounce rates and eventual loss of search rankings. This can all affect how search engines rate or even block your site. </p>\n\n\n\n<p>Good practices to keep your website safe include changing your safe password regularly, installing security software, an SSL certificate and keeping the core software, plugins and themes up to date. This will not guarantee that you will keep hackers out, so always keep several backups of your site, ideally both offline and online.</p>\n\n\n\n<p>That is just website security in a tiny nutshell. If you would like to learn more about keeping websites safe, you may want to check out some of these resources and many more videos at WordPress.tv.</p>\n\n\n\n<h2>Join in and help make the web a better place!</h2>\n\n\n\n<p>As part of Digital Citizenship Week, we would like to encourage you to learn and share skills with your colleagues, friends and family members. That way, we all become more informed of potential issues and how to reduce the risks. Together we can make it easier to navigate the web more effectively and securely!</p>\n\n\n\n<h3>Additional resources</h3>\n\n\n\n<h4>Site health check</h4>\n\n\n\n<p>WordPress 5.2 introduced pages in the admin interface to help users run health checks on their sites. They can be found under the Tools menu.</p>\n\n\n\n<h4>Security and SSL&nbsp;</h4>\n\n\n\n<ul><li><a href=\"https://wordpress.tv/2019/01/23/victor-santoyo-security-and-ssl-whats-the-difference/\">Video recording of a presentation by Victor Santoyo about website security and SSL</a>.</li><li><a href=\"https://wordpress.tv/2017/08/31/jessica-gardner-ssl-what-it-is-how-to-do-it-and-why-you-should-care/\">Video recording of a presentation by Jessica Gardner about why you should care about SSL and how to use it.</a></li><li><a href=\"https://wordpress.tv/2018/02/03/adam-warner-the-personal-and-website-security-mindset/\">Video recording of a presentation by Adam Warner about the personal and website security mindset</a>.</li><li><a href=\"https://wordpress.tv/2018/07/05/miriam-schwab-content-security-policies-a-whole-new-way-of-securing-your-website-that-no-one-knows/\">Video recording of a presentation by Miriam Schwab about content security policies</a>.</li><li><a href=\"https://en.support.wordpress.com/https-ssl/\">More information about SSL licenses on WordPress.com</a>.</li><li><a href=\"https://wordpress.org/plugins/search/SSL\">SSL plugins in the WordPress plugin repository</a>.</li></ul>\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/chanthaboune/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chanthaboune</a>, <a href=\"https://profiles.wordpress.org/yvettesonneveld/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yvettesonneveld</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>webcommsat</a>,  <a href=\"https://profiles.wordpress.org/muzhdekad/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>muzhdekad</a> <a href=\"https://profiles.wordpress.org/alexdenning/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>alexdenning</a>,&nbsp;<a href=\"https://profiles.wordpress.org/natashadrewnicki/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>natashadrewnicki</a>, <a href=\"https://profiles.wordpress.org/oglekler/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>oglekler</a>, and Daria Gogoleva.</p>\n\n\n\n<p><br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Oct 2019 19:41:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Yvette Sonneveld\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: Kioken Blocks Partners with Gutenslider Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94895\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wptavern.com/kioken-blocks-partners-with-gutenslider-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2972:\"<p><a href=\"https://wordpress.org/plugins/kioken-blocks/\" rel=\"noopener noreferrer\" target=\"_blank\">Kioken Blocks</a> creator Onur Oztaskiran is teaming up with Niklas Jurij Plessing, a Berlin-based developer and author of the <a href=\"https://wordpress.org/plugins/gutenslider/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenslider</a> plugin, to improve both products under the same roof. Oztaskiran said the partnership is not an acquisition but rather a unification of efforts that may eventually result in combining under the same name.</p>\n<p>&#8220;Our short term plan is to work on each other&#8217;s plugins to improve them according to our individual areas of expertise (me in design, marketing and user happiness, him in development and more technical stuff where I fall short), and then fully collaborate on plugins and themes,&#8221; Oztaskiran said.</p>\n<p>Gutenslider will remain a standalone plugin and will not be merged into Kioken Blocks. Both products will share similar resources in terms of functionality and support. The team plans to work on porting their products to be ready for WordPress.org&#8217;s upcoming Block Directory. Pro users of Kioken Blocks will be able to use the pro functionalities of Gutenslider and the team plans to make Gutenslider work like an extension to Kioken Blocks.</p>\n<p>&#8220;Gutenslider is pretty extensive at it is, and we thought it deserves to keep going as a standalone block and plugin, since it will be also available in the upcoming Block Directory for Gutenberg,&#8221; Oztaskiran said. &#8220;We will handle it as another product even though it is under the same roof as Kioken Blocks. We will continue adding new features to that block and improve the experience and Kioken Blocks will gain new blocks as well, but not as extensive as Gutenslider. There&#8217;s a possibility we could rename the block but that&#8217;s not the case at the moment.&#8221;</p>\n<p>Oztaskiran said he sees a lot of possibilities in Gutenslider, because it is not just an image and video slider but capable of adding different types of block content on top of the slides, such as paragraphs, headings, images, galleries, products, and more.</p>\n<p></p>\n<p>&#8220;Since the future of Gutenberg, as we see it, is going to be shaped around the Block Directory in the editor, our plan is focusing more blocks on that directory, with the Kioken Blocks as a builder on top of them as a plugin,&#8221; Oztaskiran said. &#8220;The final goal is building an ecosystem for WordPress users who have adopted the new editor &#8211; products, plugins and themes with a streamlined interface and experience. Dev partnerships are the first step of it.&#8221;</p>\n<p>Oztaskiran could not confirm if the product catalog will be combining under one company name. The final decision has not yet been made but he said it is likely that they will combine under the Kioken branding sometime in the future for marketing their WordPress products.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Oct 2019 19:03:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: WordPress 5.2.4 Release Addresses Several Security Issues\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94983\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/wordpress-5-2-4-release-addresses-several-security-issues\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2982:\"<p>The core WordPress team released version 5.2.4 of WordPress on October 14.  The release addresses six security issues that were all privately reported through WordPress&#8217; <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure procedure</a>.</p>\n\n\n\n<p>Like any security release, users should update immediately to the latest version to keep their sites secure.</p>\n\n\n\n<p>For those with automatic updates enabled, the new version is already rolling out to sites. All major branches of WordPress from version 3.7 to 5.2 received the new security fixes. If automatic updates are not enabled, users should update from the &#8220;Updates&#8221; screen under &#8220;Dashboard&#8221; in the WordPress admin.  Otherwise, users can download WordPress from the <a href=\"https://wordpress.org/download/release-archive/\">release archive</a> and manually <a href=\"https://wordpress.org/support/article/updating-wordpress/\">run an update</a> to make sure their site is not at risk to what are now publicly-known vulnerabilities.</p>\n\n\n\n<p>In the <a href=\"https://wordpress.org/news/2019/10/wordpress-5-2-4-security-release/\">release announcement</a>, the following security issues were noted. They were corrected in all updated versions.</p>\n\n\n\n<ul><li>Stored cross-site scripting (XSS) could be added from the Customizer screen.</li><li>An issue that allowed stored XSS to inject JavaScript into <code>&lt;style></code> tags.</li><li>A bug that allowed unauthenticated posts to be viewed.</li><li>A method to use the <code>Vary: Origin</code> header to poison the cache of JSON <code>GET</code> requests (REST API).</li><li>A server-side request forgery (SSRF) with how URLs are validated.</li><li>Issues with referrer validation in the WordPress admin.</li></ul>\n\n\n\n<p>For developers who want to dive more into the code changes, the <a href=\"https://github.com/WordPress/wordpress-develop/compare/5.2.3…5.2.4\">changeset is available on GitHub</a>.  Most changes should not affect plugins or themes.  However, it is worth noting that the <code>static</code> query property was removed in this release.  This removal affects both the <code>WP</code> and <code>WP_Query</code> classes.  Developers should test their plugins against this version to make sure nothing is broken if their projects rely on this property.  It is unlikely that many plugins rely on this query variable.</p>\n\n\n\n<p>WordPress 5.2.4 also includes a couple of other bug fixes.  One <a href=\"https://core.trac.wordpress.org/changeset/46074\">removes a line of code</a> that makes an extra call to the <code>wp-sanitize.js</code> script in the script loader.  The second fix <a href=\"https://core.trac.wordpress.org/changeset/46473\">addresses an issue</a> where the directory path wasn&#8217;t normalized on Windows systems, which led to the <code>wp_validate_redirect()</code> function removing the domain. This fixes a bug created in WordPress 5.2.3.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Oct 2019 15:52:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"WPTavern: Meetup.com Introduces RSVP Fees for Members, WordPress Meetup Groups Unaffected by Pricing Changes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94958\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://wptavern.com/meetup-com-introduces-rsvp-fees-for-members-wordpress-meetup-groups-unaffected-by-pricing-changes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4936:\"<p><a href=\"https://www.meetup.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Meetup</a>, a subsidiary of <a href=\"https://www.wework.com/\" rel=\"noopener noreferrer\" target=\"_blank\">WeWork</a>, has announced a significant change to its pricing structure that will require members to pay a $2 fee in order to RSVP to events. The change will go into effect in October, ostensibly to distribute meetup costs more evenly between organizers and members. Some meetup organizers have received the following <a href=\"https://www.meetup.com/lp/paymentchanges?mpId=9038\" rel=\"noopener noreferrer\" target=\"_blank\">message</a>:</p>\n<blockquote><p>Meetup is always looking for ways to improve the experience for everyone in our community. One of the options we are currently exploring is whether we reduce cost for organizers and introduce a small fee for members.</p>\n<p>Beginning in October, members of select groups will be charged a small fee to reserve their spot at events. The event fee can be paid by members or organizers can cover the cost of events to make it free for members.</p></blockquote>\n<p>Organizers have the option to subsidize the $2 fee for members who RSVP so that it is entirely free for those who attend, but for popular groups this can become cost prohibitive. If 1,000 members RSVP for an event, the organizer would owe $2,000 to host it.</p>\n<p>The new pricing does not apply to non-profit groups or Pro Networks. WordPress community organizer Andrea Middleton has <a href=\"https://twitter.com/andmiddleton/status/1183868783116472320\" rel=\"noopener noreferrer\" target=\"_blank\">confirmed</a> that Meetup&#8217;s pricing changes will not affect groups that are part of the <a href=\"http://meetup.com/pro/wordpress/\" rel=\"noopener noreferrer\" target=\"_blank\">official WordPress chapter</a>. In 2018, <a href=\"https://make.wordpress.org/community/2019/04/18/2018-meetup-survey/\">WordPress had 691 meetup groups in 99 countries</a> with more than 106,000 members. According to Meetup.com, groups in the official chapter now number 780 in 2019. Middleton encouraged any outlying WordPress meetup groups to join the official chapter by <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/meetup-program-basics/\" rel=\"noopener noreferrer\" target=\"_blank\">submitting an application</a>.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2019/10/Screen-Shot-2019-10-14-at-9.28.03-PM.png?ssl=1\"><img /></a></p>\n<p>Meetup organizers and members who are affected by the pricing hike are unhappy about the changes. If the <a href=\"https://twitter.com/securestep9/status/1183798804371386369\" rel=\"noopener noreferrer\" target=\"_blank\">angry responses on Twitter</a> are any indication, people are leaving the platform in droves. Many organizers have announced that they are cancelling their subscriptions and looking to migrate to other platforms, such as <a href=\"https://kommunity.com/\" rel=\"noopener noreferrer\" target=\"_blank\"> Kommunity</a> or <a href=\"http://gettogether.community\" rel=\"noopener noreferrer\" target=\"_blank\">gettogether.community</a>, an open source alternative for managing local events.</p>\n<p>No competitor has the reach or brand recognition that Meetup has. Some groups will inevitably resort to using Eventbrite or Facebook to manage local meetups but neither of these are focused on promoting or growing these types of local events. Discovery and new meetup marketing are Meetup.com&#8217;s forte, but the platform has been fairly stagnant when it comes to improving the user experience.</p>\n<p>&#8220;This new move is quite onerous on users, and WP is lending support to the platform, which is proprietary and for-profit,&#8221; Morten Rand-Hendriksen <a href=\"https://twitter.com/mor10/status/1183853556647903232\" rel=\"noopener noreferrer\" target=\"_blank\">said</a>. &#8220;The optics and messaging are not great. When tools we use start to act in problematic ways, and we keep using them, we are tacitly agreeing to and even promoting that behavior even if it is not directly affecting us.&#8221;</p>\n<p>Andrea Middleton responded, acknowledging that WordPress&#8217; use of certain platforms will sometimes involve compromise.</p>\n<p>&#8220;It&#8217;s true that WordPress contributors use various proprietary and for-profit tools to help us achieve various outreach and coordination goals,&#8221; Middleton said. &#8220;I think we strive for a balance between expediency and idealism, but of course any compromise results in a loss of one or the other.&#8221;</p>\n<p>Given the immediate backlash following Meetup.com&#8217;s announcement of the pricing changes, it would not be surprising to see the decision reversed. The company characterized the move as an &#8220;exploration&#8221; and plans to roll it out gradually to more meetups. For organizers who are looking to charge more on top of the fee to cover event costs, Meetup said this feature is coming soon.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Oct 2019 04:12:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WordPress.org blog: WordPress 5.2.4 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7372\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2019/10/wordpress-5-2-4-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3666:\"<p><a href=\"https://wordpress.org/wordpress-5.2.4.zip\">WordPress 5.2.4</a> is now available! This security release fixes 6 security issues.<br /><br />WordPress versions 5.2.3 and earlier are affected by these bugs, which are fixed in version 5.2.4. Updated versions of WordPress 5.1 and earlier are also available for any users who have not yet updated to 5.2.</p>\n\n\n\n<h3>Security Updates</h3>\n\n\n\n<ul><li>Props to&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://evanricafort.com/\">Evan Ricafort</a>&nbsp;for finding an issue where stored XSS (cross-site scripting) could be added via the Customizer.</li><li>Props to&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://codesymphony.co/\">J.D. Grimes</a>&nbsp;who found and disclosed a method of viewing unauthenticated posts.</li><li>Props to&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://weston.ruter.net/\">Weston Ruter</a>&nbsp;for finding a way to create a stored XSS to inject Javascript into style tags.</li><li>Props to David Newman for highlighting a method to poison the cache of JSON GET requests via the Vary: Origin header.</li><li>Props to <a href=\"http://eugenekolo.com/\">Eugene Kolodenker</a> who found a server-side request forgery in the way that URLs are validated.</li><li>Props to Ben Bidner of the WordPress Security Team who discovered issues related to referrer validation in the admin.</li></ul>\n\n\n\n<p>Thank you to all of the reporters for <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">privately disclosing</a> the vulnerabilities, which gave us time to fix them before WordPress sites could be attacked.</p>\n\n\n\n<p>For more info, browse the full list of changes on Trac or check out the Version&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://wordpress.org/support/wordpress-version/version-5-2-4/\">5.2.4 documentation page</a>.<br /><br />WordPress 5.2.4 is a short-cycle security release. The next major release will be&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://make.wordpress.org/core/5-3/\">version 5.3</a>.<br /><br />You can <a href=\"https://wordpress.org/wordpress-5.2.4.zip\">download WordPress 5.2.4</a> or visit <code>Dashboard → Updates</code> and click <code>Update Now</code>. Sites that support automatic background updates have already started to update automatically.<br /><br />In addition to the security researchers mentioned above, thank you to everyone who contributed to WordPress 5.2.4:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/darthhexx\">darthhexx</a>, <a href=\"https://profiles.wordpress.org/davidbinda\">David Binovec</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/jeffpaul\">Jeff Paul</a>, <a href=\"https://profiles.wordpress.org/nickdaugherty\">Nick Daugherty</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sstoqnov\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">Garth Mortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, and <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Oct 2019 21:54:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: AMP Project Joins OpenJS Foundation Incubation Program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94906\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wptavern.com/amp-project-joins-openjs-foundation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5565:\"<p>Last week at the AMP Contributor Summit 2019 in New York City, the AMP project <a href=\"https://blog.amp.dev/2019/10/10/amp-is-joining-the-openjs-foundation-incubation-program/\" rel=\"noopener noreferrer\" target=\"_blank\">announced</a> that it will be joining the <a href=\"https://openjsf.org\" rel=\"noopener noreferrer\" target=\"_blank\">OpenJS Foundation</a> incubation program. OpenJS was formed by a recent merger between the JS Foundation and the Node.js Foundation. AMP will join webpack, jQuery, Mocha, Node.js, ESLint, Grunt, and other open source projects that have OpenJS as their legal entity.</p>\n<p>Over the past year, AMP has been evolving its governance, moving to an open, consensus-seeking governance model in 2018, similar to the one <a href=\"https://nodejs.org/en/about/governance/\" rel=\"noopener noreferrer\" target=\"_blank\">adopted by the Node.js project</a>. One of the primary objectives of changing AMP&#8217;s governance and moving to a foundation was to foster a wider variety of contributions to the project and its technical and product roadmap. The incubation process will address AMP&#8217;s lack of contributor diversity and inclusion, as only past or current Google employees have commit rights on the code base.</p>\n<p>In recognition of how the project&#8217;s connection to Google has been problematic for adoption, the company is transferring AMP&#8217;s domains and trademarks to OpenJS, which is a vender-neutral organization, as outlined in the FAQs of OpenJS&#8217; <a href=\"https://openjsf.org/blog/2019/10/10/openjs-foundation-welcomes-amp-project-to-help-improve-user-experience-on-the-web/\" rel=\"noopener noreferrer\" target=\"_blank\">announcement</a>:</p>\n<blockquote><p>The OpenJS Foundation prides itself on vendor neutrality. Our vested interest resides solely in the ecosystem and the projects that contribute to that ecosystem. The OpenJS Foundation’s Cross Project Council is committed to supporting AMP in addressing these issues and ensure continued progress. During onboarding, AMP will also go through a multi-step process including adopting the OpenJS Foundation Code of Conduct, transferring domains and trademarks and more to graduation from incubation. AMP has made incredible strides by adopting a new governance model and by joining the OpenJS Foundation, they’ve made their intentions clear-AMP is committed to its vision of “A strong, user-first open web forever.”</p></blockquote>\n<p>Google is, however, a Platinum member of the OpenJS Foundation with annual dues of more than $250K per year. This membership guarantees the company direct participation in running the Foundation, a guaranteed board seat, and have a direct voice in budget and policy decisions. Google plans to maintain its team of employees who contribute full time to the AMP project.</p>\n<p>According to <a href=\"https://twitter.com/tobie\" rel=\"noopener noreferrer\" target=\"_blank\">Tobie Langel</a>, a member AMP&#8217;s advisory committee, one of the changes in moving to the OpenJS Foundation is AMP&#8217;s governance model will no longer be under the purview of Google and the ultimate goal is that Google will cease funding AMP directly. Instead, the company will direct funds through the foundation and work to remove the project&#8217;s Google dependencies for its infrastructure and tooling.</p>\n<h3>OpenJS Aims to Disentangle AMP Runtime from Google Cache</h3>\n<p>Gaining full infrastructural independence from Google will be no small feat for AMP contributors. The OpenJS Foundation&#8217;s announcement states that one of the long term goals in moving the project over is to disentangle the AMP runtime from the Google AMP Cache:</p>\n<blockquote><p>The end goal is to separate the AMP runtime from the Google AMP Cache. The Project is currently in the incubating stage and Project leaders are still determining the next steps. Ideally, hosting and deployment of the AMP runtime to the CDN would fall under the purview of the OpenJS Foundation, much like the foundation is handling other projects CDNs, such as the jQuery CDN.  </p>\n<p>Untangling the runtime from the cache is a complex endeavor requiring significant investments of time and effort which would be planned and implemented in collaboration with the foundation and industry stakeholders during and after incubation.</p>\n<p>The OpenJS Foundation CPC is committed to having a long-term strategy in place to address this issue by the end of AMP’s incubation.</p></blockquote>\n<p>AMP is used on more than <a href=\"https://blog.amp.dev/2018/02/13/amps-new-horizons/\" rel=\"noopener noreferrer\" target=\"_blank\">30 million domains</a>. While many see this news as a positive move towards AMP&#8217;s eventual independence from Google, it doesn&#8217;t remove Google&#8217;s power to compel publishers to support the AMP standard by prioritizing AMP pages in search results. The news was received with skepticism by commenters on <a href=\"https://news.ycombinator.com/item?id=21242890\" rel=\"noopener noreferrer\" target=\"_blank\">Hacker News</a> and <a href=\"https://www.reddit.com/r/firefox/comments/dhgwlb/google_takes_amp_to_the_openjs_foundation/f3nxmq0/\" rel=\"noopener noreferrer\" target=\"_blank\">Reddit</a>, who deemed it &#8220;mostly meaningless window-dressing,&#8221; given how aggressively Google is pushing AMP in its search engine. AMP remains deeply controversial and moving it to a foundation that is heavily financially backed by Google is not enough to win over those who see it as Google&#8217;s attempt to shape the web for its own interests.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Oct 2019 20:52:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Inside Look at GoDaddy’s Onboarding Process for Managed WordPress Hosting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94901\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/inside-look-at-godaddys-onboarding-process-for-managed-wordpress-hosting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8199:\"<p>The Tavern was provided access to test GoDaddy&#8217;s onboarding process, which is a part of its <a href=\"https://www.godaddy.com/offers/wordpress-hosting\">managed WordPress hosting</a> service.  The company has revamped its system since we <a href=\"https://wptavern.com/godaddy-launches-new-onboarding-experience-for-wordpress-customers\">covered it in 2016</a>.  The web host has had time to garner feedback since then and build an easy-to-use, headache-free way to launch WordPress sites.</p>\n\n\n\n<p>GoDaddy has been making waves in the WordPress community over the past few years and is quickly becoming one of the most dominant businesses in the ecosystem.  Several of the company&#8217;s free WordPress themes consistently rank in the theme directory&#8217;s <a href=\"https://wordpress.org/themes/browse/popular/\">popular list</a>.  Most of them are child themes of their popular <a href=\"https://wordpress.org/themes/primer/\">Primer theme</a>, which boasts 40,000+ active installs when not counting child theme installs.  The real count should be north of 200,000.</p>\n\n\n\n<p>GoDaddy provided access to its Pro 5+ tier, which is its highest level of managed WordPress hosting.  They have three lower tiers, each at different price points and with fewer features.  Regular pricing for the tiers range between $9.99 and $34.99 per month.  All levels include automatic backups, security scans, caching, and a slew of other features that are not always easy to figure out for new users.</p>\n\n\n\n<p>Aaron Campbell , GoDaddy’s head of WordPress Ecosystem &amp; Community, said that their hosting service is growing quickly.  &#8220;We were among the largest WordPress hosts when we launched our Managed WordPress Hosting in 2014,&#8221; he said.  &#8220;Within 2 years our offering became the largest Managed WordPress platform in the world and remains so to this day.&#8221;</p>\n\n\n\n<p>GoDaddy launched its basic onboarding process later in 2014.  They iterated on that version through 2018.  &#8220;When Gutenberg went into core in WordPress 5.0 we saw an opportunity to redefine the WordPress onboarding and imagine what a &#8216;Gutenberg native&#8217; experience would look like,&#8221; said Campbell.  &#8220;Meaning, do what Gutenberg uniquely enables us to do over what was possible before&#8211;things that couldn&#8217;t be done by making existing themes Gutenberg &#8216;compatible&#8217; we had to build from the ground up.&#8221;</p>\n\n\n\n<p>Based on my experience with the product, I would have no qualms about recommending it to new or even more experienced users.  Even those with no experience running WordPress can create a new site without trouble in far less time than it&#8217;d take to go through the normal, more complex process.</p>\n\n\n\n<h2>How the Onboarding Process Works</h2>\n\n\n\n<p>One of the hardest things to know prior to signing up for a service and handing over your credit card number is how the service works. For this reason, I snagged a few screenshots and will do a quick walk-through of the process.</p>\n\n\n\n<p>Once you are ready to build your new website, the service provides a &#8220;Set up&#8221; link that sends you to GoDaddy&#8217;s onboarding screen.  There are three paths to choose from.  The first and most prominent is to view the available templates, which is the path that new users would choose.  You can also manually set up WordPress or migrate an existing site.</p>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>When selecting to view templates, the service presents over 50 options to choose from.  The templates are further grouped by category based on the type of site a user might want to create.  I chose the &#8220;Beckah J.&#8221; option because it worked for my idea of creating a life-wellness site.</p>\n\n\n\n<p>Each of the templates are created from GoDaddy&#8217;s new Go WordPress theme, which is currently <a href=\"https://github.com/godaddy-wordpress/go\">available via GitHub</a> and <a href=\"https://themes.trac.wordpress.org/ticket/75007\">awaiting review</a> for placement in the official WordPress theme directory.</p>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>After selecting a template, the process moves to a preview screen, which has buttons to switch between desktop, tablet, and mobile views.  From that point, you can choose to use the template or go back and select another.</p>\n\n\n\n<p>This was the first point of the process that felt like it needed polishing.  The preview frame was too small to get a feel for what the site would look like on desktop or tablet.  This is a fixable problem.  There&#8217;s plenty of screen real estate GoDaddy could use to make the preview nicer.</p>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>The next screen allows users to enter information about what type of site they want to run. Depending on which of the following checkboxes are ticked, GoDaddy will set up the site differently.</p>\n\n\n\n<ul><li>Provide information</li><li>Write blog posts</li><li>Display my portfolio</li><li>Sell physical goods to my customers</li><li>Sell digital goods to my customers to download</li></ul>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>After completing the final form, GoDaddy begins creating the site.  The host sets up the site with one or more of several plugins based on the choices made in the previous form.</p>\n\n\n\n<p>The site installation process was slower than I had expected.  We live in a fast-paced world where users expect things to happen nearly instantly.  I admit I was antsy while waiting for the process to complete, in part because everything else happened so quickly.  I wondered if I had time to grab a sandwich.  In reality, it was much faster than manually setting up a WordPress install, but the setup did take a few minutes of waiting.  My experience may have been an anomaly too.  Sometimes these things take time.</p>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<h2>A Website Ready to Go</h2>\n\n\n\n<p>Out of the box, my newly-created site had five custom pages ready based on my choices during the onboarding process.</p>\n\n\n\n<ul><li>Blog</li><li>Get in Touch</li><li>Home</li><li>My Account</li><li>My Cart</li></ul>\n\n\n\n<p>It was nice to see WooCommerce ready and a contact form set up with my email (handled by the CoBlocks plugin). I would rather have seen <code>contact</code>, <code>account</code>, and <code>cart</code> page slugs for their respective pages, but that&#8217;s a personal preference.</p>\n\n\n\n<p>The site came with seven plugins installed, five of which were activated.</p>\n\n\n\n<ul><li>Akismet (deactivated)</li><li>CoBlocks</li><li>Gravity Forms (deactivated)</li><li>Sucuri Security</li><li>WooCommerce</li><li>WP101 Video Tutorials</li><li>Yoast SEO</li></ul>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/coblocks/\">CoBlocks</a> along with theme integration for the block editor is what made the process of working with the website a breeze.  GoDaddy <a href=\"https://wptavern.com/godaddy-acquires-themebeans-coblocks-block-gallery-and-block-unit-tests\">acquired the CoBlocks plugin</a> in April.  At the time, the plugin had 30,000+ active installs.  It has since grown to 80,000+ in the few months since GoDaddy has taken over.</p>\n\n\n\n<h2>The Onboarding Process Provides a Nice User Experience</h2>\n\n\n\n<p>I&#8217;ve been critical of GoDaddy over the years.  I am a customer of one of their other hosting products that launched years ago.  That particular site is stuck on PHP 5.6, which has given me the feeling that the company is not focused on its older projects.  However, Campbell said they are in the process of moving users on legacy hosting products to a newer platform.</p>\n\n\n\n<p>I&#8217;ve been cautiously optimistic about the work GoDaddy has been doing within the WordPress community.  They&#8217;ve more than shown their commitment to the WordPress platform over the past few years.</p>\n\n\n\n<p>Despite a couple of minor hiccups, the onboarding process the hosting giant has built is one of the best experiences I have ever had launching a WordPress site.  Even as an old pro, I&#8217;d consider using it for future projects, particularly when setting up sites for less tech-savvy family and friends.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Oct 2019 20:30:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WordPress.org blog: Becoming Better Digital Citizens Through Open Source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7353\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wordpress.org/news/2019/10/becoming-better-digital-citizens-through-open-source/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7957:\"<p>The WordPress Project is on a mission to democratize publishing. As WordPress empowers more people to participate in the digital space, we have the opportunity to make sure that everyone can participate safely and responsibly. Today marks the start of Digital Citizenship Week. We are going to share how open source can be used as a tool for learners (regardless of age) to practice and model the essential parts of being a good digital citizen.</p>\n\n\n\n<h2>What is digital citizenship?</h2>\n\n\n\n<p>The digital landscape constantly changes and this affects the way we use the internet. New platforms emerge, people find different ways to spread information, communities form, grow and fade away every day. The concepts and practice of promoting civil discourse, critical thinking and safe use of the internet still remain central. And that is exactly what digital citizenship is about.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><em>“Put simply, digital citizenship is a lot like citizenship in any other community &#8212; the knowledge of how to engage with digital communities you’re part of in a way that is thoughtful, safe, and makes appropriate use of the technology.”</em></p><cite><em>Josepha Haden, Executive Director WordPress Project</em></cite></blockquote>\n\n\n\n<h2>Who is a digital citizen?</h2>\n\n\n\n<p>Digital Citizenship is for all age groups. Anyone who uses the internet on a computer, mobile device or a TV is a digital citizen. You don’t have to be tech-savvy already, maybe you are taking your first steps with technology. Digital Citizenship Week is a chance to reflect together on our impact on the digital world. It can help us to make our consumption more considered and our interaction friendlier. It enables us to make a positive difference to those around us.</p>\n\n\n\n<p>All of us can strive (or learn) to become better digital citizens. It can be affected by the access those teaching have had to digital skills and good practice. Adult education classes and community tech hubs play a part in basic tech skill development. Unfortunately, these are not always accessible to those in less populated geographic locations.&nbsp;</p>\n\n\n\n<p>Open source communities like WordPress already make a difference in encouraging the principles of digital citizenship, from sharing tech skills to improving security knowledge. They give people an opportunity to learn alongside their peers and many of the resources are available regardless of location, resources, or skills.</p>\n\n\n\n<ul><li>WordPress Meetups &#8212; locally-based, informal learning sessions &#8212; typically take place monthly on weekday evenings. </li><li>WordCamps are city-based conferences that take place in cities worldwide. These events usually last 1-3 days and are organized and run by volunteers.</li><li>The talks are also recorded and made available on the free, online library <a href=\"https://wordpress.tv/\">WordPress.tv</a>. These can be watched from the comfort of your own home, office or during informal get-togethers.</li></ul>\n\n\n\n<h3>What can we do as part of the WordPress community?</h3>\n\n\n\n<p>Digital citizenship skills, like many other skills needed in this tech-focused world, should be kept up-to-date. Open source communities offer unparalleled opportunities to do this and are available in countries across the world. As part of our role as members of WordPress and other communities, we can pass on such skills to others. For instance by working alongside people who have had limited experience of digital skills. Or by finding new ways of making this knowledge sharing fun and accessible.&nbsp;</p>\n\n\n\n<p><strong>Here are just a few of the ways we do and can make an even greater difference:</strong></p>\n\n\n\n<ul><li>as bloggers and writers, we can be more aware of how to write content responsibly.</li><li>as designers, we can think more about how different people will view, understand and respond to the designs and visuals we create or use.</li><li>as developers, we can build systems that make it easier for all users to find information and accomplish their goals, to be secure while visiting our sites, and to model good security and practice.</li><li>as community members, through organizing events like <a href=\"https://www.meetup.com/pro/wordpress\">WordPress Meetups</a> and <a href=\"https://central.wordcamp.org\">WordCamps</a>, we are helping equip those who may not have had access to digital literacy or who lack the confidence to put it into place or share with their family and colleagues. Through these events, the online videos and other resources on <a href=\"https://wordpress.tv/\">WordPress.tv</a> and through the <a href=\"https://make.wordpress.org/\">Make WordPress teams</a>, we are already making a difference every day.</li><li>as individuals, the way we communicate in the community and listen to each other is equally important. This is a vital part of how we grow and model positive digital citizens. Through growing our positive digital skills and a better understanding of online etiquette and challenges, we can make our immediate and wider digital world a more positive and useful environment.</li><li>making it easier to document and share knowledge.</li><li>emphasizing how skills learned within the community can be used in other parts of our digital lives.</li><li>creating and becoming ambassadors for Digital Citizenship.</li></ul>\n\n\n\n<p>You can also get involved with specific events that have grown out of the wider WordPress project, championed by enthusiasts and those wanting to improve specific digital skills and bring wider benefits to society.</p>\n\n\n\n<h2>Community-driven Events</h2>\n\n\n\n<p>For example, <a href=\"https://wptranslationday.org\"><strong>WordPress Translation Day</strong></a> in 2019 had 81 local events worldwide. Running for 24-hours, individuals with language skills translated aspects of the platform into multiple languages with a total of 1181 projects modified. An amazing 221 new translators joined on the day. In addition, there was a live stream with talks, panel discussions, interviews, and sharing of tips and skills to help others learn how to translate. Volunteers are now planning the event for 2020!<br /><br /><a href=\"https://make.wordpress.org/polyglots/2019/03/01/global-wordpress-translation-day-4-is-coming/\">Stories of how people came together for WordPress Translation Day</a></p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div><br />Interviews with some of the participants from a previous WordPress Translation Day giving a flavour of how volunteers developed this event.\n\n\n\n<p><strong>Do_action days</strong> are WordPress events organized in local communities to help give charities their own online presence. Each event involves members of the local WordPress community, planning and building new websites for selected local organizations in one day. Some take place in a working day, others on weekends.&nbsp;</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>Volunteer Tess Coughlan-Allen talking about how people came together for the first do_action in Europe to help local charities. \n\n\n\n<p><a href=\"https://doaction.org\">Find the next do_action hackaton nearby your home town.</a></p>\n\n\n\n<h3>Improving digital skills through WordPress</h3>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div><br />In this video clip, Josepha talks about the Digital Divide and what current technological trends mean for it in the future. She explores what it takes to be literate in the digital landscape and how WordPress can be used to build and perfect those skills.\n\n\n\n<h2>Contributors</h2>\n\n\n\n<p>Thanks to <a href=\"https://profiles.wordpress.org/webcommsat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>webcommsat</a> for researching and writing this article and <a href=\"https://profiles.wordpress.org/yvettesonneveld/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yvettesonneveld</a> for her supporting work in this series.<br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Oct 2019 07:31:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Yvette Sonneveld\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Edit Flow Future in Flux: Here Are 5 Alternative Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94489\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wptavern.com/edit-flow-future-in-flux-here-are-5-alternative-plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10230:\"<p>After years of unpredictable development and support, it seemed the <a href=\"https://wordpress.org/plugins/edit-flow/\" rel=\"noopener noreferrer\" target=\"_blank\">Edit Flow</a> plugin had finally given up the ghost last week when an Automattic support representative <a href=\"https://wptavern.com/automattic-has-discontinued-active-development-on-edit-flow-plugin\" rel=\"noopener noreferrer\" target=\"_blank\">confirmed that it is no longer being actively developed</a> and recommended users switch to an alternative. Nick Gernert, head of WordPress.com VIP, has since <a href=\"https://wptavern.com/automattic-has-discontinued-active-development-on-edit-flow-plugin#comment-307821\" rel=\"noopener noreferrer\" target=\"_blank\">commented</a> on our post to clarify the company&#8217;s intentions. He said Automattic is &#8220;in no way dropping support for Edit Flow:&#8221;</p>\n<blockquote><p>I’ll start by saying we are in no way dropping support for Edit Flow.</p>\n<p>We do see a difference between active feature development and maintenance updates to a plugin and this post tends to use these things interchangeably. It is correct that we are not currently pushing new features for Edit Flow. However, we are committed to maintaining this and other plugins so that those who depend on them are able to continue to do so.</p>\n<p>We face the same challenge that many in software face when it comes to supporting existing work while looking to the future and where to invest energy. I hope folks can understand the delicate balance here. We accept that we have fallen short at times when it comes to maintaining our existing work and appreciate the community holding us accountable.</p></blockquote>\n<p>Gernert also said the company&#8217;s VIP service is &#8220;seeing demand for WordPress in the enterprise market like never before.&#8221; The team is doubling down on its commitment to product development for this market and Gernert said outlook for Edit Flow and other Automattic plugins should improve:</p>\n<blockquote><p>VIP is more committed than ever to product development for the unique needs of this space. We have recently brought on a new Head of Product and Engineering. With the addition of this role, there is a commitment to focused product development and that includes ensuring key plugins like Edit Flow are maintained. Presently, that maintenance includes security updates, critical bugs, ensuring compatibility with new versions of WordPress, and directly supporting VIP customer use. Going forward the VIP Product and Engineering teams are committed to allocating time to regularly review and address issues and provide regular updates to the plugins. As we stabilize on maintenance, new feature development will pick up in areas where we see unique opportunity.</p></blockquote>\n<p>Users and developers seemed wary of this response, given the plugin&#8217;s history and more recent experiences of trying to contribute to its upkeep. <a href=\"https://gorillabunny.com/\" rel=\"noopener noreferrer\" target=\"_blank\">James Miller</a>, a developer who was using Edit Flow on a client project, shared his experience trying to submit a PR for a bug fix.</p>\n<p>&#8220;It doesn’t seem like it’s even being given a level of attention at the most basic level of what could be considered &#8216;maintained,\'&#8221; Miller said. &#8220;This plugin was breaking functionality of other plugins on a client site.</p>\n<p>&#8220;I forked the repo, fixed the issue, and <a href=\"https://github.com/Automattic/Edit-Flow/pull/499\" rel=\"noopener noreferrer\" target=\"_blank\">submitted a PR</a> on January 26. After several months of periodic commenting and asking if anybody was even maintaining the repo, it finally got merged just last month. This doesn’t seem to me like a commitment to maintaining the plugin.&#8221;</p>\n<h3>What Does this Mean for Edit Flow Users?</h3>\n<p>If you&#8217;re not currently experiencing any critical bugs and you don&#8217;t require additional features beyond what it offers, Edit Flow may be still be a good option if Automattic is able to improve its maintenance. As previously predicted, any new features coming to this plugin will be those that &#8220;directly support VIP customer use.&#8221;</p>\n<p>Support for the plugin has not improved over the last week, so users may still be waiting for updates and fixes for awhile. The support forums indicate that multiple users continue to report issues with both the block editor and the classic editor, as well as conflicts with other plugins. This is likely why Automattic support representatives <a href=\"https://wordpress.org/support/topic/edit-flow-plugin-is-closed-no-longer-supported/\" rel=\"noopener noreferrer\" target=\"_blank\">recommend</a> users fork Edit Flow or switch to another solution.</p>\n<p>In support of smaller WordPress-powered publications that have an immediate need for editorial tools, we have compiled a list of alternatives that offer more frequent maintenance and support. Edit Flow&#8217;s primary features include a calendar, custom statuses, editorial comments, editorial metadata, notifications, story budget, and user groups. One of the alternatives below may be a suitable replacement, depending on which features are most important to your editorial workflow.</p>\n<h3>PublishPress</h3>\n<p><a href=\"https://wordpress.org/plugins/publishpress/\" rel=\"noopener noreferrer\" target=\"_blank\">PublishPress</a> is the plugin that Automattic recommended as an alternative, and it is the closest one to matching Edit Flow&#8217;s features. It has 7,000 active installs and is used by companies, non-profits, educational institutions, magazines, newspapers, and blogs.</p>\n<p>In the free plugin, PublishPress provides an editorial calendar, notifications, editorial comments, custom statuses, content overview, and the ability to create custom metadata for posts. Its creators also offer commercial add-ons for things like a content checklist, Slack notifications, multiple authors, WooCommerce checklist, and more.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2019/10/publishpress-editorial-calendar.png?ssl=1\"><img /></a></p>\n<p>Since PublishPress is actually a fork of the Edit Flow plugin, users can <a href=\"https://publishpress.com/knowledge-base/migrate/\" rel=\"noopener noreferrer\" target=\"_blank\">migrate seamlessly from Edit Flow</a> without losing any data or settings using the plugin&#8217;s built-in migration utility.</p>\n<p>The PublishPress team has also created several other publishing plugins that may also be useful for different editorial needs, including <a href=\"https://wordpress.org/plugins/revisionary/\" rel=\"noopener noreferrer\" target=\"_blank\">PublishPress Revisions</a>, <a href=\"https://wordpress.org/plugins/press-permit-core/\" rel=\"noopener noreferrer\" target=\"_blank\">PressPermit</a>, and <a href=\"https://wordpress.org/plugins/capability-manager-enhanced/\" rel=\"noopener noreferrer\" target=\"_blank\">Capability Manager Enhanced</a>.</p>\n<h3>Oasis Workflow</h3>\n<p><a href=\"https://wordpress.org/plugins/oasis-workflow/\">Oasis Workflow</a> is a plugin that allows site admins to create custom workflows for content review. It includes three process/task templates for assignment, review, and publishing actions with role-based routing. Workflows can be configured using a drag-and-drop interface. The plugin supports custom statuses, process history, task reassignment, due dates, and email reminders.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2019/10/oasis-workflow.png?ssl=1\"><img /></a></p>\n<p>Oasis Workflow is often used in healthcare, law and financial firms, universities, CPA firms, non-profits, news outlets, and other organizations that require a formal review process for publishing. A <a href=\"https://www.oasisworkflow.com/\" rel=\"noopener noreferrer\" target=\"_blank\">commercial version</a> of the plugin includes features like multiple workflows, auto submit, revisions for published content, with add-ons for editorial contextual comments, teams, groups, and more.</p>\n<h3>Nelio Content</h3>\n<p><a href=\"https://wordpress.org/plugins/nelio-content/\">Nelio Content</a> is a plugin with 6,000 active installs that includes an editorial calendar, editorial comments, tasks, and a content assistant. It also helps users schedule and automatically promote content on social networks. The plugin integrates relevant metrics from Google Analytics and social media accounts to assist users in promoting content.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2019/10/nelio-calendar.png?ssl=1\"><img /></a></p>\n<h3>Editorial Calendar</h3>\n<p>If the editorial calendar feature of Edit Flow is the only one you need, then the <a href=\"https://wordpress.org/plugins/editorial-calendar/\" rel=\"noopener noreferrer\" target=\"_blank\">Editorial Calendar</a> plugin might be a good alternative. It is used on more than 40,000 WordPress sites. The plugin provides an overview of when each post will be published, supports multiple authors, the ability to rearrange the schedule with drag-and-drop capabilities, and edit posts directly in the calendar.</p>\n<div class=\"embed-vimeo\"></div>\n<h3>WP Scheduled Posts</h3>\n<p><a href=\"https://wordpress.org/plugins/wp-scheduled-posts/\" rel=\"noopener noreferrer\" target=\"_blank\">WP Scheduled Posts</a> is another editorial calendar plugin that makes it easy to manage multiple authors from one place. It includes a visual calendar that can be manipulated via drag-and-drop, allowing users to easily add posts in the queue or create new posts inside the calendar. The plugin has a dashboard widget that displays post statuses for single or multiple authors.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2019/10/schedule-calendar.png?ssl=1\"><img /></a></p>\n<p>The <a href=\"https://wpdeveloper.net/plugins/wp-scheduled-posts/\" rel=\"noopener noreferrer\" target=\"_blank\">commercial version</a> of WP Scheduled Posts is targeted at the scheduling aspects of publishing. It offers an auto-scheduler where users can create rules to publish content automatically, as well as a missed schedule handler for automatically publishing posts that didn&#8217;t go out on schedule.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Oct 2019 21:21:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: Meta Box Settings Page Extension Adds Support for Customizer, Network-Wide Settings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94811\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/meta-box-settings-page-extension-adds-support-for-customizer-network-wide-settings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3677:\"<p>The team behind the Meta Box plugin <a href=\"https://metabox.io/mb-settings-page-customizer-multisite\">updated their MB Settings Page add-on</a> to include support for the customizer and multisite.  The customizer feature allows theme authors to integrate their custom settings into the customizer using framework-specific code.  The multisite integration allows plugin authors to create a network settings page.</p>\n\n\n\n<p>The new features come on the heels of an <a href=\"https://metabox.io/meta-box-updates-better-performance-for-object-fields-mb-core-and-new-settings-page\">update to the core Meta Box plugin</a> that improves performance for users who have thousands of objects such as posts, terms, or users.</p>\n\n\n\n<p>The primary <a href=\"https://wordpress.org/plugins/meta-box/\">Meta Box</a> plugin originated as a custom fields framework for plugin and theme authors to create meta boxes.  It has since grown to handle settings across taxonomies, user profiles, options pages, comment forms, and other areas that have form fields.  The plugin offers a unifying API for developers to code over 40 field types without the need to learn each of the internal, field-related APIs in WordPress.  At the moment, the plugin has over 400,000 active installations.</p>\n\n\n\n<p>Framework-style plugins such as Meta Box, Advanced Custom Fields, and others have filled a gap left open by core WordPress, which does not have a single API for handling fields.  Over the years, developers have been left to code against dissimilar APIs and in different languages (PHP and JavaScript).  This new feature from the Meta Box team will further extend its usefulness to a large number of developers who need to build out options for their users quickly and without learning additional APIs.</p>\n\n\n\n<p>The <a href=\"https://metabox.io/plugins/mb-settings-page/\">MB Settings Page add-on</a> is a premium extension that allows theme and plugin authors to create custom settings pages.</p>\n\n\n\n<p>The purpose of its customizer integration is for theme authors to map settings pages to customizer panels.  However, the feature also allows for sections instead.  All of the Meta Box&#8217;s field types carry over to the customizer except for its file and image field types due to limitations with how the customizer works.  However, other file and image-related fields will handle most needs.</p>\n\n\n\n<p>Customizer integration isn&#8217;t an all-or-nothing thing.  Developers can choose to keep both a custom settings page and panels in the customizer.  They may also opt for one screen over the other based on their needs.</p>\n\n\n\n<p>The Meta Box team released a video showcasing the new customizer support with some mood music.  <em>To be honest, I&#8217;m just chilling out and listening as I write this article.  I&#8217;ve got a little head bob going too.</em></p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>There is currently no word on whether the customizer fields support live preview.  Based on the video, when a user updates an option, the preview panel performs a full page refresh.  If live preview is not currently a feature, it would be a welcome one in a future update.</p>\n\n\n\n<p>Along with customizer integration, the MB Settings Page update provides the ability for developers to create network-wide settings for multisite.  </p>\n\n\n\n<p>For some developers, network-wide settings are a bit of an afterthought or something they don&#8217;t consider at all for their plugins.  Not all plugins need options on the network level.  For those that do, authors can start using their custom Meta Box fields directly in the WordPress network admin with a single line of code.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Oct 2019 17:58:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: WordPress 5.3 Improves Large Image Handling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94814\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wptavern.com/wordpress-5-3-improves-large-image-handling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2222:\"<p><a href=\"https://wordpress.org/news/2019/10/wordpress-5-3-beta-3/\" rel=\"noopener noreferrer\">WordPress 5.3 Beta 3</a> was released this week and RC 1 is right around the corner, expected <a href=\"https://make.wordpress.org/core/5-3/\" rel=\"noopener noreferrer\" target=\"_blank\">October 15</a>. Core contributors have been publishing developer notes on new features landing in this release. One exciting enhancement that hasn&#8217;t received much attention yet is WordPress&#8217; updated <a href=\"https://core.trac.wordpress.org/ticket/47873\" rel=\"noopener noreferrer\" target=\"_blank\">handling of large images</a>.</p>\n<p>Many WordPress users don&#8217;t consider the size of the images they are uploading to their sites, and modern smartphones are capable of producing very high quality images at very large file sizes. WordPress 5.3 will automatically detect large images (with a default threshold of 2560px) and generate a “web-optimized maximum size.&#8221; The threshold is used as the max-height and max-width value to scale down the image for use as the largest available size. A new <code>big_image_size_threshold</code> filter is available for developers who want to change the threshold size or disable the new feature altogether.</p>\n<p>WordPress will store the original image size so that it is still accessible and a new function is available for fetching its path: <code>wp_get_original_image_path()</code>. It is also used to generate all the image sub-sizes.</p>\n<p>More than two million WordPress users rely on plugins like Imsanity, Smushit, and EWWW Image Optimizer to optimize images. They often include additional features for bulk resizing previously uploaded images. WordPress&#8217; new large image handling <a href=\"https://make.wordpress.org/core/2019/10/09/introducing-handling-of-big-images-in-wordpress-5-3/#comment-37044\" rel=\"noopener noreferrer\" target=\"_blank\">should not interfere with image optimization plugins</a>, because it doesn&#8217;t affect the default settings that they often hook into and use to perform additional optimizations. The new core enhancement may be suitable to replace these plugins for some users who only require the bare minimum optimization on upload.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Oct 2019 19:46:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: MachoThemes, Modula Parent Company, Acquires Three Gallery Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94816\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/machothemes-modula-parent-company-acquires-three-gallery-plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3453:\"<p><a href=\"https://www.machothemes.com\">MachoThemes</a>, the WordPress development company behind the <a href=\"https://wordpress.org/plugins/modula-best-grid-gallery/\">Modula Gallery</a> plugin, has acquired three gallery plugins.  The company is currently rolling the first two of the plugins, <a href=\"https://wordpress.org/plugins/final-tiles-grid-gallery-lite/\">Final Tiles Grid Gallery Lite</a> and <a href=\"https://wordpress.org/plugins/photoblocks-grid-gallery/\">PhotoBlocks Grid Gallery</a>, into Modula.  The third plugin, <a href=\"https://wordpress.org/plugins/everlightbox/\">EverLightbox</a>, will remain as a standalone project.</p>\n\n\n\n<p>The three plugins were purchased from Diego Imbriani of GreenTreeLabs.  This was not MachoThemes&#8217; first acquisition from Imbriani.  They acquired the original Modula plugin from him over two years ago.  From there, they grew the user base and continued developing the plugin.</p>\n\n\n\n<p>At this time, the exact details of the financial terms are not available to the public, but the transaction was in the range of low-to-mid 5-figures.</p>\n\n\n\n<p>The acquisition is a part of MachoThemes&#8217; growth strategy for building a larger audience for their Modula plugin, which currently has over 60,000 active installations.  &#8220;We liked their feature set, their quirkiness, and overall what they stand for,&#8221; said MachoThemes owner Christian Raiber of the reasons behind the acquisition.</p>\n\n\n\n<p>The merge of Final Tiles and PhotoBlocks affects over 34,000 plugin users.  MachoThemes does not plan to continue supporting or developing them as individual plugins.</p>\n\n\n\n<p>The team is in the process of building a migration script to allow users to bring their existing galleries over to the Modula plugin.  It is important that users migrate to Modula or another option because unsupported versions of their current plugins may not work in the future.</p>\n\n\n\n<p>Both plugins are similar to Modula by allowing users to create a gallery separately from the primary post content screen.  However, the user interface and experience between all three plugins are nothing alike.  Merging the plugins into Modula means that MachoThemes can work on a single interface and experience for users.</p>\n\n\n\n<p>Users may be worried about losing features when migrating to a new plugin.  &#8220;Most of these options already exist in Modula, under a different name, setting or otherwise paid extension,&#8221; said Raiber.  &#8220;There are a few interesting options in these plugins indeed, and they&#8217;ve already sparked new ideas for the team to experiment with.&#8221;</p>\n\n\n\n<p>Raiber said his company would reach out to users.  &#8220;We&#8217;ll have videos, doc entries, and a dedicated page on wp-modula.com,&#8221; he said of the transition.  The company plans to keep the plugins available for the next six months but may extend that period depending on how the transition for users is going.</p>\n\n\n\n<p>The EverLightbox plugin will remain separate for those who want a lightbox feature for the standard WordPress galleries but not a full gallery-editing plugin.  &#8220;We will continue to support the plugin and work hard to ensure that all users have a smooth-sailing experience with the plugin just as we have been for all of the plugins we&#8217;ve been building,&#8221; said Raiber.</p>\n\n\n\n<p>The company plans to continue developing and supporting EverLightbox for the long term.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Oct 2019 19:21:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: ExpressionEngine Under New Ownership, Will Remain Open Source for Now\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94761\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/expressionengine-under-new-ownership-will-remain-open-source-for-now\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7521:\"<p>EllisLab founder Rick Ellis <a href=\"https://expressionengine.com/blog/expressionengine-has-a-new-owner\" rel=\"noopener noreferrer\" target=\"_blank\">announced</a> yesterday that ExpressionEngine has been acquired by Packet Tide, the parent company of <a href=\"https://eeharbor.com\" rel=\"noopener noreferrer\" target=\"_blank\">EEHarbor</a>, one of the most successful EE add-on providers and development agencies in the community. A year ago EllisLab, the developers of EE core, was acquired by Digital Locations but Ellis said the company ended up not being a good fit for the future of the CMS:</p>\n<blockquote><p>A year ago, EllisLab was acquired by Digital Locations in order to facilitate the transition of ExpressionEngine from a commercial software application to an open source one. That transition was successful, but it became apparent in recent months that ExpressionEngine didn’t fit perfectly within the goals of Digital Locations, as it seeks to build a business in Artificial Intelligence.</p>\n<p>We decided that what was best for ExpressionEngine was to seek a new owner, one that could devote all the resources necessary for ExpressionEngine to flourish.</p></blockquote>\n<p>In November 2018, <a href=\"https://wptavern.com/expressionengine-goes-open-source-after-16-years\" rel=\"noopener noreferrer\" target=\"_blank\">EE went open source</a>, adopting the <a href=\"https://expressionengine.com/license\" rel=\"noopener noreferrer\" target=\"_blank\">Apache License Version 2.0</a>, after 16 years of being locked down under restrictive licensing. EE&#8217;s dwindling community of product developers and site builders were hopeful that the new open source licensing would expand EE&#8217;s reach and bring back developers who had migrated to alternatives like <a href=\"https://craftcms.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Craft</a>.</p>\n<p>After the acquisition announcement, the EE community was concerned whether or not it will remain free and open source. Although the software&#8217;s homepage sports the tagline &#8220;The Open-Source CMS that supports YOU all the way,&#8221; EE&#8217;s new owners have left the option open for reconsidering its licensing further down the road. They plan to stick with the open source license for the time being. When asked directly in the <a href=\"https://t.co/gjVhmpqqn1?amp=1\" rel=\"noopener noreferrer\" target=\"_blank\">EE Slack</a>, EE Harbor developer <a href=\"https://twitter.com/TomJaeger\" rel=\"noopener noreferrer\" target=\"_blank\">Tom Jaeger</a> said, &#8220;That is our plan for now, although at this stage we&#8217;re looking at everything with a fresh eye towards what&#8217;s best.&#8221; The company has <a href=\"https://eeharbor.com/faq\" rel=\"noopener noreferrer\" target=\"_blank\">published a list of FAQs</a> with the same information.</p>\n<p>Brian Litzinger, a developer at <a href=\"https://boldminded.com/\" rel=\"noopener noreferrer\" target=\"_blank\">BoldMinded</a>, who has created more than 36 add-ons for EE, and is also on the EECA (ExpressionEngine Community Association) board that organizes EEConf, said he has confirmed that EEHarbor plans to keep the CMS open source.</p>\n<p>&#8220;The board spoke to new ownership just today actually, and they have every intention of keeping it open source,&#8221; Litzinger said. &#8220;I can’t speak for the whole community, but since going open source my add-on sales have not significantly increased or decreased.</p>\n<p>&#8220;As with any open source project there has been feedback and pull requests from the community, but nothing significant (e.g. large features). The community as a whole is pretty excited about the new ownership and ExpressionEngine&#8217;s future though.&#8221;</p>\n<p>Shawn Maida, founder of <a href=\"https://fostermade.co\" rel=\"noopener noreferrer\" target=\"_blank\">Foster Made</a>, a company that also sells ExpressionEngine add-ons, said he has not seen a significant direct change in the economics of EE since the project went open source.</p>\n<p>&#8220;I think the real question here is what business model best enables the growth and continued support of the CMS itself, and how is that balanced against the growth of the community,&#8221; Maida said. &#8220;As a business that offers some add-ons for ExpressionEngine, we need to see both continued growth in ExpressionEngine as a platform and growth in the community, so I think the license model that best enables that matters.&#8221;</p>\n<p>Travis Smith, president of <a href=\"https://www.hopstudios.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Hop Studios</a>, has been working with EE since its early days. As someone who is deeply invested in the EE community, he said that he doesn&#8217;t think a prospective licensing change would impact the broader community as much as having a clear vision for the CMS&#8217;s future.</p>\n<p>&#8220;I think a licensing change per se wouldn&#8217;t be good or bad, but a well-articulated and communicated vision for the CMS&#8217;s future would be really helpful for a community that feels unsure at the moment,&#8221; Smith said.</p>\n<p>&#8220;I do think that the exposure that going open source gave into the development process overall at EllisLab was an improvement, and that new features and bug fixes were getting added at a decent pace.&#8221;</p>\n<p>EE may have changed its licensing to be open source but it is not a community-led project where major decisions happen by a consensus of a diverse representation of community leadership.</p>\n<p>&#8220;I didn&#8217;t observe the community gaining (or applying?) much input or influence over the future of ExpressionEngine in the past year,&#8221; Smith said. &#8220;I think there was still a feeling of &#8216;EE is EllisLab&#8217;s project&#8217; &#8212; and that this change of ownership might shake the community&#8217;s devs out of that default assumption, which would be a good thing.&#8221;</p>\n<p>In the <a href=\"https://eeharbor.com/faq\" rel=\"noopener noreferrer\" target=\"_blank\">FAQs EEHarbor published today</a>, the company confirmed that it will be developing new features and that it will consider feedback submitted from the community:</p>\n<blockquote><p>While we are in the early stages of long-term strategic planning, we already have a lot of thoughts and ideas around where to take ExpressionEngine based on our own experience. However, it’s not just about us. We are also very interested in collaborating with the ExpressionEngine community. Everyone is more than welcome to submit feedback for us to review as we consider the future of ExpressionEngine</p></blockquote>\n<p>After 16 years under a restrictive license, EE is an interesting example of a newly open source, corporate-led project with a community that is rediscovering its place while ownership of the software is transferred from one company to another. Responses to the acquisition are mostly positive, and users seem excited about Packet Tide&#8217;s first planned initiative &#8211; finishing development on ExpressionEngine 6.0. Ellis described this upcoming release as &#8220;an exciting new version we’ve been quietly working on behind the scenes.&#8221; It will include a new control panel with a dark theme, along with add-on and service integrations inside the app.</p>\n<p>EEHarbor does not plan to merge its add-ons with ExpressionEngine core at this time, and the statement published today reiterates the company&#8217;s commitment to &#8220;keep the add-on marketplace fair and open to all developers.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Oct 2019 23:11:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: Rosa 2 Restaurant Theme Provides a Frustrating and Satisfying Experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94769\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/rosa-2-restaurant-theme-provides-a-frustrating-and-satisfying-experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9220:\"<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p><a href=\"https://pixelgrade.com/themes/restaurants/rosa2/\">Rosa 2</a> is the sequel to Pixelgrade&#8217;s best-selling theme, Rosa.  The new theme re-imagines its previous incarnation in the context of the block editor (Gutenberg).   I was provided a copy of the theme for free to test and provide my thoughts. </p>\n\n\n\n<p>The theme sells for $75/year, or you can pay a one-time fee of $95 for lifetime access.  The <a href=\"https://pixelgrade.com/blog/product/meet-rosa-2/\">product launch post</a> could make anyone excited about this theme, but is it worth it?</p>\n\n\n\n<p><strong>TLDR;</strong> Rosa 2 made for a satisfying experience when building restaurant-style pages.  However, the early learning curve and basic setup were frustrating.  It also lacks some of the polish I&#8217;d expect at a premium price.</p>\n\n\n\n<h2>A Rundown of the Issues</h2>\n\n\n\n<p>Before I dive into the good things about Rosa 2 (and there are some nice things about this theme), let me dive into the frustrating aspects.  There were so many pain points that I nearly gave up on the theme several times.  However, I soldiered on in the hopes of understanding why this theme might be worth using.</p>\n\n\n\n<h3>Install the Required Plugins First</h3>\n\n\n\n<p>Let me save you some time right now.  When the theme says that it requires the <a href=\"https://wordpress.org/plugins/customify/\">Customify</a> and <a href=\"https://wordpress.org/plugins/nova-blocks/\">Nova Blocks</a> plugins, it truly requires them.  Otherwise, the theme looks and behaves nothing like the demo or screenshots.  It may as well not be the same theme.</p>\n\n\n\n<p>When first activating the theme, the front page of your website will become a completely white screen.  It is not the dreaded <a href=\"https://wordpress.org/support/article/common-wordpress-errors/#the-white-screen-of-death\">White Screen of Death</a> caused by an error.  Instead, the theme is forcibly hiding the content with custom styles.</p>\n\n\n\n<p><em>Why?</em>  Yeah, good question.  </p>\n\n\n\n<p>I see no reason to do so.  Outside of changing some code (which I did), users must activate the plugins to make their content appear.  There is no technical reason this should be the case when using this theme.</p>\n\n\n\n<p>There should be no path in which a user installs a theme only to have their content disappear.</p>\n\n\n\n<p>I get it.  I was told these were required plugins.  The theme even provides easy installation and activation links via the TGM Plugin Activation script.  I also get that WordPress lacks any sort of real dependency system for handling this feature.  That doesn&#8217;t make it any less of a poor user experience.</p>\n\n\n\n<p>As a developer, I thought I&#8217;d trick the system and test the theme without those plugins installed.  I wanted to see what the theme looked like out of the box, which you can see in the following screenshot.</p>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>Oh, and that big block of category links in the above screenshot, it never goes away.  It just sits there on your blog posts page.  It is hard-coded in the posts page template (<code>home.php</code>).  Rosa 2 is billed as a restaurant theme, so it might be acceptable if you don&#8217;t plan on running a blog.</p>\n\n\n\n<h3>Header and Nav Problems</h3>\n\n\n\n<p>The default header looks nothing like the screenshots, demo, or video for the theme.  After nearly two hours of using the theme, I was ready to throw in the towel and rule this theme out as a lost cause.  Not being able to get the basic nav menu set up for the theme was an exercise in self-punishment that I wouldn&#8217;t wish on anyone.</p>\n\n\n\n<p>It turns out that the Nova Blocks plugin really is required.  <em>Did I mention that you should install the required plugins first?</em></p>\n\n\n\n<h3>Stretched images</h3>\n\n\n\n<p>On blog and archive pages, expect stretched featured images that attempt to fill out the box next to the excerpt for existing posts.  There doesn&#8217;t seem to be any remedy to this outside of uploading new images.  </p>\n\n\n\n<p>The theme uses the standard <code>post-thumbnail</code> size but does not define this size in the code.  For those unfamiliar with the technical aspects when using this specific size, the theme should ideally define it via the <code>set_post_thumbnail_size()</code> function.</p>\n\n\n\n<h3>Sticky header</h3>\n\n\n\n<p>The large sticky header gave me a gut-wrenching feeling that walls were closing in on me.  I became light-headed and dizzy.  I found it tough to breathe.  This is not hyperbole.  I&#8217;m dead serious.</p>\n\n\n\n<p>On a personal note, I&#8217;ve had some issues with claustrophobia for the last couple of years.  I first had this feeling after being stuck indoors for two weeks while watching over one of my cats who had surgery.  I typically work from the porch where I can get fresh air, but that was one of the worst periods of my life.  </p>\n\n\n\n<p>Since then, I often get this same feeling when sites have large sticky headers.  It feels like the walls are closing down.  <em>I wonder if others have similar issues.</em></p>\n\n\n\n<p>This feeling could be alleviated if the theme minimized the sticky-header height while scrolling down the page.  Fortunately, the theme allows users to choose a static header, which I strongly suggest using.  There are some other spacing and sizing options for the header area, which can help shrink some of this down.</p>\n\n\n\n<h2>Where the Theme Shines</h2>\n\n\n\n<div class=\"wp-block-image\"><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2019/10/rosa2-custom-page.jpg?ssl=1\" target=\"_blank\" rel=\"noreferrer noopener\"><img /></a></div>\n\n\n\n<p>If there is one thing this theme does well, it is making it simple to create pages for a restaurant via the Nova Blocks plugin.  Within minutes of creating a custom page, I had a restaurant-style page set up and ready to go.</p>\n\n\n\n<p>When coupled with Nova Blocks, the theme beautifully handles the process of creating custom pages with numerous unique outcomes.  The integration with the plugin is brilliant.  Each block has custom demo content that you can easily modify.</p>\n\n\n\n<p>Some of the names of the blocks and block options were cutesy and fun, such as &#8220;Hero of the Galaxy,&#8221; but they became a slight nuisance when wanting to quickly figure out the purpose of a block.  I could see some users becoming annoyed at the names, and they might not be ideal for some professional settings.  They were kind of fun though.  I have mixed feelings about them.</p>\n\n\n\n<h2>How Does the Theme Handle Gutenberg?</h2>\n\n\n\n<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>Rosa 2 is a theme primarily built for the block editor.  It wonderfully handled core block output in my tests.  </p>\n\n\n\n<p>When using Gutenberg-ready themes, I view the pullquote block as sort of the theme designer&#8217;s signature. It is one of those blocks where designers can have a lot of fun and put a unique spin on the display.  I&#8217;m a fan of the pullquote style in this theme (pictured above).</p>\n\n\n\n<p>On the whole, it works well.  When coupled with Nova Blocks, you have a lot of power at your disposal.</p>\n\n\n\n<h2>How Does the Code Stack Up?</h2>\n\n\n\n<p>Rosa 2 is lightweight in terms of custom code.  Nearly all of the functionality is within the accompanying plugins.  Because this is a theme review, I didn&#8217;t dive into the plugin code.</p>\n\n\n\n<p>From a purely technical standpoint, the theme does most things according to standards.</p>\n\n\n\n<p>There are some things I&#8217;d change from an architectural standpoint.  For example, the file for its Customify plugin integration is over 1,100 lines of code.  I would break that down to more digestible bits, which would help with long-term maintenance and bug hunting.</p>\n\n\n\n<p>Some of the editor-related JavaScript code could be more efficient.  Repeated patterns should be grouped together to make the code smaller.  The editor JavaScript file is not large, but every byte counts in a world where developers assume everyone is running on Gigabit internet connections.</p>\n\n\n\n<p>The primary stylesheet is 173 kb, which is <em>OMGBBQ</em> large, especially when you top it off with 100s of kb coming from the stylesheets and scripts loaded by Nova Blocks plugin.  Unless you&#8217;re a user who is heavily optimizing your site, you can count on some slow page loads.</p>\n\n\n\n<h2>The Final Verdict</h2>\n\n\n\n<p>I&#8217;d only recommend this theme to people who have more patience than me.  While I didn&#8217;t follow instructions right off the bat (as a reviewer, I&#8217;m trying to push limits and break things), the theme did have some pain points that simply made for a frustrating process.</p>\n\n\n\n<p>I&#8217;m in the camp of people who believes themes should work out of the box.  This theme doesn&#8217;t work without some setup.  You&#8217;ll need to put in some legwork to get it going.  However, once you make it over the initial hump, you can build some beautiful page layouts.</p>\n\n\n\n<p>I suggest using it strictly for its defined purpose of building a restaurant website.  The typography is designed well enough for blogging, but the overall theme isn&#8217;t well-suited to it.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Oct 2019 19:47:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress.org blog: WordPress 5.3 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7312\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2019/10/wordpress-5-3-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3723:\"<p>WordPress 5.3 Beta 3 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>You can test the WordPress 5.3 beta in two ways:</p>\n\n\n\n<ul><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option)</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.3-beta3.zip\">download the beta here</a>&nbsp;(zip). </li></ul>\n\n\n\n<p>WordPress 5.3 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-3/\">November 12, 2019</a>, and we need your help to get there.</p>\n\n\n\n<p>Thanks to the testing and feedback from everyone who tested <a href=\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-2/\">beta 2</a> (and&nbsp;<a href=\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-1/\">beta 1</a>) over&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=10%2F01%2F2019..10%2F08%2F2019&milestone=5.3&col=id&col=summary&col=status&col=milestone&col=owner&col=type&col=priority&order=priority\">60 tickets have been closed</a>&nbsp;in the past week. </p>\n\n\n\n<h2>Some highlights </h2>\n\n\n\n<ul><li>Fixes and enhancements in the admin interface changes introduced in previous 5.3 beta releases.</li><li>Wording changes in login screen (<a href=\"https://core.trac.wordpress.org/ticket/43037\">#43037</a>).</li><li>Improved accessibility in media upload modal (<a href=\"https://core.trac.wordpress.org/ticket/47149\">#47149</a>).</li><li>Changes in the way the new error handling with images works (<a href=\"https://core.trac.wordpress.org/ticket/48200\">#48200</a>).</li><li>MediaElement.js has been updated from 4.2.6 to 4.2.13 (<a href=\"https://core.trac.wordpress.org/ticket/46681\">#46681</a>). The script is now also being loaded in the footer again. This fixes a regression that happened two years ago, so might be worth noting (<a href=\"https://core.trac.wordpress.org/ticket/44484\">#44484</a>).</li><li>Update to the REST API media endpoint to allow resuming of uploads (<a href=\"https://core.trac.wordpress.org/ticket/47987\">#47987</a>).</li></ul>\n\n\n\n<p>In addition to these, Beta 3 landed a number of small consistency and polish changes to the REST API, including an improvement to the permissions check used when editing comments, a fix for post type controller caching edge cases, and most importantly, the ability to use the _embed parameter to access the full data for a post using the /wp/v2/search endpoint.</p>\n\n\n\n<h2>Developer notes</h2>\n\n\n\n<p>WordPress 5.3 has lots of refinements to polish the developer experience. To keep up, subscribe to the&nbsp;<a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a>&nbsp;and pay special attention to the&nbsp;<a href=\"https://make.wordpress.org/core/tag/5-3+dev-notes/\">developer notes</a>&nbsp;tag for updates on those and other changes that could affect your products.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help us translate WordPress into more than 100 languages</a>!</p>\n\n\n\n<p>If you think you’ve found a bug, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>&nbsp;where you can also find a list of&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Oct 2019 20:58:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Francesca Marano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: The Evolution of Anonymity in the Internet Age\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94745\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wptavern.com/the-evolution-of-anonymity-in-the-internet-age\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9328:\"<p>As a child of the &#8217;90s, I was growing up in one of the largest transitional periods in human history.  The Internet Age was upon us.</p>\n\n\n\n<p>I was born and raised in a small community in rural Alabama.  The country.  The backwoods.  To give you an idea of how small the place was, my entire school (grades K-12) had around 800 students.  While I was fortunate enough that my family could afford to travel for vacation almost every year, I mostly lived a sheltered life.</p>\n\n\n\n<p>I rode bikes down the dirt road and explored neighbors&#8217; hunting lands with my best friend in the summer.  We&#8217;d get up at dawn, grab some provisions, and cycle out for the day&#8217;s adventure.  We&#8217;d race old lawnmowers, build unstable treehouses, and swim in what were likely snake-infested creeks.  We&#8217;d camp out under the stars.  Our parents never asked where we were.  As long as we showed up for supper and took a bath a few times each week to scrub the dirt off, we were generally left up to our own imaginations.</p>\n\n\n\n<p>There was another aspect of growing up in the &#8217;90s, and that was video games.  At 16, I spent most of the summer in the fields picking watermelons or throwing bales of hay onto a trailer.  It was hard work, but it kept me supplied with whatever video games I wanted.  When not out in the wild, my best friend and I would be glued to a 19-inch television playing the Nintendo 64 (and later the Sega Dreamcast).</p>\n\n\n\n<p>I lived in this somewhat country-bumpkin bubble with no idea of the outside world.</p>\n\n\n\n<p>Then came the explosion of the internet.  My family never had a computer at home.  That left me to access this wonderful new thing during school hours or at a friend&#8217;s house.</p>\n\n\n\n<p>Like pretty much every teen boy I knew at the time, the best use of the internet was logging into adult chatrooms and hoping to chat with a woman.  Yeah, the average teenage boy wasn&#8217;t doing anything productive with the internet, even in the &#8217;90s.  Big surprise there.  This isn&#8217;t groundbreaking news, folks.  Move along.</p>\n\n\n\n<p>There were other uses of chatrooms, such as finding other gamers.  That&#8217;s where my original love of the internet began.  I could talk to people across the world about Nintendo and Sega games.  I even started getting pen-pals where we would exchange weekly emails.</p>\n\n\n\n<p>At the time, there was this common saying among adults, &#8220;You don&#8217;t know who you&#8217;re talking to on that thing. It could be a fat, 40-year-old man living in his parents&#8217; basement.&#8221;  <em>Hey, why you throwin&#8217; shade at heavyset men?  Just tell me it could be a psycho.</em></p>\n\n\n\n<p>My parents drilled this lesson into my brain.  School teachers did the same.  Like my peers at the time, I was required to use a pseudonym when going online.  The thought of using a real name was almost unheard of.  As teens, we&#8217;d joke about the basement-dwelling bogeyman who our parents and teachers warned us against.  It was all a game to us despite there being legitimate fears, particularly now that I have 20 years of hindsight at my disposal.</p>\n\n\n\n<p>That&#8217;s where I came up with my username of <a href=\"https://profiles.wordpress.org/greenshady\">greenshady</a>, by the way.  One day I may even tell what it means.  One day.  For now, I&#8217;ll keep all of you who have asked about it over the years guessing.</p>\n\n\n\n<p>I used that username for years because there was always this little voice in the back of my mind telling me to remain anonymous.</p>\n\n\n\n<h2>Anonymity in the Age of Transparency</h2>\n\n\n\n<p>I&#8217;m not exactly sure at what point attitudes toward anonymity changed.  Social networks likely played a huge role transitioning us from silly screen names to using our real-life names on the internet.  Otherwise, it&#8217;d be harder for our real-life friends to find us on Facebook, Twitter, and elsewhere.</p>\n\n\n\n<p>This prevailing attitude toward anonymity didn&#8217;t limit itself to social networks.  More and more, people shunned the idea of anonymous posts or comments on blogs and elsewhere.  </p>\n\n\n\n<p>There&#8217;s likely some form of stardom attached to using real names as well.  Everyone is just one video, one blog post, or one tweetstorm away from their 15 minutes in the spotlight.</p>\n\n\n\n<p>Even within the WordPress community over the years, I&#8217;ve witnessed a shift toward automatically disliking anonymous comments.  The prevailing idea is that a person&#8217;s contribution to a discussion has less worth if it&#8217;s hidden behind the veil of anonymity, that one&#8217;s opinions are invalid if they cannot be backed up by a real name. </p>\n\n\n\n<p>It opens the person to attack not based on their ideas but on how they choose to present themselves online.  This is a part of the culture that is unhealthy.</p>\n\n\n\n<p>In a time when you can effectively be shut out from the modern-day public square for making one wrong statement, anonymity is more important than ever for some.  Often, there&#8217;s no recourse for missteps after you&#8217;ve been taken down by the angry horde over a lapse in judgment.  Once your name has been hauled through the mud and back again, there&#8217;s little you can do about it.</p>\n\n\n\n<p>That little voice in the back of my mind, the one carefully crafted by my parents and teachers, is a reminder that a simpler period during the Internet Age once existed.</p>\n\n\n\n<p>There are other pockets of the internet where the pseudonym has persisted.  One area is in gaming.  You&#8217;d be the oddball if using a real name in an online multiplayer match.  <em>I suppose &#8220;Brett&#8221; or &#8220;Molly&#8221; doesn&#8217;t strike fear in the heart&#8217;s of enemies.</em>  The entire culture of online gaming is built upon anonymity, which is at odds with much of the internet world today.  Frankly, I find it oddly satisfying.</p>\n\n\n\n<p>I do wonder whether a real name online is important for civil discourse.  Quite often, online personas are much different than their real-life counterparts.  I mean, have you seen the numerous alpha-male groups on social networks made up of men who all think they&#8217;re the leaders of the pack?  <em>Hmmm…maybe there was some truth to that basement-dweller theory, after all.  Thanks for the heads up, Mom and Dad.</em></p>\n\n\n\n<p>The point is that an online persona, even attached to a real name, is still a persona.  It&#8217;s not much different than a fake user handle.</p>\n\n\n\n<p>I&#8217;d wager that the need to see a person&#8217;s real name has more to do with knowing exactly who to shun for controversial ideas rather than attaching some sort of validity to it.  Usernames can be altered.  You&#8217;re pretty much stuck with your real name, and mishaps follow your real name around.</p>\n\n\n\n<p>As we were reviewing the Tavern&#8217;s <a href=\"https://wptavern.com/comment-policy\">comment policy</a> last week, one point I brought up is that I believe we should allow anonymous comments.  A large reason for this is that people should feel safe to communicate their thoughts within the community.  While I won&#8217;t get into the specifics of internal discussions, I do hope that it&#8217;s something we officially remove from the policy.</p>\n\n\n\n<p>Being in favor of anonymity does not mean being in favor of personal attacks or handing over a license to use a vulgar term as a username.  It&#8217;s about protecting people&#8217;s ability to speak freely without fear of becoming an outcast within the community for an unpopular opinion.</p>\n\n\n\n<p>Sometimes anonymity provides people the freedom they need to effectively discuss ideas.  More importantly, it allows them to be a part of the community in a way that they choose.</p>\n\n\n\n<h2>Are We Moving back?</h2>\n\n\n\n<p>With the European Union, Japan, Australia, and other countries passing stricter privacy laws, there&#8217;s a growing movement to protect privacy across the world.  While this movement has focused more on large corporations and what they do with personal data, there&#8217;s an underlying fear that&#8217;s likely been there from the beginning.</p>\n\n\n\n<p>People are coming to the realization that we gave up too much.</p>\n\n\n\n<p>We handed over our names.  And, once we handed over our names, it was a slippery slope to handing over everything else about ourselves.  If you dig deep enough you can find the names of all my cats and when they were all born.</p>\n\n\n\n<p>I&#8217;m not sure how I feel about that.  I&#8217;m in too deep at this point.</p>\n\n\n\n<p>My parents from 20 years ago would not have liked the idea too much.  My dad just uses YouTube to watch videos on building stuff for the most part today (it took years to stop him sending me email chains), but my stepmom is right there along with everyone else on social networks.</p>\n\n\n\n<p>It&#8217;s odd to look back on the past 20 years to see how some of our initial fears surrounding anonymity have transformed.  In another 20 years, we&#8217;ll all be back to using pseudonyms again.  Call me out on it if I&#8217;m wrong.  I do wonder if we&#8217;ll look back at this time and think everyone was crazy for using their real names.</p>\n\n\n\n<p>I welcome your anonymous comments on this post.  Just don&#8217;t use &#8220;wanker&#8221; for your handle.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Oct 2019 19:20:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: GNU Project Maintainers Move to Oust Richard Stallman from Leadership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94714\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wptavern.com/gnu-project-maintainers-move-to-oust-richard-stallman-from-leadership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5486:\"<p>GNU Project maintainers are working to oust Richard Stallman from his position as head of the organization. In a joint <a href=\"https://guix.gnu.org/blog/2019/joint-statement-on-the-gnu-project/\" rel=\"noopener noreferrer\" target=\"_blank\">statement</a> published yesterday morning, a collection of 22 GNU maintainers and developers thanked Stallman for his work and declared that he can no longer represent the project:</p>\n<blockquote><p>We, the undersigned GNU maintainers and developers, owe a debt of gratitude to Richard Stallman for his decades of important work in the free software movement. Stallman tirelessly emphasized the importance of computer user freedom and laid the foundation for his vision to become a reality by starting the development of the GNU operating system. For that we are truly grateful.</p>\n<p>Yet, we must also acknowledge that Stallman’s behavior over the years has undermined a core value of the GNU project: the empowerment of all computer users. GNU is not fulfilling its mission when the behavior of its leader alienates a large part of those we want to reach out to.</p>\n<p>We believe that Richard Stallman cannot represent all of GNU.</p></blockquote>\n<p><a href=\"https://www.stallman.org/\" rel=\"noopener noreferrer\" target=\"_blank\">Stallman&#8217;s personal website</a> continues to prominently display his intentions to remain in the leadership role. He added the header to his site, following the publication of remarks he made regarding a 17-year old victim of sex trafficker Jeffrey Epstein, which precipitated his <a href=\"https://wptavern.com/gpl-author-richard-stallman-resigns-from-free-software-foundation\" rel=\"noopener noreferrer\" target=\"_blank\">resignation from both MIT and the Free Software Foundation</a>:</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2019/10/Screen-Shot-2019-10-07-at-9.44.17-PM.png?ssl=1\"><img /></a></p>\n<p>The Stallman saga has continued to grow stranger in the aftermath of his resignations, as many were concerned that he would be homeless after his website featured a notice that he was &#8220;<a href=\"https://web.archive.org/web/20190929052858/https://stallman.org/\" rel=\"noopener noreferrer\" target=\"_blank\">Seeking Housing</a>,&#8221; accompanied by a <a href=\"https://web.archive.org/web/20190929045948/https://stallman.org/seeking-housing.html\" rel=\"noopener noreferrer\" target=\"_blank\">link</a> leading to his specific requirements for a temporary residence. His personal site was also reportedly <a href=\"http://techrights.org/2019/09/29/fsf-defaced-rms/\" rel=\"noopener noreferrer\" target=\"_blank\">vandalized</a> nine days ago with a message that he was stepping down from the GNU.</p>\n<p>The defacement with the false GNU resignation message was reverted shortly thereafter on September 30, and replaced with the header saying he continues to be &#8220;Chief GNUisance of the GNU Project&#8221; with no intention of stopping soon. Stallman has not yet publicly acknowledged the statement from the GNU maintainers. He has also not yet responded to our request for comment.</p>\n<p>Yesterday the Free Software Foundation (FSF) published a <a href=\"https://www.fsf.org/news/fsf-and-gnu\" rel=\"noopener noreferrer\" target=\"_blank\">statement</a> indicating it was re-evaluating its working relationship with the GNU project, which has provided some of its technical infrastructure, fiscal sponsorship, and copyright assignment:</p>\n<blockquote><p>GNU decision-making has largely been in the hands of GNU leadership. Since RMS resigned as president of the FSF, but not as head of GNU (&#8220;Chief GNUisance&#8221;), the FSF is now working with GNU leadership on a shared understanding of the relationship for the future. As part of that, we invite comments from free software community members.</p></blockquote>\n<p>Stallman responded the next day, indicating he wanted to work with FSF on restructuring the relationship between the two organizations:</p>\n<blockquote><p>I recently resigned as president of the FSF, but the FSF continues to provide several forms of crucial support for the GNU Project.  As head of the GNU Project, I will be working with the FSF on how to structure<br />\nthe GNU Project&#8217;s relationship with the FSF in the future.</p></blockquote>\n<p>The FSF maintains some critical responsibilities in that it currently <a href=\"https://en.wikipedia.org/wiki/Free_Software_Foundation#History\" rel=\"noopener noreferrer\" target=\"_blank\">holds the copyrights to enforce the GPL</a>. Stallman has recently called on people to <a href=\"http://techrights.org/2019/10/01/what-stallman-wants/\" rel=\"noopener noreferrer\" target=\"_blank\">continue supporting the FSF&#8217;s work</a>, despite his resignation from the organization.</p>\n<p>The small contingency of GNU project maintainers who penned the <a href=\"https://guix.gnu.org/blog/2019/joint-statement-on-the-gnu-project/\" rel=\"noopener noreferrer\" target=\"_blank\">statement</a> published yesterday seem to be on the same page with FSF in its rejection of Stallman&#8217;s leadership. Their message concludes with their intention to overhaul the leadership of the free software movement to be more inclusive of the people who have been alienated by Stallman&#8217;s behavior over the years:</p>\n<p>&#8220;We think it is now time for GNU maintainers to collectively decide about the organization of the project. The GNU Project we want to build is one that everyone can trust to defend their freedom.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Oct 2019 04:33:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: Google Chrome Announces Rollout Plan for Blocking Mixed Content Beginning January 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94672\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://wptavern.com/google-chrome-announces-rollout-plan-for-blocking-mixed-content-beginning-january-2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3405:\"<p>The Google Security Team has <a href=\"https://security.googleblog.com/2019/10/no-more-mixed-messages-about-https_3.html\" rel=\"noopener noreferrer\" target=\"_blank\">announced</a> a timeline for when Chrome will begin blocking <a href=\"https://developers.google.com/web/fundamentals/security/prevent-mixed-content/what-is-mixed-content\" rel=\"noopener noreferrer\" target=\"_blank\">mixed content</a> by default in order to ensure that HTTPS browsing is more secure. Mixed content refers to HTTPS pages that load resources, such as images, videos, stylesheets, and scripts, over HTTP.</p>\n<p>The gradual rollout will begin with Chrome 79, which is scheduled for release in December 2019. The browser already blocks mixed scripts and iframes, but this release will add a new setting (that can be toggled on or off) for users to unblock it on a per-site basis.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2019/10/site-settings-unblock-mixed-content.png?ssl=1\"><img /></a></p>\n<p>The next phase of the rollout will progress with Chrome 80, due in January 2020, where mixed audio and video resources will get auto-upgraded to HTTPS. If they fail to load over HTTPS, Chrome will automatically block them. Mixed images will still load but Chrome will display a “Not Secure” warning in the omnibox next to the URL.</p>\n<p>The last phase of the rollout is planned for February 2020. Along with the release of Chrome 81, mixed content images will bet auto-upgraded to HTTPS and Chrome will block them if they fail to load.</p>\n<p>The Google Security Team reports that Chrome users now spend more than 90% of their browsing time on HTTPS on both desktop and mobile. The plan to begin blocking mixed content is targeted at addressing insecure holes in SSL implementations of sites that have already made the switch to HTTPS.</p>\n<p>WordPress site owners have plenty of time to ensure all their resources load over HTTPS. The official plugin directory has <a href=\"https://wordpress.org/plugins/search/mixed+content/\" rel=\"noopener noreferrer\" target=\"_blank\">several popular plugins</a> that can assist with fixing problems with mixed content. <a href=\"https://wordpress.org/plugins/really-simple-ssl/\" rel=\"noopener noreferrer\" target=\"_blank\">Really Simple SSL</a>, a plugin that is active on more than 3 million sites, has a built-in mixed content scan that shows users what they need to do if they aren&#8217;t seeing the green lock in the omnibar yet. It also includes a &#8220;mixed content fixer&#8221; for the back-end.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2019/10/mixed-content-scan-really-simple-ssl.png?ssl=1\"><img /></a></p>\n<p>Other popular plugins, such as <a href=\"https://wordpress.org/plugins/http-https-remover/\" rel=\"noopener noreferrer\" target=\"_blank\">SSL Mixed Content Fix</a> (20k active installs) and <a href=\"https://wordpress.org/plugins/ssl-insecure-content-fixer/\" rel=\"noopener noreferrer\" target=\"_blank\">SSL Insecure Content Fixer</a> (300k active installs) are focused specifically on fixing these issues and may assist in making other installed plugins compatible with HTTPS. They include tools that will diagnose insecure content and automatically perform basic fixes. The SSL Insecure Content Fixer plugin is also compatible with WordPress multisite and includes a network settings page to set defaults for the entire network.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 07 Oct 2019 19:09:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"WPTavern: U.S. Supreme Court Denies Domino’s Appeal to Determine Whether Websites Must Be Accessible\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94674\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/u-s-supreme-court-denies-dominos-appeal-to-determine-whether-websites-must-be-accessible\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6872:\"<p>In what is seen as a win for accessibility advocates, the U.S. Supreme Court denied Domino&#8217;s petition to appeal a lower-court decision on whether the pizza chain&#8217;s website and mobile app must be accessible to those with disabilities. The earlier U.S. 9th Circuit court <a href=\"http://cdn.ca9.uscourts.gov/datastore/opinions/2019/01/15/17-55504.pdf\">ruled that websites fall under</a> Title III of the American with Disabilities Act (ADA).</p>\n\n\n\n<p>The original case was brought forth by Guillermo Robles, a blind man, who claimed the Domino&#8217;s website and app did not allow him to place an order in 2016.  Robles, like many other people with disabilities, relies on screen-reader software to use the web.  Despite using such software, he was not able to make an order.</p>\n\n\n\n<p>The primary issue of the case was whether the ADA applied to websites or apps in the same way that they applied to brick-and-mortar locations.  Title III specifically points out public places of accommodation but not websites.</p>\n\n\n\n<p>The specific <a href=\"https://www.ada.gov/regs2010/titleIII_2010/titleIII_2010_regulations.htm\">section of the ADA</a> related to the case reads as follows:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>Section 36.201(a) contains the general rule that prohibits discrimination on the basis of disability in the full and equal enjoyment of goods, services, facilities, privileges, advantages, and accommodations of any place of public accommodation.</p><p>Full and equal enjoyment means the right to participate and to have an equal opportunity to obtain the same results as others to the extent possible with such accommodations as may be required by the Act and these regulations. It does not mean that an individual with a disability must achieve an identical result or level of achievement as persons without a disability.</p></blockquote>\n\n\n\n<p>The 9th Circuit decided the ADA also applied to businesses on the internet.</p>\n\n\n\n<p>There were three key issues in the case: whether the ADA applied to the website and app, whether Domino&#8217;s had fair notice to comply, and whether the court or the Department of Justice (DOJ) should decide the case.</p>\n\n\n\n<p>The DOJ is the body that regulates the ADA. Since it was signed into law in 1990, the DOJ has not created specific guidelines for how businesses can ensure their websites are within the law.</p>\n\n\n\n<p>One argument is that it would have been cheaper and easier for Domino&#8217;s to follow accessibility standards such as the Web Content Accessibility Guidelines (WCAG).  Such arguments don&#8217;t address the need for meaningful regulations from a governing body.  The WCAG are not legal guidelines in the U.S. However, the 9th Circuit ruled that the lack of guidelines does not remove Domino&#8217;s responsibility.</p>\n\n\n\n<p>Circuit Judge John B. Owens wrote in the <a href=\"https://www.supremecourt.gov/DocketPDF/18/18-1539/102950/20190613153344483_DominosPetitionAppendix.pdf\">9th Circuit decision</a>, &#8220;While we understand why Domino&#8217;s wants DOJ to issue specific guidelines for website and app accessibility, the Constitution only requires that Domino&#8217;s receive fair notice of its legal duties, not a blueprint for compliance with its statutory obligations.&#8221;</p>\n\n\n\n<p>The lack of such regulations is why this case was important from Domino&#8217;s standpoint.  While they lost the case, it may further push the need for more specific guidelines for businesses, both large and small, to follow.</p>\n\n\n\n<p>The lack of specific regulations could also be seen as <em>a feature rather than a bug</em>, to use a developer phrase.  Government-specific rules are often slow to keep up with the changing nature of the web.  Guidelines that apply one day may need to change soon thereafter.  It also leaves businesses the ability to make their websites accessible via a method of their choice rather than limiting what they can do to potentially bureaucratic rules that are out of touch with the modern web.</p>\n\n\n\n<p>At the same time, it could leave smaller business owners without large legal and website development budgets wondering if they could be looking at lawsuits in the future.  Courts were flooded with <a href=\"https://www.3playmedia.com/2019/06/12/2018sweb-accessibility-lawsuits/\">2,285 accessibility lawsuits in 2018</a>, which was nearly triple the 814 cases in 2017.</p>\n\n\n\n<h2>What Does This Mean for Website owners in the U.S.?</h2>\n\n\n\n<p>In terms of the case, the Supreme Court didn&#8217;t make a ruling.  They denied Domino&#8217;s petition and left the decision of the 9th Circuit in place, which covers much of the western U.S.  In the coming years, more cases will make their way through the courts.  More than likely, case law will continue becoming stronger in favor of making websites compliant with the ADA.</p>\n\n\n\n<p>If you run an online business, it&#8217;s past time to make sure your website is accessible.  It could be years before the current law is amended or new ones are written on the legislative level.  The winds of change will likely not favor those with inaccessible websites as more court decisions come down.</p>\n\n\n\n<p>In a nutshell, businesses with websites, apps, or other online presences need to make sure all people have access to their goods or services.  While there are no specific guidelines in the U.S., <a href=\"https://www.w3.org/WAI/standards-guidelines/wcag/\">WCAG</a> is the largely agreed-upon standards internationally.</p>\n\n\n\n<p>If you&#8217;re a small business owner using WordPress, you should start with a WordPress <a href=\"https://wordpress.org/themes/tags/accessibility-ready/\">theme labeled as accessibility-ready</a>.  It is worth noting that &#8220;accessibility-ready&#8221; does not mean that your website will automatically become accessible.  It simply means that the WordPress theme meets a minimum number of accessibility guidelines.  Custom content on your website should also follow the same guidelines.</p>\n\n\n\n<p>Accessibility is not a set-it-and-forget-it type of thing.  It&#8217;s something that business owners need to continually evaluate and make sure that all their customers, regardless of how that person accesses the internet, can enjoy the same services equally.</p>\n\n\n\n<p>The official theme review team is working through a long-term plan to <a href=\"https://wptavern.com/wordpress-theme-review-team-initiates-new-long-term-plan-to-make-all-wordpress-org-themes-accessible\">make all themes accessible</a> at WordPress.org.  Many theme businesses outside of WordPress.org also comply with those same guidelines.  If purchasing a theme, you should check with the business beforehand.</p>\n\n\n\n<p>As always, if you&#8217;re unsure whether your website meets legal guidelines, you&#8217;ll need to consult a lawyer who specializes in website accessibility.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 07 Oct 2019 18:02:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WordPress.org blog: People of WordPress: Alice Orru\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7288\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wordpress.org/news/2019/10/people-of-wordpress-alice-orru/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8390:\"<p><em>You’ve probably heard that WordPress is open-source software, and may know that it’s created and run by volunteers. WordPress enthusiasts share many examples of how WordPress changed people’s lives for the better. This monthly series shares some of those lesser-known, amazing stories.</em></p>\n\n\n\n<h2><strong>Meet Alice Orru, from Sardinia, Italy.</strong></h2>\n\n\n\n<p>Alice Orru was born in Sardinia, an island in the middle of the Mediterranean Sea. As a child, she dreamt of becoming a flight attendant, traveling the world, and speaking many foreign languages.</p>\n\n\n\n<p>Unable to meet the height requirements of her chosen profession, Orru ended up choosing a different path in life, following the Italian mantra: “You have to study something that will guarantee a stable and secure job for life.”</p>\n\n\n\n<p>The unemployment rate in Sardinia is very high, a challenge shared throughout the surrounding islands. In addition to that, Alice wasn’t that keen on having the same job all her life, as her parents had.</p>\n\n\n\n<p>When Orru was 22 she moved to Siena, Tuscany, to finish her studies. That is when she created her first personal blog. The website was built on an Italian platform named Tiscali, which she later migrated to WordPress.com.</p>\n\n\n\n<p>After 2 years in Tuscany Orru moved to Strasbourg, France. She studied French and worked several jobs while living there. Her first serious job was in Milan &#8211; working 40 hours/week in the marketing department of a large, international company. She found herself surrounded by ambitious colleagues and a boss who constantly requested extra —unpaid— working hours per day.</p>\n\n\n\n<img src=\"https://i0.wp.com/wordpress.org/news/files/2019/10/IMG_2672.jpg?fit=632%2C422&ssl=1\" alt=\"Alice Orru\" class=\"wp-image-7291\" />Alice Orru\n\n\n\n<h2>Choices, choices, choices&#8230;</h2>\n\n\n\n<p>Alice gave up blogging because she wasn’t feeling inspired enough to write. She questioned whether she really wanted to do that job forever; working 10 hours per day under the neon lights of an office. It forced her to set aside her dreams for the time being, and for a while, she mainly lived for the weekends.</p>\n\n\n\n<p>Alice decided to leave the job and moved to Barcelona, Spain, all by herself, in 2012.</p>\n\n\n\n<p>After a few months of intense Spanish learning at the university, she found a job in an international clinic as a “Patient Coordinator.” Orru assisted international patients coming to Barcelona for their treatments. She acted as their translator, interpreter and administrative consultant.&nbsp;</p>\n\n\n\n<p>Patients came from Italy, France, England, Morocco, Senegal, and several other countries. Alice was so inspired by some of their stories, that she started to write again: She dusted off her WordPress blog and filled it with stories about her new life in Barcelona and some of the women she met at the clinic. “I was feeling stronger and more independent than ever,” Orru expressed.</p>\n\n\n\n<h2>Technical issues led to unexpected opportunities</h2>\n\n\n\n<p>In the summer of 2015, Alice was writing on her blog and got stuck with a technical problem. While she was searching through the WordPress.com documentation, she saw a pop-up in the bottom right corner of her screen. It was a staff member of Automattic, checking if she needed help. They chatted for a few minutes and the problem was solved. Alice left the chat with one question, though: how did that person on chat find a support job with WordPress?</p>\n\n\n\n<p>Alice found the official WordPress job page: <a href=\"http://jobs.wordpress.net/\"><strong>jobs.wordpress.net</strong></a> and noticed a job offer that caught her attention: WP Media, a French startup, was looking for a polyglot and remote customer service teammate for one of their plugins, WP Rocket. She read their requirements: fluency in English, French and possibly other languages, excellent experience with WordPress, and some coding skills.</p>\n\n\n\n<p>She knew she didn’t meet all the requirements, but could speak 4 languages, and she had a WordPress blog. She didn’t know anything about PHP, though. Orru had been a WordPress.com user for years and knew she was ready to learn more.</p>\n\n\n\n<p>Orru wrote a cover letter and sent her CV. A Skype interview was conducted and several days later she received the news that she had gotten the job!&nbsp;</p>\n\n\n\n<h2><strong>A steep learning curve</strong></h2>\n\n\n\n<p>The early days in her new job were intense. Alice felt inexperienced but was supported by her teammates. She started studying and reading everything about WordPress for beginners. Initially, she answered easy tickets from customers. All the while her teammates were sending useful material to read, setting up video-calls for 1 to 1 training, and encouraging her the entire time.</p>\n\n\n\n<p>Soon, Orru was replying to customers whose first language was either Spanish or Italian in their native language. This was much appreciated and resulted in several happy comments. Until that moment the plugin’s support had been offered only in English and French.</p>\n\n\n\n<h2><strong>Finding her way in the WordPress community</strong></h2>\n\n\n\n<p>At WordCamp Paris 2016, one of Alice’s teammates introduced her to how the WordPress community collaborated and kept in contact through Slack.</p>\n\n\n\n<p>“You speak multiple languages, why don’t you try to contribute to the polyglots team?” he asked.</p>\n\n\n\n<p>Alice knew very little about contributing to WordPress. She had only been working for WP Media for 6 months and didn’t feel ready to dive into a new challenge and start also contributing to WordPress.</p>\n\n\n\n<p>Yet, curiosity led her to join both the local Italian and the global WordPress Community on Slack. For the first few months, she mainly observed what was happening the channels. Then, she attended WordCamp Milan and met some members of the Italian Polyglots team.</p>\n\n\n\n<p>It was love at first string! Laura, one of the <a href=\"https://make.wordpress.org/polyglots/teams/?locale=it_IT\"><strong>General Translation Editors</strong></a> (GTE) for Italy, taught her how to start contributing and translating, following the polyglots guidelines. She also told her about the Italian community’s big efforts to work together, consistently, to boost and grow WordPress related events in Italy.</p>\n\n\n\n<p>With her teammates’ encouragement, Orru applied to WordCamps as a speaker and gave her first talk in December 2016 at WordCamp Barcelona. After that, she both spoke at WordCamp Torino on April 2017 and at WordCamp Europe in 2017.</p>\n\n\n\n<img src=\"https://i2.wp.com/wordpress.org/news/files/2019/10/aliceorru-wordcamp-europe.jpg?fit=632%2C356&ssl=1\" alt=\"\" class=\"wp-image-7292\" />Alice Orru speaking at WordCamp Europe, in Paris, in 2017\n\n\n\n<h2><strong>Dreams evolve, all the time!</strong></h2>\n\n\n\n<p>Orru knows that her experiences are not just due to luck. She used her previous skills and passions and adapted them to a new career and life path.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>“We all have some skills; and if we don’t know which they are exactly, we should take some time to make a list of the things we’re really good at. With that in mind, just try. Apply. Get involved. Don’t get stuck in the feeling of &#8216;I can’t do it because I don’t know enough&#8217;. So that&#8217;s what I did. Without even realizing it, I started putting into reality the dream of the little girl who was born on an island and wanted to travel and speak different languages.WordPress made this possible.  I’m now part of a big community, and I am proud of it.&#8221;</p><cite>Alice Orru</cite></blockquote>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<div class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2019/07/heropress_large_white_logo.jpg?resize=109%2C82&ssl=1\" alt=\"\" class=\"wp-image-7025\" width=\"109\" height=\"82\" /></div>\n\n\n\n<p><em>This post is based on an article originally published on HeroPress.com, a community initiative created by <a href=\"https://profiles.wordpress.org/topher1kenobe/\">Topher DeRosia</a>. HeroPress highlights people in the WordPress community who have overcome barriers and whose stories would otherwise go unheard.</em></p>\n\n\n\n<p><em>Meet more WordPress community members over at </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>!</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 05 Oct 2019 04:24:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Yvette Sonneveld\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: WooSesh 2019 Scheduled for October 9 and 10: Registration Now Open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94416\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wptavern.com/woosesh-2019-scheduled-for-october-9-and-10-registration-now-open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2715:\"<p><a href=\"https://woosesh.com/\" rel=\"noopener noreferrer\" target=\"_blank\">WooSesh</a> is happening next week on October 9 and 10, and registration is now open. This is the second edition of the virtual WooCommerce event hosted by <a href=\"https://wpsessions.com/\" rel=\"noopener noreferrer\" target=\"_blank\">WPSessions</a>. In addition to presentations focused entirely on e-commerce, the event will include a &#8220;Hallway Track&#8221; that offers opportunities for attendees to connect with each other, along with virtual swag donated by various WordPress companies.</p>\n<p>Day 1 will cover a wide range of topics for WooCommerce professionals with a focus on store builders, including sessions on designing with blocks, sales tax, optimizing the checkout experience, and store emails. The first day will also feature a two-hour &#8220;State of the Woo&#8221; keynote address from the WooCommerce team. They plan to discuss case studies, lessons learned, and priorities for the year ahead.</p>\n<p>Day 2 will focus on more technical topics for WooCommerce developers, such as &#8220;Custom Tables and the Checkout Bottleneck,&#8221; solving store UX problems, and productizing development work.</p>\n<p>The event is being organized by Brian Richards and Patrick Rauland. For the past two years it has been the official successor to the previously held in-person WooConf events. Given how successful WooSesh has been in connecting the WooCommerce community, it&#8217;s easy to see why WooConf has not yet been reinstated.</p>\n<p>&#8220;One thing I can say, having helped three WooConfs and both WooSesh&#8217;s, is that a virtual event is a fraction of the cost,&#8221; Rauland said. &#8220;And we had twice as many people show up live for WooSesh compared to an in person event.&#8221;</p>\n<p>In 2018, WooSesh had 2,800 registrants and more than 1,400 who participated live during the event. Rauland reported that 900 people watched the keynote address. After the conclusion, 94% of respondents to an attendee survey said they would like to attend again the next year.</p>\n<p>Last year attendees could watch all sessions for free as long as they attended at least one presentation during the live event. This year sessions will be free during the event to encourage maximum engagement, and the recordings will be available on WPSessions.com for a fee after its conclusion.</p>\n<p>Tickets are free, thanks to sponsors that include WooCommerce, Jilt, and Avalara. Attendees can <a href=\"https://woosesh.com\" rel=\"noopener noreferrer\" target=\"_blank\">register</a> on the website and <a href=\"https://woosesh.com/#schedule\" rel=\"noopener noreferrer\" target=\"_blank\">preview the schedule</a> in their own timezones.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Oct 2019 19:10:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: WordPress.org Bumps PHP Maximum for Plugin Directory to Version 7.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94637\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/wordpress-org-bumps-php-maximum-for-plugin-directory-to-version-7-2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4315:\"<p>The WordPress.org SVN system received a version bump to 7.2 on October 3.  This change means that plugin authors can now use newer PHP syntax in plugins they submit to the official plugin directory.  In the future, the version maximum will match what&#8217;s running on WordPress.org.  </p>\n\n\n\n<p>This should be good news for any plugin developers who are using newer PHP syntax.  Previously, authors were able to submit code using newer PHP functions if they had a compatibility check in the same file.  However, newer syntax wasn&#8217;t allowed.</p>\n\n\n\n<p>&#8220;The issue was that the Linter (being stuck on 7.0) prevented anyone from checking in code via SVN that used 7.1+ standards,&#8221; said Mika Epstein from the plugin review team.  &#8220;So things like the Spaceship operator would fail on commit and you&#8217;d be told the syntax was invalid. This was holding back certain plugins from committing code into the directory.&#8221;</p>\n\n\n\n<p>Epstein first opened a <a href=\"https://meta.trac.wordpress.org/ticket/3791\">ticket to address the issue</a> 13 months ago but said she&#8217;d been quietly asking for a fix for a while longer.</p>\n\n\n\n<p>The max PHP version isn&#8217;t listed anywhere in the <a href=\"https://developer.wordpress.org/plugins/wordpress-org/\">plugin guidelines</a>.  Technically, it&#8217;s an SVN limitation on WordPress.org and not something the plugin team chose.  However, for plugin authors, they may not have known about the issue until their plugin was rejected by the system.  They would then message the plugin team about the problem.  &#8220;I may end up putting something in the docs, but it&#8217;s a somewhat uncommon occurrence,&#8221; said Epstein.</p>\n\n\n\n<p>This has been an issue for some plugin authors since PHP 7.1 was released, which was December 1, 2016.  &#8220;It was a once a year issue, then twice, and then it inched up to every couple months,&#8221; said Epstein.  &#8220;As of September, at least once a month someone would hit this and complain to plugins.&#8221;</p>\n\n\n\n<p>One potential problem with blocking newer PHP code is with plugins that rely on third-party libraries, which may only have security patches in more recent versions.  However, Epstein said that she was not aware of any security issues that resulted from the version limitation.</p>\n\n\n\n<p>Andrey &#8220;Rarst&#8221; Savchenko pointed out in the ticket that &#8220;7.2 was released almost two years ago.&#8221;  While he says it&#8217;s an improvement over the previous 7.0 limitation, version 7.2 should not be a hard ceiling for plugins in the repository.</p>\n\n\n\n<p>PHP 7.3 was released on December 16, 2018, and PHP 7.4 <a href=\"https://wptavern.com/first-look-at-php-7-4-for-wordpress-developers\">will be released</a> on November 28, 2019.</p>\n\n\n\n<p>&#8220;Given PHP&#8217;s poor adoption curves,&#8221; responded Dion Hulse, &#8220;all that this means is that you can&#8217;t release a plugin through WordPress.org that only works on 15% of WordPress sites.  &#8220;You can even use newer functions in PHP if including compat code, just not newer syntax.&#8221;</p>\n\n\n\n<p>Plugin author Josh Pollock <a href=\"https://twitter.com/Josh412/status/1100487567236059136\">called awareness to the issue</a> on Twitter in February.  &#8220;Hours later, I&#8217;m downgrading a dependency, because it requires another dependency, which requires PHP 7.1.&#8221;</p>\n\n\n\n<p>&#8220;I think we got lucky and there were no bugs,&#8221; Pollock said of downgrading to an earlier version of the dependency.  &#8220;I don&#8217;t think I&#8217;ve used SVN since. I&#8217;m really fortunate that&#8217;s not a part of my life anymore.&#8221;</p>\n\n\n\n<p>&#8220;I agree with Rarst,&#8221; said Pollock.  &#8220;We should be allowing for PHP 7 and making it easier for plugins not to support sites on out of date versions of PHP.&#8221;  This echoes the sentiment of other developers who are pushing for WordPress to adopt newer standards or at least allow them to do so in their own plugins in the official directory.</p>\n\n\n\n<p>For the majority of plugin authors, this should be a non-issue as long as the SVN system remains updated to match the version of PHP used on WordPress.og.</p>\n\n\n\n<p>PHP 7.2 will lose active support on November 30, 2019, and security support on November 30, 2020.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Oct 2019 16:41:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"WPTavern: Matt Mullenweg and David Heinemeier Hansson Discuss WordPress Market Share, Monopolies, and Power in Open Source Communities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94234\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"https://wptavern.com/matt-mullenweg-and-david-heinemeier-hansson-discuss-wordpress-market-share-monopolies-and-power-in-open-source-communities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:18041:\"<p>In what began as a heated conversation on Twitter, Automattic CEO Matt Mullenweg and Ruby on Rails creator and Basecamp co-founder David Heinemeier Hansson took to the airwaves to debate opposing viewpoints on market share, monopolies, and power in open source communities. Hansson reacted to a statement Mullenweg made in an interview after <a href=\"https://wptavern.com/automattic-raises-300m-in-series-d-investment-round-valuation-jumps-to-3-billion\" rel=\"noopener noreferrer\" target=\"_blank\">Salesforce Ventures invested $300 million in Automattic</a> last month.</p>\n<p>“I think there’s potential to get to a similar market share as Android, which I believe now has 85% of all handsets,&#8221; Mullenweg told <a href=\"https://techcrunch.com/2019/09/19/automattic-ceo-matt-mullenweg-about-raising-300-million-and-the-open-web/\" rel=\"noopener noreferrer\" target=\"_blank\">TechCrunch</a>. &#8220;When you think about it, open source has a virtuous cycle of adoption, people building on the platform and more adoption.&#8221;</p>\n<p>Hansson reacted on Twitter, sparking a conversation that received 116 comments.</p>\n<p>&#8220;&#8216;We want every website, whether it’s e-commerce or anything to be powered by WordPress&#8217; is a nasty, monopolistic goal,&#8221; he said. &#8220;Listening to Matt muse about 85% marketshare dreams is a real downer. But $300m is a down payment on monopoly dreams.&#8221;</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">“We want every website, whether it’s e-commerce or anything to be powered by WordPress” is a nasty, monopolistic goal. Listening to Matt muse about 85% marketshare dreams is a real downer. But $300m is a down payment on monopoly dreams. <a href=\"https://t.co/hf4HShISug\">https://t.co/hf4HShISug</a></p>\n<p>&mdash; DHH (@dhh) <a href=\"https://twitter.com/dhh/status/1174695189090308096?ref_src=twsrc%5Etfw\">September 19, 2019</a></p></blockquote>\n<p></p>\n<p>In an episode titled &#8220;<a href=\"https://rework.fm/open-source-and-power-with-matt-mullenweg/\" rel=\"noopener noreferrer\" target=\"_blank\">Open Source and Power</a>,&#8221; Mullwenweg joined Hansson on the Rework podcast for a more in-depth discussion that dives deeper into Mullenweg&#8217;s remarks on WordPress&#8217; potential market share.</p>\n<p>Hansson contends that he would like to see a very large, rich ecosystem of providers of tools and services on the web and expressed concern about WordPress growing many times faster than any of its competitors.</p>\n<p>Mullenweg countered that unique domains are not the only measure of a monopoly. He also referenced Shopify as having a thriving business with a small percentage of the e-commerce platform market share.</p>\n<p>&#8220;Even though open source can become a bit of a standard, it doesn&#8217;t prevent others from starting on it,&#8221; Mullenweg said. &#8220;The truth is if I had an evil hat on &#8211; let&#8217;s say I started doing evil monopoly stuff, people could easily fork the software &#8211; and they would. There&#8217;s a checks and balances there.&#8221;</p>\n<p>This is a <a href=\"https://wptavern.com/wordpress-governance-project-looks-for-new-leadership\" rel=\"noopener noreferrer\" target=\"_blank\">classic power dynamic in BDFL-led open source projects</a> where the potential for a fork checks the project leader&#8217;s actions.</p>\n<p>Hansson challenges Mullenweg&#8217;s assertion that a fork would be a threat to the project, arguing that this power is illusionary when a project has become as dominant as WordPress:</p>\n<blockquote><p>Technically someone could fork Ruby on Rails tomorrow. What is the likelihood that fork is going to succeed? Once you have this juggernaut of network effects, WordPress is growing so much faster than anyone else, the gravitational pull is huge. Should someone fork it, introducing incompatibilities, what is the likelihood that is going to be a serious contender? From me, my assessment is extremely low, just the same as if someone was to fork Ruby on Rails today and call it Snoopy on Pails. The odds of that being anything other than a curiosity for two days on Hacker News is extremely low.</p></blockquote>\n<p>The notion of Snoopy on Pails injected a bit of humor into the debate that remained high intensity for the hour-long discussion, but it also illustrated Hansson&#8217;s point regarding the absurdity of any kind of WordPress fork becoming a real threat to the project&#8217;s momentum.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">it was a privilege to have <a href=\"https://twitter.com/photomatt?ref_src=twsrc%5Etfw\">@photomatt</a> come on <a href=\"https://twitter.com/reworkpodcast?ref_src=twsrc%5Etfw\">@reworkpodcast</a> and debate <a href=\"https://twitter.com/dhh?ref_src=twsrc%5Etfw\">@dhh</a> on tech monopolies and power dynamics in open source: <a href=\"https://t.co/Aewq4QTwFe\">https://t.co/Aewq4QTwFe</a>. Also thanks to <a href=\"https://twitter.com/AdamStddrd?ref_src=twsrc%5Etfw\">@AdamStddrd</a> for making this graphic that will make sense if you listen to the episode <img src=\"https://s.w.org/images/core/emoji/12.0.0-1/72x72/1f603.png\" alt=\"😃\" class=\"wp-smiley\" /> <a href=\"https://t.co/4cqZpX2uJk\">pic.twitter.com/4cqZpX2uJk</a></p>\n<p>&mdash; Wailin Wong (@VelocityWong) <a href=\"https://twitter.com/VelocityWong/status/1179025482416820224?ref_src=twsrc%5Etfw\">October 1, 2019</a></p></blockquote>\n<p></p>\n<p>&#8220;Open source can provide a veil over true power and who has that power, and I would argue that WordPress being in the position that it is, a third of all sites, is tremendous power,&#8221; Hansson said. &#8220;Even if that power is somewhat distributed, it&#8217;s still very much so located mostly with the company backing that engine and that you built a commercial business on top of it that even uses the name, goes even further to say there&#8217;s a lot of power here.</p>\n<p>&#8220;Why would venture capitalists invest half a billion dollars into WordPress if they didn&#8217;t see Automattic as a company as having a lot of power over WordPress? The whole reason someone is able to raise that kind of money is off the back of someone who can pitch: &#8216;We have over a third of all websites on the internet and we think we can get to 85%.&#8217; That&#8217;s a very compelling venture story.&#8221;</p>\n<p>Mullenweg counters that if a Rails fork couldn&#8217;t attract a lot of users, that speaks to the Hansson&#8217;s stewardship of the project. He said that a typical WordPress release has 400-500 contributors with an estimated 10% from Automattic.</p>\n<p>&#8220;If 200 of those went someplace else because I did something really brain dead, that would be a pretty serious competitor, and there are some examples of that in open source history,&#8221; Mullenweg said. He contended that forks with enough weight behind them can become very interesting. On this point the two project leaders remained at odds.</p>\n<h3>How Open Source Market Dominance Impacts Diversity of Tools and Services on the Web</h3>\n<p>One of Hansson&#8217;s chief concerns with WordPress reaching 85% market share is what he described as the &#8220;death of diversity.&#8221; He perceives this pursuit of increased adoption as growing open source in monopolistic ways.</p>\n<p>&#8220;We&#8217;re living through an era right now where a small handful of big tech companies are exerting a completely undue amount of power over the internet, over discourse, over all sorts of things, and that&#8217;s something we should try to recoil from and at least learn from, not aspire to building more of,&#8221; Hansson said. &#8220;That&#8217;s what got this going &#8211; why isn&#8217;t WordPress in a great place only being a third of all the sites of the internet. Why does it need to get to 85%? Why does its growth need to be that explosive and that wild?&#8221;</p>\n<p>This is a question many in the WordPress community have asked in the past. Does the mission of democratizing publishing necessitate such a zealous drive towards market dominance?</p>\n<p>&#8220;I don&#8217;t want to see this concentration of power in one engine, no matter how good it is,&#8221; Hansson said.</p>\n<p>It is at this juncture that Mullenweg revealed more of his vision for WordPress becoming the &#8220;operating system of the web,&#8221; an idea he has floated several times over the past few years.</p>\n<p>&#8220;You have referred to WordPress a lot of times as blogging,&#8221; Mullenweg said. &#8220;I think of it more like a platform. If you look at how a lot of people are building on it, they use WordPress to bootstrap something that doesn&#8217;t look like WordPress at all. It might not even have a website. It might be powering just an API. It might be a headless or decoupled installation. It could be a store.&#8221;</p>\n<p>He likened the idea to Apache and nginx having a dominant market share (<a href=\"https://www.datanyze.com/market-share/web-and-application-servers/apache-http-server-market-share\" rel=\"noopener noreferrer\" target=\"_blank\">55%</a> and <a href=\"https://www.datanyze.com/market-share/web-and-application-servers/nginx-market-share\">23%</a> respectively) in the server space.</p>\n<p>&#8220;That doesn&#8217;t prevent the different types of websites that are built on it,&#8221; Mullenweg said. &#8220;If nginx got to 80 or 85%, that wouldn&#8217;t prevent the diversity or what people could put on their websites. WordPress could get to 85% and it wouldn&#8217;t mean that there&#8217;s any sort of monoculture or lack of diversity. If anything, it would allow people to focus more on what&#8217;s different and not recreating the WYSIWYG, the user system, the login, all that stuff we have all built a million times and you just don&#8217;t need to anymore, if something like WordPress solves your needs.&#8221;</p>\n<p>Hansson asked what it would look like if 85% of the web ran on WordPress, a question that the community behind the project hasn&#8217;t deeply examined yet. He encouraged listeners to consider what they want the internet to look like in the future:</p>\n<blockquote><p>What is the future I&#8217;d like to live in? What does a healthy, open, free internet look like? To me it looks like an internet with tons of different providers, tons of different tools, and what we collaborate around is protocols, not consolidation of software market share, that gives individuals and companies or even projects outsized power to dictate the matters of the internet.</p></blockquote>\n<p>Matt clarified that his comments on an 85% market share are not a goal, but rather a &#8220;trailing indicator&#8221; in the quest to create the best possible experience for developers and users. A growing market share is a signal of adoption in that sense, not a goal in itself.</p>\n<h3>WordPress Community Reactions to the Debate</h3>\n<p>After the initial exchange on Twitter, the broader tech community seemed delighted to hear Mullenweg and Hansson square off in a civil debate on topics that affect so many people working on the web. The conversation touched on a lot of the friction points in the WordPress ecosystem with Automattic being one of the most powerful companies driving WordPress&#8217; market share. Many listeners were grateful for answers to questions they have had for years.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Not sure <a href=\"https://twitter.com/dhh?ref_src=twsrc%5Etfw\">@dhh</a> realizes it, but he spoke for hundreds if not thousands of WordPress community members that have had similar questions for <a href=\"https://twitter.com/photomatt?ref_src=twsrc%5Etfw\">@photomatt</a> spanning the last few years. Most aren’t afforded the same opportunity or carry the same clout to have it.  <a href=\"https://t.co/z7wSIGJKAZ\">https://t.co/z7wSIGJKAZ</a></p>\n<p>&mdash; Matt Medeiros (@mattmedeiros) <a href=\"https://twitter.com/mattmedeiros/status/1179201126878629888?ref_src=twsrc%5Etfw\">October 2, 2019</a></p></blockquote>\n<p></p>\n<p>However, the idea of WordPress as web infrastructure and the level of market dominance (85%) discussed in the podcast are controversial and even off-putting for some who are deeply invested in the platform.</p>\n<p>&#8220;Matt appears to think of WordPress as infrastructure for the web, in the same way that Google and Facebook think of themselves as infrastructure for the web,&#8221; Morten Rand-Hendriksen said.</p>\n<p>&#8220;In the conversation about the dangers of market control, monopolization, and monoculture, Matt says, &#8216;We are not a grain, we are the soil.&#8217; The only way to interpret that from my position is &#8216;WordPress is not a thing on the web. It is the web,&#8217; i.e. infrastructure. A future where WP is web infrastructure is something I think very few people actually want, open source or not.&#8221;</p>\n<p>On the podcast, Mullenweg argued that open source allows for competition in a way proprietary software does not, but Rand-Hendriksen said he sees this as a logical fallacy.</p>\n<p>&#8220;He talks at the same time about WP being infrastructure and powering 85% of the web AND about this being a reason for others to fight it with other solutions,&#8221; he said. &#8220;So monopolization leads to competition somehow. I don&#8217;t think WordPress is infrastructure, or that it should power 85% of the web, especially after hearing this conversation.</p>\n<p>&#8220;If we truly believe in this idea of open source as diversification and forking, WP should actively support other projects and try to not be the dominant force on the web. WP is not infrastructure, it is very much a grain that has become a monoculture.&#8221;</p>\n<p>Matt Medeiros, host of the <a href=\"http://youtube.com/themattreport\" rel=\"noopener noreferrer\" target=\"_blank\">Matt Report podcast</a> focused on WordPress business and entrepreneurs, said that while the conversation answered a lot of questions, it left him wanting more.</p>\n<p>&#8220;The cloud of uncertainty that hangs above a large portion of this community is directly formed from lack of clear communication in both <a href=\"http://WordPress.org\">WordPress.org</a> and how Automattic + Jetpack move in lockstep with the open source project,&#8221; Medeiros said. &#8220;As we see hundreds of millions of dollars invested, with billions of dollars of valuation going to a single company, surely the optics leave one wondering how all of this gets repaid to investors?&#8221;</p>\n<p>Automattic invariably comes under more public scrutiny regarding its investments due to having the WordPress project lead as its CEO. One interesting observation Mullenweg made during podcast is that Automattic is just one of many larger players that make up the the WordPress economy, which he has previously estimated at $10 billion/year.</p>\n<p>&#8220;Automattic makes probably 2-3% of the revenue in the WordPress world,&#8221; Mullenweg said. &#8220;There are companies like GoDaddy, which might not contribute very much back to core, but probably have 3 or 4 times the number of subscribers than us running WordPress. I think about that a lot. I want to grow the whole ecosystem, not just our slice of it.&#8221;</p>\n<p>Revenue is not always equal to influence, and a good portion of the end of the podcast tackled questions about power and leadership in open source.</p>\n<p>&#8220;David&#8217;s questions are spun from the threads that fear monopoly on the web, as much as we fear a singular rule of decision making in the open source project,&#8221; Medeiros said. &#8220;I think David did well at challenging Matt&#8217;s view on the desire of world domination and how undesirable it is to earn the title of Benevolent Dictator &#8212; but it left me wanting more. For example, in an attempt to throw a curveball, Matt pointed out, the investment is made in Automattic &#8212; not WordPress &#8212; a point so opaque it didn&#8217;t fool David, but didn&#8217;t have him pressing any deeper.</p>\n<p>&#8220;Had David viewed this conversation through the lens of our community, he would know that Automattic and WordPress.com enjoy the full benefit of leveraging the WordPress brand, a brand protected by a foundation that Matt himself founded, which may have guided the podcast episode into the ethics of it all.&#8221;</p>\n<p>While Mullenweg&#8217;s claim that &#8220;WordPress belongs to you as much as it belongs to anyone else&#8221; is true in the sense that the software is freely available to be used and modified by anyone, the full power of <a href=\"http://wpandlegalstuff.com/using-wordpress-trademarks-business-product-service/\" rel=\"noopener noreferrer\" target=\"_blank\">leveraging the WordPress brand</a> does not belong to everyone.</p>\n<p>&#8220;I don&#8217;t think Matt would have been willing to have this kind of conversation with me or most members from the the general community, so I&#8217;m glad someone of David&#8217;s clout was able to engage here,&#8221; Medeiros said. &#8220;I do sympathize with all that Matt is responsible for and it&#8217;s not a challenge I think I&#8217;d be up for, given the opportunity. I love this community and want to see people stay, contribute, and flourish &#8212; not walk away because they felt unheard. DHH isn&#8217;t the hero we asked for, but he&#8217;s the hero we need right now. Hopefully he continues to keep a watchful eye over where WordPress is heading.&#8221;</p>\n<p>If you only listen to one podcast this week, <a href=\"https://rework.fm/open-source-and-power-with-matt-mullenweg/\" rel=\"noopener noreferrer\" target=\"_blank\">Hansson&#8217;s conversation with Mullenweg</a> is an invigorating battle of opposing open source ideals held as a respectful exchange. In defending their positions, both reveal how their experiences of the early days of the web shaped their ideologies and approaches to open source project leadership and commercialization. Conversations like these are rare but long overdue, as the WordPress community considers its growing influence on the future of the web.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Oct 2019 18:59:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: WordPress Theme Review Team Brings Back Review Shindigs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94599\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wptavern.com/wordpress-theme-review-team-brings-back-review-shindigs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3730:\"<p>The WordPress theme review team (TRT) is kicking off a review weekend October 5 and will begin at 10:00 Coordinated Universal Time (UTC).  These events, called &#8220;review shindigs,&#8221; are marathon sessions where the team joins together to review themes and teach best practices.  The current plan is to hold the event on the first Saturday of every month.</p>\n\n\n\n<p>&#8220;The goal of the review weekend is to get together and do as many quality reviews as possible,&#8221; wrote Carolina Nymark, one of the team&#8217;s review representatives, in the <a href=\"https://make.wordpress.org/themes/2019/10/03/review-weekend\">event&#8217;s announcement</a>.  Events sometimes have different goals, depending on what the team needs to work on at the time.  </p>\n\n\n\n<p>Most of the event will happen over the team&#8217;s <a href=\"https://wordpress.slack.com/messages/themereview\">Slack channel</a>.  They will also hold a live presentation or Q&amp;A on Zoom at 13:00 UTC.  Anyone is welcome to attend (the Zoom link will be provided in Slack).  This will help teach those who are interested in how to perform reviews and check common issues.  Anyone attending is also able to submit topics for discussion in the comments on the announcement post.</p>\n\n\n\n<p>The TRT originally <a href=\"https://make.wordpress.org/themes/2019/09/24/meeting-notes-for-tuesday-24th-september-2019/\">announced plans</a> for the event after the last team meeting, but it was overshadowed by other news, such as the <a href=\"https://wptavern.com/theme-review-team-restructures-into-project-representatives\">team moving to a flat structure</a>.  &#8220;Not sure if anyone but myself will be there,&#8221; joked Nymark.  &#8220;It&#8217;s short notice.  Some of the team reps already had other plans.&#8221;</p>\n\n\n\n<p>Anyone from the WordPress community is allowed to participate in the event by simply commenting on a ticket without being assigned a review.  Nymark provided links on <a href=\"https://make.wordpress.org/themes/handbook/get-involved/become-a-reviewer/\">how to become a reviewer</a> and the team&#8217;s <a href=\"https://make.wordpress.org/themes/handbook/get-involved/onboarding-for-new-reviewers/\">reviewer onboarding process</a> to get new reviewers started.</p>\n\n\n\n<p>Review shindigs can help new reviewers because it puts them in touch with more experienced reviewers at a time when they know someone will be online to answer questions.  They&#8217;re also a team-building exercise where people can join together and work toward a common goal.</p>\n\n\n\n<p>Currently, <a href=\"https://themes.trac.wordpress.org/\">214 tickets</a> are awaiting review. A successful event would significantly cut that number down.</p>\n\n\n\n<h2>Events From the Past</h2>\n\n\n\n<p>Theme review shindigs have seen varying levels of success over the years.  In the TRT&#8217;s earliest days, review gatherings were regular events and helped keep the ever-growing ticket queue under control.  Participation waned over time as leaders within the team switched to other projects or no longer had time to run the events.  Proposals to bring back them back have not gone far in the last couple of years.</p>\n\n\n\n<p>The last TRT shindig was a <a href=\"https://make.wordpress.org/themes/2016/12/05/december-shindig-recap/\">December 2016 event</a> that saw over 50 participants.  Reviewers worked on 108 tickets throughout the weekend.  The event also coincided with contributor day at WordCamp US, which helped bump up participation numbers.</p>\n\n\n\n<p>Jose Castaneda, Cristiano Zanca, Benjamin Lu, and Afzaal Ahmed held a live stream that covered how to load scripts and styles in themes in the previous review event.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Oct 2019 18:29:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: Debating OSS with DHH\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=50262\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://ma.tt/2019/10/debating-oss-with-dhh/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:931:\"<p>The other week I ended up going back and forth in tweets with <a href=\"https://dhh.dk/\">David Heinemeier Hansson</a>, it wasn&#8217;t going anywhere but he graciously invited me to their podcast and we were able to expand the discussion in a way I found really refreshing and mind-opening.</p>\n\n\n\n<p>DHH and I have philosophies around work and open source that I believe overlap 95% or more, so that makes where we have differences all that more interesting to mine. Although we would see each other logged into the same server 15 years ago, we haven&#8217;t actually spoken directly until this podcast started, but the conversation flowed so naturally you&#8217;d think we have been talking since then.</p>\n\n\n\n<p>Check out the <a href=\"https://rework.fm/open-source-and-power-with-matt-mullenweg/\">episode on Open Source and Power on the Rework Podcast</a>, hopefully you enjoy listening as much as we enjoyed recording it.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Oct 2019 00:04:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: First Look at PHP 7.4 for WordPress Developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94552\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wptavern.com/first-look-at-php-7-4-for-wordpress-developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7152:\"<p>PHP 7.4 is slated for release on November 28, 2019.  WordPress 5.3 will also <a href=\"https://core.trac.wordpress.org/ticket/47783\">include several commits</a> that address deprecated features.</p>\n\n\n\n<p>It&#8217;s unlikely that most WordPress plugin and theme developers will be able to use the new PHP 7.4 features for a while except when working on setups where they have some measure of control over the environment.  Given WordPress&#8217; reluctance to bump the minimum PHP version to the latest supported versions, it could be years before it&#8217;s safe to use new features.  However, developers should make sure their plugins and themes are compatible with 7.4.  It&#8217;s also good practice to keep up with current features.</p>\n\n\n\n<p>WordPress 5.2 <a href=\"https://wordpress.org/news/2019/05/jaco/\">bumped the minimum requirement</a> to PHP 5.6 with a recommendation of PHP 7.3.  The following is the breakdown for current <a href=\"https://wordpress.org/about/stats/\">PHP usage stats</a> for WordPress installs:</p>\n\n\n\n<ul><li>PHP 7.3 &#8211; 9.6%</li><li>PHP 7.2 &#8211; 22.2%</li><li>PHP 7.1 &#8211; 13.5%</li><li>PHP 7.0 &#8211; 14.9%</li><li>PHP 5.6 &#8211; 25.7%</li></ul>\n\n\n\n<p>Currently, PHP 7.2 and 7.3 are the only versions receiving active support.  PHP will drop security support for version 7.1 on December 1.</p>\n\n\n\n<h2>New Features</h2>\n\n\n\n<p>PHP 7.4 includes a number of <a href=\"https://www.php.net/manual/en/migration74.php\">new features</a> that will make writing code easier.  The following is a small overview of some of the features that will likely be useful for WordPress plugin and theme authors.</p>\n\n\n\n<h3>Typed Properties</h3>\n\n\n\n<p>PHP first introduced type hinting in 5.0 and has continued improving the feature.  PHP 7.0 introduced return type declarations.  PHP 7.4 steps it up a notch and allows developers to declare types for class properties.  This lets developers make sure the type of data assigned to a specific property is always that data type.</p>\n\n\n\n<p>In the following example, the <code>$id</code> property can only be assigned an integer and the <code>$title</code> property a string.  Attempting to assign the wrong data type will result in a fatal error if strict types are declared.  Otherwise, PHP will coerce the value to the correct type.</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\nclass Event {\n\n    public int $id;\n\n    public string $title;\n}\n</pre>\n\n\n<h3>Arrow Functions</h3>\n\n\n\n<p>Many developers have been clamoring for arrow functions similar to JavaScript. They are pretty sweet to use.  However, PHP&#8217;s arrow functions, also called &#8220;short closures,&#8221; are slightly different.  PHP 7.4 introduces the <code>fn</code> keyword (now a reserved keyword).  Short closures can only contain one expression and have no <code>return</code> keyword.  They&#8217;re not quite as powerful as their JavaScript cousins, but they do offer a quick solution for some scenarios.</p>\n\n\n\n<p>For example, the following code snippet shows two different ways to build an array of user emails from a collection of user objects.</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\n// Old way, but still acceptable.\n$value = array_map( function( $user ) {\n    return $user-&gt;user_email;\n}, $users );\n\n// New way.\n$value = array_map( fn( $user ) =&gt; $user-&gt;user_email, $users );\n</pre>\n\n\n<h3>Unpacking Inside of Arrays</h3>\n\n\n\n<p>Argument unpacking was <a href=\"https://www.php.net/manual/en/migration56.new-features.php\">introduced in PHP 5.6</a>, so this may still be unfamiliar territory for many developers in the WordPress space.  It&#8217;s been an invaluable feature in some of my projects.</p>\n\n\n\n<p>PHP 7.4 allows developers to unpack an array within an array.  This should be faster than <code>array_merge()</code> because the spread operator (<code>...</code>) is a language construct rather than a function.</p>\n\n\n\n<p>Consider the following example of injecting an array of two colors within a larger array of colors.</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\n$colors_a = [ \'green\', \'blue\' ];\n\n$colors_b = [ \'red\', ...$colors_a, \'yellow\', \'purple\' ];\n\n// [ \'red\', \'green\', \'blue\', \'yellow\', \'purple\' ];\n</pre>\n\n\n<h3>Null Coalescing Assignment Operator</h3>\n\n\n\n<p>The null coalescing assignment operator is a shorthand way of combining an <code>isset()</code> check with a ternary operator.</p>\n\n\n\n<p>The following example shows how to check the <code>$product[\'id\']</code> variable.  If it&#8217;s set, do nothing.  Else, assign it the value on the right.  You can see the evolution of the code between PHP versions.  It&#8217;s much simpler to write in 7.4.</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\n// Pre-PHP 7.0.\n$product[\'id\'] = isset( $product[\'id\'] ) ? $product[\'id\'] : 0;\n\n// PHP 7.0.\n$product[\'id\'] = $product[\'id\'] ?? 0;\n\n// PHP 7.4.\n$product[\'id\'] ??= 0;\n</pre>\n\n\n<h2>Deprecated Features</h2>\n\n\n\n<p>PHP 7.4 will deprecate several features.  Plugin and theme authors will want to <a href=\"https://www.php.net/manual/en/migration74.deprecated.php\">consult the complete list</a> to determine whether they should update any outdated code.  I cherry-picked a few items that I&#8217;ve seen in plugin and theme code over the last few years.  Most other deprecated features are unlikely in current code bases.</p>\n\n\n\n<h3>Nested Ternary Operators Without Parenthesis</h3>\n\n\n\n<p>Nested ternary operators are generally something you should avoid as a developer.  Seriously.  Just don&#8217;t write them.  They&#8217;re tough to follow and are prone to bugs due to human error.  However, if you&#8217;re going to throw caution to the wind and dismiss good advice, at least use parenthesis.  PHP 7.4 deprecated nested ternaries without them.</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\n// Not OK (deprecated).\n$value = $a ? $b : $c ? $d : $e;\n\n// OK.\n$value = ( $a ? $b : $c ) ? $d : $e;\n\n// OK.\n$value = $a ? $b : ( $c ? $d : $e );\n</pre>\n\n\n<h3>Using array_key_exists() on Objects</h3>\n\n\n\n<p>Developers should not use <code>array_key_exists()</code> on objects simply because objects are not arrays.  Instead, use the more appropriate <code>property_exists()</code> function or <code>isset()</code>.</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\n// Not OK (deprecated).\nif ( array_key_exists( $property, $object ) ) {}\n\n// OK.\nif ( property_exists( $object, $property ) ) {}\n\n// OK.\nif ( isset( $object-&gt;$property ) ) {}\n</pre>\n\n\n<h3>Array and String Offset Access With Curly Braces</h3>\n\n\n\n<p>Using curly braces for array and string offset access is a bit more of a rarity, but I&#8217;ve seen it in the wild a couple of times.  Make sure you&#8217;re using square brackets such as <code>[]</code> instead of curly brackets like <code>{}</code>.</p>\n\n\n<pre class=\"brush: php; gutter: false; title: ; wrap-lines: false; notranslate\">\n// Not OK (deprecated).\n$value = $a{ $key };\n\n// OK.\n$value = $a[ $key ];\n</pre>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Oct 2019 18:16:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: BuddyPress 5.0 Introduces BP REST API, Paving the Way for Blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94453\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wptavern.com/buddypress-5-0-introduces-bp-rest-api-paving-the-way-for-blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3919:\"<p><a href=\"https://buddypress.org/2019/09/buddypress-5-0-0-le-gusto/\" rel=\"noopener noreferrer\" target=\"_blank\">BuddyPress 5.0.0</a> “Le Gusto” was released this week with the long-awaited BP REST API, a new Invitations API, and BuddyPress info on the Site Health screen. The release was named for a favorite pizza restaurant in Fortaleza, Brazil, where BP REST API contributor and core committer <a href=\"https://profiles.wordpress.org/espellcaste/\" rel=\"noopener noreferrer\" target=\"_blank\">Renato Alves</a> resides.</p>\n<p>The new REST API is <a href=\"https://developer.buddypress.org/bp-rest-api/\" rel=\"noopener noreferrer\" target=\"_blank\">fully documented</a> and includes endpoints for members, groups, activities, private messages, screen notifications and extended profiles.</p>\n<p>The first feature powered by the new API is an improved interface for managing group members. It enables administrators to quickly search for specific members to promote, demote, ban, or remove.</p>\n<p><div class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<a href=\"https://wptavern.com/wp-content/uploads/2019/06/5zJCxp2ARb.mp4\">https://wptavern.com/wp-content/uploads/2019/06/5zJCxp2ARb.mp4</a></div></p>\n<p>BuddyPress 5.0 also includes a new <a href=\"https://bpdevel.wordpress.com/2019/09/16/new-invitations-api-coming-in-buddypress-5-0/\" rel=\"noopener noreferrer\" target=\"_blank\">BP Invitations API</a> to help developers better manage group invites and membership requests.</p>\n<p>BuddyPress site administrators may notice <a href=\"https://wptavern.com/buddypress-5-0-to-display-debug-info-in-the-new-site-health-info-screen\" rel=\"noopener noreferrer\" target=\"_blank\">a new panel in the Site Health Info screen</a>, containing plugin-specific debug information that may be useful when seeking help in the forums.</p>\n<p>This release <a href=\"https://wptavern.com/buddypress-5-0-to-update-password-control-to-match-wordpress\" rel=\"noopener noreferrer\" target=\"_blank\">updates the BP Nouveau template pack</a> to use the same password control as the one used in WordPress core. It provides a more consistent interface for users when setting their passwords on the registration page and on the user’s general settings page.</p>\n<h3>Blocks Are Coming to BuddyPress</h3>\n<p>The BP REST API offers a myriad of opportunities for developers to create new interactive features and front-end experiences, as well as improve performance by replacing AJAX calls. It also opens up the world of block creation. BP core contributors and community developers will have a much easier time creating blocks, since Gutenberg mainly uses REST.</p>\n<p>In anticipation of BP blocks, <a href=\"https://wptavern.com/buddypress-5-0-to-add-category-for-storing-buddypress-blocks\" rel=\"noopener noreferrer\" target=\"_blank\">5.0 includes a new panel in the block inserter</a> that allows developers to organize their custom blocks under a BuddyPress category.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2019/08/buddypress-blocks-panel.png?ssl=1\"><img /></a></p>\n<p>BuddyPress 6.0 <a href=\"https://buddypress.trac.wordpress.org/ticket/8048\" rel=\"noopener noreferrer\" target=\"_blank\">may include core blocks for specific components</a> and core blocks may ultimately replace the plugin&#8217;s existing widgets. Contributors are still discussing which blocks to begin building. They are looking to get community feedback on blocks that will be the most useful, particularly from BuddyPress theme developers. The team <a href=\"https://bpdevel.wordpress.com/2019/10/01/bp-dev-chat-agenda-october-2-2019/\" rel=\"noopener noreferrer\" target=\"_blank\">plans to discuss 6.0 release priorities</a> during the BP core dev chat on <a href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20191002T1900\" rel=\"noopener noreferrer\" target=\"_blank\">October 2, 2019, at 1900 UTC</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Oct 2019 11:06:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WordPress.org blog: The Month in WordPress: September 2019\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7280\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2019/10/the-month-in-wordpress-september-2019/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7584:\"<p>September has been a particularly busy month in the WordPress community—a lot of important work has been done as everyone in the project works towards an upcoming major release. Read on to find out more about this and everything else that has been going on over the past month.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 5.2.3 Security and Maintenance Release</h2>\n\n\n\n<p>Early in September, <a href=\"https://wordpress.org/news/2019/09/wordpress-5-2-3-security-and-maintenance-release/\">version 5.2.3 of WordPress was released</a> as a security and maintenance release. Sixty-two individuals contributed to its 29 fixes and enhancements.</p>\n\n\n\n<p>The security issues fixed in this release owe thanks to numerous people who disclosed them responsibly. You can read more about the vulnerability reporting process <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">in the Core handbook</a>.</p>\n\n\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>WordPress 5.3 Enters Beta</h2>\n\n\n\n<p>WhileWordPress 5.3 is slated for release on November 12, it has already entered the beta phase with <a href=\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-2/\">the second beta release being made available</a> at the end of September. As this is a major release, it will feature a number of new features and enhancements, including <a href=\"https://make.wordpress.org/core/2019/09/19/whats-new-in-gutenberg-18-september/\">significant improvements to the block editor</a>, <a href=\"https://make.wordpress.org/core/2019/09/25/whats-new-in-site-health-for-wordpress-5-3/\">updates to the Site Health component</a>, <a href=\"https://make.wordpress.org/core/2019/09/24/new-block-apis-in-wordpress-5-3/\">new block APIs</a>, <a href=\"https://make.wordpress.org/core/2019/09/23/core-widgets-new-aria-current-attribute-in-wordpress-5-3/\">accessibility updates</a>, and <a href=\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-1/\">much more</a>.</p>\n\n\n\n<p>You can test the 5.3 beta release by installing <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">the WordPress Beta Tester plugin</a> on any WordPress site, although as this is software that is currently in development, we don’t recommend installing it on a live site.</p>\n\n\n\n<p>Want to get involved in building this release? <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">Test the beta</a>, follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Date/Time Component Improvements</h2>\n\n\n\n<p>For over a year, contributors involved in <a href=\"https://make.wordpress.org/core/components/date-time/\">the Date/Time component</a> of WordPress Core have been working hard on the “wp_date” project. The goal of this project is to fix and streamline the way that Core handles times and dates throughout the platform.</p>\n\n\n\n<p>This ambitious project has seen incremental changes over the last few Core releases. The upcoming 5.3 release <a href=\"https://make.wordpress.org/core/2019/09/23/date-time-improvements-wp-5-3/\">will include the final and most significant changes</a> to the component, bringing much-needed stability to time handling in WordPress Core.</p>\n\n\n\n<p>Want to get involved in the Date/Time component of WordPress Core? <a href=\"https://make.wordpress.org/core/components/date-time/\">Learn more about it</a>, follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, and join the #core-datetime channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>New Theme Review Team Structure</h2>\n\n\n\n<p>After recent discussions around the goals of the Theme Review team, <a href=\"https://make.wordpress.org/themes/2019/09/24/new-theme-review-team-structure/\">some changes have been made</a> to the leadership structure of the team. The team leads are now ‘representatives’ of different areas of the work that they do. This flat structure allows for representatives to work in more loosely defined areas so they contribute to the team in more diverse ways, and helps the team to be more focused on setting and achieving their goals. The new structure is outlined <a href=\"https://make.wordpress.org/themes/handbook/about/members/\">in the team handbook</a>.</p>\n\n\n\n<p>Want to get involved in reviewing themes for WordPress? Follow <a href=\"https://make.wordpress.org/themes/\">the Theme Review team blog</a>, and join the #themereview channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>New Default Theme: Twenty Twenty</h2>\n\n\n\n<p>The upcoming 5.3 release will also include <a href=\"https://make.wordpress.org/core/2019/09/06/introducing-twenty-twenty/\">a new default theme for WordPress</a>, <em>Twenty Twenty</em>. This theme will have a strong focus on readability and accessibility while being optimized for the block editor that first shipped with WordPress 5.0.</p>\n\n\n\n<p>Development of <em>Twenty Twenty</em> has been going quickly, with <a href=\"https://make.wordpress.org/core/2019/09/30/twenty-twenty-update/\">a recent update</a> showing more of the design and layouts that you can expect when the theme is released with WordPress 5.3 in November.</p>\n\n\n\n<p>Want to get involved in building <em>Twenty Twenty</em>? You can <a href=\"https://github.com/WordPress/twentytwenty\">contribute on GitHub</a>, follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li>The Gutenberg project has continued to see regular updates with <a href=\"https://make.wordpress.org/core/2019/09/19/whats-new-in-gutenberg-18-september/\">the latest version</a> set to be included in WordPress 5.3.</li><li>Members of the Community Team <a href=\"https://make.wordpress.org/community/2019/09/13/call-for-participants-creating-a-welcoming-and-diverse-space-online-workshop-on-sun-oct-6/\">will run a workshop</a> to help event organizers create welcoming and diverse spaces for attendees.&nbsp;</li><li>There are some <a href=\"https://make.wordpress.org/updates/2019/09/20/wordpress-user-pro-survey-11-questions-and-a-script/\">proposed updates for the annual WordPress user survey</a> that need community feedback.</li><li><a href=\"https://make.wordpress.org/docs/2019/09/23/summary-for-helphub-meeting-23-september-2019/\">Work continues on the HelpHub project</a> where contributors are moving documentation to the updated support portal.</li><li>The Gutenberg team performed further usability tests in August, <a href=\"https://make.wordpress.org/test/2019/09/06/gutenberg-usability-testing-for-august-2019/\">with some interesting results</a>.</li><li><a href=\"https://buddypress.org/2019/09/buddypress-5-0-0-le-gusto/\">Version 5.0 of BuddyPress was released</a> near the end of this month, featuring a new REST API, improved group management, and other enhancements.</li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Oct 2019 08:05:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"HeroPress: 14 Years’ Detour\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=2972\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://heropress.com/essays/14-years-detour/#utm_source=rss&utm_medium=rss&utm_campaign=14-years-detour\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:35176:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2019/10/100219-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I learned not only to keep face and move forward, but also to dare.\" /><p><a href=\"https://heropress.com/feed/#ru\">Это эссе также доступно на русском языке</a></p>\n<blockquote><p>Knowing what you want isn&#8217;t enough.</p></blockquote>\n<p>At the age of fifteen, I was told to hurry up with my professional education, if I don’t get a free place at university no one will pay for me. Last one was obvious and not because of money. I didn’t know how high or low my chances are even I had very good marks. I could have been just the biggest fish in the pond, but I wanted to leave people who treat me like expense item as soon as possible anyway. I made up my mind and it’s separated me from my classmates. I got secondary school certificate and left school instantly without goodbyes.</p>\n<p>My knowledge of opportunities was very narrow. I thought to be an ecologist or guide translator from German, based on what I was taught at school, or an advertiser, it was ads boom in Russia, ads were fascinating, and I collected flyers. At the same time, I was already good a computer user and did a lot of typing for one of the school&#8217;s principals, sometimes instead of classes, volunteered once and they couldn’t say “no”.</p>\n<p>No one bothered to give me advice, but I was sure my future was unimaginable without computers and came to a general decision to be a programmer. The range of technical schools was not wide, and names of specializations looked very abstruse. I messed up and spend four years studying transistor markings, soldering and drawing PCB layouts. Programming course turns out to be a bit of a joke, it was Pascal, we didn’t even try to do something useful with it. English course was another flaw in this education, the teacher was busy showing off and teasing girls. I&#8217;m not sure if he even knew the subject. He was fired after our collective petition. We got good marks just to forget about it. I left technical school with honors degree and improved typing skills.</p>\n<p>It was wild unfriendly market I faced. I didn’t know how to recognize a normal job offer from sinister one, so I bumped into several, like banging in people’s doors and pitch them in buying cheap stuff for very high price. It was harassing and I have no idea how long I would’ve looked for work without help.</p>\n<h3>The wrong approach can cause failure</h3>\n<p>I was lucky to have a father in an IT company. He proposed me like a substitute to typists when I was still a student and when I finished, helped me to get a job on updating a law system on client’s computers. Maybe I could get it by coming from the street, but I had to know where the entrance is. Half a year later I got a full-time job in the same service department and started to play volleyball with colleagues. It was great to meet people from other departments and on the field was no big difference between director and analyst, it’s fair play. I liked my place and my clients, but I was “friendly” told that without a university degree I will have no further promotions.</p>\n<p>At this time, I tried to study PHP by a book. It was very exciting at first, but a lot of functions without explanation how to build something useful with them didn’t make much sense and when I tried, I failed and backed off. It was hard to admit a fail even to myself and it was nagging me for a long time.</p>\n<p>I had to choose something I can handle; I’m interested in and can afford. It turned out to be advertising. I spent most of my and my husband’s holidays on sessions in the next 6 years. It was tricky for him to make me to leave a computer, once I was glued to it, so he bought me my first laptop. English was still hard for me, I got my high marks just memorizing all the words in a textbook and how they must sound. Again, I wanted something I cannot handle.</p>\n<blockquote><p>I started to hate my workplace long before I finished education with another honor degree no one was interested in.</p></blockquote>\n<p>I got a promotion quite soon despite apprehensions but then my chief was dismissed and with new one the things became very tense; I escaped to have a baby and spent a whole three years on child’s care holidays full of doubts. I tried to get off by studying, drawing and baking but the pram was pulling me back. I didn’t use to stay put, rely on my husband’s money and be separate from other people. I didn’t want to come back, but it looked like I have no better choice, I was convinced (overall, rightly) that not too many companies want in office position a woman with small baby and lots of sick leaves.</p>\n<p>After I returned at work it became clear that the situation in my department was unhealthier than ever, I lost my place and next boss treated all back-office girls like pieces of furniture. In a few months I had enough.</p>\n<h3>The flip side of the coin can become a black swan</h3>\n<p>I wanted to be a marketer. Knowing how tricky it is to sell intangibles, I wanted solid product to work with. Now I see that it isn&#8217;t a point at all.</p>\n<p>It turned out to be difficult to find a job outside IT, some HRs was kind enough to answer that with my experience I’ll better be in IT.</p>\n<p>Still I was very hopeful, studied hard and considered myself well, but once again I set a low bar to my employers. Companies I worked in wanted to get all publicity and sales rise through a cost of my salaries. I was careless once, the next time I asked specifically about budget before signing up and was assured, but still they meant my wages. It was a tough period of disappointments.</p>\n<p>When I was offered a part-time administrative job with “ok” to sick leaves, I took it gladly like a reprieve. It was far from home, and I was spending 2-3 hours a day on buses with Harry Potter audio books for company. In these traffic jams I started to feel English at last and loved it, it gave me a freedom no money can buy. And despite the long way I managed to play volleyball with my husband and his colleagues. Life was getting better.</p>\n<p>This job itself in addition to low payment had something valuable to me — a working website. After my boss had a row with its developer, I got it to maintain, did some reverse engineering and understood how it works. It wasn’t a most creative site, but it gave me a view. I started to write simple sites from scratch.</p>\n<blockquote><p>My first JavaScript calculator almost made me crazy, but I pursued.</p></blockquote>\n<p>From time to time I was asked for help from a friend or relative, usually to solve some urgent problems. So, I started to meet popular CMSs. One of the first I met with was WordPress. There was some issue in theme, which was changed and dropped by developer. I was digging a whole weekend deciphering how it works and found infinity loop to fix. Back then for me it was just a system…</p>\n<p>Two years later I found myself still clinging to my temporary job. I was tired of working for a hard nosed dictator, the last drop was his statement that I was not a programmer, because he hadn’t seen anything I made. I’ve already written some parts of website he asked for, so it was just unfair. I became angry and it was exactly what I needed, a big kick.</p>\n<p>I went out but still had no courage to pretend on a developer’s place and landed in some franchise company selling “box version” websites. It was another tough half of a year with a lot of work, low payment and plan failures, ending with pneumonia. I see now that I was making a disservice to customers, websites are not a microwave meal — quick, cheap and dummy. There was no life in them without a lot of work no one bargained to buy or do. Most of the sites I sold back then died when year expired but they never were truly alive and useful.</p>\n<h3>You need to pluck up your courage to become lucky</h3>\n<p>When I recovered, I search through developer’s job offers, but it was difficult to find something suitable worth trying to apply. I was reading job advertising and it looked, and still is, like mostly IT company are presented and they want geniuses who know a lot of technologies and frameworks at once. It was very distressing just to look.</p>\n<p>And then I became lucky again. I opened a private ads site and almost immediately found a job which was fitted me perfectly — they wanted someone with experience to write from scratch, understand another’s code and maintain it, ability to translate technical documentation and articles and make simple design of printing products. I made test task and there was no need in my resume or diplomas, I was taken. It’s turned out direct ad from one of sales departments in tech company and I passed by HR, who most likely wouldn&#8217;t even have considered me. Superior agreed to have me remotely most of the time, it solved sick leaves problem even if it was already much better than before. Addition to better salaries and calm work without over hours, I got very pleasant colleagues. We are friends ever since, despite back then no one guessed to invite me to play volleyball.</p>\n<p>It was 14 years after the original decision to be a programmer and it was only the beginning. I left this amazing place a couple years later when it held no more challenges for me.</p>\n<h3>Conscious decisions require wide knowledge</h3>\n<p>After I worked with a bunch of CMSs, I started to be able to compare them and understood not only that WordPress is the best one for developers and clients but also that I didn’t see right examples at all. The biggest flaw of WordPress — it’s so easy to make things work that there&#8217;s no need to bother and do things right and this becomes a problem later. I also saw bad cases on very different systems… and did them as well.</p>\n<p>I used to work relying on examples at hand, documentation and Google, but searching for a specific feature or a solution, I found myself again missing the whole picture. At this point Udemy courses came very handy and then I started to attend WordPress events, firstly online and then by foot, trains and airplanes and discovered a wide and very alive community. Now I know not only where to look but whom to ask and how to be not far from those who stays on top of things as much as possible. Most important is that I found allies who don’t think I’m going crazy, speaking with shining eyes about work, with whom I share a passion and fondness to WordPress. It’s what matters.</p>\n<p>Now, after 6 years of full time in development, I still feel myself like a newbie, it’s endless learning, frequent discoveries, mistakes and impassable wish to do better…</p>\n<h3>The way is the destination</h3>\n<p>I made a path very uneven, a lot of mess and banging, but for me it’s like a kaleidoscope where a little turn presents a new picture, new “a-ha” moment, new excitement after seemingly pointless efforts. When in doubt I remind myself about David Ogilvy who tried a lot of things before struck gold with advertising and it’s maybe why.</p>\n<p>Finally, I learned not only to keep face and move forward but also to dare.</p>\n<h3>Freedom is to make your own mind</h3>\n<p>I left my last workplace after we finished exhausted two years project on another CMS system which was a big reinventing of wheels and made up my mind to work only with WordPress from now on and dare to be my own boss.</p>\n<p>Now I’m officially an entrepreneur. This big boy’s stuff looks difficult. But I don’t want to be told, collaboration is a new black wherever I look.</p>\n<h2 id=\"ru\">Крюк длинной в 14 лет</h2>\n<blockquote><p>Не достаточно знать, что хочешь</p></blockquote>\n<p>В 15 лет мне было сказано, чтобы я поспешила с профессиональным образованием, если не поступлю бесплатно в институт, никто платить за меня не будет. Последнее было очевидно и не из-за денег. Несмотря на весьма хорошие оценки, я не могла оценить свои шансы, могло оказаться, что я просто большая рыба в маленьком пруду. Но в любом случае, я хотела как можно быстрей расстаться с людьми, видящими во мне одну большую статью расходов. Я приняла решение и это откололо меня от моих одноклассников. Ушла из школы я, не прощаясь, как только получила на руки сертификат об окончании 9 классов.</p>\n<p>Нужно было выбрать профессию, но потенциальные возможности были весьма туманны. Я могла стать экологом или немецкоязычным гид-переводчиком, на основе того, чему училась в школе, или рекламщиком, в России тогда начался рекламный бум, и она казалась очень захватывающей, я даже листовки собирала. В то же самое время я уже была хорошим пользователем компьютера и набирала документы для завуча старших классов, иногда вместо занятий — вызвалась один раз и потом уже не могла сказать «нет».</p>\n<p>Никто не пытался дать мне совет, но я была уверена, что будущее немыслимо без компьютеров и решила стать программистом. Выбор техникумов в пределах разумной досягаемости, был не очень большой, а названия специальностей выглядели очень мудрено. Я ошиблась и провела следующие 4 года изучая маркировку транзисторов, паяя и чертя печатные платы. Курс программирования обернулся дурной шуткой, это был Паскаль, и мы даже не пытались сделать с ним что-то полезное. Другим серьезным недостатком этого обучения стал английский язык, преподаватель выпендривался и задирал девушек, я так и не поняла знал ли он язык вообще. В конце концов он был уволен после нашей коллективной жалобы, а мы получили хорошие оценки, в качестве решения проблемы. Я выпустилась из техникума с красным дипломом и улучшенными навыками машинистки.</p>\n<p>Рынок труда был диким и неизведанным. Не зная, как распознать сомнительное предложение о работе, наткнулась на несколько таких, как ходить по домам и навязывать людям дешевые утюги за внушительную цену. Поиск работы оказался изматывающим, без посторонней помощи, я могла бы еще долго ходить по этим собеседованиям.</p>\n<h3>Неправильный подход может быть причиной неудачи</h3>\n<p>Мне повезло, отец работал в IT-компании. Он предложил меня в качестве подмены наборщикам, когда я еще училась, а когда закончила, помог получить работу по обновлению правовой системы на компьютерах у клиентов. Может быть меня взяли бы и, приди я с улицы, но для этого нужно было знать, куда идти. Через полгода я получила место в офисе в том же отделе обслуживания, а также начала играть с коллегами в волейбол. Это было здорово, знакомиться с людьми из других отделов, а еще на поле нет большой разницы между директором и аналитиком. Мне нравилось мое место и мои клиенты, но опять мне было «дружески» сказано, что без высшего образования, на большее я могу не рассчитывать.</p>\n<p>В это время я пыталась изучать PHP по книге. В начале все выглядело очень захватывающе, но функции без понимания как из них построить что-то целое не имели большого смысла, я пробовала, у меня не получалось, и в конце концов сдалась. Было сложно признаться, что я не смогла, даже самой себе и это неприятное чувство преследовало меня долгое время.</p>\n<p>Нужно было выбрать то, с чем я смогу справиться, что-то интересное и что будет мне по карману. Выбор пал на рекламу. В следующие 6 лет большая часть наших с мужем отпусков ушла на мои сессии. Ему было сложно выгнать меня из-за компьютера, я к нему приклеилась, поэтому он купил мне мой первый ноутбук. Английский по-прежнему давался мне очень трудно, и чтобы получить пять, пришлось переводить и запоминать вместе с транскрипцией все слова в учебном пособии. Снова я хотела то, что мне не давалось.</p>\n<blockquote><p>Я начала ненавидеть свое рабочее место задолго до того, как закончила университет с еще одним никому не нужным красным дипломом.</p></blockquote>\n<p>Я получила повышение достаточно скоро, несмотря на опасения, но затем руководство сменилось и работать с новым стало весьма напряженно. Я сбежала в декрет и провела следующие три года отпуска по уходу за ребенком полные сомнений. Учеба, рисование и приготовление пирогов отвлекали, но я оказалась не готова быть привязанной к коляске — ограниченной в передвижениях, оторванной от других людей, полагаться на деньги мужа. Возвращаться на работу я не хотела, но не видела лучшего выхода, была убеждена, и вполне резонно, что ни так много компаний готовы взять на офисную позицию женщину с маленьким ребенком и кучей больничных.</p>\n<p>После того, как я вернулась на работу, стало ясно, что ситуация стала еще хуже, чем была. Я потеряла свое место, а очередной новый руководитель относился во всем девушкам «поддержки» как к мебели. Несколько месяцев мне хватило.</p>\n<h3>Обратная сторона медали может быть золотой</h3>\n<p>Я хотела быть маркетологом. Зная, как непросто продавать что-то неосязаемое, решила работать с товаром, который можно пощупать. Сейчас думаю, разница была только в голове.</p>\n<p>Оказалось, сложно найти работу вне IT-сектора, некоторые менеджеры по персоналу снисходили для объяснений, что мне будет лучше в IT.</p>\n<p>И все-таки я была настроена оптимистично, я усердно училась и считала, что хорошо справляюсь, но опять, оказалось, что установила слишком низкую планку для работодателей. Компании, в которых я работала, хотели и публикации, и рост продаж исключительно за счет моей зарплаты. Ошибившись один раз, в следующий я специально уточнила вопрос с бюджетом, и меня заверили, что он есть. Оказалось, что это по-прежнему только зарплата. Это был период разочарований.</p>\n<p>Когда мне предложили административную работу на полставки с терпимым отношением к больничным, я с радостью ухватилась за возможность взять передышку. Работа была далеко от дома, и я проводила 2-3 часа в маршрутках каждый день в компании с аудиокнигами про Гарри Поттера. В этих дорожных пробках я наконец почувствовала английский язык и полюбила его, это дало мне свободу, которую невозможно купить за деньги. И, несмотря на долгую дорогу, я смогла играть после работы в волейбол с мужем и его коллегами. Жизнь налаживалась.</p>\n<p>Эта работа сама по себе, помимо низкой зарплаты, имела нечто ценное для меня – работающий сайт. После того, как мой начальник поссорился с разработчиком, я получила его на поддержку. Разобрав его на части, я поняла, как он работает. Это не был самый креативный сайт в мире, но он дал мне целостное представление, и я начала писать простые сайты с нуля.</p>\n<blockquote><p>Мой первый калькулятор на JavaScript практически свел меня с ума, но я продолжила.</p></blockquote>\n<p>Время от времени меня просили помочь родственники и друзья, обычно решить какую-то срочную проблему. Так я стала встречаться с популярными CMS. Одной из первых оказался WordPress. Там была проблема в теме, которую разработчик изменил и бросил. Я копала все выходные, но в конце концов нашла место, где код уходил в бесконечный цикл и исправила. Тогда для меня это была просто какая-то система…</p>\n<p>Два года спустя я все еще держалась за свою временную работу. Резкие манеры начальника перестали казаться забавными и последней каплей стало его категорическое заявление, что я не программист, потому что он не видел ничего, созданного мной. На тот момент я уже написала для сайта функционал, который он же просил, так что это было обидно. Я разозлилась и это стало толчком в нужном направлении.</p>\n<p>Я ушла, но все еще не пыталась получить работу разработчика, и в результате оказалась в одной из франшизных компаний, продающих сайты «из коробки». Это были сложные полгода с кучей работы, низкой зарплатой и провалами плана, закончившиеся воспалением легких. Сейчас, думаю, я оказывала клиентам медвежью услугу, сайт – не готовое блюдо для микроволновки, быстрое, дешевое и типовое. В этих сайтах нет жизни без вложения огромного труда, за которых никто не готов был платить. Большая часть сайтов умерли через год, но они и живыми то не были.</p>\n<h3>Нужно набраться смелости, чтобы повезло</h3>\n<p>Когда я поправилась, начала искать работу разработчика, но было сложно найти что-то подходящее даже просто чтобы решиться ответить на вакансию. В объявлениях были в основном представлены IT-компании, которым нужны гении, знающие огромное количество технологий и фреймворков. Только вид этих вакансий вгонял в депрессию.</p>\n<p>А потом мне снова повезло. Я открыла сайт частных объявлений и буквально сразу же нашла работу, которая мне подходила идеально — они хотели кого-то с опытом написания с нуля, умеющего разбираться и дописывать чужой код, переводить техническую документацию и статьи, а также делать простую полиграфию. Я сделала тестовое задание и была принята, ни дипломы, ни резюме уже не понадобились. Оказалось, это был объявление одного из отделов продаж в компании, занимающейся промышленным оборудованием, и я прошла в обход отделка кадров, который, уверена, даже не посмотрел бы на меня. Начальник согласился на мою работу удаленно, что решило проблему частых больничных, хотя ребенок рос, и их уже стало намного меньше. В дополнение к лучшей зарплате и спокойной работе без переработок и нервотрепки, мне достались замечательные коллеги. Мы дружим с тех пор, несмотря на то, что тогда никто не догадался позвать меня играть в волейбол.</p>\n<p>Это случилось через 14 лет после первоначального решения стать программистом и это был только начало. Я ушла через пару лет, когда ничего нового в работе уже не осталось.</p>\n<h3>Сознательные решения требуют широкий знаний</h3>\n<p>После того, как я поработала с разными CMS, смогла не только сравнить их между собой и понять, что WordPress лучшая из всех как для разработчиков, так и для клиентов, но также обнаружить, что вообще не видела хороших примеров разработки. Самая большая проблема WordPress — сделать так, чтобы работало, настолько легко, что мало кто не утруждает себя делать правильно, что позже оборачивается проблемами при доработке и поддержке. Впрочем, я видела плохие решения на разных CMS, да и сама их делала.</p>\n<p>Отталкиваясь от доступных примеров и документации и ища в поисковиках конкретные решения, я опять обнаружила, что не вижу всей картины. В этот момент курсы Udemy оказались очень кстати, а затем я начала посещать мероприятия WordPress, сначала онлайн, потом топая ни них ножками, оправляясь на поездах и самолетах, и обнаружила большое и весьма активное сообщество. Наконец-то я нашла не только тех, у кого можно спросить, но и как быть недалеко от тех, кто «в теме», насколько это вообще возможно. Самое важное – я нашла единомышленников, тех, кто не думает, что человек, говорящий с горящими глазами о работе, рехнулся, с кем у нас общая страсть и любовь к WordPress. Это то, что имеет значение.</p>\n<p>Сейчас, проработав 6 лет как разработчик, я все еще чувствую себя новичком, это бесконечное обучение, частые открытия, ошибки и непроходящее желание сделать лучше.</p>\n<h3>Смысл пути в самом пути</h3>\n<p>Мой путь очень извилистый, много метаний и набитых шишек, но для меня это как калейдоскоп, где каждый поворот показывает новую картинку, новое озарение, дает энергию двигаться дальше после казавшихся напрасными усилий. В периоды сомнений, я напоминаю себе о Дэвиде Огилви, который сменил множество специальностей, пока не добился успеха в рекламе.</p>\n<p>Я научилась не только сохранять лицо и идти вперед, но также набралась смелости.</p>\n<h3>Свобода — возможность принимать решения</h3>\n<p>Я ушла со своего последнего места работы, где мы закончили изматывающий двухлетний проект на другой CMS, ставший сам по себе большой ошибкой, и ни только приняла решение работать исключительно с WordPress, но и стать своим собственным начальником.</p>\n<p>Теперь я официально предприниматель. Все эти вещи «для больших мальчиков» выглядят достаточно сложными, но я больше не хочу слепо делать то, что мне скажут. В тренде коллаборации, куда ни глянь.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: 14 Years’ Detour\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=14%20Years%E2%80%99%20Detour&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2F14-years-detour%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: 14 Years’ Detour\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2F14-years-detour%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2F14-years-detour%2F&title=14+Years%E2%80%99+Detour\" rel=\"nofollow\" target=\"_blank\" title=\"Share: 14 Years’ Detour\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/14-years-detour/&media=https://heropress.com/wp-content/uploads/2019/10/100219-150x150.jpg&description=14 Years’ Detour\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: 14 Years’ Detour\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/14-years-detour/\" title=\"14 Years’ Detour\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/14-years-detour/\">14 Years’ Detour</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Oct 2019 05:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olga Gleckler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: Brian Gardner Steps Down From StudioPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94449\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wptavern.com/brian-gardner-steps-down-from-studiopress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7190:\"<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>Brian Gardner <a href=\"https://studiopress.blog/not-goodbye/\">announced he was stepping down</a> from his role with StudioPress this past Friday.  Last year, <a href=\"https://wptavern.com/wp-engine-acquires-studiopress\">WP Engine acquired StudioPress</a>.  After staying on board for the remainder of his contract, Gardner stepped down from his role with the company.</p>\n\n\n\n<p>&#8220;The past 15 months have gone by quickly, and it sometimes feels like yesterday that we made the announcement,&#8221; Gardner said in his post. &#8220;In the same breath, it has also felt like forever.&#8221;</p>\n\n\n\n<p>For many in the WordPress community, Gardner needs no introduction.  He&#8217;s the founder of <a href=\"https://studiopress.com\">StudioPress</a> and co-created Genesis with Nathan Rice, one of the most popular WordPress themes today.  In many ways, he&#8217;s the father of the modern professional WordPress theme ecosystem, becoming one of the first theme authors to figure out that you could make a living by providing WordPress products.</p>\n\n\n\n<p>He&#8217;s unafraid of letting his personal geek flag fly in his online life. He <a href=\"https://twitter.com/bgardner/status/6776616143294464\">quotes Sarah McLachlan</a>, is a self-affirmed Starbucks addict, runs marathons, and loves family trips to Disney World.</p>\n\n\n\n<p>For many theme authors in the WordPress community, he&#8217;s an inspiration.  Even as a former business competitor, I&#8217;ve always admired his work.  More than that, I&#8217;ve admired how he runs his business.  He never needed to be flashy.  He never needed to create controversy for PR.  He, almost quietly, built up a successful company.  The splashes he made came from the products he and his company released.</p>\n\n\n\n<p>In 2007, Gardner released the Revolution WordPress theme to the public for sale. Some may argue that Revolution was the catalyst for the commercial WordPress themes ecosystem.  There were several theme business startups around the same time.  Revolution at least played a pivotal role in the market&#8217;s early growth.</p>\n\n\n\n<p>Gardner launched the Revolution business in 2008, but quickly <a href=\"https://www.studiopress.com/revolution-rebrands-as-studiopress/\">rebranded to StudioPress</a> in 2009 after some legal issues with the name. By late 2010, <a href=\"https://wptavern.com/studiopress-sold-to-copyblogger\">StudioPress merged with Copyblogger</a>.</p>\n\n\n\n<h2>Hindsight: The Biggest Regrets After 12 Years</h2>\n\n\n\n<p>When building a successful company, it&#8217;s easy to look back on things that could&#8217;ve been handled differently.  There are deals passed up, ideas that flopped, and products that didn&#8217;t scale.</p>\n\n\n\n<p>&#8220;My biggest regret was not starting with (or switching to) a recurring business model,&#8221; said Gardner.  &#8220;I think I left a lot of money on the table by not doing that, but once I merged StudioPress into Copyblogger Media, we decided to leave it as is and use the former as a doorway into our company&#8217;s ecosystem.&#8221;</p>\n\n\n\n<p>Many theme companies in the early days had lifetime sales.  It&#8217;s unlikely many could foretell how they&#8217;d need to scale for 10 or 20 years down the line.  The concept was relatively new in the WordPress space.  Gardner kept up with the model despite most theme shops moving to subscription-based sales, which typically scale better in the long term.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>From a personal standpoint, I think I could have done better. There were a few seasons (some short and others a bit longer) where I strayed away from my involvement at StudioPress. While I justified it by thinking that it was OK to pursue side projects and other things, I realize looking back that jeopardized the trust our customers had in the brand. I think I may have leaned too heavily on the fact that we had a team, but in the same breath, I think it was necessary for StudioPress to outgrow the label of &#8216;Brian Gardner themes.&#8217; This emphasis really helped with the transition after WP Engine acquired StudioPress.</p></blockquote>\n\n\n\n<h2>Building a Community Over Software</h2>\n\n\n\n<p>&#8220;Without a doubt, it&#8217;s the <a href=\"https://genesis.community/\">Genesis community</a>,&#8221; Gardner said when asked what he&#8217;s most proud of with his time at StudioPress. &#8220;When Nathan Rice and I set out to build Genesis (the framework), we were trying to solve a software problem and bring a better user experience for our customers.&#8221;</p>\n\n\n\n<p>Instead of building software, he learned what he was building was a community.  After creating a showcase page for people using the Genesis theme, he kept getting requests for people to build child themes.  This led to the creation of the <a href=\"https://www.studiopress.com/genesis-developers/\">Genesis Developers</a> page, which provided a way for people within the community to earn a living.</p>\n\n\n\n<p>&#8220;While community has always been important to me,&#8221; Gardner said, &#8220;I didn&#8217;t realize the ripple effect that creating a solid piece of software would have.&#8221;</p>\n\n\n\n<p>Gardner said the developers page created a way to pay it forward to the people who had helped him build a successful company.  The idea has remained a success, and there are many designers within the larger WordPress community who list custom Genesis design work in their credentials.</p>\n\n\n\n<p>&#8220;I have had the pleasure of being able to meet and spend time with members of the community—from talking about their success to future plans,&#8221; said Gardner.  &#8220;This past year at WordCamp US in Nashville, I was able to fully comprehend the level in which lives had been changed by what we had done—and those are the moments I could not be any prouder of what I built.&#8221;</p>\n\n\n\n<h2>What&#8217;s on the Horizon?</h2>\n\n\n\n<p>&#8220;Heh. The million-dollar question, right?&#8221; responded Gardner to whether he plans to continue building themes.  He doesn&#8217;t have any plans to create a new theme business, and any themes that he does build will be built for Genesis and made available from his website.</p>\n\n\n\n<p>&#8220;Over the past few years, I have developed a particular love for minimalist design, and I want to spend some of my time and creative energy there.&#8221;</p>\n\n\n\n<p>Gardner is currently available for hire as a website designer through <a href=\"https://authentik.com/\">Authentik</a>, a design and development studio that he founded.  Authentik specializes in branding and growth/audience building.  The team builds everything from landing pages to more complex multi-system environments.</p>\n\n\n\n<p>However, there may be more to come from Gardner in the future.  &#8220;I have created some personal space to pursue collaborations and consulting,&#8221; he said.  &#8220;I have a renewed focus on my blog and want to spend more time consuming content—reading books, listening to podcasts, and meeting up with folks locally. My heart to help fellow creators is as strong as ever, and I feel there are some really interesting opportunities to do that.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Oct 2019 19:37:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: Gatsby Days London Features Multiple WordPress Presentations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94405\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/gatsby-days-london-features-multiple-wordpress-presentations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9154:\"<p><a href=\"https://www.eventbrite.com/e/gatsby-days-london-2019-tickets-66228586485\" rel=\"noopener noreferrer\" target=\"_blank\">Gatsby Days London</a> kicked off yesterday with a lot of momentum after Gatsby Inc. announced <a href=\"https://wptavern.com/gatsby-raises-15m-plans-to-invest-more-heavily-in-wordpress-and-cms-integrations\" rel=\"noopener noreferrer\" target=\"_blank\">a $15M Series A funding round</a> last week. The one-day conference drew 200 attendees and was the third in a series of Gatsby Days that have been held in other cities. They are designed to give the community an opportunity to meet in person and hear more about the future of the project from its creators and contributors.</p>\n<p>Gatsby creator Kyle Mathews gave the keynote address and described what he sees as a shift from the LAMP-stack CMS era to &#8220;content mesh&#8221; architecture.</p>\n<p>&#8220;Monolithic CMSs were invented in 90s — they’re now migrating to become specialized modular services,&#8221; Mathews said. Gatsby provides the presentation layer for this new architecture and its plugin layer connects out to multiple content sources.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Old world vs new world explained by <a href=\"https://twitter.com/kylemathews?ref_src=twsrc%5Etfw\">@kylemathews</a> shown in his diagram when explaining <a href=\"https://twitter.com/gatsbyjs?ref_src=twsrc%5Etfw\">@gatsbyjs</a> <a href=\"https://twitter.com/hashtag/GatsbyDaysLondon?src=hash&ref_src=twsrc%5Etfw\">#GatsbyDaysLondon</a> <a href=\"https://t.co/9EIxS6Sc3X\">pic.twitter.com/9EIxS6Sc3X</a></p>\n<p>&mdash; Ilesh Mistry (@ileshmistry) <a href=\"https://twitter.com/ileshmistry/status/1178598732000108544?ref_src=twsrc%5Etfw\">September 30, 2019</a></p></blockquote>\n<p></p>\n<p>An informal survey of attendees showed that roughly a 1/3 were experienced at working with Gatsby and the majority of those in the audience were newer users or simply curious to learn more. Although Gatsby is currently geared primarily towards developers, Mathews described how the project is working towards enabling people in other roles who also work on websites.</p>\n<p>&#8220;We&#8217;re thinking really hard about how we can help everyone who works on a website, not just developers,&#8221; Mathews said. &#8220;Right now, Gatsby is essentially for developers, but our goal isn&#8217;t to help developers per se. Our goal is to help amazing websites be created.</p>\n<p>&#8220;This matters because the world runs on websites. More and more essential services that everyone relies on are websites and web apps, and we want to help with that. Developers are a key part of building websites but the actual process of building a web property is an incredible cross functional job for an organization to take on.&#8221; This process often includes designers, content editors, marketing professionals, and others.</p>\n<p>Gatsby, Inc.&#8217;s first cloud service, <a href=\"https://www.gatsbyjs.com/preview\" rel=\"noopener noreferrer\" target=\"_blank\">CMS Preview</a>, was inspired by this goal of assisting non-developers who work on websites. It shows content authors immediate feedback when they change content, which the team found to be a common requirement in most editorial workflows.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/hashtag/GatsbyJS?src=hash&ref_src=twsrc%5Etfw\">#GatsbyJS</a> is great for <a href=\"https://twitter.com/hashtag/Drupal?src=hash&ref_src=twsrc%5Etfw\">#Drupal</a>. Our new <a href=\"https://twitter.com/hashtag/CMS?src=hash&ref_src=twsrc%5Etfw\">#CMS</a> Preview product makes preview lightning-fast! <img src=\"https://s.w.org/images/core/emoji/12.0.0-1/72x72/26a1.png\" alt=\"⚡\" class=\"wp-smiley\" /></p>\n<p>Thanks to all at <a href=\"https://twitter.com/hashtag/GatsbyDaysLondon?src=hash&ref_src=twsrc%5Etfw\">#GatsbyDaysLondon</a> who came to see \"Live preview with <a href=\"https://twitter.com/gatsbyjs?ref_src=twsrc%5Etfw\">@GatsbyJS</a> and <a href=\"https://twitter.com/hashtag/decoupled?src=hash&ref_src=twsrc%5Etfw\">#decoupled</a> <a href=\"https://twitter.com/drupal?ref_src=twsrc%5Etfw\">@Drupal</a>\"!</p>\n<p>Slides: <a href=\"https://t.co/tJ3A0dWlGV\">https://t.co/tJ3A0dWlGV</a><a href=\"https://twitter.com/hashtag/PHP?src=hash&ref_src=twsrc%5Etfw\">#PHP</a> <a href=\"https://twitter.com/hashtag/JavaScript?src=hash&ref_src=twsrc%5Etfw\">#JavaScript</a> <a href=\"https://twitter.com/hashtag/ReactJS?src=hash&ref_src=twsrc%5Etfw\">#ReactJS</a> <a href=\"https://twitter.com/hashtag/GatsbyDrupalPreview?src=hash&ref_src=twsrc%5Etfw\">#GatsbyDrupalPreview</a> <a href=\"https://t.co/k4UwJCp18m\">pic.twitter.com/k4UwJCp18m</a></p>\n<p>&mdash; Preston So @ #GatsbyDaysLondon <img src=\"https://s.w.org/images/core/emoji/12.0.0-1/72x72/1f1ec-1f1e7.png\" alt=\"🇬🇧\" class=\"wp-smiley\" /> (@prestonso) <a href=\"https://twitter.com/prestonso/status/1178617916637552641?ref_src=twsrc%5Etfw\">September 30, 2019</a></p></blockquote>\n<p></p>\n<p>Mathews also said that the project&#8217;s design system library, <a href=\"https://www.gatsbyjs.org/docs/theme-ui/\" rel=\"noopener noreferrer\" target=\"_blank\">Gatsby Theme UI</a>, is another aspect of site creation aimed at making it more friendly for designers.</p>\n<p>&#8220;The goal of this is that designers and other non-developers can build Gatsby sites without building any code,&#8221; he said.</p>\n<p>Mathews covered some technical updates to Gatsby core and how the company is growing its team. A recording of the live broadcast is <a href=\"https://youtu.be/kuyLCwAMCZo?t=941\" rel=\"noopener noreferrer\" target=\"_blank\">available on YouTube</a>.</p>\n<h3>WordPress Sessions at Gatsby Days London: How to Use WPGraphQL and ACF as a Content Source, and Building and Selling Gatsby + WordPress Sites</h3>\n<p>Gatsby Days London featured presentations on several WordPress-related topics. Alexandra Spalato spoke about <a href=\"https://slides.com/alexandraspalato/gatsby-with-wordpress-and-wpgraphql-2\" rel=\"noopener noreferrer\" target=\"_blank\">using WordPress as a source for Gatsby</a>, demonstrating how to use WPGraphQL and Advanced Custom Fields (ACF) in a WordPress installation that produces content for a Gatsby front-end.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">now on stage is <a href=\"https://twitter.com/alexadark?ref_src=twsrc%5Etfw\">@alexadark</a> showing us how to work with Gatsby &amp; WordPress!<a href=\"https://twitter.com/hashtag/GatsbyDayslondon?src=hash&ref_src=twsrc%5Etfw\">#GatsbyDayslondon</a> <a href=\"https://t.co/1xP2sPjPam\">pic.twitter.com/1xP2sPjPam</a></p>\n<p>&mdash; Horacio Herrera (@hhg2288) <a href=\"https://twitter.com/hhg2288/status/1178610525401423872?ref_src=twsrc%5Etfw\">September 30, 2019</a></p></blockquote>\n<p></p>\n<p>&#8220;The vibe at Gatsby days was fantastic, the beautiful Venue with round tables, the enthusiastic community where you can find people from WordPress, Drupal and others, all interested by Gatsby.&#8221; Spalato said.</p>\n<p>She found the event to provide a good balance between talks and networking, with unconference sessions devoted to WordPress, themes, Drupal, PWA, component libraries, migrating to Gatsby, and other topics.</p>\n<p>&#8220;For me it was fantastic to speak there, as Gatsby is the bridge between my two worlds &#8211; WordPress and JavaScript/React,&#8221; Spalato said. &#8220;It was my first real public talk and the feeling that people loved it and learned something is extremely rewarding, so I plan to do lot of more talks at WordCamps about Gatsby in the near future.&#8221;</p>\n<p>Horacio Herrera gave a presentation on building and selling Gatsby + WordPress sites. He shared the process he uses to sell Gatsby-powered projects to clients as high-performing websites. For a week leading up to his Gatsby pitch, Herrera uses <a href=\"https://speedcurve.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Speed Curve</a> to track a client&#8217;s website performance and then uses <a href=\"https://wpostats.com\" rel=\"noopener noreferrer\" target=\"_blank\">WPO stats</a> to demonstrate how performance improvements have helped competitors and industry leaders succeed.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/hhg2288?ref_src=twsrc%5Etfw\">@hhg2288</a>  next up <a href=\"https://twitter.com/hashtag/GatsbyDaysLondon?src=hash&ref_src=twsrc%5Etfw\">#GatsbyDaysLondon</a> building and selling <a href=\"https://twitter.com/gatsbyjs?ref_src=twsrc%5Etfw\">@gatsbyjs</a> and <a href=\"https://twitter.com/WordPress?ref_src=twsrc%5Etfw\">@WordPress</a> sites <a href=\"https://t.co/F2l4TsQ5ks\">pic.twitter.com/F2l4TsQ5ks</a></p>\n<p>&mdash; Ilesh Mistry (@ileshmistry) <a href=\"https://twitter.com/ileshmistry/status/1178681914074554369?ref_src=twsrc%5Etfw\">September 30, 2019</a></p></blockquote>\n<p></p>\n<p>The emerging Gatsby ecosystem is one to keep an eye on, as the project intensifies its focus on providing deeper integrations for popular CMS&#8217;s. How these related technologies intersect with WordPress will impact developers&#8217; expectations and choices for the architecture of their websites in the future.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Oct 2019 17:41:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Automattic Has Discontinued Active Development on Edit Flow Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94429\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://wptavern.com/automattic-has-discontinued-active-development-on-edit-flow-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4251:\"<p><a href=\"https://wordpress.org/plugins/edit-flow/\" rel=\"noopener noreferrer\" target=\"_blank\">Edit Flow</a>, the modular editorial plugin that enables collaboration inside the WordPress admin, is no longer being actively developed. After no updates for nine months, Mark Warbinek, a frustrated user, contacted Automattic to ask if they have abandoned the plugin or still plan to update it. A support representative from Automattic <a href=\"https://wordpress.org/support/topic/edit-flow-plugin-is-closed-no-longer-supported/\" rel=\"noopener noreferrer\" target=\"_blank\">confirmed</a> the company will no longer be updating Edit Flow:</p>\n<blockquote><p>At this time there is no active development of the Edit Flow Plugin.</p>\n<p>That being the case – two things I can suggest are:</p>\n<p>Submitting the issue to the Github repository for the plugin. This is used to track future development of the plugin and will be a canonical place for bugs or issues to be recorded.<br />\n<a href=\"https://github.com/Automattic/Edit-Flow\">https://github.com/Automattic/Edit-Flow</a></p>\n<p>It is possible to ‘fork’ the plugin and make the changes needed – or use an alternative that has already been forked like PublishPress:<br />\nhttps://github.com/Automattic/Edit-Flow</p></blockquote>\n<p>Edit Flow is active on more than 10,000 WordPress sites and its sporadic development has caused users to question whether it was abandoned several times over the years. It is still listed among the <a href=\"https://wpvip.com/plugins/edit-flow/\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress.com VIP plugins</a>, but will likely only be maintained for that platform going forward. <a href=\"https://github.com/Automattic/Edit-Flow/pull/499\" rel=\"noopener noreferrer\" target=\"_blank\">A 10-month old PR</a> was merged on its GitHub repository as recently as 19 days ago, after the contributor began to question whether the project was abandoned.</p>\n<p>In 2016, <a href=\"https://wptavern.com/hey-automattic-whats-going-on-with-edit-flow\" rel=\"noopener noreferrer\" target=\"_blank\">Edit Flow went two years in between updates</a>, leaving frustrated users in the dark. After that incident, a representative from Automattic <a href=\"https://wptavern.com/hey-automattic-whats-going-on-with-edit-flow#comment-164215\" rel=\"noopener noreferrer\" target=\"_blank\">said</a> the company was working on an internal effort to improve the maintenance of their own plugins in order to avoid a situation like this happening again. The company currently has 88 plugins listed in the official directory.</p>\n<p><a href=\"https://wordpress.org/plugins/publishpress/\" rel=\"noopener noreferrer\" target=\"_blank\">PublishPress</a> is the only alternative editorial plugin with comparable features, including an editorial calendar, notifications, editorial comments, custom statuses, and a content overview. It also offers <a href=\"https://publishpress.com/knowledge-base/migrate/\" rel=\"noopener noreferrer\" target=\"_blank\">seamless migration of Edit Flow data to PublishPress</a>. A commercial version of the plugin includes additional features, such as a publishing checklist, reminders, permissions, a WooCommerce checklist, and more.</p>\n<p>&#8220;I think I can speak for those users of this plugin that we are not happy with the horrible handling of this plugin, how Automattic has ignored and abandoned it, leaving users to suffer in the continuing fails this out-of-date plugin is causing,&#8221; Mark Warbinek <a href=\"https://wordpress.org/support/topic/edit-flow-plugin-is-closed-no-longer-supported/\" rel=\"noopener noreferrer\" target=\"_blank\">said</a> in response to to the reply from Automattic&#8217;s support team.</p>\n<p>Unfortunately, this is always a risk when using free plugins from WordPress.org, especially ones without a direct business model supporting development. In many instances the plugin author&#8217;s first priority will be maintaining it for the paying customers. In this case that is WordPress.com VIP clients. Automattic has not posted an announcement on Edit Flow&#8217;s support forums, but an official communication would go a long way towards steering users in the right direction when they inevitably come looking for signs of life in the plugin.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Oct 2019 03:31:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress.org blog: WordPress 5.3 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7262\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2993:\"<p>WordPress 5.3 Beta 2 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong> so we don’t recommend running it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>You can test the WordPress 5.3 beta in two ways:</p>\n\n\n\n<ul><li>Try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (choose the “bleeding edge nightlies” option)</li><li>Or <a href=\"https://wordpress.org/wordpress-5.3-beta2.zip\">download the beta here</a> (zip).</li></ul>\n\n\n\n<p>WordPress 5.3 is slated for release on <a href=\"https://make.wordpress.org/core/5-3/\">November 12, 2019</a>, and we need your help to get there. </p>\n\n\n\n<p>Thanks to the testing and feedback from everyone who tested <a href=\"https://wordpress.org/news/2019/09/wordpress-5-3-beta-1/\">beta 1</a>, over <a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=09%2F24%2F2019..&milestone=5.3&group=component&col=id&col=summary&col=owner&col=type&col=priority&col=component&col=version&order=priority\">45 tickets have been closed</a>&nbsp;since then. </p>\n\n\n\n<h2>Some highlights</h2>\n\n\n\n<ul><li>Work continues on the <strong>block editor</strong>.</li><li>Bugs fixed on<strong> Twenty Twenty</strong>.</li><li><strong>Accessibility</strong> bugs fixes and enhancements on the interface changes introduced with 5.3 beta 1:<ul><li>Iterate on the admin interface</li><li>Reduce potential backward compatibility issues</li><li>Improve consistency between admin screens and the block editor</li><li>Better text zoom management</li></ul></li><li>Support <code>rel=\"ugc\"</code> attribute value in comments (<a href=\"https://core.trac.wordpress.org/ticket/48022\">#48022</a>) &#8211; this particular ticket shows the WordPress project ability to integrate quick solutions to things that are changing unexpectedly – like Google new features.</li></ul>\n\n\n\n<h2>Developer notes</h2>\n\n\n\n<p>WordPress 5.3 has lots of refinements to polish the developer experience. To keep up, subscribe to the&nbsp;<a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a>&nbsp;and pay special attention to the&nbsp;<a href=\"https://make.wordpress.org/core/tag/5-3+dev-notes/\">developers notes</a>&nbsp;for updates on those and other changes that could affect your products.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev/\">Help us translate WordPress into more than 100 languages</a>!</p>\n\n\n\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a> where you can also find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.<br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 30 Sep 2019 21:43:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Francesca Marano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"BuddyPress: BuddyPress 5.0.0 “Le Gusto”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=308041\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://buddypress.org/2019/09/buddypress-5-0-0-le-gusto/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10760:\"<p>Here&#8217;s our latest major release featuring the <strong>BuddyPress REST API</strong> !!</p>\n\n\n\n<div class=\"wp-block-button aligncenter is-style-squared\"><a class=\"wp-block-button__link has-background\" href=\"https://downloads.wordpress.org/plugin/buddypress.5.0.0.zip\">Get BuddyPress 5.0.0</a></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p>We are very excited to announce the BuddyPress community the immediate availability of <strong>BuddyPress 5.0.0</strong> code-named &#8220;<strong>Le Gusto</strong>&#8220;. You can get it clicking on the above button, downloading it from our&nbsp;<a href=\"https://wordpress.org/plugins/buddypress/\">WordPress.org plugin repository</a> or checking it out from our <a href=\"https://buddypress.trac.wordpress.org/browser/branches/5.0\">subversion repository</a>.</p>\n\n\n\n<p><em>NB: if you&#8217;re upgrading from a previous version of BuddyPress, please make sure to back-up your WordPress database and files before proceeding.  </em></p>\n\n\n\n<p>You can view all the changes we made in 5.0.0 thanks to our <a href=\"https://codex.buddypress.org/releases/version-5-0-0/\">full release note</a>. Below are the key features we want to get your attention on.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div><span class=\"dashicons dashicons-rest-api\"></span></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>The BP REST API opens a new era for BuddyPress!</h2>\n\n\n\n<p>You can now enjoy&nbsp;REST&nbsp;API&nbsp;endpoints&nbsp;for&nbsp;members, groups, activities, private&nbsp;messages, screen notifications and extended profiles.</p>\n\n\n\n<p>BuddyPress endpoints provide machine-readable external access to your WordPress site with a clear, standards-driven interface, paving the way for new and innovative methods of interacting with your community through plugins, themes, apps, and beyond.</p>\n\n\n\n<p>The BP REST API opens great new opportunities to improve the way you play with the BuddyPress component features: we couldn&#8217;t resist to start building on top of it introducing&#8230; </p>\n\n\n\n<h3>A new interface for managing group members.</h3>\n\n\n\n<div class=\"wp-block-image\"><a href=\"https://buddypress.org/wp-content/uploads/1/2019/09/group-manage-members.png\"><img src=\"https://buddypress.org/wp-content/uploads/1/2019/09/group-manage-members.png\" alt=\"Screen Capture of the new Group Mange Members UI\" class=\"wp-image-308052\" /></a></div>\n\n\n\n<p>Group administrators will love our new interface for managing group membership. Whether you&#8217;re working as a group admin on the front-end Manage tab, or as the site admin on the Dashboard, the new REST API-based tools are faster, easier to use, and more consistent.</p>\n\n\n\n<h3>The BP REST API is fully documented</h3>\n\n\n\n<p>The development team worked hard on the features but also took the time to <a href=\"https://buddypress.org/2019/09/bp-devhub-1-0/\">write the documentation</a> about how to use it and how to extend it. BuddyPress developers, let&#8217;s start building great stuff for our end users: take a look at <a href=\"https://developer.buddypress.org/bp-rest-api/\">the BP REST API developer reference</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div><span class=\"dashicons dashicons-buddicons-groups\"></span></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Improved Group invites and membership requests</h2>\n\n\n\n<p>Thanks to the new BP Invitations API, Group invites and membership requests are now managed in a more consistent way. The BP Invitations API abstracts how these two actions are handled and allows developers to use them for any object on your site (e.g., Sites of a WordPress network).</p>\n\n\n\n<p>Read&nbsp;more&nbsp;about&nbsp;the&nbsp;<a href=\"https://bpdevel.wordpress.com/2019/09/16/new-invitations-api-coming-in-buddypress-5-0/\">BP&nbsp;Invitations&nbsp;API</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div><span class=\"dashicons dashicons-buddicons-forums\"></span></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Help our support volunteers help you.</h2>\n\n\n\n<p>Knowing your WordPress and BuddyPress configuration is very important when one of our beloved support volunteers tries to help you fix an issue. That&#8217;s why we added a BuddyPress section to the Site Health Info Administration screen.</p>\n\n\n\n<a href=\"https://buddypress.org/wp-content/uploads/1/2019/09/debug-buddypress.png\"><img src=\"https://buddypress.org/wp-content/uploads/1/2019/09/debug-buddypress.png\" alt=\"Screen capture of the BuddyPress section of the Site Health screen.\" class=\"wp-image-308058\" /></a>\n\n\n\n<p>The panel is displayed at the bottom of the screen. It includes the BuddyPress version, active components, active template pack, and a list of other component-specific settings information.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-columns has-2-columns\">\n<div class=\"wp-block-column\">\n<div><span class=\"dashicons dashicons-heart\"></span></div>\n</div>\n\n\n\n<div class=\"wp-block-column\">\n<div><span class=\"dashicons dashicons-wordpress-alt\"></span></div>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Improved integrations with WordPress</h2>\n\n\n\n<h3>BP Nouveau Template Pack</h3>\n\n\n\n<p>In BuddyPress 5.0.0, the BP Nouveau template pack looks better than ever with the Twenty Nineteen theme.</p>\n\n\n\n<div class=\"wp-block-image\"><a href=\"https://buddypress.org/wp-content/uploads/1/2019/09/edit-password.png\"><img src=\"https://buddypress.org/wp-content/uploads/1/2019/09/edit-password.png\" alt=\"\" class=\"wp-image-308069\" /></a></div>\n\n\n\n<p>Nouveau now uses the same password control as the one used in WordPress Core, for better consistency between BuddyPress and WordPress spaces.</p>\n\n\n\n<h3>BuddyPress Blocks now have their own category into the Block Editor.</h3>\n\n\n\n<div class=\"wp-block-image\"><a href=\"https://buddypress.org/wp-content/uploads/1/2019/09/bp-blocks.png\"><img src=\"https://buddypress.org/wp-content/uploads/1/2019/09/bp-blocks.png\" alt=\"\" class=\"wp-image-308070\" /></a></div>\n\n\n\n<p>Developers building tools for the Block Editor can now add their blocks to the BuddyPress category. This change provides a foundation for organizing custom BuddyPress blocks.</p>\n\n\n\n<p>Read more about this feature in this <a href=\"https://bpdevel.wordpress.com/2019/07/31/a-category-to-store-your-buddypress-blocks/\">development note</a>.</p>\n\n\n\n<div class=\"wp-block-image\"><a href=\"https://buddypress.org/2018/11/buddypress-4-0-0-pequod/#comment-44752\"><img src=\"https://buddypress.org/wp-content/uploads/1/2019/09/matt-comment.png\" alt=\"\" class=\"wp-image-308075\" /></a>Screen capture of the <a href=\"https://buddypress.org/2018/11/buddypress-4-0-0-pequod/#comment-44752\">comment</a> Matt made about BuddyPress 4.0.0</div>\n\n\n\n<p><em>PS: we know, just like Matt, you&#8217;re eager to enjoy high quality community blocks: now we have the BP REST API and this new Blocks category available in BuddyPress Core, get ready to be amazed for our next release. Fasten your seatbelts: BuddyPress blocks are arriving!</em></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-image\"><img src=\"https://buddypress.org/wp-content/uploads/1/2019/09/pizza.png\" alt=\"\" class=\"wp-image-308073\" /></div>\n\n\n\n<h2>BuddyPress Le Gusto</h2>\n\n\n\n<p>5.0.0 is code-named <strong>&#8220;Le Gusto&#8221;</strong> after the <a href=\"https://goo.gl/maps/tpvew6YSivZ5KX218\">well known Pizza restaurant</a> in Fortaleza, Brazil. It’s the perfect place to meet with friends and start tasting new flavors like <a class=\"bp-suggestions-mention\" href=\"https://buddypress.org/members/espellcaste/\" rel=\"nofollow\">@espellcaste</a>’s favorite one: the &#8220;Pizza de Camarão&#8221;. </p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div><span class=\"dashicons dashicons-buddicons-buddypress-logo\"></span></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Muito Obrigado</h2>\n\n\n\n<p>As usual, this BuddyPress release is only possible thanks to the contributions of the community. Special thanks to the following folks who contributed code and testing to the release: <a href=\"https://github.com/baconbro\">baconbro</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone B Gorges (boonebgorges)</a>, <a href=\"https://profiles.wordpress.org/joncadams/\">boop (joncadams)</a>, <a href=\"https://profiles.wordpress.org/sbrajesh/\">Brajesh Singh (sbrajesh)</a>, <a href=\"https://profiles.wordpress.org/dcavins/\">David Cavins (dcavins)</a>, <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Lewis (ericlewis)</a>, <a href=\"https://profiles.wordpress.org/geminorum/\">geminorum</a>, <a href=\"https://profiles.wordpress.org/gingerbooch/\">gingerbooch</a>, <a href=\"https://profiles.wordpress.org/ivinco/\">Ivinco</a>, <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock (whyisjake)</a>, <a href=\"https://profiles.wordpress.org/JarretC/\">Jarret (JarretC)</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby (johnjamesjacoby)</a>, <a href=\"https://profiles.wordpress.org/klawton/\">klawton</a>, <a href=\"https://profiles.wordpress.org/kristianngve/\">Kristian Yngve (kristianngve)</a>, <a href=\"https://profiles.wordpress.org/maniou/\">Maniou</a>, <a href=\"https://profiles.wordpress.org/netweblogic/\">Marcus (netweblogic)</a>, <a href=\"https://profiles.wordpress.org/imath/\">Mathieu Viet (imath)</a>, <a href=\"https://github.com/bhoot-biswas\">Mithun Biswas</a>, <a href=\"https://profiles.wordpress.org/modemlooper/\">modemlooper</a>, <a href=\"https://profiles.wordpress.org/DJPaul/\">Paul Gibbs (DJPaul)</a>, <a href=\"https://profiles.wordpress.org/r-a-y/\">r-a-y</a>, <a href=\"https://profiles.wordpress.org/razor90/\">razor90</a>, <a href=\"https://profiles.wordpress.org/espellcaste/\">Renato Alves (espellcaste)</a>, <a href=\"https://profiles.wordpress.org/slaFFik/\">Slava Abakumov (slaFFik)</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar (netweb)</a>, <a href=\"https://profiles.wordpress.org/truchot/\">truchot</a>, <a href=\"https://profiles.wordpress.org/venutius/\">Venutius</a>, <a href=\"https://profiles.wordpress.org/wegosi/\">wegosi</a>, and of course you for using BuddyPress <img src=\"https://s.w.org/images/core/emoji/12.0.0-1/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" /></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div><span class=\"dashicons dashicons-format-chat\"></span></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Feedbacks welcome!</h2>\n\n\n\n<p>Receiving your feedback and suggestions for future versions of BuddyPress genuinely motivates and encourages our contributors. Please share&nbsp;your&nbsp;feedback about this version of BuddyPress in the comments area of this post. And of course, if you&#8217;ve found a bug: please tell us about it into our <a href=\"https://buddypress.org/support/\">Support forums</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 30 Sep 2019 21:30:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"imath\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WPTavern: Preparing Themes For WordPress 5.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94401\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wptavern.com/preparing-themes-for-wordpress-5-3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5011:\"<p>Now that <a href=\"https://wptavern.com/wordpress-5-3-beta-1-ready-for-testing-includes-12-gutenberg-releases-and-new-twenty-nineteen-default-theme\">WordPress 5.3 Beta 1</a> is open for testing and with the official release slated for November 12, it&#8217;s time for theme authors to begin making sure their themes are ready for several changes.</p>\n\n\n\n<p>Most work will revolve around the block editor.  WordPress 5.3 will include versions 5.4 &#8211; 6.5 of the Gutenberg plugin, a total of 12 releases.  This makes for a lot of ground to cover.  The next release includes breaking changes.</p>\n\n\n\n<p>For themes without custom block styles, little should change.  However, theme authors who have been building custom block designs will likely have some work to do if they haven&#8217;t kept up with the changes in the Gutenberg plugin over the past several months.</p>\n\n\n\n<h2>Block Style Variations API Introduced</h2>\n\n\n\n<p>WordPress 5.3 introduces new <a href=\"https://make.wordpress.org/core/2019/09/24/new-block-apis-in-wordpress-5-3/\">server-side block style functions</a>.  This means that theme authors who prefer PHP can now register custom block style variations without writing JavaScript code.</p>\n\n\n\n<p>The block styles feature allows theme authors to register custom styles for individual blocks.  Then, they must apply custom CSS to these styles in the editor and the front end.</p>\n\n\n\n<p>The new functions are basic one-to-one matches to their JavaScript counterparts.  Block styles still need to be registered on a per-block basis.  Support for registering single styles to multiple blocks at once hasn&#8217;t landed in core.</p>\n\n\n\n<h2>New Block HTML Creates Breaking Changes</h2>\n\n\n\n<p>Despite WordPress&#8217; commitment to backward compatibility over the years, the Gutenberg team hasn&#8217;t maintained that approach with blocks.  Block HTML output in the editor and the front end has changed for some blocks.  These changes will break custom theme styles in many cases.</p>\n\n\n\n<p>The following blocks have potential breaking changes for themes:</p>\n\n\n\n<ul><li><strong>Group:</strong> A new inner container element was added to the markup.</li><li><strong>Table:</strong> A wrapper element was added and the block class moved to the wrapper.</li><li><strong>Gallery:</strong> Like the table block, it received the same wrapper element treatment. Galleries also support a caption for the entire gallery block.</li></ul>\n\n\n\n<p>In my tests, the gallery block had the most obvious breaking changes. Depending on how it is styled, users could be looking at a single column of images instead of their selected number.  The core development blog has a <a href=\"https://make.wordpress.org/core/2019/09/27/block-editor-theme-related-updates-in-wordpress-5-3/\">complete overview of the HTML changes</a> along with code examples for addressing issues.</p>\n\n\n\n<p>It&#8217;d be interesting to see if the Gutenberg team makes similar HTML changes with other blocks in the future. Such changes make it tough for theme authors to maintain support between versions of WordPress and versions of the Gutenberg plugin.  It also bloats CSS code when attempting to maintain compatibility.  Adding an extra element doesn&#8217;t typically break things.  However, moving an element&#8217;s class to another element is a dumpster fire waiting to happen.  If these types of changes continue to happen, it could turn some theme authors away from supporting the block editor at a time when core needs to be encouraging more authors to design around it.</p>\n\n\n\n<h2>New Block Classes Added</h2>\n\n\n\n<p>Several <a href=\"https://make.wordpress.org/core/2019/09/27/block-editor-theme-related-updates-in-wordpress-5-3/\">new CSS classes</a> are making their way into 5.3.  For themes that remove core block styles on the front end, they need to add support for the classes to their theme&#8217;s stylesheet.</p>\n\n\n\n<p>WordPress is doing away with inline styles for left, right, and center text alignment. This is a welcome change because it moves CSS to its appropriate place, which is in a stylesheet.  Theme authors need to make sure they support these new classes for the following blocks.</p>\n\n\n\n<ul><li>Heading</li><li>Paragraph</li><li>Quote</li><li>Verse</li></ul>\n\n\n\n<p>The columns block no longer supports column-specific class names.  Version 5.3 supports custom column widths, which are handled with inline styles.  It&#8217;s unlikely this will break most themes, but it&#8217;s worth testing.</p>\n\n\n\n<p>The separator block now supports custom colors.  It is given both the text and background color class names on the front end.  This allows theme authors to utilize the styling method they prefer.  Ideally, a border color class would exist, but the block editor does not yet support selecting a custom border color.  </p>\n\n\n\n<p>Quick developer tip: if your theme uses a border color for the separator block, use <a href=\"https://css-tricks.com/currentcolor/\">currentColor</a> to handle custom colors.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 30 Sep 2019 16:45:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WPTavern: Secure the News Project Finds 93% of Major Publishers Offer HTTPS Encryption by Default\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94365\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://wptavern.com/secure-the-news-project-finds-93-of-major-publishers-offer-https-encryption-by-default\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4469:\"<p><a href=\"https://securethe.news\" rel=\"noopener noreferrer\" target=\"_blank\">Secure the News</a> is a project that was created by the <a href=\"https://freedom.press/\" rel=\"noopener noreferrer\" target=\"_blank\">Freedom of the Press Foundation</a> in 2016 to track HTTPS encryption across major news organizations&#8217; websites. It lists the publications and automatically scores them on a scale of 0-100, based on HTTPS implementation according to <a href=\"https://securethe.news/methodology-and-metrics/\" rel=\"noopener noreferrer\" target=\"_blank\">best practices</a>, as defined by General Services Administration (GSA) Pulse’s current criteria for modern and secure HTTPS deployment. The score is converted to an A-F letter grade.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2019/09/Screen-Shot-2019-09-27-at-4.29.56-PM.png?ssl=1\"><img /></a></p>\n<p>The primary benefits of news organizations adopting HTTPS include reader privacy and website security, but there are also other positive byproducts, such as protecting sources and preventing censorship. Secure the News provides some interesting data in its campaign to encourage more broad HTTPS adoption.</p>\n<p>In 2018, after one year of collecting data on HTTPS encryption at more than 130 major world news sites, the project found that HTTPS was available on 2/3 of the sites it monitors (89 of 131), up from 1/3 in 2016. Approximately <a href=\"https://securethe.news/blog/how-secure-are-news-sites-report-first-year-secure-news/\" rel=\"noopener noreferrer\" target=\"_blank\">60% of news organizations offered HTTPS encryption by default in 2018</a> and that number is up to 93% today.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2019/09/Screen-Shot-2019-09-27-at-5.40.27-PM.png?ssl=1\"><img /></a></p>\n<p>Most of the WordPress-powered major news sites, such as <a href=\"https://arstechnica.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Ars Technica</a>, <a href=\"https://time.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Time</a> and the <a href=\"https://nypost.com/\" rel=\"noopener noreferrer\" target=\"_blank\">New York Post</a>, get a B ranking, with the exception of <a href=\"https://techcrunch.com\" rel=\"noopener noreferrer\" target=\"_blank\">TechCrunch</a> and <a href=\"https://qz.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Quartz</a>, which both scored an A.</p>\n<p>The most recent addition to the project is the ability to <a href=\"https://securethe.news/blog/introducing-regional-leaderboards-secure-news/\" rel=\"noopener noreferrer\" target=\"_blank\">sort publications by region on the homepage</a>. Publications based in North America and Europe lead the world in having the most secure HTTPS implementations. Asia has a smaller percentage of major news sites with a score of A- or higher. Some smaller regions, such as the Middle East and North Africa, Oceana, and South America, list just a handful of news organizations but they all have a score of B or higher. Secure the News is just getting started with this feature and is accepting feedback on the project&#8217;s GitHub account.</p>\n<p>In addition to promoting HTTPS adoption, the team behind Secure the News is also considering broadening its coverage to measure other ways that news sites are delivering secure content, such as whether the site has an <a href=\"https://en.wikipedia.org/wiki/.onion\" rel=\"noopener noreferrer\" target=\"_blank\">onion service</a>, is <a href=\"https://www.torproject.org/\" rel=\"noopener noreferrer\" target=\"_blank\">Tor project</a> friendly, or has a <a href=\"https://freedom.press/training/blog/first-time-they-reach-out-protect-sources-themselves/\" rel=\"noopener noreferrer\" target=\"_blank\">confidential tip line</a>. The project also has more news sites to add and a long list of improvements they want to make to the <a href=\"https://securethe.news/methodology-and-metrics/\" rel=\"noopener noreferrer\" target=\"_blank\">metrics used to rank sites</a>.</p>\n<p>The code for <a href=\"https://securethe.news/blog/secure-news-open-source/\" rel=\"noopener noreferrer\" target=\"_blank\">Secure the News is open source</a> (licensed under the GNU AGPL) and <a href=\"https://github.com/freedomofpress/securethenews\" rel=\"noopener noreferrer\" target=\"_blank\">available on GitHub</a> for anyone who wants to contribute or fork it for use with other site categories where browsing might be sensitive, such as libraries, adult sites, educational institutes, or medical facilities.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Sep 2019 23:58:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: Rebirth of Creativity: Gutenberg and the Future of WordPress Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94231\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://wptavern.com/rebirth-of-creativity-gutenberg-and-the-future-of-wordpress-themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10060:\"<p>I began using WordPress in 2005.  I&#8217;d already been learning HTML and CSS for a couple of years.  I even had a home-brewed blog that pulled posts from plain text files at one point.  I knew enough JavaScript to do pop-up alerts and other annoying things that served no purpose and made for a poor user experience, even if they were fun for me.</p>\n\n\n\n<p>This was my second attempt at using WordPress.  This time it was after a botched go of making PHP Nuke behave how I wanted.  I had big dreams for my website but lacked the coding skills to make them happen.  WordPress was simple enough to hack for a novice like me at the time.  Sure, I broke my site more times than I could count, but I managed to put together my first real theme.</p>\n\n\n\n<p>I popped open Photoshop; grabbed a few images from <em>Angel</em>, my favorite TV show at the time; and began my work.  I&#8217;d recently watched <em>Soul Purpose</em>, an episode that explored whether the titular character was truly the hero mentioned in an ancient prophecy.  It was foretold that the vampire with a soul would shed his demon half and live as a human.  It explored themes of the character&#8217;s place in the world.  At 21 years old, it&#8217;s the sort of episode that resonated with a young man who was also looking for his place.  I thought it fitting to work that into my theme&#8217;s design and began hacking away at a header for my theme.</p>\n\n\n\n<div class=\"wp-block-image\"><img />Screenshot of my first WordPress theme header.</div>\n\n\n\n<p>At that time, there was this loosely-connected underground of themers and hobbyists who were building WordPress themes based on their favorite TV series, movies, comic books, and more.  That was my first real introduction to WordPress.  These people were not building themes for profit.  They were searching for their place in this small corner of the internet.  At most, some were looking for validation from like-minded people who might enjoy their art.  It was about creation for the sake of creation.  Anyone could be an artist with a simple lesson in CSS, an image manipulation program, and enough grit to pour their soul into the project for a few hours.</p>\n\n\n\n<p>If there were ever a time that WordPress themes died, it was when the hobbyists who built for pure passion were overshadowed by business interests.</p>\n\n\n\n<p>Don&#8217;t get me wrong; business interests played a crucial role in propelling WordPress to become the most dominant CMS in the world.  However, the balance has clearly shifted in favor of building WordPress themes for business and ecommerce rather than for the enthusiasts who just want to create.  Other platforms have better catered to these users and filled in the gaps left open by WordPress.  Tumblr became a safe-haven for popular culture fans.  DeviantArt a home for artists.  Wattpad for aspiring writers and fanfic lovers.</p>\n\n\n\n<p>Somewhere along the way, we lost the innocence and artistry of building WordPress themes for the pure fun of it.  WordPress grew up and WordPress themes along with it.</p>\n\n\n\n<h2>Today&#8217;s Themes Are Not Tomorrow&#8217;s</h2>\n\n\n\n<p>In his post, <a href=\"https://www.binarymoon.co.uk/2019/09/the-end-of-wordpress-themes-is-in-sight/\">The End of WordPress Themes is in Sight</a>, Ben Gillbanks said, &#8220;Themes as we know them will no longer be made.&#8221;  It is a bleak look at the future of WordPress theming.  He notes that he doesn&#8217;t believe that he&#8217;ll be able to make a living building WordPress themes in the next couple of years.</p>\n\n\n\n<p>His worries are warranted.  They have been shared by several theme authors over the past couple of years as the block editor (Gutenberg) was making its way into core WordPress.  The official theme review team has discussed the team&#8217;s future role surrounding the coming changes.</p>\n\n\n\n<p>Gillbanks&#8217; post comes on the heels of a post written by Matias Ventura on <a href=\"https://make.wordpress.org/core/2019/09/05/defining-content-block-areas/\">defining content block areas</a>.  Essentially, the idea is for WordPress to allow users to edit areas outside of the post content via the block editor.  Anything from the header, footer, sidebar, or otherwise would likely be fair game.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>In such a system, themes would be relegated to defining block areas, providing base styles, and designing block output.  In many ways, this is what WordPress themes <em>should</em> be.  Some might say that WordPress is putting themes back into their proper place of simply styling content.  With the behemoth themes with hundreds or thousands of features we&#8217;ve seen over the past few years, this could be a welcome change.  </p>\n\n\n\n<p>There&#8217;s huge potential for designers to step up and make their mark.  I, for one, wouldn&#8217;t mind seeing CSS artists unleashed in the WordPress theme ecosystem.</p>\n\n\n\n<p>Gillbanks went on to say:</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>There are definite benefits to doing this from a user&#8217;s perspective – they will have full control of their site – but it&#8217;s going to result in some very boring website layouts.</p></blockquote>\n\n\n\n<p>This is the point where I&#8217;ll respectfully disagree.  Putting control in the hands of non-designers will be anything but boring.</p>\n\n\n\n<p><em>Do we all so easily forget the days of GeoCities?</em>  The websites built from it may have been horribly inaccessible.  They may have blared midi files as soon as you opened a webpage.  They may have even had a flashing, scrolling marquee zipping across the header.  Boring is not the word I&#8217;d use to describe them.</p>\n\n\n\n<p>As much as many of us want to put those days behind us (Come on, you had one of those sites at one point, right? Tell the truth.), there was something fascinating about it all.  Real people built these sites because they were fun.  The sites told you something about that person.  It was a deeply personal look into this stranger&#8217;s world.  Sometimes it was just a bunch of junk spewed onto the screen, but most sites were a reflection of the site owners at that point in time.</p>\n\n\n\n<p>It was ugly and beautiful all the same.</p>\n\n\n\n<p>Web developers and designers joke about those dark days of the web.  It&#8217;s easy to look back at sites from the &#8217;90s and cringe at the silliness (It makes you wonder what designers of 2050 will think about today&#8217;s designs, doesn&#8217;t it?).  I choose to look fondly upon those days.  It was a time before I became a &#8220;designer&#8221; with rules to follow.</p>\n\n\n\n<p>But, here&#8217;s the important point.  We are not the arbiters of the web.  It&#8217;s all about the user.  If someone wants a blinking Justin Bieber GIF in their site header, more power to them.  It&#8217;s the developer&#8217;s job to enable the user to do this in an easy-to-configure way.</p>\n\n\n\n<p><em>Wait?  So Geocities is your argument for full-site editing in WordPress?</em></p>\n\n\n\n<p>Understanding why WordPress should become a full-site editor means understanding the average user.  Developers are more apt to view things in a structured manner.  I spent over a decade honing my development skills.  Logic and order are old friends.  </p>\n\n\n\n<p>With end-users, things may seem a bit more chaotic.  A teenager might want to plaster a picture of her favorite band anywhere she wants on her site.  A soccer mom might want to show her kid slamming home the winning goal.  A poet may want to showcase one of his poems as a background image on his blog.  Humans are creative beings.  While our unique brand of artistry might not appeal to others, it&#8217;s still something we crave to share.</p>\n\n\n\n<p>It&#8217;s also important to understand that building WordPress themes is nowhere near as simple in 2019 as it was in 2005 when I started hacking away.  The code is much more complex.  It&#8217;s not quite as easy for a new user to piece together something fun as it once was.  Unless you have a theme or plugin that allows you to do this with simple drag-and-drop or similar tools, users have little control over their own sites.  And, that&#8217;s why the Gutenberg project is so revolutionary.  Its mission is to put the power back in the hands of the people.</p>\n\n\n\n<p>Theme authors need to evolve.  They will need to find a way to balance good design principles with the insane amount of freedom users will have.  There&#8217;s nothing stopping designers from making sure the Bieber screengrab looks more presentable.</p>\n\n\n\n<h2>Are WordPress Themes Dead?</h2>\n\n\n\n<p>No.  But, the theme landscape will certainly change and not for the first time.  We need not look at that as a bad thing.</p>\n\n\n\n<p>Those hobbyists who like to tinker with their site, they will once again have power that was so long ago lost to more advanced code.</p>\n\n\n\n<p>There will also be sub-communities within the WordPress landscape.  Some people will want something more akin to classic WordPress.  Others will want a simple blog handled with Markdown (side note: I&#8217;m one of those people, and Gutenberg actually handles pasting from Markdown well).  Plugins will be built to cater to every user&#8217;s needs.  Themes will exist for different types of users.  Client builds and enterprise solutions that look nothing like core WordPress aren&#8217;t going anywhere.</p>\n\n\n\n<p>There&#8217;s still a long road ahead.  Theme authors need to be more involved with the development of Gutenberg as these features make their way into the plugin and eventually into WordPress.  Otherwise, they&#8217;ll risk losing the opportunity to help shape the future theme landscape.</p>\n\n\n\n<p>Truth be told, I&#8217;m not sure what themes will look like in a few years.  I have a horrible track record with predictions.  However, I think it&#8217;s safe to say that there&#8217;ll be a place for designers.</p>\n\n\n\n<p>I&#8217;m excited because I feel like it will bring back the potential for users to have the control they once had and more.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Sep 2019 18:56:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: Rich Reviews Plugin Discontinued after Vulnerabilities Exploited in the Wild\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94302\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wptavern.com/rich-reviews-plugin-discontinued-after-vulnerabilities-exploited-in-the-wild\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3397:\"<p>After <a href=\"https://www.wordfence.com/blog/2019/09/rich-reviews-plugin-vulnerability-exploited-in-the-wild/\" rel=\"noopener noreferrer\" target=\"_blank\">tracking exploits of a zero day XSS vulnerability</a> in the <a href=\"https://wordpress.org/plugins/rich-reviews/\" rel=\"noopener noreferrer\" target=\"_blank\">Rich Reviews plugin</a> for WordPress, Wordfence is recommending that users remove it from their websites. The company estimates that there are 16,000 active installations vulnerable to unauthenticated plugin option updates:</p>\n<blockquote><p>Attackers are currently abusing this exploit chain to inject malvertising code into target websites. The malvertising code creates redirects and popup ads. Our team has been tracking this attack campaign since April of this year. </p></blockquote>\n<p>Rich Reviews was removed from the WordPress.org Plugin Directory on March 11, 2019, due to a security issue.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2019/09/Screen-Shot-2019-09-27-at-10.38.09-AM.png?ssl=1\"><img /></a></p>\n<p>One week ago, a Rich Reviews plugin user reported 3 out of 4 of her sites using the plugin were infected with redirect scripts and that removing the plugin fixed the issue. A digital marketing agency called Nuanced Media, the author of the plugin, <a href=\"https://wordpress.org/support/topic/plugin-not-supported-open-to-malware-uninstall-now/#post-11953681\" rel=\"noopener noreferrer\" target=\"_blank\">responded</a> to the post indicating that a new version would be released within two weeks:</p>\n<blockquote><p>We’ve been working on an overall rewrite of this plugin for a while now, but someone out there apparently wanted us to work faster on it, and decided to exploit our plugin to get some malware out there. We’re now going double-quick on it, and hope to have it back up (and newly cozy and secure) within the next two weeks.</p></blockquote>\n<p>Oddly, there seemed to be no rush to patch the issue that is currently being exploited. Yesterday, less than a week after assuring users that a new version is coming, the company behind the plugin announced that it is <a href=\"https://nuancedmedia.com/wordpress-rich-reviews-plugin/\" rel=\"noopener noreferrer\" target=\"_blank\">discontinuing active support and development on Rich Reviews</a>.</p>\n<p>Nuanced Media CEO Ryan Flannagan cited Google&#8217;s recent changes to its <a href=\"https://developers.google.com/search/docs/data-types/review-snippet#local-business-reviews\" rel=\"noopener noreferrer\" target=\"_blank\">business review guidelines</a> as the reason for discontinuing its development.</p>\n<p>&#8220;As part of this update, in the organic search results, Google has decided to remove all merchant review star ratings that businesses display on their own URL,&#8221; Flannagan said.</p>\n<p>&#8220;Based on this information, we have discontinued all active development and support on Rich  Reviews. We apologize for any inconvenience.&#8221;</p>\n<p>The announcement does not include any information about the vulnerability or the recent exploits. Users should assume that no patch is coming to the plugin, since it has been officially discontinued. It&#8217;s already not available to potential new users on WordPress.org, but those who have Rich Reviews active on their sites should deactivate it and remove the plugin as soon as possible to avoid getting hacked.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Sep 2019 18:25:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: Gatsby Raises $15M, Plans to Invest More Heavily in WordPress and CMS Integrations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94300\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://wptavern.com/gatsby-raises-15m-plans-to-invest-more-heavily-in-wordpress-and-cms-integrations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5857:\"<p><a href=\"https://www.gatsbyjs.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Gatsby Inc</a>. CEO Kyle Mathews announced a <a href=\"https://www.gatsbyjs.org/blog/2019-09-26-announcing-gatsby-15m-series-a-funding-round/\" rel=\"noopener noreferrer\" target=\"_blank\">$15M Series A funding round</a> today, just one year after creating the company with GatsbyJS core contributors. The open source Gatsby project started in 2015 to provide a framework for developers to quickly build websites with React. As the project soared in popularity, Mathews formed a company to fund its ongoing development and further invest in the growing Gatsby ecosystem of products.</p>\n<p>This round of funding will enable Gatsby to grow its 35-person team while investing in open source and cloud services that complement the company&#8217;s products.</p>\n<p>&#8220;With Gatsby, we’re striving to create a business model that will drive many millions of dollars of investment in open-source tools and enable people to build the next generation of web experiences,&#8221; Mathews said.</p>\n<p>At the forefront of the company&#8217;s vision is the idea of &#8220;reinventing website development.&#8221; Gatsby has popularized the concept of a “<a href=\"https://www.gatsbyjs.org/blog/2018-10-04-journey-to-the-content-mesh/\" rel=\"noopener noreferrer\" target=\"_blank\">content mesh</a>,” a platform that provides the infrastructure layer for a decoupled website and reimagines the role of a CMS within this architecture.</p>\n<p>Gatsby&#8217;s goal of creating more integrations for CMS&#8217;s was a big part of Mathews&#8217; funding announcement. Instead of writing off LAMP stack architecture as slow and obsolete, Gatsby is creating bridges to the CMS&#8217;s that power a large portion of the web:</p>\n<blockquote><p>Instead of a monolithic CMS powering everything, Gatsby ties together specialized services with a modern development experience and optimized website delivery.</p>\n<p>This content mesh empowers developers while preserving content creators’ workflows. It gives developers access to great cloud services without the pain of manual integration.</p>\n<p>Web developers from dozens of web CMS communities like WordPress and Drupal are going “headless” and using Gatsby as the presentation layer for their CMS.</p>\n<p>We’re forming partnerships with these communities to create seamless integrations between their solutions and Gatsby.</p></blockquote>\n<p>Gatsby will be using some of its funding to invest more heavily in the WordPress ecosystem. The company hired <a href=\"https://wptavern.com/jason-bahl-joins-the-gatsby-team-to-work-on-wpgraphql-full-time\" rel=\"noopener noreferrer\" target=\"_blank\">hiring Jason Bahl</a>, creator of the GraphQL for WordPress project, in June, and plans to add more WordPress developers.</p>\n<p>&#8220;We recently hired someone else to work alongside Jason in developing WPGraphQL (announcement coming soon!) and are currently hiring for several roles on the team,&#8221; Mathews told the Tavern.</p>\n<p>WordPress powers <a href=\"https://w3techs.com/technologies/details/cm-wordpress/all/all\" rel=\"noopener noreferrer\" target=\"_blank\">34.6% of the top 10 million websites</a> and Matt Mullenweg has previously estimated its ecosystem to be a $10 billion industry. The CMS is <a href=\"https://joost.blog/cms-market-share-a-numbers-analysis/\" rel=\"noopener noreferrer\" target=\"_blank\">showing no signs of decline</a>, and is a market that Gatsby product developers are strategically targeting.</p>\n<p>WordPress adopted React as its JavaScript framework in 2017, and built its new Gutenberg editor on top of it. Although some early adopters began digging deeper into React and creating their own products with it, the majority of PHP developers have been slow to move in that direction. Gatsby provides a bridge for those who are just getting started.</p>\n<p>&#8220;We think that for many web developers, a Gatsby project may be the first time they are using React, GraphQL, webpack or even Node.js,&#8221; Mathews said. &#8220;And that’s not just the case for WordPress developers &#8211; the same can be true for professionals in the Drupal, Rails, or .NET ecosystems.</p>\n<p>&#8220;It’s our goal to make a framework that empowers developers to use these technologies easily, then dive deeper as they gain more experience. So, instead of taking days to configure webpack for the first time, you can use a Gatsby Theme that connects to WordPress as a data source, and automatically get a blazing fast site. Later, you can learn the innards of the system, and begin customizing Gatsby yourself.&#8221;</p>\n<p>While Gatsby as a framework enables developers to bypass a lot of the technical and tooling jargon that has made modern development so complex, it is still a framework geared almost exclusively towards developers. Mathews said the company&#8217;s vision will continue to focus on enabling developers, not on creating solutions to make Gatsby more accessible to the non-technical crowd.</p>\n<p>&#8220;We are focused on making Gatsby the best choice for WordPress developers who want a flexible and powerful presentation layer for their headless WordPress sites,&#8221; he said. &#8220;Non-technical team members or clients will still use WordPress to create and manage content, while the web developers on their team or at the agency they hired get to be productive using the best development tools available.&#8221;</p>\n<p>Gatsby plans to use the funding to invest $3 million per year in open source, including the core Gatsby project, official plugins, and more learning materials. The funding is also good news for the future of the <a href=\"https://www.wpgraphql.com/\" rel=\"noopener noreferrer\" target=\"_blank\">WPGraphQL</a> project, which should see deeper integration with Gatsby in the near future.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Sep 2019 22:35:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: Long-Needed Date/Time Improvements Land in Core\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=94295\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/long-needed-date-time-improvements-land-in-core\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4026:\"<div class=\"wp-block-image\"><img /></div>\n\n\n\n<p>After more than a year and several WordPress updates, an <a href=\"https://make.wordpress.org/core/2019/09/23/date-time-improvements-wp-5-3/\">overhaul of the core Date/Time component</a> concluded.  WordPress 5.3 will ship with fixes for long-standing bugs and new API functions.</p>\n\n\n\n<p>Andrey &#8220;Rarst&#8221; Savchenko spearheaded this project and worked through most of the issues in his <a href=\"https://github.com/Rarst/wp-date\">WP Date</a> fork of WordPress.  Much of his work toward addressing the problems with this core component goes back further with the initialization of his <a href=\"https://github.com/Rarst/wpdatetime\">WPDateTime project</a>.</p>\n\n\n\n<p>Diving into the Date/Time component is no small feat.  Addressing one issue leads to another.  It&#8217;s a rabbit hole that few in the community have navigated.  Many developers were also unaware of the issues.  However, the bugs lingered for years, and users had no working solution for the problems they were facing.</p>\n\n\n\n<p>The most common errors were caused by core bugs or developer errors due to compatibility issues, described Savchenko.  This would cause user-facing issues such as post scheduling and other time-based operations.</p>\n\n\n\n<p>With the release of WordPress 5.3, all existing functions should behave more reliably.  Developers working on the component fixed several bugs and updated incorrect inline code documentation for many core functions. Along with the fixes, 5.3 will ship with new <a href=\"https://github.com/Rarst/wp-date/issues/4\">Date/Time API functions</a>.  The updated API includes unified time zone retrieval, localization, and PHP interoperability functions.</p>\n\n\n\n<p>Savchenko called it &#8220;the slow descent into madness&#8221; when asked of the catalyst for diving into the Date/Time component and its underlying issues.  &#8220;I started to notice serious bugs in the component from WordPress Stack Exchange questions about them, and the more I looked over years the more clear the dire state of it became to me.&#8221;</p>\n\n\n\n<p>One of the major problems is the way WordPress handles timestamps.  &#8220;I actually had to invent the &#8216;WordPress timestamp&#8217; term,&#8221; said Savchenko.  &#8220;There was no name for it in core development and inline documentation incorrectly called these Unix timestamps before.&#8221;  WordPress adds a time zone offset to the real Unix timestamp, which causes issues with upstream PHP and external systems.  </p>\n\n\n\n<p>WordPress timestamps couldn&#8217;t be removed from core without breaking backward compatibility.  Plugin and theme developers should avoid working with the WordPress timestamp and opt to use the <a href=\"https://make.wordpress.org/core/2019/09/23/date-time-improvements-wp-5-3/\">recommended methods</a> outlined in Savchenko&#8217;s post.</p>\n\n\n\n<p>WordPress date functions were originally written in PHP 4, a version of PHP so long-dead that it&#8217;s almost not worth digging up the end-of-life date (it&#8217;s <a href=\"https://www.php.net/eol.php\">11 years</a>, by the way).  PHP 5.2 introduced the PHP <code>DateTime</code> and <code>DateTimeZone</code> classes and has continued receiving improvements over the years.  WordPress date functions were never updated to utilize newer standards.  The platform&#8217;s more recent bump to a minimum of PHP 5.6 also meant that the <code>DateTimeImmutable</code> class introduced in PHP 5.5 would be available.  The version bump helped land the new API functions in WordPress 5.3.</p>\n\n\n\n<p>Some bugs go as far back as 7 years, such as <a href=\"https://core.trac.wordpress.org/ticket/20973\">shorthand formats not working with the core date_i18n() function</a>, which was fixed in WordPress 5.1.  With any luck, core may also adopt such features as <a href=\"https://core.trac.wordpress.org/ticket/18146\">user-based timezones</a> in the future, which would better handle time differences on WordPress installs with users all over the world.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Sep 2019 16:33:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Gary: Talking with WP&amp;UP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"https://pento.net/?p=5120\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://pento.net/2019/09/26/talking-with-wpup/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"<p>At WordCamp Europe this year, I had the opportunity to chat with the folks at WP&amp;UP, who are doing wonderful work providing mental health support in the WordPress community.</p>\n\n\n\n<p><a href=\"https://wpandup.org/podcast/getting-to-the-core-of-wordpress-021/\">Listen to the podcast</a>, and check out the services that WP&amp;UP provide!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Sep 2019 04:35:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Gary\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 23 Oct 2019 09:53:54 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Wed, 23 Oct 2019 09:30:09 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 1\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20190827113608\";}", "no");
INSERT INTO `wp_options` VALUES("2819", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1571867634", "no");
INSERT INTO `wp_options` VALUES("2820", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1571824434", "no");
INSERT INTO `wp_options` VALUES("2821", "_transient_timeout_dash_v2_6a99407fb8af46de90ed98bf9677a010", "1571867634", "no");
INSERT INTO `wp_options` VALUES("2822", "_transient_dash_v2_6a99407fb8af46de90ed98bf9677a010", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2019/10/wordpress-5-3-rc2/\'>WordPress 5.3 RC2</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2019/10/wordpress-5-3-rc2/\'>WordPress.org blog: WordPress 5.3 RC2</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/gutenberg-6-7-introduces-storybook-and-gradient-backgrounds\'>WPTavern: Gutenberg 6.7 Introduces Storybook and Gradient Backgrounds</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/coming-in-wordpress-5-3-what-is-the-php-spread-operator\'>WPTavern: Coming in WordPress 5.3: What is the PHP Spread Operator?</a></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("2823", "_site_transient_timeout_available_translations", "1571835250", "no");
INSERT INTO `wp_options` VALUES("2824", "_site_transient_available_translations", "a:118:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:5:\"5.0.7\";s:7:\"updated\";s:19:\"2019-05-16 12:52:45\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.0.7/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-22 22:33:28\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:5:\"4.7.7\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.7/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-22 18:59:07\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.12\";s:7:\"updated\";s:19:\"2019-05-14 14:59:20\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.12/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"5.2.3\";s:7:\"updated\";s:19:\"2019-09-10 16:44:41\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.3/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.8.6\";s:7:\"updated\";s:19:\"2017-10-01 12:57:10\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.8.6/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-21 07:55:00\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"མུ་མཐུད།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-04 16:59:04\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-20 06:18:47\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 13:20:27\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-22 10:34:50\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-07-08 20:19:38\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 15:09:43\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-15 07:07:34\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-06-22 14:40:13\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-15 07:08:52\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/5.2.4/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 15:10:06\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/5.2.4/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-23 08:44:15\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-20 22:32:55\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 14:36:29\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-20 22:33:08\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"5.1.3\";s:7:\"updated\";s:19:\"2019-06-06 15:48:01\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.1.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-20 00:26:02\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"5.2.3\";s:7:\"updated\";s:19:\"2019-06-20 20:46:03\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.3/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 23:07:29\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-07-22 16:47:50\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-11 06:22:41\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:3:\"5.1\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.1/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"5.0.7\";s:7:\"updated\";s:19:\"2018-12-07 18:38:30\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.0.7/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-06 21:26:01\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:6:\"4.9.12\";s:7:\"updated\";s:19:\"2019-05-23 02:23:28\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.12/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-09 09:36:22\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 15:11:33\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:9:\"5.0-beta3\";s:7:\"updated\";s:19:\"2018-11-28 16:04:33\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.0-beta3/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.9.2\";s:7:\"updated\";s:19:\"2017-12-09 21:12:23\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.9.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"5.2.3\";s:7:\"updated\";s:19:\"2019-08-13 21:31:06\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.3/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-22 14:09:21\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-20 19:33:33\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-20 17:54:04\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-01-31 11:16:06\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:5:\"4.8.6\";s:7:\"updated\";s:19:\"2018-01-29 17:32:35\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.6/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 22:06:57\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-09-14 12:33:48\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.9.8/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-13 18:50:12\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.9.7\";s:7:\"updated\";s:19:\"2018-06-17 09:33:44\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-04 14:45:25\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"5.1.1\";s:7:\"updated\";s:19:\"2019-03-19 14:36:40\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.1.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-07-28 13:16:13\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.8/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.7.11\";s:7:\"updated\";s:19:\"2018-09-20 11:13:37\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.7.11/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 16:37:56\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-15 00:51:33\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-03-24 13:53:29\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.5/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nutugne\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:3:\"5.1\";s:7:\"updated\";s:19:\"2019-02-21 08:17:32\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.1/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-09-21 14:15:57\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-03-12 08:08:32\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.9.5/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:5:\"5.0.3\";s:7:\"updated\";s:19:\"2019-01-09 07:34:10\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.0.3/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:6:\"4.9.12\";s:7:\"updated\";s:19:\"2019-05-08 04:00:57\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.12/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರೆಸಿ\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-11 02:10:53\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"4.9.9\";s:7:\"updated\";s:19:\"2018-12-18 14:32:44\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.9/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ຕໍ່\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 19:23:46\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:6:\"4.7.15\";s:7:\"updated\";s:19:\"2019-05-10 10:24:08\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.15/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"5.2.3\";s:7:\"updated\";s:19:\"2019-09-08 12:57:25\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.3/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"Үргэлжлүүлэх\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.8.11\";s:7:\"updated\";s:19:\"2018-02-13 07:38:55\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.11/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-08-30 20:27:25\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.8/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.20\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.20/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ေဆာင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-06 17:43:28\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-03-27 10:30:26\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.5/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"जारीराख्नु \";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-20 07:55:46\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.2.3\";s:7:\"updated\";s:19:\"2019-08-16 11:16:09\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.3/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"5.2.3\";s:7:\"updated\";s:19:\"2019-08-15 14:36:38\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/5.2.3/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-15 07:50:35\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.8.3\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.3/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-07-07 06:24:50\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.20\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.20/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"دوام\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 15:13:04\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-16 11:33:10\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"5.2.3\";s:7:\"updated\";s:19:\"2019-07-02 07:58:03\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/5.2.3/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-20 09:41:26\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-21 12:45:31\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 14:39:35\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-18 06:59:45\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"5.2.3\";s:7:\"updated\";s:19:\"2019-06-26 11:40:37\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.3/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.9.2\";s:7:\"updated\";s:19:\"2018-01-04 13:33:13\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-20 12:34:38\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-15 10:03:57\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 13:41:32\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-22 00:19:41\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-19 08:19:37\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-30 02:38:08\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-04 19:18:21\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-04-12 12:31:53\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.5/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-16 10:31:10\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:5:\"5.1.3\";s:7:\"updated\";s:19:\"2019-03-31 10:39:40\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.1.3/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:5:\"5.0.3\";s:7:\"updated\";s:19:\"2019-01-23 12:32:40\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.0.3/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-23 07:14:52\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.2.4/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-20 19:10:35\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-07-29 00:33:56\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"5.2.4\";s:7:\"updated\";s:19:\"2019-10-01 15:59:49\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.2.4/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("9", "8", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("10", "8", "_wp_page_template", "page-home.php");
INSERT INTO `wp_postmeta` VALUES("11", "8", "_edit_lock", "1571055015:1");
INSERT INTO `wp_postmeta` VALUES("12", "11", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("13", "11", "_edit_lock", "1569928859:1");
INSERT INTO `wp_postmeta` VALUES("14", "15", "_wp_attached_file", "2019/08/sps-gal-001.jpg");
INSERT INTO `wp_postmeta` VALUES("15", "15", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-gal-001.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-gal-001-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-gal-001-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-gal-001-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-gal-001-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("16", "16", "_wp_attached_file", "2019/08/sps-gal-002.jpg");
INSERT INTO `wp_postmeta` VALUES("17", "16", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-gal-002.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-gal-002-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-gal-002-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-gal-002-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-gal-002-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("18", "17", "_wp_attached_file", "2019/08/sps-gal-003.jpg");
INSERT INTO `wp_postmeta` VALUES("19", "17", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-gal-003.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-gal-003-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-gal-003-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-gal-003-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-gal-003-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("20", "18", "_wp_attached_file", "2019/08/sps-gal-004.jpg");
INSERT INTO `wp_postmeta` VALUES("21", "18", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-gal-004.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-gal-004-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-gal-004-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-gal-004-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-gal-004-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("22", "19", "_wp_attached_file", "2019/08/sps-gal-005.jpg");
INSERT INTO `wp_postmeta` VALUES("23", "19", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-gal-005.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-gal-005-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-gal-005-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-gal-005-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-gal-005-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("24", "20", "_wp_attached_file", "2019/08/sps-gal-006.jpg");
INSERT INTO `wp_postmeta` VALUES("25", "20", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-gal-006.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-gal-006-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-gal-006-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-gal-006-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-gal-006-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("26", "21", "_wp_attached_file", "2019/08/sps-gal-007.jpg");
INSERT INTO `wp_postmeta` VALUES("27", "21", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-gal-007.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-gal-007-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-gal-007-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-gal-007-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-gal-007-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("35", "8", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("36", "8", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("37", "23", "sekce_leva_0_obrazek", "21");
INSERT INTO `wp_postmeta` VALUES("38", "23", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("39", "23", "sekce_leva_0_text", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad.\r\n\r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\n\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("40", "23", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("41", "23", "sekce_leva", "1");
INSERT INTO `wp_postmeta` VALUES("42", "23", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("45", "25", "sekce_leva_0_obrazek", "21");
INSERT INTO `wp_postmeta` VALUES("46", "25", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("47", "25", "sekce_leva_0_text", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad.\r\n\r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\n\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("48", "25", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("49", "25", "sekce_leva", "1");
INSERT INTO `wp_postmeta` VALUES("50", "25", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("51", "25", "sekce_leva_0_titulek", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("52", "25", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("53", "28", "_wp_attached_file", "2019/08/sps-slide-1.jpg");
INSERT INTO `wp_postmeta` VALUES("54", "28", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-slide-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-slide-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-slide-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-slide-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-slide-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("55", "29", "_wp_attached_file", "2019/08/sps-slide-2.jpg");
INSERT INTO `wp_postmeta` VALUES("56", "29", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-slide-2.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-slide-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-slide-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-slide-2-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-slide-2-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("57", "30", "_wp_attached_file", "2019/08/sps-slide-3.jpg");
INSERT INTO `wp_postmeta` VALUES("58", "30", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-slide-3.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-slide-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-slide-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-slide-3-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-slide-3-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("59", "31", "_wp_attached_file", "2019/08/sps-slide-4.jpg");
INSERT INTO `wp_postmeta` VALUES("60", "31", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-slide-4.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-slide-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-slide-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-slide-4-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-slide-4-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("61", "32", "_wp_attached_file", "2019/08/sps-slide-5.jpg");
INSERT INTO `wp_postmeta` VALUES("62", "32", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-slide-5.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-slide-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-slide-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-slide-5-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-slide-5-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("63", "33", "_wp_attached_file", "2019/08/sps-slide-6.jpg");
INSERT INTO `wp_postmeta` VALUES("64", "33", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-slide-6.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-slide-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-slide-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-slide-6-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-slide-6-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("65", "34", "_wp_attached_file", "2019/08/sps-slide-7.jpg");
INSERT INTO `wp_postmeta` VALUES("66", "34", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-slide-7.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-slide-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-slide-7-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-slide-7-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-slide-7-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("67", "35", "_wp_attached_file", "2019/08/sps-slide-8.jpg");
INSERT INTO `wp_postmeta` VALUES("68", "35", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2019/08/sps-slide-8.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"sps-slide-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"sps-slide-8-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"sps-slide-8-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"sps-slide-8-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("69", "8", "slider_0_slider_image", "136");
INSERT INTO `wp_postmeta` VALUES("70", "8", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("71", "8", "slider_1_slider_image", "133");
INSERT INTO `wp_postmeta` VALUES("72", "8", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("73", "8", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("74", "8", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("75", "36", "sekce_leva_0_obrazek", "21");
INSERT INTO `wp_postmeta` VALUES("76", "36", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("77", "36", "sekce_leva_0_text", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad.\r\n\r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\n\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("78", "36", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("79", "36", "sekce_leva", "1");
INSERT INTO `wp_postmeta` VALUES("80", "36", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("81", "36", "sekce_leva_0_titulek", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("82", "36", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("83", "36", "slider_0_slider_image", "35");
INSERT INTO `wp_postmeta` VALUES("84", "36", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("85", "36", "slider_1_slider_image", "34");
INSERT INTO `wp_postmeta` VALUES("86", "36", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("87", "36", "slider", "2");
INSERT INTO `wp_postmeta` VALUES("88", "36", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("89", "8", "slider_2_slider_image", "135");
INSERT INTO `wp_postmeta` VALUES("90", "8", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("91", "8", "slider_3_slider_image", "134");
INSERT INTO `wp_postmeta` VALUES("92", "8", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("93", "37", "sekce_leva", "");
INSERT INTO `wp_postmeta` VALUES("94", "37", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("95", "37", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("96", "37", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("97", "37", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("98", "37", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("99", "37", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("100", "37", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("101", "37", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("102", "37", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("103", "37", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("104", "37", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("105", "8", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("106", "8", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("107", "8", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("108", "8", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("109", "8", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("110", "8", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("111", "8", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("112", "8", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("113", "8", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("114", "8", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("115", "8", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("116", "8", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("117", "38", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("118", "38", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("119", "38", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("120", "38", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("121", "38", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("122", "38", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("123", "38", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("124", "38", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("125", "38", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("126", "38", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("127", "38", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("128", "38", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("129", "38", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("130", "38", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("131", "38", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("132", "38", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("133", "38", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("134", "38", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("135", "38", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("136", "38", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("137", "38", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("138", "38", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("139", "38", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("140", "38", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("141", "8", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("142", "8", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("143", "8", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("144", "8", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("145", "8", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("146", "8", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("147", "8", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("148", "8", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("149", "8", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("150", "8", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("151", "8", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("152", "8", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("153", "39", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("154", "39", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("155", "39", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("156", "39", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("157", "39", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("158", "39", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("159", "39", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("160", "39", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("161", "39", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("162", "39", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("163", "39", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("164", "39", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("165", "39", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("166", "39", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("167", "39", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("168", "39", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("169", "39", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("170", "39", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("171", "39", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("172", "39", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("173", "39", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("174", "39", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("175", "39", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("176", "39", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("177", "39", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("178", "39", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("179", "39", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("180", "39", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("181", "39", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("182", "39", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("183", "39", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("184", "39", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("185", "39", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("186", "39", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("187", "39", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("188", "39", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("189", "40", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("190", "40", "_edit_lock", "1566383883:1");
INSERT INTO `wp_postmeta` VALUES("191", "8", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("192", "8", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("193", "8", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš.\r\n");
INSERT INTO `wp_postmeta` VALUES("194", "8", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("195", "8", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("196", "8", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("197", "44", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("198", "44", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("199", "44", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("200", "44", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("201", "44", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("202", "44", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("203", "44", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("204", "44", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("205", "44", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("206", "44", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("207", "44", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("208", "44", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("209", "44", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("210", "44", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("211", "44", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("212", "44", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("213", "44", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("214", "44", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("215", "44", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("216", "44", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("217", "44", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("218", "44", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("219", "44", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("220", "44", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("221", "44", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("222", "44", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("223", "44", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("224", "44", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("225", "44", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("226", "44", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("227", "44", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("228", "44", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("229", "44", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("230", "44", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("231", "44", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("232", "44", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("233", "44", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("234", "44", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("235", "44", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("236", "44", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("237", "44", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("238", "44", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("239", "8", "titulek_2", "Tady chillujeme");
INSERT INTO `wp_postmeta` VALUES("240", "8", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("241", "8", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("242", "8", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("243", "8", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("244", "8", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("245", "48", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("246", "48", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("247", "48", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("248", "48", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("249", "48", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("250", "48", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("251", "48", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("252", "48", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("253", "48", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("254", "48", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("255", "48", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("256", "48", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("257", "48", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("258", "48", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("259", "48", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("260", "48", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("261", "48", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("262", "48", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("263", "48", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("264", "48", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("265", "48", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("266", "48", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("267", "48", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("268", "48", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("269", "48", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("270", "48", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("271", "48", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("272", "48", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("273", "48", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("274", "48", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("275", "48", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("276", "48", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("277", "48", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("278", "48", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("279", "48", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("280", "48", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("281", "48", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("282", "48", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("283", "48", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("284", "48", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("285", "48", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("286", "48", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("287", "48", "titulek_2", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("288", "48", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("289", "48", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("290", "48", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("291", "48", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("292", "48", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("293", "8", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("294", "8", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("295", "8", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny.\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("296", "8", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("297", "8", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("298", "8", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("299", "52", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("300", "52", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("301", "52", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("302", "52", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("303", "52", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("304", "52", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("305", "52", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("306", "52", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("307", "52", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("308", "52", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("309", "52", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("310", "52", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("311", "52", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("312", "52", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("313", "52", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("314", "52", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("315", "52", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("316", "52", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("317", "52", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("318", "52", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("319", "52", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("320", "52", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("321", "52", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("322", "52", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("323", "52", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("324", "52", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("325", "52", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("326", "52", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("327", "52", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("328", "52", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("329", "52", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("330", "52", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("331", "52", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("332", "52", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("333", "52", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("334", "52", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("335", "52", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("336", "52", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("337", "52", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("338", "52", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("339", "52", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("340", "52", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("341", "52", "titulek_2", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("342", "52", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("343", "52", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("344", "52", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("345", "52", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("346", "52", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("347", "52", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("348", "52", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("349", "52", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("350", "52", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("351", "52", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("352", "52", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("353", "8", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("354", "8", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("355", "8", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("356", "8", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("357", "8", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("358", "8", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("359", "8", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("360", "8", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("361", "8", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("362", "8", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("363", "8", "obrazek_5", "31");
INSERT INTO `wp_postmeta` VALUES("364", "8", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("365", "59", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("366", "59", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("367", "59", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("368", "59", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("369", "59", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("370", "59", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("371", "59", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("372", "59", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("373", "59", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("374", "59", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("375", "59", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("376", "59", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("377", "59", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("378", "59", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("379", "59", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("380", "59", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("381", "59", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("382", "59", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("383", "59", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("384", "59", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("385", "59", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("386", "59", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("387", "59", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("388", "59", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("389", "59", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("390", "59", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("391", "59", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("392", "59", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("393", "59", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("394", "59", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("395", "59", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("396", "59", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("397", "59", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("398", "59", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("399", "59", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("400", "59", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("401", "59", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("402", "59", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("403", "59", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("404", "59", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("405", "59", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("406", "59", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("407", "59", "titulek_2", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("408", "59", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("409", "59", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("410", "59", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("411", "59", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("412", "59", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("413", "59", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("414", "59", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("415", "59", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("416", "59", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("417", "59", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("418", "59", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("419", "59", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("420", "59", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("421", "59", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("422", "59", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("423", "59", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("424", "59", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("425", "59", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("426", "59", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("427", "59", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("428", "59", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("429", "59", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("430", "59", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("431", "8", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("432", "8", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("433", "59", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("434", "59", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("448", "62", "forminator_form_meta", "a:6:{s:6:\"fields\";a:0:{}s:8:\"settings\";a:77:{s:8:\"formName\";s:4:\"test\";s:22:\"admin-email-recipients\";a:1:{i:0;s:20:\"pavelkocan@pulary.cz\";}s:13:\"results_behav\";s:5:\"after\";s:12:\"visual_style\";s:4:\"list\";s:21:\"forminator-quiz-theme\";s:7:\"default\";s:11:\"msg_correct\";s:29:\"Correct! It was %UserAnswer%.\";s:13:\"msg_incorrect\";s:39:\"Wrong! It was %CorrectAnswer%, sorry...\";s:9:\"msg_count\";s:34:\"You got %YourNum%/%Total% correct!\";s:22:\"nowrong-title-settings\";s:0:\"\";s:19:\"nowrong-title-color\";s:7:\"#333333\";s:25:\"nowrong-title-font-family\";s:6:\"Roboto\";s:23:\"nowrong-title-font-size\";s:2:\"42\";s:25:\"nowrong-title-font-weight\";s:3:\"500\";s:28:\"nowrong-description-settings\";s:0:\"\";s:25:\"nowrong-description-color\";s:7:\"#8C8C8C\";s:31:\"nowrong-description-font-family\";s:6:\"Roboto\";s:29:\"nowrong-description-font-size\";s:2:\"20\";s:31:\"nowrong-description-font-weight\";s:3:\"400\";s:22:\"nowrong-image-settings\";s:0:\"\";s:26:\"nowrong-image-border-color\";s:7:\"#000000\";s:26:\"nowrong-image-border-width\";s:1:\"0\";s:26:\"nowrong-image-border-style\";s:5:\"solid\";s:25:\"nowrong-question-settings\";s:0:\"\";s:26:\"nowrong-question-font-size\";s:2:\"24\";s:28:\"nowrong-question-font-family\";s:6:\"Roboto\";s:28:\"nowrong-question-font-weight\";s:3:\"500\";s:23:\"nowrong-answer-settings\";s:0:\"\";s:28:\"nowrong-answer-border-static\";s:7:\"#EBEDEB\";s:27:\"nowrong-answer-border-hover\";s:7:\"#17A8E3\";s:28:\"nowrong-answer-border-active\";s:7:\"#17A8E3\";s:32:\"nowrong-answer-background-static\";s:7:\"#FAFAFA\";s:31:\"nowrong-answer-background-hover\";s:7:\"#F3FBFE\";s:32:\"nowrong-answer-background-active\";s:7:\"#F3FBFE\";s:27:\"nowrong-answer-chkbo-static\";s:7:\"#BFBFBF\";s:27:\"nowrong-answer-chkbo-active\";s:7:\"#17A8E3\";s:27:\"nowrong-answer-color-static\";s:7:\"#888888\";s:27:\"nowrong-answer-color-active\";s:7:\"#333333\";s:24:\"nowrong-answer-font-size\";s:2:\"14\";s:26:\"nowrong-answer-font-family\";s:6:\"Roboto\";s:26:\"nowrong-answer-font-weight\";s:3:\"500\";s:32:\"nowrong-submit-background-static\";s:7:\"#17A8E3\";s:31:\"nowrong-submit-background-hover\";s:7:\"#008FCA\";s:32:\"nowrong-submit-background-active\";s:7:\"#008FCA\";s:27:\"nowrong-submit-color-static\";s:7:\"#FFFFFF\";s:26:\"nowrong-submit-color-hover\";s:7:\"#FFFFFF\";s:27:\"nowrong-submit-color-active\";s:7:\"#FFFFFF\";s:26:\"nowrong-submit-font-family\";s:6:\"Roboto\";s:24:\"nowrong-submit-font-size\";s:2:\"14\";s:26:\"nowrong-submit-font-weight\";s:3:\"500\";s:30:\"nowrong-result-background-main\";s:7:\"#FAFAFA\";s:32:\"nowrong-result-background-header\";s:7:\"#FAFAFA\";s:27:\"nowrong-result-border-color\";s:7:\"#17A8E3\";s:25:\"nowrong-result-quiz-color\";s:7:\"#FFFFFF\";s:31:\"nowrong-result-quiz-font-family\";s:6:\"Roboto\";s:29:\"nowrong-result-quiz-font-size\";s:2:\"15\";s:31:\"nowrong-result-quiz-font-weight\";s:3:\"500\";s:33:\"nowrong-result-retake-font-family\";s:6:\"Roboto\";s:31:\"nowrong-result-retake-font-size\";s:2:\"13\";s:33:\"nowrong-result-retake-font-weight\";s:3:\"500\";s:39:\"nowrong-result-retake-background-static\";s:7:\"#17A8E3\";s:38:\"nowrong-result-retake-background-hover\";s:7:\"#17A8E3\";s:39:\"nowrong-result-retake-background-active\";s:7:\"#17A8E3\";s:30:\"nowrong-result-background-body\";s:7:\"#EBEDEB\";s:26:\"nowrong-result-title-color\";s:7:\"#333333\";s:32:\"nowrong-result-title-font-family\";s:6:\"Roboto\";s:30:\"nowrong-result-title-font-size\";s:2:\"15\";s:32:\"nowrong-result-title-font-weight\";s:3:\"500\";s:32:\"nowrong-result-description-color\";s:7:\"#4D4D4D\";s:38:\"nowrong-result-description-font-family\";s:6:\"Roboto\";s:36:\"nowrong-result-description-font-size\";s:2:\"13\";s:38:\"nowrong-result-description-font-weight\";s:3:\"400\";s:12:\"enable-share\";s:2:\"on\";s:9:\"quiz_name\";s:9:\"Otázka 1\";s:15:\"quiz_feat_image\";s:74:\"http://bavse.pulary.cz/wp-content/uploads/2019/08/sps-slide-2-1024x683.jpg\";s:24:\"quiz_feat_image_filename\";s:15:\"sps-slide-2.jpg\";s:16:\"quiz_description\";s:1194:\"<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nulla non lectus sed nisl molestie malesuada. Morbi imperdiet, mauris ac auctor dictum, nisl ligula egestas nulla, et sollicitudin sem purus in lacus. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Proin mattis lacinia justo. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Fusce tellus. Fusce dui leo, imperdiet in, aliquam sit amet, feugiat eu, orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Curabitur sagittis hendrerit ante. Proin in tellus sit amet nibh dignissim sagittis. Suspendisse nisl. Proin in tellus sit amet nibh dignissim sagittis. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Praesent in mauris eu tortor porttitor accumsan. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam erat volutpat.</p>\";s:7:\"version\";s:5:\"1.8.1\";}s:9:\"client_id\";N;s:9:\"questions\";a:0:{}s:7:\"results\";a:3:{i:0;a:3:{s:4:\"slug\";s:16:\"result-2117-3472\";s:5:\"title\";s:5:\"jedna\";s:11:\"description\";s:0:\"\";}i:1;a:3:{s:4:\"slug\";s:16:\"result-7600-2493\";s:5:\"title\";s:3:\"dve\";s:11:\"description\";s:0:\"\";}i:2;a:3:{s:4:\"slug\";s:16:\"result-9673-7125\";s:5:\"title\";s:3:\"tri\";s:11:\"description\";s:0:\"\";}}s:9:\"quiz_type\";s:7:\"nowrong\";}");
INSERT INTO `wp_postmeta` VALUES("449", "63", "forminator_form_meta", "a:6:{s:6:\"fields\";a:0:{}s:8:\"settings\";a:77:{s:8:\"formName\";s:6:\"Test 2\";s:22:\"admin-email-recipients\";a:1:{i:0;s:20:\"pavelkocan@pulary.cz\";}s:17:\"admin-email-title\";s:35:\"New Quiz Submission for {quiz_name}\";s:18:\"admin-email-editor\";s:150:\"You have a new quiz submission: <br/><br/>{quiz_answer}<br/><br/>Quiz results: <br/>{quiz_result} <br/>---<br/> This message was sent from {site_url}.\";s:13:\"results_behav\";s:5:\"after\";s:12:\"visual_style\";s:4:\"grid\";s:21:\"forminator-quiz-theme\";s:7:\"default\";s:11:\"msg_correct\";s:29:\"Correct! It was %UserAnswer%.\";s:13:\"msg_incorrect\";s:39:\"Wrong! It was %CorrectAnswer%, sorry...\";s:9:\"msg_count\";s:34:\"You got %YourNum%/%Total% correct!\";s:21:\"knowledge-title-color\";s:7:\"#333333\";s:27:\"knowledge-title-font-family\";s:6:\"Roboto\";s:25:\"knowledge-title-font-size\";s:2:\"42\";s:27:\"knowledge-title-font-weight\";s:3:\"500\";s:27:\"knowledge-description-color\";s:7:\"#8C8C8C\";s:33:\"knowledge-description-font-family\";s:6:\"Roboto\";s:31:\"knowledge-description-font-size\";s:2:\"20\";s:33:\"knowledge-description-font-weight\";s:3:\"400\";s:24:\"knowledge-question-color\";s:7:\"#333333\";s:30:\"knowledge-question-font-family\";s:6:\"Roboto\";s:28:\"knowledge-question-font-size\";s:2:\"24\";s:30:\"knowledge-question-font-weight\";s:3:\"500\";s:34:\"knowledge-answer-background-static\";s:7:\"#FAFAFA\";s:33:\"knowledge-answer-background-hover\";s:7:\"#F3FBFE\";s:34:\"knowledge-answer-background-active\";s:7:\"#F3FBFE\";s:27:\"knowledge-aright-background\";s:7:\"#F4FCF2\";s:27:\"knowledge-awrong-background\";s:7:\"#FDF2F2\";s:30:\"knowledge-answer-border-static\";s:7:\"#EBEDEB\";s:29:\"knowledge-answer-border-hover\";s:7:\"#17A8E3\";s:30:\"knowledge-answer-border-active\";s:7:\"#17A8E3\";s:23:\"knowledge-aright-border\";s:7:\"#0BC30B\";s:23:\"knowledge-awrong-border\";s:7:\"#DA0000\";s:29:\"knowledge-answer-color-static\";s:7:\"#888888\";s:29:\"knowledge-answer-color-active\";s:7:\"#333333\";s:22:\"knowledge-aright-color\";s:7:\"#0BC30B\";s:22:\"knowledge-awrong-color\";s:7:\"#DA0000\";s:26:\"knowledge-answer-font-size\";s:2:\"14\";s:28:\"knowledge-answer-font-family\";s:6:\"Roboto\";s:28:\"knowledge-answer-font-weight\";s:3:\"500\";s:36:\"knowledge-answer-check-border-static\";s:7:\"#BFBFBF\";s:36:\"knowledge-answer-check-border-active\";s:7:\"#17A8E3\";s:37:\"knowledge-answer-check-border-correct\";s:7:\"#0BC30B\";s:39:\"knowledge-answer-check-border-incorrect\";s:7:\"#DA0000\";s:40:\"knowledge-answer-check-background-static\";s:7:\"#FFFFFF\";s:40:\"knowledge-answer-check-background-active\";s:7:\"#17A8E3\";s:41:\"knowledge-answer-check-background-correct\";s:7:\"#0BC30B\";s:43:\"knowledge-answer-check-background-incorrect\";s:7:\"#DA0000\";s:24:\"knowledge-phrasing-color\";s:7:\"#4D4D4D\";s:28:\"knowledge-phrasing-font-size\";s:2:\"16\";s:30:\"knowledge-phrasing-font-family\";s:6:\"Roboto\";s:30:\"knowledge-phrasing-font-weight\";s:3:\"700\";s:34:\"knowledge-submit-background-static\";s:7:\"#bf2121\";s:33:\"knowledge-submit-background-hover\";s:7:\"#008FCA\";s:34:\"knowledge-submit-background-active\";s:7:\"#008FCA\";s:29:\"knowledge-submit-color-static\";s:7:\"#FFFFFF\";s:28:\"knowledge-submit-color-hover\";s:7:\"#FFFFFF\";s:29:\"knowledge-submit-color-active\";s:7:\"#FFFFFF\";s:28:\"knowledge-submit-font-family\";s:6:\"Roboto\";s:26:\"knowledge-submit-font-size\";s:2:\"14\";s:28:\"knowledge-submit-font-weight\";s:3:\"500\";s:23:\"knowledge-summary-color\";s:7:\"#333333\";s:29:\"knowledge-summary-font-family\";s:6:\"Roboto\";s:27:\"knowledge-summary-font-size\";s:2:\"40\";s:29:\"knowledge-summary-font-weight\";s:3:\"400\";s:12:\"enable-share\";s:2:\"on\";s:22:\"knowledge-sshare-color\";s:7:\"#4D4D4D\";s:28:\"knowledge-sshare-font-family\";s:6:\"Roboto\";s:26:\"knowledge-sshare-font-size\";s:2:\"20\";s:25:\"knowledge-social-facebook\";s:7:\"#0084BF\";s:24:\"knowledge-social-twitter\";s:7:\"#1DA1F2\";s:23:\"knowledge-social-google\";s:7:\"#DB4437\";s:36:\"forminator-knowledge-social-linkedin\";s:7:\"#0084BF\";s:21:\"knowledge-social-size\";s:2:\"36\";s:9:\"quiz_name\";s:5:\"Kvíz\";s:16:\"quiz_description\";s:356:\"<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nulla non lectus sed nisl molestie malesuada. Morbi imperdiet, mauris ac auctor dictum, nisl ligula egestas nulla, et sollicitudin sem purus in lacus. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Proin mattis lacinia justo. </p>\";s:24:\"knowledge-toggle-palette\";s:4:\"true\";s:7:\"version\";s:5:\"1.8.1\";}s:9:\"client_id\";N;s:9:\"questions\";a:3:{i:0;a:4:{s:4:\"slug\";s:18:\"question-4077-2549\";s:7:\"answers\";a:3:{i:0;a:3:{s:5:\"title\";s:1:\"1\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:1;a:3:{s:5:\"title\";s:1:\"2\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:2;a:4:{s:5:\"title\";s:1:\"3\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";s:6:\"toggle\";s:1:\"1\";}}s:4:\"type\";s:9:\"knowledge\";s:5:\"title\";s:9:\"Otázka 1\";}i:1;a:4:{s:4:\"slug\";s:18:\"question-5153-6613\";s:7:\"answers\";a:3:{i:0;a:3:{s:5:\"title\";s:1:\"1\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:1;a:4:{s:5:\"title\";s:1:\"2\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";s:6:\"toggle\";s:1:\"1\";}i:2;a:3:{s:5:\"title\";s:1:\"3\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}}s:4:\"type\";s:9:\"knowledge\";s:5:\"title\";s:9:\"Otázka 2\";}i:2;a:4:{s:4:\"slug\";s:18:\"question-9423-4568\";s:7:\"answers\";a:3:{i:0;a:4:{s:5:\"title\";s:1:\"1\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";s:6:\"toggle\";s:1:\"1\";}i:1;a:3:{s:5:\"title\";s:1:\"2\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:2;a:3:{s:5:\"title\";s:1:\"3\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}}s:4:\"type\";s:9:\"knowledge\";s:5:\"title\";s:9:\"Otázka 3\";}}s:7:\"results\";a:0:{}s:9:\"quiz_type\";s:9:\"knowledge\";}");
INSERT INTO `wp_postmeta` VALUES("450", "8", "video_1", "81");
INSERT INTO `wp_postmeta` VALUES("451", "8", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("452", "66", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("453", "66", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("454", "66", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("455", "66", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("456", "66", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("457", "66", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("458", "66", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("459", "66", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("460", "66", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("461", "66", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("462", "66", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("463", "66", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("464", "66", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("465", "66", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("466", "66", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("467", "66", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("468", "66", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("469", "66", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("470", "66", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("471", "66", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("472", "66", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("473", "66", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("474", "66", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("475", "66", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("476", "66", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("477", "66", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("478", "66", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("479", "66", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("480", "66", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("481", "66", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("482", "66", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("483", "66", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("484", "66", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("485", "66", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("486", "66", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("487", "66", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("488", "66", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("489", "66", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("490", "66", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("491", "66", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("492", "66", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("493", "66", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("494", "66", "titulek_2", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("495", "66", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("496", "66", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("497", "66", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("498", "66", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("499", "66", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("500", "66", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("501", "66", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("502", "66", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("503", "66", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("504", "66", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("505", "66", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("506", "66", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("507", "66", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("508", "66", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("509", "66", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("510", "66", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("511", "66", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("512", "66", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("513", "66", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("514", "66", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("515", "66", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("516", "66", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("517", "66", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("518", "66", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("519", "66", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("520", "66", "video_1", "29");
INSERT INTO `wp_postmeta` VALUES("521", "66", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("522", "67", "_wp_attached_file", "2019/08/foto-3.jpg");
INSERT INTO `wp_postmeta` VALUES("523", "67", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:18:\"2019/08/foto-3.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"foto-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"foto-3-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("524", "68", "_wp_attached_file", "2019/08/foto-2.jpg");
INSERT INTO `wp_postmeta` VALUES("525", "68", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:18:\"2019/08/foto-2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"foto-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"foto-2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("526", "69", "_wp_attached_file", "2019/08/foto-1.jpg");
INSERT INTO `wp_postmeta` VALUES("527", "69", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:18:\"2019/08/foto-1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"foto-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"foto-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("528", "70", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("529", "70", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("530", "70", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("531", "70", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("532", "70", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("533", "70", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("534", "70", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("535", "70", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("536", "70", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("537", "70", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("538", "70", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("539", "70", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("540", "70", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("541", "70", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("542", "70", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("543", "70", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("544", "70", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("545", "70", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("546", "70", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("547", "70", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("548", "70", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("549", "70", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("550", "70", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("551", "70", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("552", "70", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("553", "70", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("554", "70", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("555", "70", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("556", "70", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("557", "70", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("558", "70", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("559", "70", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("560", "70", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("561", "70", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("562", "70", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("563", "70", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("564", "70", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("565", "70", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("566", "70", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("567", "70", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("568", "70", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("569", "70", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("570", "70", "titulek_2", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("571", "70", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("572", "70", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("573", "70", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("574", "70", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("575", "70", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("576", "70", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("577", "70", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("578", "70", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("579", "70", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("580", "70", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("581", "70", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("582", "70", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("583", "70", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("584", "70", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("585", "70", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("586", "70", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("587", "70", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("588", "70", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("589", "70", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("590", "70", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("591", "70", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("592", "70", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("593", "70", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("594", "70", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("595", "70", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("596", "70", "video_1", "69");
INSERT INTO `wp_postmeta` VALUES("597", "70", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("598", "8", "video_2", "80");
INSERT INTO `wp_postmeta` VALUES("599", "8", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("600", "8", "video_3", "79");
INSERT INTO `wp_postmeta` VALUES("601", "8", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("602", "73", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("603", "73", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("604", "73", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("605", "73", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("606", "73", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("607", "73", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("608", "73", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("609", "73", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("610", "73", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("611", "73", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("612", "73", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("613", "73", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("614", "73", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("615", "73", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("616", "73", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("617", "73", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("618", "73", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("619", "73", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("620", "73", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("621", "73", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("622", "73", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("623", "73", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("624", "73", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("625", "73", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("626", "73", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("627", "73", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("628", "73", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("629", "73", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("630", "73", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("631", "73", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("632", "73", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("633", "73", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("634", "73", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("635", "73", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("636", "73", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("637", "73", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("638", "73", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("639", "73", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("640", "73", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("641", "73", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("642", "73", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("643", "73", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("644", "73", "titulek_2", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("645", "73", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("646", "73", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("647", "73", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("648", "73", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("649", "73", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("650", "73", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("651", "73", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("652", "73", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("653", "73", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("654", "73", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("655", "73", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("656", "73", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("657", "73", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("658", "73", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("659", "73", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("660", "73", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("661", "73", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("662", "73", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("663", "73", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("664", "73", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("665", "73", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("666", "73", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("667", "73", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("668", "73", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("669", "73", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("670", "73", "video_1", "69");
INSERT INTO `wp_postmeta` VALUES("671", "73", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("672", "73", "video_2", "68");
INSERT INTO `wp_postmeta` VALUES("673", "73", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("674", "73", "video_3", "67");
INSERT INTO `wp_postmeta` VALUES("675", "73", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("676", "8", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("677", "8", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("678", "8", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("679", "8", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("680", "8", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("681", "8", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("682", "77", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("683", "77", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("684", "77", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("685", "77", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("686", "77", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("687", "77", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("688", "77", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("689", "77", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("690", "77", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("691", "77", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("692", "77", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("693", "77", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("694", "77", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("695", "77", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("696", "77", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("697", "77", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("698", "77", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("699", "77", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("700", "77", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("701", "77", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("702", "77", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("703", "77", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("704", "77", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("705", "77", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("706", "77", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("707", "77", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("708", "77", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("709", "77", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("710", "77", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("711", "77", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("712", "77", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("713", "77", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("714", "77", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("715", "77", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("716", "77", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("717", "77", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("718", "77", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("719", "77", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("720", "77", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("721", "77", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("722", "77", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("723", "77", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("724", "77", "titulek_2", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("725", "77", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("726", "77", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("727", "77", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("728", "77", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("729", "77", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("730", "77", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("731", "77", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("732", "77", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("733", "77", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("734", "77", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("735", "77", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("736", "77", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("737", "77", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("738", "77", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("739", "77", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("740", "77", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("741", "77", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("742", "77", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("743", "77", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("744", "77", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("745", "77", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("746", "77", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("747", "77", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("748", "77", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("749", "77", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("750", "77", "video_1", "69");
INSERT INTO `wp_postmeta` VALUES("751", "77", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("752", "77", "video_2", "68");
INSERT INTO `wp_postmeta` VALUES("753", "77", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("754", "77", "video_3", "67");
INSERT INTO `wp_postmeta` VALUES("755", "77", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("756", "77", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("757", "77", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("758", "77", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("759", "77", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("760", "77", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("761", "77", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("762", "78", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("763", "78", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("764", "78", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("765", "78", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("766", "78", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("767", "78", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("768", "78", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("769", "78", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("770", "78", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("771", "78", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("772", "78", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("773", "78", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("774", "78", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("775", "78", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("776", "78", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("777", "78", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("778", "78", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("779", "78", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("780", "78", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("781", "78", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("782", "78", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("783", "78", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("784", "78", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("785", "78", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("786", "78", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("787", "78", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("788", "78", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("789", "78", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("790", "78", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("791", "78", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("792", "78", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("793", "78", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("794", "78", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("795", "78", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("796", "78", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("797", "78", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("798", "78", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("799", "78", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("800", "78", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("801", "78", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("802", "78", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("803", "78", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("804", "78", "titulek_2", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("805", "78", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("806", "78", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("807", "78", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("808", "78", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("809", "78", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("810", "78", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("811", "78", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("812", "78", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("813", "78", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("814", "78", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("815", "78", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("816", "78", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("817", "78", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("818", "78", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("819", "78", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("820", "78", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("821", "78", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("822", "78", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("823", "78", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("824", "78", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("825", "78", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("826", "78", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("827", "78", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("828", "78", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("829", "78", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("830", "78", "video_1", "29");
INSERT INTO `wp_postmeta` VALUES("831", "78", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("832", "78", "video_2", "68");
INSERT INTO `wp_postmeta` VALUES("833", "78", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("834", "78", "video_3", "67");
INSERT INTO `wp_postmeta` VALUES("835", "78", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("836", "78", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("837", "78", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("838", "78", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("839", "78", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("840", "78", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("841", "78", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("842", "79", "_wp_attached_file", "2019/08/foto-3-1.jpg");
INSERT INTO `wp_postmeta` VALUES("843", "79", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:800;s:4:\"file\";s:20:\"2019/08/foto-3-1.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"foto-3-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"foto-3-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"foto-3-1-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("844", "80", "_wp_attached_file", "2019/08/foto-2-1.jpg");
INSERT INTO `wp_postmeta` VALUES("845", "80", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:800;s:4:\"file\";s:20:\"2019/08/foto-2-1.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"foto-2-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"foto-2-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"foto-2-1-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("846", "81", "_wp_attached_file", "2019/08/foto-1-1.jpg");
INSERT INTO `wp_postmeta` VALUES("847", "81", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:800;s:4:\"file\";s:20:\"2019/08/foto-1-1.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"foto-1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"foto-1-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"foto-1-1-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("848", "82", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("849", "82", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("850", "82", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("851", "82", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("852", "82", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("853", "82", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("854", "82", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("855", "82", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("856", "82", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("857", "82", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("858", "82", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("859", "82", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("860", "82", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("861", "82", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("862", "82", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("863", "82", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("864", "82", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("865", "82", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("866", "82", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("867", "82", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("868", "82", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("869", "82", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("870", "82", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("871", "82", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("872", "82", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("873", "82", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("874", "82", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("875", "82", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("876", "82", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("877", "82", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("878", "82", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("879", "82", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("880", "82", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("881", "82", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("882", "82", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("883", "82", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("884", "82", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("885", "82", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("886", "82", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("887", "82", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("888", "82", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("889", "82", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("890", "82", "titulek_2", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("891", "82", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("892", "82", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("893", "82", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("894", "82", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("895", "82", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("896", "82", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("897", "82", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("898", "82", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("899", "82", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("900", "82", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("901", "82", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("902", "82", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("903", "82", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("904", "82", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("905", "82", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("906", "82", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("907", "82", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("908", "82", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("909", "82", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("910", "82", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("911", "82", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("912", "82", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("913", "82", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("914", "82", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("915", "82", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("916", "82", "video_1", "81");
INSERT INTO `wp_postmeta` VALUES("917", "82", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("918", "82", "video_2", "68");
INSERT INTO `wp_postmeta` VALUES("919", "82", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("920", "82", "video_3", "67");
INSERT INTO `wp_postmeta` VALUES("921", "82", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("922", "82", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("923", "82", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("924", "82", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("925", "82", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("926", "82", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("927", "82", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("928", "83", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("929", "83", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("930", "83", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("931", "83", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("932", "83", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("933", "83", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("934", "83", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("935", "83", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("936", "83", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("937", "83", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("938", "83", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("939", "83", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("940", "83", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("941", "83", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("942", "83", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("943", "83", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("944", "83", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("945", "83", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("946", "83", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("947", "83", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("948", "83", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("949", "83", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("950", "83", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("951", "83", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("952", "83", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("953", "83", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("954", "83", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("955", "83", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("956", "83", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("957", "83", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("958", "83", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("959", "83", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("960", "83", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("961", "83", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("962", "83", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("963", "83", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("964", "83", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("965", "83", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("966", "83", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("967", "83", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("968", "83", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("969", "83", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("970", "83", "titulek_2", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("971", "83", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("972", "83", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("973", "83", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("974", "83", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("975", "83", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("976", "83", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("977", "83", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("978", "83", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("979", "83", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("980", "83", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("981", "83", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("982", "83", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("983", "83", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("984", "83", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("985", "83", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("986", "83", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("987", "83", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("988", "83", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("989", "83", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("990", "83", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("991", "83", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("992", "83", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("993", "83", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("994", "83", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("995", "83", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("996", "83", "video_1", "81");
INSERT INTO `wp_postmeta` VALUES("997", "83", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("998", "83", "video_2", "80");
INSERT INTO `wp_postmeta` VALUES("999", "83", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("1000", "83", "video_3", "79");
INSERT INTO `wp_postmeta` VALUES("1001", "83", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("1002", "83", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1003", "83", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("1004", "83", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1005", "83", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("1006", "83", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1007", "83", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("1008", "8", "video_1_odkaz", "<iframe  src=\"https://www.youtube.com/embed/Kkx2erP5Bn4\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1009", "8", "_video_1_odkaz", "field_5d664c588221e");
INSERT INTO `wp_postmeta` VALUES("1010", "8", "video_2_odkaz", "<iframe  src=\"https://www.youtube.com/embed/oQo9LlYgCaE\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1011", "8", "_video_2_odkaz", "field_5d664c738221f");
INSERT INTO `wp_postmeta` VALUES("1012", "8", "video_3_odkaz", "<iframe src=\"https://www.youtube.com/embed/1qfoaX59qrU\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1013", "8", "_video_3_odkaz", "field_5d664c7d82220");
INSERT INTO `wp_postmeta` VALUES("1014", "88", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("1015", "88", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("1016", "88", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("1017", "88", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1018", "88", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("1019", "88", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1020", "88", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("1021", "88", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("1022", "88", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("1023", "88", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1024", "88", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("1025", "88", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1026", "88", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1027", "88", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1028", "88", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1029", "88", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1030", "88", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("1031", "88", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1032", "88", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("1033", "88", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1034", "88", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1035", "88", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1036", "88", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1037", "88", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1038", "88", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("1039", "88", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1040", "88", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1041", "88", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1042", "88", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("1043", "88", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1044", "88", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("1045", "88", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1046", "88", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1047", "88", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1048", "88", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1049", "88", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1050", "88", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1051", "88", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("1052", "88", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?\r\n");
INSERT INTO `wp_postmeta` VALUES("1053", "88", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("1054", "88", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1055", "88", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("1056", "88", "titulek_2", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1057", "88", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("1058", "88", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("1059", "88", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("1060", "88", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("1061", "88", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("1062", "88", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("1063", "88", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("1064", "88", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny. ?\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("1065", "88", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("1066", "88", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("1067", "88", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("1068", "88", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("1069", "88", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("1070", "88", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("1071", "88", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("1072", "88", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("1073", "88", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("1074", "88", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("1075", "88", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("1076", "88", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("1077", "88", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1078", "88", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("1079", "88", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("1080", "88", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("1081", "88", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1082", "88", "video_1", "81");
INSERT INTO `wp_postmeta` VALUES("1083", "88", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("1084", "88", "video_2", "80");
INSERT INTO `wp_postmeta` VALUES("1085", "88", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("1086", "88", "video_3", "79");
INSERT INTO `wp_postmeta` VALUES("1087", "88", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("1088", "88", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1089", "88", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("1090", "88", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1091", "88", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("1092", "88", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1093", "88", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("1094", "88", "video_1_odkaz", "<iframe  src=\"https://www.youtube.com/embed/Kkx2erP5Bn4\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1095", "88", "_video_1_odkaz", "field_5d664c588221e");
INSERT INTO `wp_postmeta` VALUES("1096", "88", "video_2_odkaz", "<iframe  src=\"https://www.youtube.com/embed/oQo9LlYgCaE\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1097", "88", "_video_2_odkaz", "field_5d664c738221f");
INSERT INTO `wp_postmeta` VALUES("1098", "88", "video_3_odkaz", "<iframe src=\"https://www.youtube.com/embed/1qfoaX59qrU\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1099", "88", "_video_3_odkaz", "field_5d664c7d82220");
INSERT INTO `wp_postmeta` VALUES("1100", "89", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("1101", "89", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("1102", "89", "slider_0_slider_image", "33");
INSERT INTO `wp_postmeta` VALUES("1103", "89", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1104", "89", "slider_1_slider_image", "32");
INSERT INTO `wp_postmeta` VALUES("1105", "89", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1106", "89", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("1107", "89", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("1108", "89", "slider_2_slider_image", "31");
INSERT INTO `wp_postmeta` VALUES("1109", "89", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1110", "89", "slider_3_slider_image", "30");
INSERT INTO `wp_postmeta` VALUES("1111", "89", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1112", "89", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1113", "89", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1114", "89", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1115", "89", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1116", "89", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("1117", "89", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1118", "89", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("1119", "89", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1120", "89", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1121", "89", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1122", "89", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1123", "89", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1124", "89", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("1125", "89", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1126", "89", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1127", "89", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1128", "89", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("1129", "89", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1130", "89", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("1131", "89", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1132", "89", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1133", "89", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1134", "89", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1135", "89", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1136", "89", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1137", "89", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("1138", "89", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš.\r\n");
INSERT INTO `wp_postmeta` VALUES("1139", "89", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("1140", "89", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1141", "89", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("1142", "89", "titulek_2", "Tady chillujeme");
INSERT INTO `wp_postmeta` VALUES("1143", "89", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("1144", "89", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("1145", "89", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("1146", "89", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("1147", "89", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("1148", "89", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("1149", "89", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("1150", "89", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny.\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("1151", "89", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("1152", "89", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("1153", "89", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("1154", "89", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("1155", "89", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("1156", "89", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("1157", "89", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("1158", "89", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("1159", "89", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("1160", "89", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("1161", "89", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("1162", "89", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("1163", "89", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1164", "89", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("1165", "89", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("1166", "89", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("1167", "89", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1168", "89", "video_1", "81");
INSERT INTO `wp_postmeta` VALUES("1169", "89", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("1170", "89", "video_2", "80");
INSERT INTO `wp_postmeta` VALUES("1171", "89", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("1172", "89", "video_3", "79");
INSERT INTO `wp_postmeta` VALUES("1173", "89", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("1174", "89", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1175", "89", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("1176", "89", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1177", "89", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("1178", "89", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1179", "89", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("1180", "89", "video_1_odkaz", "<iframe  src=\"https://www.youtube.com/embed/Kkx2erP5Bn4\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1181", "89", "_video_1_odkaz", "field_5d664c588221e");
INSERT INTO `wp_postmeta` VALUES("1182", "89", "video_2_odkaz", "<iframe  src=\"https://www.youtube.com/embed/oQo9LlYgCaE\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1183", "89", "_video_2_odkaz", "field_5d664c738221f");
INSERT INTO `wp_postmeta` VALUES("1184", "89", "video_3_odkaz", "<iframe src=\"https://www.youtube.com/embed/1qfoaX59qrU\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1185", "89", "_video_3_odkaz", "field_5d664c7d82220");
INSERT INTO `wp_postmeta` VALUES("1188", "11", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1189", "118", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1194", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1199", "8", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1200", "8", "_wp_page_template", "page-home.php");
INSERT INTO `wp_postmeta` VALUES("1201", "8", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("1202", "8", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("1203", "8", "slider_0_slider_image", "136");
INSERT INTO `wp_postmeta` VALUES("1204", "8", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1205", "8", "slider_1_slider_image", "133");
INSERT INTO `wp_postmeta` VALUES("1206", "8", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1207", "8", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("1208", "8", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("1209", "8", "slider_2_slider_image", "135");
INSERT INTO `wp_postmeta` VALUES("1210", "8", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1211", "8", "slider_3_slider_image", "134");
INSERT INTO `wp_postmeta` VALUES("1212", "8", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1213", "8", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1214", "8", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1215", "8", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1216", "8", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1217", "8", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\n\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\n\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš 😊");
INSERT INTO `wp_postmeta` VALUES("1218", "8", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1219", "8", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("1220", "8", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1221", "8", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1222", "8", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1223", "8", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\n\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1224", "8", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1225", "8", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("1226", "8", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1227", "8", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1228", "8", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1229", "8", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\n\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\n\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš 😊");
INSERT INTO `wp_postmeta` VALUES("1230", "8", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1231", "8", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("1232", "8", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1233", "8", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1234", "8", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1235", "8", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\n\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1236", "8", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1237", "8", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1238", "8", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("1239", "8", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš.\r\n");
INSERT INTO `wp_postmeta` VALUES("1240", "8", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("1241", "8", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1242", "8", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("1243", "8", "titulek_2", "Tady chillujeme");
INSERT INTO `wp_postmeta` VALUES("1244", "8", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("1245", "8", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("1246", "8", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("1247", "8", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("1248", "8", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("1249", "8", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("1250", "8", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("1251", "8", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny.\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("1252", "8", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("1253", "8", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("1254", "8", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("1255", "8", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("1256", "8", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("1257", "8", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("1258", "8", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("1259", "8", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("1260", "8", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("1261", "8", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("1262", "8", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("1263", "8", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\nTvoje badatelská činnost může začít!\n");
INSERT INTO `wp_postmeta` VALUES("1264", "8", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1265", "8", "obrazek_5", "31");
INSERT INTO `wp_postmeta` VALUES("1266", "8", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("1267", "8", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("1268", "8", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1269", "8", "video_1", "81");
INSERT INTO `wp_postmeta` VALUES("1270", "8", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("1271", "8", "video_2", "80");
INSERT INTO `wp_postmeta` VALUES("1272", "8", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("1273", "8", "video_3", "79");
INSERT INTO `wp_postmeta` VALUES("1274", "8", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("1275", "8", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1276", "8", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("1277", "8", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1278", "8", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("1279", "8", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1280", "8", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("1281", "8", "video_1_odkaz", "<iframe  src=\"https://www.youtube.com/embed/Kkx2erP5Bn4\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1282", "8", "_video_1_odkaz", "field_5d664c588221e");
INSERT INTO `wp_postmeta` VALUES("1283", "8", "video_2_odkaz", "<iframe  src=\"https://www.youtube.com/embed/oQo9LlYgCaE\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1284", "8", "_video_2_odkaz", "field_5d664c738221f");
INSERT INTO `wp_postmeta` VALUES("1285", "8", "video_3_odkaz", "<iframe src=\"https://www.youtube.com/embed/1qfoaX59qrU\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1286", "8", "_video_3_odkaz", "field_5d664c7d82220");
INSERT INTO `wp_postmeta` VALUES("1287", "8", "obor_0_obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1288", "8", "_obor_0_obrazek_obor", "field_5d7613d39e303");
INSERT INTO `wp_postmeta` VALUES("1289", "8", "obor_0_nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("1290", "8", "_obor_0_nazev_oboru", "field_5d76142bd4876");
INSERT INTO `wp_postmeta` VALUES("1291", "8", "obor_0_text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\n 	<li>Studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1292", "8", "_obor_0_text_obor", "field_5d7613e79e304");
INSERT INTO `wp_postmeta` VALUES("1293", "8", "obor", "2");
INSERT INTO `wp_postmeta` VALUES("1294", "8", "_obor", "field_5d7613c69e302");
INSERT INTO `wp_postmeta` VALUES("1295", "8", "obor_0_obrazek_obor_2", "15");
INSERT INTO `wp_postmeta` VALUES("1296", "8", "_obor_0_obrazek_obor_2", "field_5d7617af379d3");
INSERT INTO `wp_postmeta` VALUES("1297", "8", "obor_0_nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("1298", "8", "_obor_0_nazev_oboru_2", "field_5d7617b9379d4");
INSERT INTO `wp_postmeta` VALUES("1299", "8", "obor_0_text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\n\n&nbsp;\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\n 	<li>podniková ekonomika,</li>\n 	<li>personalistika a mzdy,</li>\n 	<li>finanční gramotnost,</li>\n 	<li>účetnictví a daňová evidence,</li>\n 	<li>právo,</li>\n 	<li>vedení kompletní podnikové agendy na PC.</li>\n</ul>\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</em></strong>\n\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\n\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</em></strong>\n\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\n\n<strong><em> </em></strong>\n\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>Absolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1300", "8", "_obor_0_text_obor_2", "field_5d7617c2379d5");
INSERT INTO `wp_postmeta` VALUES("1301", "8", "obor_1_obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1302", "8", "_obor_1_obrazek_obor", "field_5d7613d39e303");
INSERT INTO `wp_postmeta` VALUES("1303", "8", "obor_1_nazev_oboru", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("1304", "8", "_obor_1_nazev_oboru", "field_5d76142bd4876");
INSERT INTO `wp_postmeta` VALUES("1305", "8", "obor_1_text_obor", "<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n\n<strong><em> </em></strong>\n<ul>\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\n<ul>\n 	<li>Počítačová grafika; Robotika</li>\n 	<li>Programování; Elektrotechnika</li>\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\n</ul>\n</li>\n</ul>\n<ul>\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\n</ul>\n&nbsp;\n\n<strong><em>Zaměření: Počítačová technika a robotika</em></strong>\n\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\n\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\n\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\n\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\n\n<strong><em> </em></strong>\n\n<strong><em>Zaměření: Informační systémy</em></strong>\n\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\n\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\n\n&nbsp;\n\n<strong><em>Zaměření: Počítačové sítě</em></strong>\n\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\n\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\n\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("1306", "8", "_obor_1_text_obor", "field_5d7613e79e304");
INSERT INTO `wp_postmeta` VALUES("1307", "8", "obor_1_obrazek_obor_2", "28");
INSERT INTO `wp_postmeta` VALUES("1308", "8", "_obor_1_obrazek_obor_2", "field_5d7617af379d3");
INSERT INTO `wp_postmeta` VALUES("1309", "8", "obor_1_nazev_oboru_2", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("1310", "8", "_obor_1_nazev_oboru_2", "field_5d7617b9379d4");
INSERT INTO `wp_postmeta` VALUES("1311", "8", "obor_1_text_obor_2", "<strong><em>Zaměření: Strojírenství pro automobilový průmysl</em></strong>\n\n<strong><em> </em></strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n\n&nbsp;\n<ul>\n 	<li>Konstruktér, technolog, nástrojař,</li>\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\n 	<li>kontrola výroby,</li>\n 	<li>diagnostik vozidel,</li>\n 	<li>opravář vozidel, prodejce vozidel,</li>\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\n 	<li>obchodní zástupce na technickém úseku,</li>\n 	<li>studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1312", "8", "_obor_1_text_obor_2", "field_5d7617c2379d5");
INSERT INTO `wp_postmeta` VALUES("1313", "8", "nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("1314", "8", "_nazev_oboru", "field_5d7619d20878e");
INSERT INTO `wp_postmeta` VALUES("1315", "8", "obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1316", "8", "_obrazek_obor", "field_5d761a090878f");
INSERT INTO `wp_postmeta` VALUES("1317", "8", "text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\n 	<li>Studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1318", "8", "_text_obor", "field_5d761a1e08790");
INSERT INTO `wp_postmeta` VALUES("1319", "8", "nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("1320", "8", "_nazev_oboru_2", "field_5d761ba16e4bf");
INSERT INTO `wp_postmeta` VALUES("1321", "8", "obrazek_obor_2", "15");
INSERT INTO `wp_postmeta` VALUES("1322", "8", "_obrazek_obor_2", "field_5d761bad6e4c0");
INSERT INTO `wp_postmeta` VALUES("1323", "8", "text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\n\n&nbsp;\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\n 	<li>podniková ekonomika,</li>\n 	<li>personalistika a mzdy,</li>\n 	<li>finanční gramotnost,</li>\n 	<li>účetnictví a daňová evidence,</li>\n 	<li>právo,</li>\n 	<li>vedení kompletní podnikové agendy na PC.</li>\n</ul>\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</em></strong>\n\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\n\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</em></strong>\n\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\n\n<strong><em> </em></strong>\n\n<strong><em>Uplatnění absolventa:</em></strong>\n\nAbsolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.");
INSERT INTO `wp_postmeta` VALUES("1324", "8", "_text_obor_2", "field_5d761bb36e4c1");
INSERT INTO `wp_postmeta` VALUES("1325", "8", "nazev_oboru_3", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("1326", "8", "_nazev_oboru_3", "field_5d761c3894f15");
INSERT INTO `wp_postmeta` VALUES("1327", "8", "obrazek_obor_3", "32");
INSERT INTO `wp_postmeta` VALUES("1328", "8", "_obrazek_obor_3", "field_5d761c3f94f16");
INSERT INTO `wp_postmeta` VALUES("1329", "8", "text_obor_3", "<strong>Obor: INFORMAČNÍ TECHNOLOGIE</strong>\n\n<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n\n<strong><em> </em></strong>\n<ul>\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\n<ul>\n 	<li>Počítačová grafika; Robotika</li>\n 	<li>Programování; Elektrotechnika</li>\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\n</ul>\n</li>\n</ul>\n<ul>\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\n</ul>\n&nbsp;\n\n<strong><em>Zaměření: Počítačová technika a robotika</em></strong>\n\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\n\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\n\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\n\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\n\n<strong><em> </em></strong>\n\n<strong><em>Zaměření: Informační systémy</em></strong>\n\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\n\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\n\n&nbsp;\n\n<strong><em>Zaměření: Počítačové sítě</em></strong>\n\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\n\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\n\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("1330", "8", "_text_obor_3", "field_5d761c4294f17");
INSERT INTO `wp_postmeta` VALUES("1331", "8", "nazev_oboru_4", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("1332", "8", "_nazev_oboru_4", "field_5d761c4e94f18");
INSERT INTO `wp_postmeta` VALUES("1333", "8", "obrazek_obor_4", "28");
INSERT INTO `wp_postmeta` VALUES("1334", "8", "_obrazek_obor_4", "field_5d761c5394f19");
INSERT INTO `wp_postmeta` VALUES("1335", "8", "text_obor_4", "<strong>Obor: DOPRAVNÍ PROSTŘEDKY</strong>\n\n<strong><em>Zaměření: Strojírenství pro automobilový průmysl</em></strong>\n\n<strong><em> </em></strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n\n&nbsp;\n<ul>\n 	<li>Konstruktér, technolog, nástrojař,</li>\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\n 	<li>kontrola výroby,</li>\n 	<li>diagnostik vozidel,</li>\n 	<li>opravář vozidel, prodejce vozidel,</li>\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\n 	<li>obchodní zástupce na technickém úseku,</li>\n 	<li>studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1336", "8", "_text_obor_4", "field_5d761c5794f1a");
INSERT INTO `wp_postmeta` VALUES("1350", "62", "forminator_form_meta", "a:6:{s:6:\"fields\";a:0:{}s:8:\"settings\";a:77:{s:8:\"formName\";s:4:\"test\";s:22:\"admin-email-recipients\";a:1:{i:0;s:20:\"pavelkocan@pulary.cz\";}s:13:\"results_behav\";s:5:\"after\";s:12:\"visual_style\";s:4:\"list\";s:21:\"forminator-quiz-theme\";s:7:\"default\";s:11:\"msg_correct\";s:29:\"Correct! It was %UserAnswer%.\";s:13:\"msg_incorrect\";s:39:\"Wrong! It was %CorrectAnswer%, sorry...\";s:9:\"msg_count\";s:34:\"You got %YourNum%/%Total% correct!\";s:22:\"nowrong-title-settings\";s:0:\"\";s:19:\"nowrong-title-color\";s:7:\"#333333\";s:25:\"nowrong-title-font-family\";s:6:\"Roboto\";s:23:\"nowrong-title-font-size\";s:2:\"42\";s:25:\"nowrong-title-font-weight\";s:3:\"500\";s:28:\"nowrong-description-settings\";s:0:\"\";s:25:\"nowrong-description-color\";s:7:\"#8C8C8C\";s:31:\"nowrong-description-font-family\";s:6:\"Roboto\";s:29:\"nowrong-description-font-size\";s:2:\"20\";s:31:\"nowrong-description-font-weight\";s:3:\"400\";s:22:\"nowrong-image-settings\";s:0:\"\";s:26:\"nowrong-image-border-color\";s:7:\"#000000\";s:26:\"nowrong-image-border-width\";s:1:\"0\";s:26:\"nowrong-image-border-style\";s:5:\"solid\";s:25:\"nowrong-question-settings\";s:0:\"\";s:26:\"nowrong-question-font-size\";s:2:\"24\";s:28:\"nowrong-question-font-family\";s:6:\"Roboto\";s:28:\"nowrong-question-font-weight\";s:3:\"500\";s:23:\"nowrong-answer-settings\";s:0:\"\";s:28:\"nowrong-answer-border-static\";s:7:\"#EBEDEB\";s:27:\"nowrong-answer-border-hover\";s:7:\"#17A8E3\";s:28:\"nowrong-answer-border-active\";s:7:\"#17A8E3\";s:32:\"nowrong-answer-background-static\";s:7:\"#FAFAFA\";s:31:\"nowrong-answer-background-hover\";s:7:\"#F3FBFE\";s:32:\"nowrong-answer-background-active\";s:7:\"#F3FBFE\";s:27:\"nowrong-answer-chkbo-static\";s:7:\"#BFBFBF\";s:27:\"nowrong-answer-chkbo-active\";s:7:\"#17A8E3\";s:27:\"nowrong-answer-color-static\";s:7:\"#888888\";s:27:\"nowrong-answer-color-active\";s:7:\"#333333\";s:24:\"nowrong-answer-font-size\";s:2:\"14\";s:26:\"nowrong-answer-font-family\";s:6:\"Roboto\";s:26:\"nowrong-answer-font-weight\";s:3:\"500\";s:32:\"nowrong-submit-background-static\";s:7:\"#17A8E3\";s:31:\"nowrong-submit-background-hover\";s:7:\"#008FCA\";s:32:\"nowrong-submit-background-active\";s:7:\"#008FCA\";s:27:\"nowrong-submit-color-static\";s:7:\"#FFFFFF\";s:26:\"nowrong-submit-color-hover\";s:7:\"#FFFFFF\";s:27:\"nowrong-submit-color-active\";s:7:\"#FFFFFF\";s:26:\"nowrong-submit-font-family\";s:6:\"Roboto\";s:24:\"nowrong-submit-font-size\";s:2:\"14\";s:26:\"nowrong-submit-font-weight\";s:3:\"500\";s:30:\"nowrong-result-background-main\";s:7:\"#FAFAFA\";s:32:\"nowrong-result-background-header\";s:7:\"#FAFAFA\";s:27:\"nowrong-result-border-color\";s:7:\"#17A8E3\";s:25:\"nowrong-result-quiz-color\";s:7:\"#FFFFFF\";s:31:\"nowrong-result-quiz-font-family\";s:6:\"Roboto\";s:29:\"nowrong-result-quiz-font-size\";s:2:\"15\";s:31:\"nowrong-result-quiz-font-weight\";s:3:\"500\";s:33:\"nowrong-result-retake-font-family\";s:6:\"Roboto\";s:31:\"nowrong-result-retake-font-size\";s:2:\"13\";s:33:\"nowrong-result-retake-font-weight\";s:3:\"500\";s:39:\"nowrong-result-retake-background-static\";s:7:\"#17A8E3\";s:38:\"nowrong-result-retake-background-hover\";s:7:\"#17A8E3\";s:39:\"nowrong-result-retake-background-active\";s:7:\"#17A8E3\";s:30:\"nowrong-result-background-body\";s:7:\"#EBEDEB\";s:26:\"nowrong-result-title-color\";s:7:\"#333333\";s:32:\"nowrong-result-title-font-family\";s:6:\"Roboto\";s:30:\"nowrong-result-title-font-size\";s:2:\"15\";s:32:\"nowrong-result-title-font-weight\";s:3:\"500\";s:32:\"nowrong-result-description-color\";s:7:\"#4D4D4D\";s:38:\"nowrong-result-description-font-family\";s:6:\"Roboto\";s:36:\"nowrong-result-description-font-size\";s:2:\"13\";s:38:\"nowrong-result-description-font-weight\";s:3:\"400\";s:12:\"enable-share\";s:2:\"on\";s:9:\"quiz_name\";s:9:\"Otázka 1\";s:15:\"quiz_feat_image\";s:74:\"http://localhost/bavse/wp-content/uploads/2019/08/sps-slide-2-1024x683.jpg\";s:24:\"quiz_feat_image_filename\";s:15:\"sps-slide-2.jpg\";s:16:\"quiz_description\";s:1194:\"<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nulla non lectus sed nisl molestie malesuada. Morbi imperdiet, mauris ac auctor dictum, nisl ligula egestas nulla, et sollicitudin sem purus in lacus. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Proin mattis lacinia justo. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Fusce tellus. Fusce dui leo, imperdiet in, aliquam sit amet, feugiat eu, orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Curabitur sagittis hendrerit ante. Proin in tellus sit amet nibh dignissim sagittis. Suspendisse nisl. Proin in tellus sit amet nibh dignissim sagittis. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Praesent in mauris eu tortor porttitor accumsan. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam erat volutpat.</p>\";s:7:\"version\";s:5:\"1.8.1\";}s:9:\"client_id\";N;s:9:\"questions\";a:0:{}s:7:\"results\";a:3:{i:0;a:3:{s:4:\"slug\";s:16:\"result-2117-3472\";s:5:\"title\";s:5:\"jedna\";s:11:\"description\";s:0:\"\";}i:1;a:3:{s:4:\"slug\";s:16:\"result-7600-2493\";s:5:\"title\";s:3:\"dve\";s:11:\"description\";s:0:\"\";}i:2;a:3:{s:4:\"slug\";s:16:\"result-9673-7125\";s:5:\"title\";s:3:\"tri\";s:11:\"description\";s:0:\"\";}}s:9:\"quiz_type\";s:7:\"nowrong\";}");
INSERT INTO `wp_postmeta` VALUES("1351", "63", "forminator_form_meta", "a:6:{s:6:\"fields\";a:0:{}s:8:\"settings\";a:77:{s:8:\"formName\";s:6:\"Test 2\";s:22:\"admin-email-recipients\";a:1:{i:0;s:20:\"pavelkocan@pulary.cz\";}s:17:\"admin-email-title\";s:35:\"New Quiz Submission for {quiz_name}\";s:18:\"admin-email-editor\";s:150:\"You have a new quiz submission: <br/><br/>{quiz_answer}<br/><br/>Quiz results: <br/>{quiz_result} <br/>---<br/> This message was sent from {site_url}.\";s:13:\"results_behav\";s:5:\"after\";s:12:\"visual_style\";s:4:\"grid\";s:21:\"forminator-quiz-theme\";s:7:\"default\";s:11:\"msg_correct\";s:29:\"Correct! It was %UserAnswer%.\";s:13:\"msg_incorrect\";s:39:\"Wrong! It was %CorrectAnswer%, sorry...\";s:9:\"msg_count\";s:34:\"You got %YourNum%/%Total% correct!\";s:21:\"knowledge-title-color\";s:7:\"#333333\";s:27:\"knowledge-title-font-family\";s:6:\"Roboto\";s:25:\"knowledge-title-font-size\";s:2:\"42\";s:27:\"knowledge-title-font-weight\";s:3:\"500\";s:27:\"knowledge-description-color\";s:7:\"#8C8C8C\";s:33:\"knowledge-description-font-family\";s:6:\"Roboto\";s:31:\"knowledge-description-font-size\";s:2:\"20\";s:33:\"knowledge-description-font-weight\";s:3:\"400\";s:24:\"knowledge-question-color\";s:7:\"#333333\";s:30:\"knowledge-question-font-family\";s:6:\"Roboto\";s:28:\"knowledge-question-font-size\";s:2:\"24\";s:30:\"knowledge-question-font-weight\";s:3:\"500\";s:34:\"knowledge-answer-background-static\";s:7:\"#FAFAFA\";s:33:\"knowledge-answer-background-hover\";s:7:\"#F3FBFE\";s:34:\"knowledge-answer-background-active\";s:7:\"#F3FBFE\";s:27:\"knowledge-aright-background\";s:7:\"#F4FCF2\";s:27:\"knowledge-awrong-background\";s:7:\"#FDF2F2\";s:30:\"knowledge-answer-border-static\";s:7:\"#EBEDEB\";s:29:\"knowledge-answer-border-hover\";s:7:\"#17A8E3\";s:30:\"knowledge-answer-border-active\";s:7:\"#17A8E3\";s:23:\"knowledge-aright-border\";s:7:\"#0BC30B\";s:23:\"knowledge-awrong-border\";s:7:\"#DA0000\";s:29:\"knowledge-answer-color-static\";s:7:\"#888888\";s:29:\"knowledge-answer-color-active\";s:7:\"#333333\";s:22:\"knowledge-aright-color\";s:7:\"#0BC30B\";s:22:\"knowledge-awrong-color\";s:7:\"#DA0000\";s:26:\"knowledge-answer-font-size\";s:2:\"14\";s:28:\"knowledge-answer-font-family\";s:6:\"Roboto\";s:28:\"knowledge-answer-font-weight\";s:3:\"500\";s:36:\"knowledge-answer-check-border-static\";s:7:\"#BFBFBF\";s:36:\"knowledge-answer-check-border-active\";s:7:\"#17A8E3\";s:37:\"knowledge-answer-check-border-correct\";s:7:\"#0BC30B\";s:39:\"knowledge-answer-check-border-incorrect\";s:7:\"#DA0000\";s:40:\"knowledge-answer-check-background-static\";s:7:\"#FFFFFF\";s:40:\"knowledge-answer-check-background-active\";s:7:\"#17A8E3\";s:41:\"knowledge-answer-check-background-correct\";s:7:\"#0BC30B\";s:43:\"knowledge-answer-check-background-incorrect\";s:7:\"#DA0000\";s:24:\"knowledge-phrasing-color\";s:7:\"#4D4D4D\";s:28:\"knowledge-phrasing-font-size\";s:2:\"16\";s:30:\"knowledge-phrasing-font-family\";s:6:\"Roboto\";s:30:\"knowledge-phrasing-font-weight\";s:3:\"700\";s:34:\"knowledge-submit-background-static\";s:7:\"#bf2121\";s:33:\"knowledge-submit-background-hover\";s:7:\"#008FCA\";s:34:\"knowledge-submit-background-active\";s:7:\"#008FCA\";s:29:\"knowledge-submit-color-static\";s:7:\"#FFFFFF\";s:28:\"knowledge-submit-color-hover\";s:7:\"#FFFFFF\";s:29:\"knowledge-submit-color-active\";s:7:\"#FFFFFF\";s:28:\"knowledge-submit-font-family\";s:6:\"Roboto\";s:26:\"knowledge-submit-font-size\";s:2:\"14\";s:28:\"knowledge-submit-font-weight\";s:3:\"500\";s:23:\"knowledge-summary-color\";s:7:\"#333333\";s:29:\"knowledge-summary-font-family\";s:6:\"Roboto\";s:27:\"knowledge-summary-font-size\";s:2:\"40\";s:29:\"knowledge-summary-font-weight\";s:3:\"400\";s:12:\"enable-share\";s:2:\"on\";s:22:\"knowledge-sshare-color\";s:7:\"#4D4D4D\";s:28:\"knowledge-sshare-font-family\";s:6:\"Roboto\";s:26:\"knowledge-sshare-font-size\";s:2:\"20\";s:25:\"knowledge-social-facebook\";s:7:\"#0084BF\";s:24:\"knowledge-social-twitter\";s:7:\"#1DA1F2\";s:23:\"knowledge-social-google\";s:7:\"#DB4437\";s:36:\"forminator-knowledge-social-linkedin\";s:7:\"#0084BF\";s:21:\"knowledge-social-size\";s:2:\"36\";s:9:\"quiz_name\";s:5:\"Kvíz\";s:16:\"quiz_description\";s:356:\"<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nulla non lectus sed nisl molestie malesuada. Morbi imperdiet, mauris ac auctor dictum, nisl ligula egestas nulla, et sollicitudin sem purus in lacus. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Proin mattis lacinia justo. </p>\";s:24:\"knowledge-toggle-palette\";s:4:\"true\";s:7:\"version\";s:5:\"1.8.1\";}s:9:\"client_id\";N;s:9:\"questions\";a:3:{i:0;a:4:{s:4:\"slug\";s:18:\"question-4077-2549\";s:7:\"answers\";a:3:{i:0;a:3:{s:5:\"title\";s:1:\"1\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:1;a:3:{s:5:\"title\";s:1:\"2\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:2;a:4:{s:5:\"title\";s:1:\"3\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";s:6:\"toggle\";s:1:\"1\";}}s:4:\"type\";s:9:\"knowledge\";s:5:\"title\";s:9:\"Otázka 1\";}i:1;a:4:{s:4:\"slug\";s:18:\"question-5153-6613\";s:7:\"answers\";a:3:{i:0;a:3:{s:5:\"title\";s:1:\"1\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:1;a:4:{s:5:\"title\";s:1:\"2\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";s:6:\"toggle\";s:1:\"1\";}i:2;a:3:{s:5:\"title\";s:1:\"3\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}}s:4:\"type\";s:9:\"knowledge\";s:5:\"title\";s:9:\"Otázka 2\";}i:2;a:4:{s:4:\"slug\";s:18:\"question-9423-4568\";s:7:\"answers\";a:3:{i:0;a:4:{s:5:\"title\";s:1:\"1\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";s:6:\"toggle\";s:1:\"1\";}i:1;a:3:{s:5:\"title\";s:1:\"2\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:2;a:3:{s:5:\"title\";s:1:\"3\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}}s:4:\"type\";s:9:\"knowledge\";s:5:\"title\";s:9:\"Otázka 3\";}}s:7:\"results\";a:0:{}s:9:\"quiz_type\";s:9:\"knowledge\";}");
INSERT INTO `wp_postmeta` VALUES("1352", "119", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1353", "119", "_wp_page_template", "page-obory.php");
INSERT INTO `wp_postmeta` VALUES("1354", "119", "nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("1355", "119", "_nazev_oboru", "field_5d7619d20878e");
INSERT INTO `wp_postmeta` VALUES("1356", "119", "obrazek_obor", "123");
INSERT INTO `wp_postmeta` VALUES("1357", "119", "_obrazek_obor", "field_5d761a090878f");
INSERT INTO `wp_postmeta` VALUES("1358", "119", "text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\r\n\r\n<strong> </strong>\r\n\r\n<strong>Základní info o oboru:</strong>\r\n<ul>\r\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\r\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\r\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\r\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\r\n</ul>\r\n<strong>Uplatnění absolventa:</strong>\r\n<ul>\r\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\r\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\r\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\r\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\r\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\r\n 	<li>Studium na VŠ.</li>\r\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1359", "119", "_text_obor", "field_5d761a1e08790");
INSERT INTO `wp_postmeta` VALUES("1360", "119", "nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("1361", "119", "_nazev_oboru_2", "field_5d761ba16e4bf");
INSERT INTO `wp_postmeta` VALUES("1362", "119", "obrazek_obor_2", "126");
INSERT INTO `wp_postmeta` VALUES("1363", "119", "_obrazek_obor_2", "field_5d761bad6e4c0");
INSERT INTO `wp_postmeta` VALUES("1364", "119", "text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\r\n\r\n&nbsp;\r\n\r\n<strong>Základní info o oboru:</strong>\r\n<ul>\r\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\r\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\r\n 	<li>podniková ekonomika,</li>\r\n 	<li>personalistika a mzdy,</li>\r\n 	<li>finanční gramotnost,</li>\r\n 	<li>účetnictví a daňová evidence,</li>\r\n 	<li>právo,</li>\r\n 	<li>vedení kompletní podnikové agendy na PC.</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</strong>\r\n\r\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\r\n\r\n&nbsp;\r\n\r\n<strong>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</strong>\r\n\r\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\r\n\r\n&nbsp;\r\n\r\n<strong>Uplatnění absolventa:</strong>\r\n<ul>\r\n 	<li>Absolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.</li>\r\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1365", "119", "_text_obor_2", "field_5d761bb36e4c1");
INSERT INTO `wp_postmeta` VALUES("1366", "119", "nazev_oboru_3", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("1367", "119", "_nazev_oboru_3", "field_5d761c3894f15");
INSERT INTO `wp_postmeta` VALUES("1368", "119", "obrazek_obor_3", "125");
INSERT INTO `wp_postmeta` VALUES("1369", "119", "_obrazek_obor_3", "field_5d761c3f94f16");
INSERT INTO `wp_postmeta` VALUES("1370", "119", "text_obor_3", "<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\r\n\r\n<strong> </strong>\r\n\r\n<strong>Základní info o oboru:</strong>\r\n<ul>\r\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\r\n<ul>\r\n 	<li>Počítačová grafika; Robotika</li>\r\n 	<li>Programování; Elektrotechnika</li>\r\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\r\n</ul>\r\n</li>\r\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>Zaměření: Počítačová technika a robotika</strong>\r\n\r\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\r\n\r\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\r\n\r\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\r\n\r\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\r\n\r\n<strong><em> </em></strong>\r\n\r\n<strong>Zaměření: Informační systémy</strong>\r\n\r\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\r\n\r\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\r\n\r\n&nbsp;\r\n\r\n<strong>Zaměření: Počítačové sítě</strong>\r\n\r\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\r\n\r\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\r\n\r\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("1371", "119", "_text_obor_3", "field_5d761c4294f17");
INSERT INTO `wp_postmeta` VALUES("1372", "119", "nazev_oboru_4", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("1373", "119", "_nazev_oboru_4", "field_5d761c4e94f18");
INSERT INTO `wp_postmeta` VALUES("1374", "119", "obrazek_obor_4", "124");
INSERT INTO `wp_postmeta` VALUES("1375", "119", "_obrazek_obor_4", "field_5d761c5394f19");
INSERT INTO `wp_postmeta` VALUES("1376", "119", "text_obor_4", "<strong>Zaměření: Strojírenství pro automobilový průmysl</strong>\r\n\r\n<strong> </strong>\r\n\r\n<strong>Základní info o oboru:</strong>\r\n<ul>\r\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\r\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\r\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\r\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\r\n</ul>\r\n<strong>Uplatnění absolventa:</strong>\r\n<ul>\r\n 	<li>Konstruktér, technolog, nástrojař,</li>\r\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\r\n 	<li>kontrola výroby,</li>\r\n 	<li>diagnostik vozidel,</li>\r\n 	<li>opravář vozidel, prodejce vozidel,</li>\r\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\r\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\r\n 	<li>obchodní zástupce na technickém úseku,</li>\r\n 	<li>studium na VŠ.</li>\r\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1377", "119", "_text_obor_4", "field_5d761c5794f1a");
INSERT INTO `wp_postmeta` VALUES("1378", "119", "_edit_lock", "1571123181:1");
INSERT INTO `wp_postmeta` VALUES("1379", "123", "_wp_attached_file", "2019/09/sps-obory-04.jpg");
INSERT INTO `wp_postmeta` VALUES("1380", "123", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:24:\"2019/09/sps-obory-04.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"sps-obory-04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"sps-obory-04-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"sps-obory-04-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"sps-obory-04-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1381", "124", "_wp_attached_file", "2019/09/sps-obory-03.jpg");
INSERT INTO `wp_postmeta` VALUES("1382", "124", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:24:\"2019/09/sps-obory-03.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"sps-obory-03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"sps-obory-03-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"sps-obory-03-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"sps-obory-03-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1383", "125", "_wp_attached_file", "2019/09/sps-obory-02.jpg");
INSERT INTO `wp_postmeta` VALUES("1384", "125", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:24:\"2019/09/sps-obory-02.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"sps-obory-02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"sps-obory-02-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"sps-obory-02-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"sps-obory-02-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1385", "126", "_wp_attached_file", "2019/09/sps-obory-01.jpg");
INSERT INTO `wp_postmeta` VALUES("1386", "126", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:24:\"2019/09/sps-obory-01.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"sps-obory-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"sps-obory-01-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"sps-obory-01-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"sps-obory-01-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1387", "127", "nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("1388", "127", "_nazev_oboru", "field_5d7619d20878e");
INSERT INTO `wp_postmeta` VALUES("1389", "127", "obrazek_obor", "123");
INSERT INTO `wp_postmeta` VALUES("1390", "127", "_obrazek_obor", "field_5d761a090878f");
INSERT INTO `wp_postmeta` VALUES("1391", "127", "text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\r\n\r\n<strong> </strong>\r\n\r\n<strong>Základní info o oboru:</strong>\r\n<ul>\r\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\r\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\r\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\r\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\r\n</ul>\r\n<strong>Uplatnění absolventa:</strong>\r\n<ul>\r\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\r\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\r\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\r\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\r\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\r\n 	<li>Studium na VŠ.</li>\r\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1392", "127", "_text_obor", "field_5d761a1e08790");
INSERT INTO `wp_postmeta` VALUES("1393", "127", "nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("1394", "127", "_nazev_oboru_2", "field_5d761ba16e4bf");
INSERT INTO `wp_postmeta` VALUES("1395", "127", "obrazek_obor_2", "126");
INSERT INTO `wp_postmeta` VALUES("1396", "127", "_obrazek_obor_2", "field_5d761bad6e4c0");
INSERT INTO `wp_postmeta` VALUES("1397", "127", "text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\r\n\r\n&nbsp;\r\n\r\n<strong>Základní info o oboru:</strong>\r\n<ul>\r\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\r\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\r\n 	<li>podniková ekonomika,</li>\r\n 	<li>personalistika a mzdy,</li>\r\n 	<li>finanční gramotnost,</li>\r\n 	<li>účetnictví a daňová evidence,</li>\r\n 	<li>právo,</li>\r\n 	<li>vedení kompletní podnikové agendy na PC.</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</strong>\r\n\r\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\r\n\r\n&nbsp;\r\n\r\n<strong>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</strong>\r\n\r\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\r\n\r\n&nbsp;\r\n\r\n<strong>Uplatnění absolventa:</strong>\r\n<ul>\r\n 	<li>Absolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.</li>\r\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1398", "127", "_text_obor_2", "field_5d761bb36e4c1");
INSERT INTO `wp_postmeta` VALUES("1399", "127", "nazev_oboru_3", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("1400", "127", "_nazev_oboru_3", "field_5d761c3894f15");
INSERT INTO `wp_postmeta` VALUES("1401", "127", "obrazek_obor_3", "125");
INSERT INTO `wp_postmeta` VALUES("1402", "127", "_obrazek_obor_3", "field_5d761c3f94f16");
INSERT INTO `wp_postmeta` VALUES("1403", "127", "text_obor_3", "<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\r\n\r\n<strong> </strong>\r\n\r\n<strong>Základní info o oboru:</strong>\r\n<ul>\r\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\r\n<ul>\r\n 	<li>Počítačová grafika; Robotika</li>\r\n 	<li>Programování; Elektrotechnika</li>\r\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\r\n</ul>\r\n</li>\r\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\r\n</ul>\r\n&nbsp;\r\n\r\n<strong>Zaměření: Počítačová technika a robotika</strong>\r\n\r\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\r\n\r\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\r\n\r\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\r\n\r\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\r\n\r\n<strong><em> </em></strong>\r\n\r\n<strong>Zaměření: Informační systémy</strong>\r\n\r\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\r\n\r\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\r\n\r\n&nbsp;\r\n\r\n<strong>Zaměření: Počítačové sítě</strong>\r\n\r\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\r\n\r\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\r\n\r\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("1404", "127", "_text_obor_3", "field_5d761c4294f17");
INSERT INTO `wp_postmeta` VALUES("1405", "127", "nazev_oboru_4", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("1406", "127", "_nazev_oboru_4", "field_5d761c4e94f18");
INSERT INTO `wp_postmeta` VALUES("1407", "127", "obrazek_obor_4", "124");
INSERT INTO `wp_postmeta` VALUES("1408", "127", "_obrazek_obor_4", "field_5d761c5394f19");
INSERT INTO `wp_postmeta` VALUES("1409", "127", "text_obor_4", "<strong>Zaměření: Strojírenství pro automobilový průmysl</strong>\r\n\r\n<strong> </strong>\r\n\r\n<strong>Základní info o oboru:</strong>\r\n<ul>\r\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\r\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\r\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\r\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\r\n</ul>\r\n<strong>Uplatnění absolventa:</strong>\r\n<ul>\r\n 	<li>Konstruktér, technolog, nástrojař,</li>\r\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\r\n 	<li>kontrola výroby,</li>\r\n 	<li>diagnostik vozidel,</li>\r\n 	<li>opravář vozidel, prodejce vozidel,</li>\r\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\r\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\r\n 	<li>obchodní zástupce na technickém úseku,</li>\r\n 	<li>studium na VŠ.</li>\r\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1410", "127", "_text_obor_4", "field_5d761c5794f1a");
INSERT INTO `wp_postmeta` VALUES("1411", "128", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1412", "128", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1413", "128", "_menu_item_object_id", "8");
INSERT INTO `wp_postmeta` VALUES("1414", "128", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1415", "128", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1416", "128", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1417", "128", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1418", "128", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1419", "128", "_menu_item_orphaned", "1568098013");
INSERT INTO `wp_postmeta` VALUES("1420", "129", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1421", "129", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1422", "129", "_menu_item_object_id", "8");
INSERT INTO `wp_postmeta` VALUES("1423", "129", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1424", "129", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1425", "129", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1426", "129", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1427", "129", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1428", "129", "_menu_item_orphaned", "1568098013");
INSERT INTO `wp_postmeta` VALUES("1429", "130", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1430", "130", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1431", "130", "_menu_item_object_id", "119");
INSERT INTO `wp_postmeta` VALUES("1432", "130", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1433", "130", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1434", "130", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1435", "130", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1436", "130", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1437", "130", "_menu_item_orphaned", "1568098014");
INSERT INTO `wp_postmeta` VALUES("1441", "133", "_wp_attached_file", "2019/09/bavse_slide_01.jpg");
INSERT INTO `wp_postmeta` VALUES("1442", "133", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:26:\"2019/09/bavse_slide_01.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"bavse_slide_01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"bavse_slide_01-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"bavse_slide_01-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"bavse_slide_01-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1443", "134", "_wp_attached_file", "2019/09/bavse_slide_02.jpg");
INSERT INTO `wp_postmeta` VALUES("1444", "134", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:26:\"2019/09/bavse_slide_02.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"bavse_slide_02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"bavse_slide_02-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"bavse_slide_02-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"bavse_slide_02-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1445", "135", "_wp_attached_file", "2019/09/bavse_slide_03.jpg");
INSERT INTO `wp_postmeta` VALUES("1446", "135", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:26:\"2019/09/bavse_slide_03.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"bavse_slide_03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"bavse_slide_03-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"bavse_slide_03-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"bavse_slide_03-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1447", "136", "_wp_attached_file", "2019/09/bavse_slide_04.jpg");
INSERT INTO `wp_postmeta` VALUES("1448", "136", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1208;s:4:\"file\";s:26:\"2019/09/bavse_slide_04.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"bavse_slide_04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"bavse_slide_04-300x189.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:189;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"bavse_slide_04-768x483.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:483;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"bavse_slide_04-1024x644.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:644;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1449", "137", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("1450", "137", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("1451", "137", "slider_0_slider_image", "133");
INSERT INTO `wp_postmeta` VALUES("1452", "137", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1453", "137", "slider_1_slider_image", "134");
INSERT INTO `wp_postmeta` VALUES("1454", "137", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1455", "137", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("1456", "137", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("1457", "137", "slider_2_slider_image", "135");
INSERT INTO `wp_postmeta` VALUES("1458", "137", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1459", "137", "slider_3_slider_image", "136");
INSERT INTO `wp_postmeta` VALUES("1460", "137", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1461", "137", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1462", "137", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1463", "137", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1464", "137", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1465", "137", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("1466", "137", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1467", "137", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("1468", "137", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1469", "137", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1470", "137", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1471", "137", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1472", "137", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1473", "137", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("1474", "137", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1475", "137", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1476", "137", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1477", "137", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("1478", "137", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1479", "137", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("1480", "137", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1481", "137", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1482", "137", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1483", "137", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1484", "137", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1485", "137", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1486", "137", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("1487", "137", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš.\r\n");
INSERT INTO `wp_postmeta` VALUES("1488", "137", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("1489", "137", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1490", "137", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("1491", "137", "titulek_2", "Tady chillujeme");
INSERT INTO `wp_postmeta` VALUES("1492", "137", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("1493", "137", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("1494", "137", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("1495", "137", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("1496", "137", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("1497", "137", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("1498", "137", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("1499", "137", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny.\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("1500", "137", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("1501", "137", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("1502", "137", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("1503", "137", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("1504", "137", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("1505", "137", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("1506", "137", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("1507", "137", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("1508", "137", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("1509", "137", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("1510", "137", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("1511", "137", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("1512", "137", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1513", "137", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("1514", "137", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("1515", "137", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("1516", "137", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1517", "137", "video_1", "81");
INSERT INTO `wp_postmeta` VALUES("1518", "137", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("1519", "137", "video_2", "80");
INSERT INTO `wp_postmeta` VALUES("1520", "137", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("1521", "137", "video_3", "79");
INSERT INTO `wp_postmeta` VALUES("1522", "137", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("1523", "137", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1524", "137", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("1525", "137", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1526", "137", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("1527", "137", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1528", "137", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("1529", "137", "video_1_odkaz", "<iframe  src=\"https://www.youtube.com/embed/Kkx2erP5Bn4\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1530", "137", "_video_1_odkaz", "field_5d664c588221e");
INSERT INTO `wp_postmeta` VALUES("1531", "137", "video_2_odkaz", "<iframe  src=\"https://www.youtube.com/embed/oQo9LlYgCaE\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1532", "137", "_video_2_odkaz", "field_5d664c738221f");
INSERT INTO `wp_postmeta` VALUES("1533", "137", "video_3_odkaz", "<iframe src=\"https://www.youtube.com/embed/1qfoaX59qrU\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1534", "137", "_video_3_odkaz", "field_5d664c7d82220");
INSERT INTO `wp_postmeta` VALUES("1535", "137", "obor_0_obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1536", "137", "_obor_0_obrazek_obor", "field_5d7613d39e303");
INSERT INTO `wp_postmeta` VALUES("1537", "137", "obor_0_nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("1538", "137", "_obor_0_nazev_oboru", "field_5d76142bd4876");
INSERT INTO `wp_postmeta` VALUES("1539", "137", "obor_0_text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\n 	<li>Studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1540", "137", "_obor_0_text_obor", "field_5d7613e79e304");
INSERT INTO `wp_postmeta` VALUES("1541", "137", "obor", "2");
INSERT INTO `wp_postmeta` VALUES("1542", "137", "_obor", "field_5d7613c69e302");
INSERT INTO `wp_postmeta` VALUES("1543", "137", "obor_0_obrazek_obor_2", "15");
INSERT INTO `wp_postmeta` VALUES("1544", "137", "_obor_0_obrazek_obor_2", "field_5d7617af379d3");
INSERT INTO `wp_postmeta` VALUES("1545", "137", "obor_0_nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("1546", "137", "_obor_0_nazev_oboru_2", "field_5d7617b9379d4");
INSERT INTO `wp_postmeta` VALUES("1547", "137", "obor_0_text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\n\n&nbsp;\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\n 	<li>podniková ekonomika,</li>\n 	<li>personalistika a mzdy,</li>\n 	<li>finanční gramotnost,</li>\n 	<li>účetnictví a daňová evidence,</li>\n 	<li>právo,</li>\n 	<li>vedení kompletní podnikové agendy na PC.</li>\n</ul>\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</em></strong>\n\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\n\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</em></strong>\n\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\n\n<strong><em> </em></strong>\n\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>Absolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1548", "137", "_obor_0_text_obor_2", "field_5d7617c2379d5");
INSERT INTO `wp_postmeta` VALUES("1549", "137", "obor_1_obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1550", "137", "_obor_1_obrazek_obor", "field_5d7613d39e303");
INSERT INTO `wp_postmeta` VALUES("1551", "137", "obor_1_nazev_oboru", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("1552", "137", "_obor_1_nazev_oboru", "field_5d76142bd4876");
INSERT INTO `wp_postmeta` VALUES("1553", "137", "obor_1_text_obor", "<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n\n<strong><em> </em></strong>\n<ul>\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\n<ul>\n 	<li>Počítačová grafika; Robotika</li>\n 	<li>Programování; Elektrotechnika</li>\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\n</ul>\n</li>\n</ul>\n<ul>\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\n</ul>\n&nbsp;\n\n<strong><em>Zaměření: Počítačová technika a robotika</em></strong>\n\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\n\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\n\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\n\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\n\n<strong><em> </em></strong>\n\n<strong><em>Zaměření: Informační systémy</em></strong>\n\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\n\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\n\n&nbsp;\n\n<strong><em>Zaměření: Počítačové sítě</em></strong>\n\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\n\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\n\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("1554", "137", "_obor_1_text_obor", "field_5d7613e79e304");
INSERT INTO `wp_postmeta` VALUES("1555", "137", "obor_1_obrazek_obor_2", "28");
INSERT INTO `wp_postmeta` VALUES("1556", "137", "_obor_1_obrazek_obor_2", "field_5d7617af379d3");
INSERT INTO `wp_postmeta` VALUES("1557", "137", "obor_1_nazev_oboru_2", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("1558", "137", "_obor_1_nazev_oboru_2", "field_5d7617b9379d4");
INSERT INTO `wp_postmeta` VALUES("1559", "137", "obor_1_text_obor_2", "<strong><em>Zaměření: Strojírenství pro automobilový průmysl</em></strong>\n\n<strong><em> </em></strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n\n&nbsp;\n<ul>\n 	<li>Konstruktér, technolog, nástrojař,</li>\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\n 	<li>kontrola výroby,</li>\n 	<li>diagnostik vozidel,</li>\n 	<li>opravář vozidel, prodejce vozidel,</li>\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\n 	<li>obchodní zástupce na technickém úseku,</li>\n 	<li>studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1560", "137", "_obor_1_text_obor_2", "field_5d7617c2379d5");
INSERT INTO `wp_postmeta` VALUES("1561", "137", "nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("1562", "137", "_nazev_oboru", "field_5d7619d20878e");
INSERT INTO `wp_postmeta` VALUES("1563", "137", "obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1564", "137", "_obrazek_obor", "field_5d761a090878f");
INSERT INTO `wp_postmeta` VALUES("1565", "137", "text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\n 	<li>Studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1566", "137", "_text_obor", "field_5d761a1e08790");
INSERT INTO `wp_postmeta` VALUES("1567", "137", "nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("1568", "137", "_nazev_oboru_2", "field_5d761ba16e4bf");
INSERT INTO `wp_postmeta` VALUES("1569", "137", "obrazek_obor_2", "15");
INSERT INTO `wp_postmeta` VALUES("1570", "137", "_obrazek_obor_2", "field_5d761bad6e4c0");
INSERT INTO `wp_postmeta` VALUES("1571", "137", "text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\n\n&nbsp;\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\n 	<li>podniková ekonomika,</li>\n 	<li>personalistika a mzdy,</li>\n 	<li>finanční gramotnost,</li>\n 	<li>účetnictví a daňová evidence,</li>\n 	<li>právo,</li>\n 	<li>vedení kompletní podnikové agendy na PC.</li>\n</ul>\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</em></strong>\n\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\n\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</em></strong>\n\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\n\n<strong><em> </em></strong>\n\n<strong><em>Uplatnění absolventa:</em></strong>\n\nAbsolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.");
INSERT INTO `wp_postmeta` VALUES("1572", "137", "_text_obor_2", "field_5d761bb36e4c1");
INSERT INTO `wp_postmeta` VALUES("1573", "137", "nazev_oboru_3", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("1574", "137", "_nazev_oboru_3", "field_5d761c3894f15");
INSERT INTO `wp_postmeta` VALUES("1575", "137", "obrazek_obor_3", "32");
INSERT INTO `wp_postmeta` VALUES("1576", "137", "_obrazek_obor_3", "field_5d761c3f94f16");
INSERT INTO `wp_postmeta` VALUES("1577", "137", "text_obor_3", "<strong>Obor: INFORMAČNÍ TECHNOLOGIE</strong>\n\n<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n\n<strong><em> </em></strong>\n<ul>\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\n<ul>\n 	<li>Počítačová grafika; Robotika</li>\n 	<li>Programování; Elektrotechnika</li>\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\n</ul>\n</li>\n</ul>\n<ul>\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\n</ul>\n&nbsp;\n\n<strong><em>Zaměření: Počítačová technika a robotika</em></strong>\n\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\n\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\n\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\n\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\n\n<strong><em> </em></strong>\n\n<strong><em>Zaměření: Informační systémy</em></strong>\n\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\n\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\n\n&nbsp;\n\n<strong><em>Zaměření: Počítačové sítě</em></strong>\n\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\n\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\n\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("1578", "137", "_text_obor_3", "field_5d761c4294f17");
INSERT INTO `wp_postmeta` VALUES("1579", "137", "nazev_oboru_4", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("1580", "137", "_nazev_oboru_4", "field_5d761c4e94f18");
INSERT INTO `wp_postmeta` VALUES("1581", "137", "obrazek_obor_4", "28");
INSERT INTO `wp_postmeta` VALUES("1582", "137", "_obrazek_obor_4", "field_5d761c5394f19");
INSERT INTO `wp_postmeta` VALUES("1583", "137", "text_obor_4", "<strong>Obor: DOPRAVNÍ PROSTŘEDKY</strong>\n\n<strong><em>Zaměření: Strojírenství pro automobilový průmysl</em></strong>\n\n<strong><em> </em></strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n\n&nbsp;\n<ul>\n 	<li>Konstruktér, technolog, nástrojař,</li>\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\n 	<li>kontrola výroby,</li>\n 	<li>diagnostik vozidel,</li>\n 	<li>opravář vozidel, prodejce vozidel,</li>\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\n 	<li>obchodní zástupce na technickém úseku,</li>\n 	<li>studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1584", "137", "_text_obor_4", "field_5d761c5794f1a");
INSERT INTO `wp_postmeta` VALUES("1585", "138", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("1586", "138", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("1587", "138", "slider_0_slider_image", "136");
INSERT INTO `wp_postmeta` VALUES("1588", "138", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1589", "138", "slider_1_slider_image", "133");
INSERT INTO `wp_postmeta` VALUES("1590", "138", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1591", "138", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("1592", "138", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("1593", "138", "slider_2_slider_image", "135");
INSERT INTO `wp_postmeta` VALUES("1594", "138", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1595", "138", "slider_3_slider_image", "134");
INSERT INTO `wp_postmeta` VALUES("1596", "138", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1597", "138", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1598", "138", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1599", "138", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1600", "138", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1601", "138", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("1602", "138", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1603", "138", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("1604", "138", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1605", "138", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1606", "138", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1607", "138", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1608", "138", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1609", "138", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("1610", "138", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1611", "138", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1612", "138", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1613", "138", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("1614", "138", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1615", "138", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("1616", "138", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1617", "138", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1618", "138", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1619", "138", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1620", "138", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1621", "138", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1622", "138", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("1623", "138", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš.\r\n");
INSERT INTO `wp_postmeta` VALUES("1624", "138", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("1625", "138", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1626", "138", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("1627", "138", "titulek_2", "Tady chillujeme");
INSERT INTO `wp_postmeta` VALUES("1628", "138", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("1629", "138", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("1630", "138", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("1631", "138", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("1632", "138", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("1633", "138", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("1634", "138", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("1635", "138", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny.\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("1636", "138", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("1637", "138", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("1638", "138", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("1639", "138", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("1640", "138", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("1641", "138", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("1642", "138", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("1643", "138", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("1644", "138", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("1645", "138", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("1646", "138", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("1647", "138", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("1648", "138", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1649", "138", "obrazek_5", "30");
INSERT INTO `wp_postmeta` VALUES("1650", "138", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("1651", "138", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("1652", "138", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1653", "138", "video_1", "81");
INSERT INTO `wp_postmeta` VALUES("1654", "138", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("1655", "138", "video_2", "80");
INSERT INTO `wp_postmeta` VALUES("1656", "138", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("1657", "138", "video_3", "79");
INSERT INTO `wp_postmeta` VALUES("1658", "138", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("1659", "138", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1660", "138", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("1661", "138", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1662", "138", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("1663", "138", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1664", "138", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("1665", "138", "video_1_odkaz", "<iframe  src=\"https://www.youtube.com/embed/Kkx2erP5Bn4\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1666", "138", "_video_1_odkaz", "field_5d664c588221e");
INSERT INTO `wp_postmeta` VALUES("1667", "138", "video_2_odkaz", "<iframe  src=\"https://www.youtube.com/embed/oQo9LlYgCaE\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1668", "138", "_video_2_odkaz", "field_5d664c738221f");
INSERT INTO `wp_postmeta` VALUES("1669", "138", "video_3_odkaz", "<iframe src=\"https://www.youtube.com/embed/1qfoaX59qrU\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1670", "138", "_video_3_odkaz", "field_5d664c7d82220");
INSERT INTO `wp_postmeta` VALUES("1671", "138", "obor_0_obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1672", "138", "_obor_0_obrazek_obor", "field_5d7613d39e303");
INSERT INTO `wp_postmeta` VALUES("1673", "138", "obor_0_nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("1674", "138", "_obor_0_nazev_oboru", "field_5d76142bd4876");
INSERT INTO `wp_postmeta` VALUES("1675", "138", "obor_0_text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\n 	<li>Studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1676", "138", "_obor_0_text_obor", "field_5d7613e79e304");
INSERT INTO `wp_postmeta` VALUES("1677", "138", "obor", "2");
INSERT INTO `wp_postmeta` VALUES("1678", "138", "_obor", "field_5d7613c69e302");
INSERT INTO `wp_postmeta` VALUES("1679", "138", "obor_0_obrazek_obor_2", "15");
INSERT INTO `wp_postmeta` VALUES("1680", "138", "_obor_0_obrazek_obor_2", "field_5d7617af379d3");
INSERT INTO `wp_postmeta` VALUES("1681", "138", "obor_0_nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("1682", "138", "_obor_0_nazev_oboru_2", "field_5d7617b9379d4");
INSERT INTO `wp_postmeta` VALUES("1683", "138", "obor_0_text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\n\n&nbsp;\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\n 	<li>podniková ekonomika,</li>\n 	<li>personalistika a mzdy,</li>\n 	<li>finanční gramotnost,</li>\n 	<li>účetnictví a daňová evidence,</li>\n 	<li>právo,</li>\n 	<li>vedení kompletní podnikové agendy na PC.</li>\n</ul>\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</em></strong>\n\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\n\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</em></strong>\n\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\n\n<strong><em> </em></strong>\n\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>Absolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1684", "138", "_obor_0_text_obor_2", "field_5d7617c2379d5");
INSERT INTO `wp_postmeta` VALUES("1685", "138", "obor_1_obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1686", "138", "_obor_1_obrazek_obor", "field_5d7613d39e303");
INSERT INTO `wp_postmeta` VALUES("1687", "138", "obor_1_nazev_oboru", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("1688", "138", "_obor_1_nazev_oboru", "field_5d76142bd4876");
INSERT INTO `wp_postmeta` VALUES("1689", "138", "obor_1_text_obor", "<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n\n<strong><em> </em></strong>\n<ul>\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\n<ul>\n 	<li>Počítačová grafika; Robotika</li>\n 	<li>Programování; Elektrotechnika</li>\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\n</ul>\n</li>\n</ul>\n<ul>\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\n</ul>\n&nbsp;\n\n<strong><em>Zaměření: Počítačová technika a robotika</em></strong>\n\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\n\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\n\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\n\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\n\n<strong><em> </em></strong>\n\n<strong><em>Zaměření: Informační systémy</em></strong>\n\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\n\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\n\n&nbsp;\n\n<strong><em>Zaměření: Počítačové sítě</em></strong>\n\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\n\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\n\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("1690", "138", "_obor_1_text_obor", "field_5d7613e79e304");
INSERT INTO `wp_postmeta` VALUES("1691", "138", "obor_1_obrazek_obor_2", "28");
INSERT INTO `wp_postmeta` VALUES("1692", "138", "_obor_1_obrazek_obor_2", "field_5d7617af379d3");
INSERT INTO `wp_postmeta` VALUES("1693", "138", "obor_1_nazev_oboru_2", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("1694", "138", "_obor_1_nazev_oboru_2", "field_5d7617b9379d4");
INSERT INTO `wp_postmeta` VALUES("1695", "138", "obor_1_text_obor_2", "<strong><em>Zaměření: Strojírenství pro automobilový průmysl</em></strong>\n\n<strong><em> </em></strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n\n&nbsp;\n<ul>\n 	<li>Konstruktér, technolog, nástrojař,</li>\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\n 	<li>kontrola výroby,</li>\n 	<li>diagnostik vozidel,</li>\n 	<li>opravář vozidel, prodejce vozidel,</li>\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\n 	<li>obchodní zástupce na technickém úseku,</li>\n 	<li>studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1696", "138", "_obor_1_text_obor_2", "field_5d7617c2379d5");
INSERT INTO `wp_postmeta` VALUES("1697", "138", "nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("1698", "138", "_nazev_oboru", "field_5d7619d20878e");
INSERT INTO `wp_postmeta` VALUES("1699", "138", "obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1700", "138", "_obrazek_obor", "field_5d761a090878f");
INSERT INTO `wp_postmeta` VALUES("1701", "138", "text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\n 	<li>Studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1702", "138", "_text_obor", "field_5d761a1e08790");
INSERT INTO `wp_postmeta` VALUES("1703", "138", "nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("1704", "138", "_nazev_oboru_2", "field_5d761ba16e4bf");
INSERT INTO `wp_postmeta` VALUES("1705", "138", "obrazek_obor_2", "15");
INSERT INTO `wp_postmeta` VALUES("1706", "138", "_obrazek_obor_2", "field_5d761bad6e4c0");
INSERT INTO `wp_postmeta` VALUES("1707", "138", "text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\n\n&nbsp;\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\n 	<li>podniková ekonomika,</li>\n 	<li>personalistika a mzdy,</li>\n 	<li>finanční gramotnost,</li>\n 	<li>účetnictví a daňová evidence,</li>\n 	<li>právo,</li>\n 	<li>vedení kompletní podnikové agendy na PC.</li>\n</ul>\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</em></strong>\n\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\n\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</em></strong>\n\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\n\n<strong><em> </em></strong>\n\n<strong><em>Uplatnění absolventa:</em></strong>\n\nAbsolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.");
INSERT INTO `wp_postmeta` VALUES("1708", "138", "_text_obor_2", "field_5d761bb36e4c1");
INSERT INTO `wp_postmeta` VALUES("1709", "138", "nazev_oboru_3", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("1710", "138", "_nazev_oboru_3", "field_5d761c3894f15");
INSERT INTO `wp_postmeta` VALUES("1711", "138", "obrazek_obor_3", "32");
INSERT INTO `wp_postmeta` VALUES("1712", "138", "_obrazek_obor_3", "field_5d761c3f94f16");
INSERT INTO `wp_postmeta` VALUES("1713", "138", "text_obor_3", "<strong>Obor: INFORMAČNÍ TECHNOLOGIE</strong>\n\n<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n\n<strong><em> </em></strong>\n<ul>\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\n<ul>\n 	<li>Počítačová grafika; Robotika</li>\n 	<li>Programování; Elektrotechnika</li>\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\n</ul>\n</li>\n</ul>\n<ul>\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\n</ul>\n&nbsp;\n\n<strong><em>Zaměření: Počítačová technika a robotika</em></strong>\n\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\n\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\n\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\n\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\n\n<strong><em> </em></strong>\n\n<strong><em>Zaměření: Informační systémy</em></strong>\n\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\n\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\n\n&nbsp;\n\n<strong><em>Zaměření: Počítačové sítě</em></strong>\n\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\n\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\n\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("1714", "138", "_text_obor_3", "field_5d761c4294f17");
INSERT INTO `wp_postmeta` VALUES("1715", "138", "nazev_oboru_4", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("1716", "138", "_nazev_oboru_4", "field_5d761c4e94f18");
INSERT INTO `wp_postmeta` VALUES("1717", "138", "obrazek_obor_4", "28");
INSERT INTO `wp_postmeta` VALUES("1718", "138", "_obrazek_obor_4", "field_5d761c5394f19");
INSERT INTO `wp_postmeta` VALUES("1719", "138", "text_obor_4", "<strong>Obor: DOPRAVNÍ PROSTŘEDKY</strong>\n\n<strong><em>Zaměření: Strojírenství pro automobilový průmysl</em></strong>\n\n<strong><em> </em></strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n\n&nbsp;\n<ul>\n 	<li>Konstruktér, technolog, nástrojař,</li>\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\n 	<li>kontrola výroby,</li>\n 	<li>diagnostik vozidel,</li>\n 	<li>opravář vozidel, prodejce vozidel,</li>\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\n 	<li>obchodní zástupce na technickém úseku,</li>\n 	<li>studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1720", "138", "_text_obor_4", "field_5d761c5794f1a");
INSERT INTO `wp_postmeta` VALUES("1721", "139", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("1722", "139", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("1723", "139", "slider_0_slider_image", "136");
INSERT INTO `wp_postmeta` VALUES("1724", "139", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1725", "139", "slider_1_slider_image", "133");
INSERT INTO `wp_postmeta` VALUES("1726", "139", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1727", "139", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("1728", "139", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("1729", "139", "slider_2_slider_image", "135");
INSERT INTO `wp_postmeta` VALUES("1730", "139", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1731", "139", "slider_3_slider_image", "134");
INSERT INTO `wp_postmeta` VALUES("1732", "139", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1733", "139", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1734", "139", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1735", "139", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1736", "139", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1737", "139", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("1738", "139", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1739", "139", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("1740", "139", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1741", "139", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1742", "139", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1743", "139", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1744", "139", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1745", "139", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("1746", "139", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1747", "139", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1748", "139", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1749", "139", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("1750", "139", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1751", "139", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("1752", "139", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1753", "139", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1754", "139", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1755", "139", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1756", "139", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1757", "139", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1758", "139", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("1759", "139", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš.\r\n");
INSERT INTO `wp_postmeta` VALUES("1760", "139", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("1761", "139", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1762", "139", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("1763", "139", "titulek_2", "Tady chillujeme");
INSERT INTO `wp_postmeta` VALUES("1764", "139", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("1765", "139", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("1766", "139", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("1767", "139", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("1768", "139", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("1769", "139", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("1770", "139", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("1771", "139", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny.\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("1772", "139", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("1773", "139", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("1774", "139", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("1775", "139", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("1776", "139", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("1777", "139", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("1778", "139", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("1779", "139", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("1780", "139", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("1781", "139", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("1782", "139", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("1783", "139", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("1784", "139", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1785", "139", "obrazek_5", "31");
INSERT INTO `wp_postmeta` VALUES("1786", "139", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("1787", "139", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("1788", "139", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("1789", "139", "video_1", "81");
INSERT INTO `wp_postmeta` VALUES("1790", "139", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("1791", "139", "video_2", "80");
INSERT INTO `wp_postmeta` VALUES("1792", "139", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("1793", "139", "video_3", "79");
INSERT INTO `wp_postmeta` VALUES("1794", "139", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("1795", "139", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1796", "139", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("1797", "139", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1798", "139", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("1799", "139", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("1800", "139", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("1801", "139", "video_1_odkaz", "<iframe  src=\"https://www.youtube.com/embed/Kkx2erP5Bn4\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1802", "139", "_video_1_odkaz", "field_5d664c588221e");
INSERT INTO `wp_postmeta` VALUES("1803", "139", "video_2_odkaz", "<iframe  src=\"https://www.youtube.com/embed/oQo9LlYgCaE\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1804", "139", "_video_2_odkaz", "field_5d664c738221f");
INSERT INTO `wp_postmeta` VALUES("1805", "139", "video_3_odkaz", "<iframe src=\"https://www.youtube.com/embed/1qfoaX59qrU\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1806", "139", "_video_3_odkaz", "field_5d664c7d82220");
INSERT INTO `wp_postmeta` VALUES("1807", "139", "obor_0_obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1808", "139", "_obor_0_obrazek_obor", "field_5d7613d39e303");
INSERT INTO `wp_postmeta` VALUES("1809", "139", "obor_0_nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("1810", "139", "_obor_0_nazev_oboru", "field_5d76142bd4876");
INSERT INTO `wp_postmeta` VALUES("1811", "139", "obor_0_text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\n 	<li>Studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1812", "139", "_obor_0_text_obor", "field_5d7613e79e304");
INSERT INTO `wp_postmeta` VALUES("1813", "139", "obor", "2");
INSERT INTO `wp_postmeta` VALUES("1814", "139", "_obor", "field_5d7613c69e302");
INSERT INTO `wp_postmeta` VALUES("1815", "139", "obor_0_obrazek_obor_2", "15");
INSERT INTO `wp_postmeta` VALUES("1816", "139", "_obor_0_obrazek_obor_2", "field_5d7617af379d3");
INSERT INTO `wp_postmeta` VALUES("1817", "139", "obor_0_nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("1818", "139", "_obor_0_nazev_oboru_2", "field_5d7617b9379d4");
INSERT INTO `wp_postmeta` VALUES("1819", "139", "obor_0_text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\n\n&nbsp;\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\n 	<li>podniková ekonomika,</li>\n 	<li>personalistika a mzdy,</li>\n 	<li>finanční gramotnost,</li>\n 	<li>účetnictví a daňová evidence,</li>\n 	<li>právo,</li>\n 	<li>vedení kompletní podnikové agendy na PC.</li>\n</ul>\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</em></strong>\n\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\n\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</em></strong>\n\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\n\n<strong><em> </em></strong>\n\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>Absolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1820", "139", "_obor_0_text_obor_2", "field_5d7617c2379d5");
INSERT INTO `wp_postmeta` VALUES("1821", "139", "obor_1_obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1822", "139", "_obor_1_obrazek_obor", "field_5d7613d39e303");
INSERT INTO `wp_postmeta` VALUES("1823", "139", "obor_1_nazev_oboru", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("1824", "139", "_obor_1_nazev_oboru", "field_5d76142bd4876");
INSERT INTO `wp_postmeta` VALUES("1825", "139", "obor_1_text_obor", "<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n\n<strong><em> </em></strong>\n<ul>\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\n<ul>\n 	<li>Počítačová grafika; Robotika</li>\n 	<li>Programování; Elektrotechnika</li>\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\n</ul>\n</li>\n</ul>\n<ul>\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\n</ul>\n&nbsp;\n\n<strong><em>Zaměření: Počítačová technika a robotika</em></strong>\n\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\n\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\n\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\n\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\n\n<strong><em> </em></strong>\n\n<strong><em>Zaměření: Informační systémy</em></strong>\n\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\n\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\n\n&nbsp;\n\n<strong><em>Zaměření: Počítačové sítě</em></strong>\n\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\n\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\n\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("1826", "139", "_obor_1_text_obor", "field_5d7613e79e304");
INSERT INTO `wp_postmeta` VALUES("1827", "139", "obor_1_obrazek_obor_2", "28");
INSERT INTO `wp_postmeta` VALUES("1828", "139", "_obor_1_obrazek_obor_2", "field_5d7617af379d3");
INSERT INTO `wp_postmeta` VALUES("1829", "139", "obor_1_nazev_oboru_2", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("1830", "139", "_obor_1_nazev_oboru_2", "field_5d7617b9379d4");
INSERT INTO `wp_postmeta` VALUES("1831", "139", "obor_1_text_obor_2", "<strong><em>Zaměření: Strojírenství pro automobilový průmysl</em></strong>\n\n<strong><em> </em></strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n\n&nbsp;\n<ul>\n 	<li>Konstruktér, technolog, nástrojař,</li>\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\n 	<li>kontrola výroby,</li>\n 	<li>diagnostik vozidel,</li>\n 	<li>opravář vozidel, prodejce vozidel,</li>\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\n 	<li>obchodní zástupce na technickém úseku,</li>\n 	<li>studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1832", "139", "_obor_1_text_obor_2", "field_5d7617c2379d5");
INSERT INTO `wp_postmeta` VALUES("1833", "139", "nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("1834", "139", "_nazev_oboru", "field_5d7619d20878e");
INSERT INTO `wp_postmeta` VALUES("1835", "139", "obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("1836", "139", "_obrazek_obor", "field_5d761a090878f");
INSERT INTO `wp_postmeta` VALUES("1837", "139", "text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\n 	<li>Studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1838", "139", "_text_obor", "field_5d761a1e08790");
INSERT INTO `wp_postmeta` VALUES("1839", "139", "nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("1840", "139", "_nazev_oboru_2", "field_5d761ba16e4bf");
INSERT INTO `wp_postmeta` VALUES("1841", "139", "obrazek_obor_2", "15");
INSERT INTO `wp_postmeta` VALUES("1842", "139", "_obrazek_obor_2", "field_5d761bad6e4c0");
INSERT INTO `wp_postmeta` VALUES("1843", "139", "text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\n\n&nbsp;\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\n 	<li>podniková ekonomika,</li>\n 	<li>personalistika a mzdy,</li>\n 	<li>finanční gramotnost,</li>\n 	<li>účetnictví a daňová evidence,</li>\n 	<li>právo,</li>\n 	<li>vedení kompletní podnikové agendy na PC.</li>\n</ul>\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</em></strong>\n\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\n\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</em></strong>\n\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\n\n<strong><em> </em></strong>\n\n<strong><em>Uplatnění absolventa:</em></strong>\n\nAbsolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.");
INSERT INTO `wp_postmeta` VALUES("1844", "139", "_text_obor_2", "field_5d761bb36e4c1");
INSERT INTO `wp_postmeta` VALUES("1845", "139", "nazev_oboru_3", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("1846", "139", "_nazev_oboru_3", "field_5d761c3894f15");
INSERT INTO `wp_postmeta` VALUES("1847", "139", "obrazek_obor_3", "32");
INSERT INTO `wp_postmeta` VALUES("1848", "139", "_obrazek_obor_3", "field_5d761c3f94f16");
INSERT INTO `wp_postmeta` VALUES("1849", "139", "text_obor_3", "<strong>Obor: INFORMAČNÍ TECHNOLOGIE</strong>\n\n<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n\n<strong><em> </em></strong>\n<ul>\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\n<ul>\n 	<li>Počítačová grafika; Robotika</li>\n 	<li>Programování; Elektrotechnika</li>\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\n</ul>\n</li>\n</ul>\n<ul>\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\n</ul>\n&nbsp;\n\n<strong><em>Zaměření: Počítačová technika a robotika</em></strong>\n\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\n\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\n\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\n\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\n\n<strong><em> </em></strong>\n\n<strong><em>Zaměření: Informační systémy</em></strong>\n\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\n\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\n\n&nbsp;\n\n<strong><em>Zaměření: Počítačové sítě</em></strong>\n\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\n\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\n\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("1850", "139", "_text_obor_3", "field_5d761c4294f17");
INSERT INTO `wp_postmeta` VALUES("1851", "139", "nazev_oboru_4", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("1852", "139", "_nazev_oboru_4", "field_5d761c4e94f18");
INSERT INTO `wp_postmeta` VALUES("1853", "139", "obrazek_obor_4", "28");
INSERT INTO `wp_postmeta` VALUES("1854", "139", "_obrazek_obor_4", "field_5d761c5394f19");
INSERT INTO `wp_postmeta` VALUES("1855", "139", "text_obor_4", "<strong>Obor: DOPRAVNÍ PROSTŘEDKY</strong>\n\n<strong><em>Zaměření: Strojírenství pro automobilový průmysl</em></strong>\n\n<strong><em> </em></strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n\n&nbsp;\n<ul>\n 	<li>Konstruktér, technolog, nástrojař,</li>\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\n 	<li>kontrola výroby,</li>\n 	<li>diagnostik vozidel,</li>\n 	<li>opravář vozidel, prodejce vozidel,</li>\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\n 	<li>obchodní zástupce na technickém úseku,</li>\n 	<li>studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("1856", "139", "_text_obor_4", "field_5d761c5794f1a");
INSERT INTO `wp_postmeta` VALUES("1886", "11", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1887", "118", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1939", "160", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1944", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1949", "8", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1950", "8", "_wp_page_template", "page-home.php");
INSERT INTO `wp_postmeta` VALUES("1951", "8", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("1952", "8", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("1953", "8", "slider_0_slider_image", "136");
INSERT INTO `wp_postmeta` VALUES("1954", "8", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1955", "8", "slider_1_slider_image", "133");
INSERT INTO `wp_postmeta` VALUES("1956", "8", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1957", "8", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("1958", "8", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("1959", "8", "slider_2_slider_image", "135");
INSERT INTO `wp_postmeta` VALUES("1960", "8", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1961", "8", "slider_3_slider_image", "134");
INSERT INTO `wp_postmeta` VALUES("1962", "8", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("1963", "8", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1964", "8", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1965", "8", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1966", "8", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1967", "8", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\n\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\n\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš 😊");
INSERT INTO `wp_postmeta` VALUES("1968", "8", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1969", "8", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("1970", "8", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1971", "8", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1972", "8", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1973", "8", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\n\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1974", "8", "_sekce_leva_1_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1975", "8", "sekce_leva_0_image", "16");
INSERT INTO `wp_postmeta` VALUES("1976", "8", "_sekce_leva_0_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1977", "8", "sekce_leva_0_link", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1978", "8", "_sekce_leva_0_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1979", "8", "sekce_leva_0_content", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\n\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\n\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš 😊");
INSERT INTO `wp_postmeta` VALUES("1980", "8", "_sekce_leva_0_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1981", "8", "sekce_leva_1_image", "15");
INSERT INTO `wp_postmeta` VALUES("1982", "8", "_sekce_leva_1_image", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("1983", "8", "sekce_leva_1_link", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("1984", "8", "_sekce_leva_1_link", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("1985", "8", "sekce_leva_1_content", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\n\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd.");
INSERT INTO `wp_postmeta` VALUES("1986", "8", "_sekce_leva_1_content", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("1987", "8", "titulek", "Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("1988", "8", "_titulek", "field_5d5d1fb577d96");
INSERT INTO `wp_postmeta` VALUES("1989", "8", "text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové. \r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš.\r\n");
INSERT INTO `wp_postmeta` VALUES("1990", "8", "_text", "field_5d5d1fbc77d97");
INSERT INTO `wp_postmeta` VALUES("1991", "8", "obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("1992", "8", "_obrazek", "field_5d5d1fa377d95");
INSERT INTO `wp_postmeta` VALUES("1993", "8", "titulek_2", "Tady chillujeme");
INSERT INTO `wp_postmeta` VALUES("1994", "8", "_titulek_2", "field_5d5d33129d39b");
INSERT INTO `wp_postmeta` VALUES("1995", "8", "text_2", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na oběd. \r\n");
INSERT INTO `wp_postmeta` VALUES("1996", "8", "_text_2", "field_5d5d331f9d39c");
INSERT INTO `wp_postmeta` VALUES("1997", "8", "obrazek_2", "15");
INSERT INTO `wp_postmeta` VALUES("1998", "8", "_obrazek_2", "field_5d5d332b9d39d");
INSERT INTO `wp_postmeta` VALUES("1999", "8", "titulek_3", "Stovky kcal v každém jídle");
INSERT INTO `wp_postmeta` VALUES("2000", "8", "_titulek_3", "field_5d5d342b31e89");
INSERT INTO `wp_postmeta` VALUES("2001", "8", "text_3", "Běžné menu v KFC či McDonald´s tě sotva zasytí a zanedlouho budeš mít opět hlad. \r\nS obědem z naší jídelny vydržíš až do 8. vyučovací hodiny.\r\nVýběr jídla je jen na tobě! Stojí za to jíst lépe!");
INSERT INTO `wp_postmeta` VALUES("2002", "8", "_text_3", "field_5d5d343931e8a");
INSERT INTO `wp_postmeta` VALUES("2003", "8", "obrazek_3", "21");
INSERT INTO `wp_postmeta` VALUES("2004", "8", "_obrazek_3", "field_5d5d344b31e8b");
INSERT INTO `wp_postmeta` VALUES("2005", "8", "titulek_4", "Formujeme mysl i tělo");
INSERT INTO `wp_postmeta` VALUES("2006", "8", "_titulek_4", "field_5d5d36039e740");
INSERT INTO `wp_postmeta` VALUES("2007", "8", "text_4", "Dvě tělocvičny, kde můžeš zpevňovat své svalstvo a zvyšovat svou kondici. \r\nPosilovna, beach volejbalové hřiště, bazén – vše pro aktivní využívání tvého času.\r\n");
INSERT INTO `wp_postmeta` VALUES("2008", "8", "_text_4", "field_5d5d36169e741");
INSERT INTO `wp_postmeta` VALUES("2009", "8", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("2010", "8", "_obrazek_4", "field_5d5d36239e742");
INSERT INTO `wp_postmeta` VALUES("2011", "8", "titulek_5", "Škola plná experimentů");
INSERT INTO `wp_postmeta` VALUES("2012", "8", "_titulek_5", "field_5d5d36349e743");
INSERT INTO `wp_postmeta` VALUES("2013", "8", "sekce_5_-_text", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\nTvoje badatelská činnost může začít!\n");
INSERT INTO `wp_postmeta` VALUES("2014", "8", "_sekce_5_-_text", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("2015", "8", "obrazek_5", "31");
INSERT INTO `wp_postmeta` VALUES("2016", "8", "_obrazek_5", "field_5d5d364a9e745");
INSERT INTO `wp_postmeta` VALUES("2017", "8", "text_5", "Desítky interaktivních exponátů, díky kterým můžeš objevovat, jak funguje vše kolem nás.\r\nZábavné pokusy a experimenty z oblasti fyziky a chemie.\r\nTvoje badatelská činnost může začít!\r\n");
INSERT INTO `wp_postmeta` VALUES("2018", "8", "_text_5", "field_5d5d363f9e744");
INSERT INTO `wp_postmeta` VALUES("2019", "8", "video_1", "81");
INSERT INTO `wp_postmeta` VALUES("2020", "8", "_video_1", "field_5d64fac13175f");
INSERT INTO `wp_postmeta` VALUES("2021", "8", "video_2", "80");
INSERT INTO `wp_postmeta` VALUES("2022", "8", "_video_2", "field_5d64fbff9504f");
INSERT INTO `wp_postmeta` VALUES("2023", "8", "video_3", "79");
INSERT INTO `wp_postmeta` VALUES("2024", "8", "_video_3", "field_5d64fc0495050");
INSERT INTO `wp_postmeta` VALUES("2025", "8", "video_1_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("2026", "8", "_video_1_jmeno", "field_5d64fe6905002");
INSERT INTO `wp_postmeta` VALUES("2027", "8", "video_2_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("2028", "8", "_video_2_jmeno", "field_5d64fe8a05003");
INSERT INTO `wp_postmeta` VALUES("2029", "8", "video_3_jmeno", "Jméno Příjmení");
INSERT INTO `wp_postmeta` VALUES("2030", "8", "_video_3_jmeno", "field_5d64fe9c05005");
INSERT INTO `wp_postmeta` VALUES("2031", "8", "video_1_odkaz", "<iframe  src=\"https://www.youtube.com/embed/Kkx2erP5Bn4\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("2032", "8", "_video_1_odkaz", "field_5d664c588221e");
INSERT INTO `wp_postmeta` VALUES("2033", "8", "video_2_odkaz", "<iframe  src=\"https://www.youtube.com/embed/oQo9LlYgCaE\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("2034", "8", "_video_2_odkaz", "field_5d664c738221f");
INSERT INTO `wp_postmeta` VALUES("2035", "8", "video_3_odkaz", "<iframe src=\"https://www.youtube.com/embed/1qfoaX59qrU\" frameborder=\"0\" allow=\"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("2036", "8", "_video_3_odkaz", "field_5d664c7d82220");
INSERT INTO `wp_postmeta` VALUES("2037", "8", "obor_0_obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("2038", "8", "_obor_0_obrazek_obor", "field_5d7613d39e303");
INSERT INTO `wp_postmeta` VALUES("2039", "8", "obor_0_nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("2040", "8", "_obor_0_nazev_oboru", "field_5d76142bd4876");
INSERT INTO `wp_postmeta` VALUES("2041", "8", "obor_0_text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\n 	<li>Studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("2042", "8", "_obor_0_text_obor", "field_5d7613e79e304");
INSERT INTO `wp_postmeta` VALUES("2043", "8", "obor", "2");
INSERT INTO `wp_postmeta` VALUES("2044", "8", "_obor", "field_5d7613c69e302");
INSERT INTO `wp_postmeta` VALUES("2045", "8", "obor_0_obrazek_obor_2", "15");
INSERT INTO `wp_postmeta` VALUES("2046", "8", "_obor_0_obrazek_obor_2", "field_5d7617af379d3");
INSERT INTO `wp_postmeta` VALUES("2047", "8", "obor_0_nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("2048", "8", "_obor_0_nazev_oboru_2", "field_5d7617b9379d4");
INSERT INTO `wp_postmeta` VALUES("2049", "8", "obor_0_text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\n\n&nbsp;\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\n 	<li>podniková ekonomika,</li>\n 	<li>personalistika a mzdy,</li>\n 	<li>finanční gramotnost,</li>\n 	<li>účetnictví a daňová evidence,</li>\n 	<li>právo,</li>\n 	<li>vedení kompletní podnikové agendy na PC.</li>\n</ul>\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</em></strong>\n\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\n\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</em></strong>\n\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\n\n<strong><em> </em></strong>\n\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>Absolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("2050", "8", "_obor_0_text_obor_2", "field_5d7617c2379d5");
INSERT INTO `wp_postmeta` VALUES("2051", "8", "obor_1_obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("2052", "8", "_obor_1_obrazek_obor", "field_5d7613d39e303");
INSERT INTO `wp_postmeta` VALUES("2053", "8", "obor_1_nazev_oboru", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("2054", "8", "_obor_1_nazev_oboru", "field_5d76142bd4876");
INSERT INTO `wp_postmeta` VALUES("2055", "8", "obor_1_text_obor", "<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n\n<strong><em> </em></strong>\n<ul>\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\n<ul>\n 	<li>Počítačová grafika; Robotika</li>\n 	<li>Programování; Elektrotechnika</li>\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\n</ul>\n</li>\n</ul>\n<ul>\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\n</ul>\n&nbsp;\n\n<strong><em>Zaměření: Počítačová technika a robotika</em></strong>\n\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\n\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\n\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\n\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\n\n<strong><em> </em></strong>\n\n<strong><em>Zaměření: Informační systémy</em></strong>\n\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\n\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\n\n&nbsp;\n\n<strong><em>Zaměření: Počítačové sítě</em></strong>\n\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\n\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\n\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("2056", "8", "_obor_1_text_obor", "field_5d7613e79e304");
INSERT INTO `wp_postmeta` VALUES("2057", "8", "obor_1_obrazek_obor_2", "28");
INSERT INTO `wp_postmeta` VALUES("2058", "8", "_obor_1_obrazek_obor_2", "field_5d7617af379d3");
INSERT INTO `wp_postmeta` VALUES("2059", "8", "obor_1_nazev_oboru_2", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("2060", "8", "_obor_1_nazev_oboru_2", "field_5d7617b9379d4");
INSERT INTO `wp_postmeta` VALUES("2061", "8", "obor_1_text_obor_2", "<strong><em>Zaměření: Strojírenství pro automobilový průmysl</em></strong>\n\n<strong><em> </em></strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n\n&nbsp;\n<ul>\n 	<li>Konstruktér, technolog, nástrojař,</li>\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\n 	<li>kontrola výroby,</li>\n 	<li>diagnostik vozidel,</li>\n 	<li>opravář vozidel, prodejce vozidel,</li>\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\n 	<li>obchodní zástupce na technickém úseku,</li>\n 	<li>studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("2062", "8", "_obor_1_text_obor_2", "field_5d7617c2379d5");
INSERT INTO `wp_postmeta` VALUES("2063", "8", "nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("2064", "8", "_nazev_oboru", "field_5d7619d20878e");
INSERT INTO `wp_postmeta` VALUES("2065", "8", "obrazek_obor", "32");
INSERT INTO `wp_postmeta` VALUES("2066", "8", "_obrazek_obor", "field_5d761a090878f");
INSERT INTO `wp_postmeta` VALUES("2067", "8", "text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n<ul>\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\n 	<li>Studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("2068", "8", "_text_obor", "field_5d761a1e08790");
INSERT INTO `wp_postmeta` VALUES("2069", "8", "nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("2070", "8", "_nazev_oboru_2", "field_5d761ba16e4bf");
INSERT INTO `wp_postmeta` VALUES("2071", "8", "obrazek_obor_2", "15");
INSERT INTO `wp_postmeta` VALUES("2072", "8", "_obrazek_obor_2", "field_5d761bad6e4c0");
INSERT INTO `wp_postmeta` VALUES("2073", "8", "text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\n\n&nbsp;\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\n 	<li>podniková ekonomika,</li>\n 	<li>personalistika a mzdy,</li>\n 	<li>finanční gramotnost,</li>\n 	<li>účetnictví a daňová evidence,</li>\n 	<li>právo,</li>\n 	<li>vedení kompletní podnikové agendy na PC.</li>\n</ul>\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</em></strong>\n\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\n\n&nbsp;\n\n<strong><em>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</em></strong>\n\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\n\n<strong><em> </em></strong>\n\n<strong><em>Uplatnění absolventa:</em></strong>\n\nAbsolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.");
INSERT INTO `wp_postmeta` VALUES("2074", "8", "_text_obor_2", "field_5d761bb36e4c1");
INSERT INTO `wp_postmeta` VALUES("2075", "8", "nazev_oboru_3", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("2076", "8", "_nazev_oboru_3", "field_5d761c3894f15");
INSERT INTO `wp_postmeta` VALUES("2077", "8", "obrazek_obor_3", "32");
INSERT INTO `wp_postmeta` VALUES("2078", "8", "_obrazek_obor_3", "field_5d761c3f94f16");
INSERT INTO `wp_postmeta` VALUES("2079", "8", "text_obor_3", "<strong>Obor: INFORMAČNÍ TECHNOLOGIE</strong>\n\n<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\n\n<strong> </strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n\n<strong><em> </em></strong>\n<ul>\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\n<ul>\n 	<li>Počítačová grafika; Robotika</li>\n 	<li>Programování; Elektrotechnika</li>\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\n</ul>\n</li>\n</ul>\n<ul>\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\n</ul>\n&nbsp;\n\n<strong><em>Zaměření: Počítačová technika a robotika</em></strong>\n\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\n\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\n\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\n\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\n\n<strong><em> </em></strong>\n\n<strong><em>Zaměření: Informační systémy</em></strong>\n\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\n\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\n\n&nbsp;\n\n<strong><em>Zaměření: Počítačové sítě</em></strong>\n\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\n\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\n\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("2080", "8", "_text_obor_3", "field_5d761c4294f17");
INSERT INTO `wp_postmeta` VALUES("2081", "8", "nazev_oboru_4", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("2082", "8", "_nazev_oboru_4", "field_5d761c4e94f18");
INSERT INTO `wp_postmeta` VALUES("2083", "8", "obrazek_obor_4", "28");
INSERT INTO `wp_postmeta` VALUES("2084", "8", "_obrazek_obor_4", "field_5d761c5394f19");
INSERT INTO `wp_postmeta` VALUES("2085", "8", "text_obor_4", "<strong>Obor: DOPRAVNÍ PROSTŘEDKY</strong>\n\n<strong><em>Zaměření: Strojírenství pro automobilový průmysl</em></strong>\n\n<strong><em> </em></strong>\n\n<strong><em>Základní info o oboru:</em></strong>\n<ul>\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\n</ul>\n<strong><em>Uplatnění absolventa:</em></strong>\n\n&nbsp;\n<ul>\n 	<li>Konstruktér, technolog, nástrojař,</li>\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\n 	<li>kontrola výroby,</li>\n 	<li>diagnostik vozidel,</li>\n 	<li>opravář vozidel, prodejce vozidel,</li>\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\n 	<li>obchodní zástupce na technickém úseku,</li>\n 	<li>studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("2086", "8", "_text_obor_4", "field_5d761c5794f1a");
INSERT INTO `wp_postmeta` VALUES("2100", "62", "forminator_form_meta", "a:6:{s:6:\"fields\";a:0:{}s:8:\"settings\";a:77:{s:8:\"formName\";s:4:\"test\";s:22:\"admin-email-recipients\";a:1:{i:0;s:20:\"pavelkocan@pulary.cz\";}s:13:\"results_behav\";s:5:\"after\";s:12:\"visual_style\";s:4:\"list\";s:21:\"forminator-quiz-theme\";s:7:\"default\";s:11:\"msg_correct\";s:29:\"Correct! It was %UserAnswer%.\";s:13:\"msg_incorrect\";s:39:\"Wrong! It was %CorrectAnswer%, sorry...\";s:9:\"msg_count\";s:34:\"You got %YourNum%/%Total% correct!\";s:22:\"nowrong-title-settings\";s:0:\"\";s:19:\"nowrong-title-color\";s:7:\"#333333\";s:25:\"nowrong-title-font-family\";s:6:\"Roboto\";s:23:\"nowrong-title-font-size\";s:2:\"42\";s:25:\"nowrong-title-font-weight\";s:3:\"500\";s:28:\"nowrong-description-settings\";s:0:\"\";s:25:\"nowrong-description-color\";s:7:\"#8C8C8C\";s:31:\"nowrong-description-font-family\";s:6:\"Roboto\";s:29:\"nowrong-description-font-size\";s:2:\"20\";s:31:\"nowrong-description-font-weight\";s:3:\"400\";s:22:\"nowrong-image-settings\";s:0:\"\";s:26:\"nowrong-image-border-color\";s:7:\"#000000\";s:26:\"nowrong-image-border-width\";s:1:\"0\";s:26:\"nowrong-image-border-style\";s:5:\"solid\";s:25:\"nowrong-question-settings\";s:0:\"\";s:26:\"nowrong-question-font-size\";s:2:\"24\";s:28:\"nowrong-question-font-family\";s:6:\"Roboto\";s:28:\"nowrong-question-font-weight\";s:3:\"500\";s:23:\"nowrong-answer-settings\";s:0:\"\";s:28:\"nowrong-answer-border-static\";s:7:\"#EBEDEB\";s:27:\"nowrong-answer-border-hover\";s:7:\"#17A8E3\";s:28:\"nowrong-answer-border-active\";s:7:\"#17A8E3\";s:32:\"nowrong-answer-background-static\";s:7:\"#FAFAFA\";s:31:\"nowrong-answer-background-hover\";s:7:\"#F3FBFE\";s:32:\"nowrong-answer-background-active\";s:7:\"#F3FBFE\";s:27:\"nowrong-answer-chkbo-static\";s:7:\"#BFBFBF\";s:27:\"nowrong-answer-chkbo-active\";s:7:\"#17A8E3\";s:27:\"nowrong-answer-color-static\";s:7:\"#888888\";s:27:\"nowrong-answer-color-active\";s:7:\"#333333\";s:24:\"nowrong-answer-font-size\";s:2:\"14\";s:26:\"nowrong-answer-font-family\";s:6:\"Roboto\";s:26:\"nowrong-answer-font-weight\";s:3:\"500\";s:32:\"nowrong-submit-background-static\";s:7:\"#17A8E3\";s:31:\"nowrong-submit-background-hover\";s:7:\"#008FCA\";s:32:\"nowrong-submit-background-active\";s:7:\"#008FCA\";s:27:\"nowrong-submit-color-static\";s:7:\"#FFFFFF\";s:26:\"nowrong-submit-color-hover\";s:7:\"#FFFFFF\";s:27:\"nowrong-submit-color-active\";s:7:\"#FFFFFF\";s:26:\"nowrong-submit-font-family\";s:6:\"Roboto\";s:24:\"nowrong-submit-font-size\";s:2:\"14\";s:26:\"nowrong-submit-font-weight\";s:3:\"500\";s:30:\"nowrong-result-background-main\";s:7:\"#FAFAFA\";s:32:\"nowrong-result-background-header\";s:7:\"#FAFAFA\";s:27:\"nowrong-result-border-color\";s:7:\"#17A8E3\";s:25:\"nowrong-result-quiz-color\";s:7:\"#FFFFFF\";s:31:\"nowrong-result-quiz-font-family\";s:6:\"Roboto\";s:29:\"nowrong-result-quiz-font-size\";s:2:\"15\";s:31:\"nowrong-result-quiz-font-weight\";s:3:\"500\";s:33:\"nowrong-result-retake-font-family\";s:6:\"Roboto\";s:31:\"nowrong-result-retake-font-size\";s:2:\"13\";s:33:\"nowrong-result-retake-font-weight\";s:3:\"500\";s:39:\"nowrong-result-retake-background-static\";s:7:\"#17A8E3\";s:38:\"nowrong-result-retake-background-hover\";s:7:\"#17A8E3\";s:39:\"nowrong-result-retake-background-active\";s:7:\"#17A8E3\";s:30:\"nowrong-result-background-body\";s:7:\"#EBEDEB\";s:26:\"nowrong-result-title-color\";s:7:\"#333333\";s:32:\"nowrong-result-title-font-family\";s:6:\"Roboto\";s:30:\"nowrong-result-title-font-size\";s:2:\"15\";s:32:\"nowrong-result-title-font-weight\";s:3:\"500\";s:32:\"nowrong-result-description-color\";s:7:\"#4D4D4D\";s:38:\"nowrong-result-description-font-family\";s:6:\"Roboto\";s:36:\"nowrong-result-description-font-size\";s:2:\"13\";s:38:\"nowrong-result-description-font-weight\";s:3:\"400\";s:12:\"enable-share\";s:2:\"on\";s:9:\"quiz_name\";s:9:\"Otázka 1\";s:15:\"quiz_feat_image\";s:74:\"http://localhost/bavse/wp-content/uploads/2019/08/sps-slide-2-1024x683.jpg\";s:24:\"quiz_feat_image_filename\";s:15:\"sps-slide-2.jpg\";s:16:\"quiz_description\";s:1194:\"<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nulla non lectus sed nisl molestie malesuada. Morbi imperdiet, mauris ac auctor dictum, nisl ligula egestas nulla, et sollicitudin sem purus in lacus. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Proin mattis lacinia justo. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Fusce tellus. Fusce dui leo, imperdiet in, aliquam sit amet, feugiat eu, orci. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Curabitur sagittis hendrerit ante. Proin in tellus sit amet nibh dignissim sagittis. Suspendisse nisl. Proin in tellus sit amet nibh dignissim sagittis. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Praesent in mauris eu tortor porttitor accumsan. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam erat volutpat.</p>\";s:7:\"version\";s:5:\"1.8.1\";}s:9:\"client_id\";N;s:9:\"questions\";a:0:{}s:7:\"results\";a:3:{i:0;a:3:{s:4:\"slug\";s:16:\"result-2117-3472\";s:5:\"title\";s:5:\"jedna\";s:11:\"description\";s:0:\"\";}i:1;a:3:{s:4:\"slug\";s:16:\"result-7600-2493\";s:5:\"title\";s:3:\"dve\";s:11:\"description\";s:0:\"\";}i:2;a:3:{s:4:\"slug\";s:16:\"result-9673-7125\";s:5:\"title\";s:3:\"tri\";s:11:\"description\";s:0:\"\";}}s:9:\"quiz_type\";s:7:\"nowrong\";}");
INSERT INTO `wp_postmeta` VALUES("2101", "63", "forminator_form_meta", "a:6:{s:6:\"fields\";a:0:{}s:8:\"settings\";a:77:{s:8:\"formName\";s:6:\"Test 2\";s:22:\"admin-email-recipients\";a:1:{i:0;s:20:\"pavelkocan@pulary.cz\";}s:17:\"admin-email-title\";s:35:\"New Quiz Submission for {quiz_name}\";s:18:\"admin-email-editor\";s:150:\"You have a new quiz submission: <br/><br/>{quiz_answer}<br/><br/>Quiz results: <br/>{quiz_result} <br/>---<br/> This message was sent from {site_url}.\";s:13:\"results_behav\";s:5:\"after\";s:12:\"visual_style\";s:4:\"grid\";s:21:\"forminator-quiz-theme\";s:7:\"default\";s:11:\"msg_correct\";s:29:\"Correct! It was %UserAnswer%.\";s:13:\"msg_incorrect\";s:39:\"Wrong! It was %CorrectAnswer%, sorry...\";s:9:\"msg_count\";s:34:\"You got %YourNum%/%Total% correct!\";s:21:\"knowledge-title-color\";s:7:\"#333333\";s:27:\"knowledge-title-font-family\";s:6:\"Roboto\";s:25:\"knowledge-title-font-size\";s:2:\"42\";s:27:\"knowledge-title-font-weight\";s:3:\"500\";s:27:\"knowledge-description-color\";s:7:\"#8C8C8C\";s:33:\"knowledge-description-font-family\";s:6:\"Roboto\";s:31:\"knowledge-description-font-size\";s:2:\"20\";s:33:\"knowledge-description-font-weight\";s:3:\"400\";s:24:\"knowledge-question-color\";s:7:\"#333333\";s:30:\"knowledge-question-font-family\";s:6:\"Roboto\";s:28:\"knowledge-question-font-size\";s:2:\"24\";s:30:\"knowledge-question-font-weight\";s:3:\"500\";s:34:\"knowledge-answer-background-static\";s:7:\"#FAFAFA\";s:33:\"knowledge-answer-background-hover\";s:7:\"#F3FBFE\";s:34:\"knowledge-answer-background-active\";s:7:\"#F3FBFE\";s:27:\"knowledge-aright-background\";s:7:\"#F4FCF2\";s:27:\"knowledge-awrong-background\";s:7:\"#FDF2F2\";s:30:\"knowledge-answer-border-static\";s:7:\"#EBEDEB\";s:29:\"knowledge-answer-border-hover\";s:7:\"#17A8E3\";s:30:\"knowledge-answer-border-active\";s:7:\"#17A8E3\";s:23:\"knowledge-aright-border\";s:7:\"#0BC30B\";s:23:\"knowledge-awrong-border\";s:7:\"#DA0000\";s:29:\"knowledge-answer-color-static\";s:7:\"#888888\";s:29:\"knowledge-answer-color-active\";s:7:\"#333333\";s:22:\"knowledge-aright-color\";s:7:\"#0BC30B\";s:22:\"knowledge-awrong-color\";s:7:\"#DA0000\";s:26:\"knowledge-answer-font-size\";s:2:\"14\";s:28:\"knowledge-answer-font-family\";s:6:\"Roboto\";s:28:\"knowledge-answer-font-weight\";s:3:\"500\";s:36:\"knowledge-answer-check-border-static\";s:7:\"#BFBFBF\";s:36:\"knowledge-answer-check-border-active\";s:7:\"#17A8E3\";s:37:\"knowledge-answer-check-border-correct\";s:7:\"#0BC30B\";s:39:\"knowledge-answer-check-border-incorrect\";s:7:\"#DA0000\";s:40:\"knowledge-answer-check-background-static\";s:7:\"#FFFFFF\";s:40:\"knowledge-answer-check-background-active\";s:7:\"#17A8E3\";s:41:\"knowledge-answer-check-background-correct\";s:7:\"#0BC30B\";s:43:\"knowledge-answer-check-background-incorrect\";s:7:\"#DA0000\";s:24:\"knowledge-phrasing-color\";s:7:\"#4D4D4D\";s:28:\"knowledge-phrasing-font-size\";s:2:\"16\";s:30:\"knowledge-phrasing-font-family\";s:6:\"Roboto\";s:30:\"knowledge-phrasing-font-weight\";s:3:\"700\";s:34:\"knowledge-submit-background-static\";s:7:\"#bf2121\";s:33:\"knowledge-submit-background-hover\";s:7:\"#008FCA\";s:34:\"knowledge-submit-background-active\";s:7:\"#008FCA\";s:29:\"knowledge-submit-color-static\";s:7:\"#FFFFFF\";s:28:\"knowledge-submit-color-hover\";s:7:\"#FFFFFF\";s:29:\"knowledge-submit-color-active\";s:7:\"#FFFFFF\";s:28:\"knowledge-submit-font-family\";s:6:\"Roboto\";s:26:\"knowledge-submit-font-size\";s:2:\"14\";s:28:\"knowledge-submit-font-weight\";s:3:\"500\";s:23:\"knowledge-summary-color\";s:7:\"#333333\";s:29:\"knowledge-summary-font-family\";s:6:\"Roboto\";s:27:\"knowledge-summary-font-size\";s:2:\"40\";s:29:\"knowledge-summary-font-weight\";s:3:\"400\";s:12:\"enable-share\";s:2:\"on\";s:22:\"knowledge-sshare-color\";s:7:\"#4D4D4D\";s:28:\"knowledge-sshare-font-family\";s:6:\"Roboto\";s:26:\"knowledge-sshare-font-size\";s:2:\"20\";s:25:\"knowledge-social-facebook\";s:7:\"#0084BF\";s:24:\"knowledge-social-twitter\";s:7:\"#1DA1F2\";s:23:\"knowledge-social-google\";s:7:\"#DB4437\";s:36:\"forminator-knowledge-social-linkedin\";s:7:\"#0084BF\";s:21:\"knowledge-social-size\";s:2:\"36\";s:9:\"quiz_name\";s:5:\"Kvíz\";s:16:\"quiz_description\";s:356:\"<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nulla non lectus sed nisl molestie malesuada. Morbi imperdiet, mauris ac auctor dictum, nisl ligula egestas nulla, et sollicitudin sem purus in lacus. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Proin mattis lacinia justo. </p>\";s:24:\"knowledge-toggle-palette\";s:4:\"true\";s:7:\"version\";s:5:\"1.8.1\";}s:9:\"client_id\";N;s:9:\"questions\";a:3:{i:0;a:4:{s:4:\"slug\";s:18:\"question-4077-2549\";s:7:\"answers\";a:3:{i:0;a:3:{s:5:\"title\";s:1:\"1\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:1;a:3:{s:5:\"title\";s:1:\"2\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:2;a:4:{s:5:\"title\";s:1:\"3\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";s:6:\"toggle\";s:1:\"1\";}}s:4:\"type\";s:9:\"knowledge\";s:5:\"title\";s:9:\"Otázka 1\";}i:1;a:4:{s:4:\"slug\";s:18:\"question-5153-6613\";s:7:\"answers\";a:3:{i:0;a:3:{s:5:\"title\";s:1:\"1\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:1;a:4:{s:5:\"title\";s:1:\"2\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";s:6:\"toggle\";s:1:\"1\";}i:2;a:3:{s:5:\"title\";s:1:\"3\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}}s:4:\"type\";s:9:\"knowledge\";s:5:\"title\";s:9:\"Otázka 2\";}i:2;a:4:{s:4:\"slug\";s:18:\"question-9423-4568\";s:7:\"answers\";a:3:{i:0;a:4:{s:5:\"title\";s:1:\"1\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";s:6:\"toggle\";s:1:\"1\";}i:1;a:3:{s:5:\"title\";s:1:\"2\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}i:2;a:3:{s:5:\"title\";s:1:\"3\";s:5:\"image\";s:0:\"\";s:7:\"default\";s:0:\"\";}}s:4:\"type\";s:9:\"knowledge\";s:5:\"title\";s:9:\"Otázka 3\";}}s:7:\"results\";a:0:{}s:9:\"quiz_type\";s:9:\"knowledge\";}");
INSERT INTO `wp_postmeta` VALUES("2102", "119", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2103", "119", "_wp_page_template", "page-obory.php");
INSERT INTO `wp_postmeta` VALUES("2104", "119", "nazev_oboru", "Strojírenství");
INSERT INTO `wp_postmeta` VALUES("2105", "119", "_nazev_oboru", "field_5d7619d20878e");
INSERT INTO `wp_postmeta` VALUES("2106", "119", "obrazek_obor", "129");
INSERT INTO `wp_postmeta` VALUES("2107", "119", "_obrazek_obor", "field_5d761a090878f");
INSERT INTO `wp_postmeta` VALUES("2108", "119", "text_obor", "<strong>Zaměření: CAD - CAM technologie</strong>\n\n<strong> </strong>\n\n<strong>Základní info o oboru:</strong>\n<ul>\n 	<li>Čtyřletý studijní obor s maturitou, jeden z nejžádanějších na trhu práce.</li>\n 	<li>Obor je zaměřen na zvládnutí konstrukce, provoz a údržbu strojů a nástrojů s využitím výpočetní techniky, kreslení a čtení technických výkresů na počítači a programování CNC strojů.</li>\n 	<li>První dva ročníky základy odborných předmětů, 3. a 4. ročník seznámení s oblastmi programování, elektrotechnika, počítačová grafika, tekutinové mechanismy ad.</li>\n 	<li>Seznámí se s obsluhou CNC strojů HEIDENHAIN a FANUC. Ve školních dílnách mohou žáci na těchto strojích navržené součásti vyrobit a tím si osvojit i praktické dovednosti.</li>\n</ul>\n<strong>Uplatnění absolventa:</strong>\n<ul>\n 	<li>V podnicích a provozech strojírenských, potravinářských, dopravě, chemických provozech.</li>\n 	<li>Pracovníci v konstrukci, při navrhování strojních celků.</li>\n 	<li>Programátor obráběcích strojů CNC řízených počítačem.</li>\n 	<li>Mistři ve vedení provozů pracovníci technické kontroly a měření součástí, v oblasti servisu.</li>\n 	<li>Provozní technici, zkušební a školící technici ad.</li>\n 	<li>Studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("2109", "119", "_text_obor", "field_5d761a1e08790");
INSERT INTO `wp_postmeta` VALUES("2110", "119", "nazev_oboru_2", "Obchodní akademie");
INSERT INTO `wp_postmeta` VALUES("2111", "119", "_nazev_oboru_2", "field_5d761ba16e4bf");
INSERT INTO `wp_postmeta` VALUES("2112", "119", "obrazek_obor_2", "128");
INSERT INTO `wp_postmeta` VALUES("2113", "119", "_obrazek_obor_2", "field_5d761bad6e4c0");
INSERT INTO `wp_postmeta` VALUES("2114", "119", "text_obor_2", "<strong>Zaměření: Právo a daně; Finanční trhy</strong>\n\n&nbsp;\n\n<strong>Základní info o oboru:</strong>\n<ul>\n 	<li>V okrese Bruntál tento obor nabízí pouze naše škola, čtyřletý studijní obor s maturitou.</li>\n 	<li>Kromě všeobecného vzdělání s důrazem na výuku 2 cizích jazyků se studium orientuje na aktuální ekonomické vzdělání v těchto oblastech:</li>\n 	<li>podniková ekonomika,</li>\n 	<li>personalistika a mzdy,</li>\n 	<li>finanční gramotnost,</li>\n 	<li>účetnictví a daňová evidence,</li>\n 	<li>právo,</li>\n 	<li>vedení kompletní podnikové agendy na PC.</li>\n</ul>\n&nbsp;\n\n<strong>OBSAH ZAMĚŘENÍ – PRÁVO A DANĚ</strong>\n\nZaměření se profiluje ve 3. a 4. ročníku. Základní rozsah právního vzdělání se rozšiřuje o předmět právo a daně.  Je orientován především na oblast obchodního, občanského a daňového práva. Sestavují daňová přiznání a hlášení, provádí elektronická podání, sepisují smlouvy v obchodním i občanském styku.\n\n&nbsp;\n\n<strong>OBSAH ZAMĚŘENÍ – FINANČNÍ TRHY</strong>\n\nProgram finančního vzdělávání se profiluje ve 3. a 4. ročníku. Základní rozsah gramotnosti v tomto oboru se rozšiřuje o předmět finanční trhy. V jeho rámci studenti navštíví Českou národní banku, burzu cenných papírů a další finanční instituce. Sestavují podnikatelský plán, osobní rozpočet a provádí finanční analýzu. V průběhu studia student získá znalosti a odborné dovednosti v těchto oborech: bankovnictví, pojišťovnictví, osobní a podnikové finance, finanční produkty a cenné papíry.\n\n&nbsp;\n\n<strong>Uplatnění absolventa:</strong>\n<ul>\n 	<li>Absolventi se uplatní na trhu práce v oborech ekonom, samostatný účetní, mzdový účetní, personalista a obchodní referent. Dále mohou pokračovat ve studiu na vysokých školách ekonomického i jiného zaměření.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("2115", "119", "_text_obor_2", "field_5d761bb36e4c1");
INSERT INTO `wp_postmeta` VALUES("2116", "119", "nazev_oboru_3", "Informační technologie");
INSERT INTO `wp_postmeta` VALUES("2117", "119", "_nazev_oboru_3", "field_5d761c3894f15");
INSERT INTO `wp_postmeta` VALUES("2118", "119", "obrazek_obor_3", "127");
INSERT INTO `wp_postmeta` VALUES("2119", "119", "_obrazek_obor_3", "field_5d761c3f94f16");
INSERT INTO `wp_postmeta` VALUES("2120", "119", "text_obor_3", "<strong>Zaměření: Počítačové sítě, Počítačová technika a robotika, Informační systémy</strong>\n\n<strong> </strong>\n\n<strong>Základní info o oboru:</strong>\n<ul>\n 	<li>Všechna zaměření v rámci oboru Informační technologie vychází ze společného vzdělávacího základu. Každý absolvent se seznámí se všemi stěžejními oblastmi v rámci IT:\n<ul>\n 	<li>Počítačová grafika; Robotika</li>\n 	<li>Programování; Elektrotechnika</li>\n 	<li>Operační systémy a hardware; Počítačové sítě</li>\n</ul>\n</li>\n 	<li>Předměty v rámci zaměření si volí až ve třetím ročníku studia.</li>\n</ul>\n&nbsp;\n\n<strong>Zaměření: Počítačová technika a robotika</strong>\n\nNabízí vstup do světa počítačů, robotů, moderních řídících systémů, automatizace, měření a testování.\n\nRobotika je rychle se rozvíjející obor, který v sobě zahrnuje poznatky z mechaniky (strojírenství), elektrotechniky a informatiky v rámci jednoho zařízení. Řeší otázky koncepce robotů, umělé inteligence, senzoriky, navigace, simulace, aj.\n\nPočítačové řídící systémy jsou dnes všude kolem nás. Neobejde se bez nich žádný automobil, moderní budova, výrobní linka ani spotřební elektronika.\n\nStředem zájmu je výběr vhodného řídícího prvku, tvorba programu a uvedení systému do chodu.\n\n<strong><em> </em></strong>\n\n<strong>Zaměření: Informační systémy</strong>\n\nCílem zaměření je naučit žáky vyvíjet vlastní řešení na platformě PHP a MySQL. Rozsah znalostí absolventa lze poměřit k aplikacím, jako jsou objednávkové systémy, diskusní fóra nebo například redakční systémy. Ve výuce se žáci zabývají také vývojem mobilních aplikací.\n\nSe znalostmi v oblasti informačních systémů získávají absolventi snadno uplatnění na trhu práce. Významná většina absolventů se již při studiích na vysoké škole živý jako tvůrci aplikací na platformě www. Novým trendem v zaměstnávání v této oblasti je především tzv. homeworking.\n\n&nbsp;\n\n<strong>Zaměření: Počítačové sítě</strong>\n\nVelmi významným trendem v oblasti IT jsou též počítačové sítě.\n\nVýuka počítačových sítí ve škole probíhá v rámci školní Cisco Networking Academy, kde mohou studenti získat již v rámci studia certifikáty v rámci kurzů IT Essentialls a CCNA. Systém mezinárodní certifikace, usnadňuje srovnání znalostí mezi uchazeči o zaměstnání.\n\nPro výuku mají zájemci o počítačové sítě k dispozici novou síťovou laboratoř. Tato laboratoř je vybavena veškerým potřebným vybavení jak od firmy Cisco, Mikrotik a měřícími přístroji od firmy FLUKE Networks.");
INSERT INTO `wp_postmeta` VALUES("2121", "119", "_text_obor_3", "field_5d761c4294f17");
INSERT INTO `wp_postmeta` VALUES("2122", "119", "nazev_oboru_4", "Dopravní prostředky");
INSERT INTO `wp_postmeta` VALUES("2123", "119", "_nazev_oboru_4", "field_5d761c4e94f18");
INSERT INTO `wp_postmeta` VALUES("2124", "119", "obrazek_obor_4", "126");
INSERT INTO `wp_postmeta` VALUES("2125", "119", "_obrazek_obor_4", "field_5d761c5394f19");
INSERT INTO `wp_postmeta` VALUES("2126", "119", "text_obor_4", "<strong>Zaměření: Strojírenství pro automobilový průmysl</strong>\n\n<strong> </strong>\n\n<strong>Základní info o oboru:</strong>\n<ul>\n 	<li>Čtyřletý maturitní obor, který žáka vede ke zvládnutí strojírenské výroby určené pro automobilový průmysl.</li>\n 	<li>Základem vzdělávání je vyvážené propojení teoretických a praktických znalostí vycházejících ze strojírenství a znalostí automobilů. Ve školních dílnách je výuka založena na praktických zkušenostech, která je pro získání vědomostí a pochopení principu nejcennější.</li>\n 	<li>Výstupem vzdělávání je absolvent, který má znalost konstrukce vozidla, je schopen jej opravit, umí vymodelovat pomocí PC (SolidWorks) části vozidla, u CNC stroje je schopen je vyrobit a v metrologické laboratoři změřit.</li>\n 	<li>Součástí vzdělávání zůstávají teoretické i praktické dovednosti s opravou a údržbou vozidel. Zaměření oboru reflektuje potřeby trhu práce.</li>\n</ul>\n<strong>Uplatnění absolventa:</strong>\n<ul>\n 	<li>Konstruktér, technolog, nástrojař,</li>\n 	<li>obsluha x programátor CNC obráběcích strojů,</li>\n 	<li>kontrola výroby,</li>\n 	<li>diagnostik vozidel,</li>\n 	<li>opravář vozidel, prodejce vozidel,</li>\n 	<li>technik na STK, revizní technik, přijímací technik,</li>\n 	<li>řidič z povolání B, C, E, profesní způsobilost k řízení vozidel,</li>\n 	<li>obchodní zástupce na technickém úseku,</li>\n 	<li>studium na VŠ.</li>\n</ul>");
INSERT INTO `wp_postmeta` VALUES("2127", "119", "_text_obor_4", "field_5d761c5794f1a");
INSERT INTO `wp_postmeta` VALUES("2128", "197", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2129", "197", "_wp_page_template", "page-internat.php");
INSERT INTO `wp_postmeta` VALUES("2130", "197", "titulek", "Internát");
INSERT INTO `wp_postmeta` VALUES("2131", "197", "_titulek", "field_5d79faf7c1047");
INSERT INTO `wp_postmeta` VALUES("2132", "197", "text", "Domov mládeže (dále DM) je v areálu SPŠ a OA Bruntál. V blízkosti DM se nachází městský park, tělocvičny, Wellness centrum, kino a nedaleko také samotné centrum města s mnoha dalšími možnostmi vyžití. \r\nPoskytujeme žákům ubytování a volnočasové aktivity. ");
INSERT INTO `wp_postmeta` VALUES("2133", "197", "_text", "field_5d79faf7cf2da");
INSERT INTO `wp_postmeta` VALUES("2134", "197", "obrazek", "198");
INSERT INTO `wp_postmeta` VALUES("2135", "197", "_obrazek", "field_5d79faf7db62d");
INSERT INTO `wp_postmeta` VALUES("2136", "197", "titulek_2", "Ubytování");
INSERT INTO `wp_postmeta` VALUES("2137", "197", "_titulek_2", "field_5d79faf7eb419");
INSERT INTO `wp_postmeta` VALUES("2138", "197", "text_2", "Celková kapacita DM je 106 míst. Žáci jsou ubytováni na pokojích po dvou (možnost volby spolubydlícího). Nabízíme také nadstandardní jednolůžkové pokoje žákům, kteří chtějí mít větší prostor pro studium. \r\nSoučástí každého patra je studovna a společenská místnost s TV SAT s 99 programy, sociální zázemí, sprchy a čajová kuchyňka s lednicí, mikrovlnnou troubou a rychlovarnou konvicí. Žáci mohou využívat připojení k bezdrátové vysokorychlostní síti. \r\n");
INSERT INTO `wp_postmeta` VALUES("2139", "197", "_text_2", "field_5d79faf8142b7");
INSERT INTO `wp_postmeta` VALUES("2140", "197", "obrazek_2", "16");
INSERT INTO `wp_postmeta` VALUES("2141", "197", "_obrazek_2", "field_5d79faf82c95d");
INSERT INTO `wp_postmeta` VALUES("2142", "197", "titulek_3", "Poplatky za ubytování a stravu");
INSERT INTO `wp_postmeta` VALUES("2143", "197", "_titulek_3", "field_5d79faf838cb0");
INSERT INTO `wp_postmeta` VALUES("2144", "197", "text_3", "Cena ubytování je 1 110 Kč pro dvoulůžkový pokoj.\r\nCena ubytování je 1 440 Kč nadstandartní jednolůžkový pokoj.\r\nCelodenní strava za měsíc činí 1 680 Kč (výběr ze dvou druhů jídel).\r\n");
INSERT INTO `wp_postmeta` VALUES("2145", "197", "_text_3", "field_5d79faf863c3a");
INSERT INTO `wp_postmeta` VALUES("2146", "197", "obrazek_3", "20");
INSERT INTO `wp_postmeta` VALUES("2147", "197", "_obrazek_3", "field_5d79faf87e9f0");
INSERT INTO `wp_postmeta` VALUES("2148", "197", "titulek_4", "Volnočasové a sportovní aktivity ");
INSERT INTO `wp_postmeta` VALUES("2149", "197", "_titulek_4", "field_5d79faf88e3f4");
INSERT INTO `wp_postmeta` VALUES("2150", "197", "text_4", "Žáci mohou navštěvovat:\r\n\r\n• školní kroužky – ROBOTIKA, CNC STROJÍRENSTVÍ, SPORTOVNÍ HRY,\r\n• kolektivní míčové sporty,\r\n• turnaj v bowlingu,\r\n• stolní tenis,\r\n• moderně vybavená posilovna,\r\n• boxovací místnost a rukavice,\r\n• šipkový automat,\r\n• půjčovna tenisových potřeb a venkovní hřiště,\r\n• půjčovna stolních her ad.\r\n\r\nVíce informací na: <a href=\"https://intr.spsoa.cz/\">https://intr.spsoa.cz/</a>");
INSERT INTO `wp_postmeta` VALUES("2151", "197", "_text_4", "field_5d79faf89e1e0");
INSERT INTO `wp_postmeta` VALUES("2152", "197", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("2153", "197", "_obrazek_4", "field_5d79faf8aeb84");
INSERT INTO `wp_postmeta` VALUES("2154", "197", "titulek_5", "");
INSERT INTO `wp_postmeta` VALUES("2155", "197", "_titulek_5", "field_5d79faf8d7fb5");
INSERT INTO `wp_postmeta` VALUES("2156", "197", "text_5", "");
INSERT INTO `wp_postmeta` VALUES("2157", "197", "_text_5", "field_5d79faf8e79b9");
INSERT INTO `wp_postmeta` VALUES("2158", "197", "obrazek_5", "");
INSERT INTO `wp_postmeta` VALUES("2159", "197", "_obrazek_5", "field_5d79faf91ac6a");
INSERT INTO `wp_postmeta` VALUES("2160", "197", "_edit_lock", "1569925344:1");
INSERT INTO `wp_postmeta` VALUES("2164", "198", "_wp_attached_file", "2019/09/internat.jpg");
INSERT INTO `wp_postmeta` VALUES("2165", "198", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:20:\"2019/09/internat.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"internat-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"internat-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"internat-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"internat-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2166", "199", "titulek", "Internát");
INSERT INTO `wp_postmeta` VALUES("2167", "199", "_titulek", "field_5d79faf7c1047");
INSERT INTO `wp_postmeta` VALUES("2168", "199", "text", "Domov mládeže (dále DM) je v areálu SPŠ a OA Bruntál. V blízkosti DM se nachází městský park, tělocvičny, Wellness centrum, kino a nedaleko také samotné centrum města s mnoha dalšími možnostmi vyžití. \r\nPoskytujeme žákům ubytování a volnočasové aktivity. ");
INSERT INTO `wp_postmeta` VALUES("2169", "199", "_text", "field_5d79faf7cf2da");
INSERT INTO `wp_postmeta` VALUES("2170", "199", "obrazek", "198");
INSERT INTO `wp_postmeta` VALUES("2171", "199", "_obrazek", "field_5d79faf7db62d");
INSERT INTO `wp_postmeta` VALUES("2172", "199", "titulek_2", "Ubytování");
INSERT INTO `wp_postmeta` VALUES("2173", "199", "_titulek_2", "field_5d79faf7eb419");
INSERT INTO `wp_postmeta` VALUES("2174", "199", "text_2", "Celková kapacita DM je 106 míst. Žáci jsou ubytováni na pokojích po dvou (možnost volby spolubydlícího). Nabízíme také nadstandardní jednolůžkové pokoje žákům, kteří chtějí mít větší prostor pro studium. \r\nSoučástí každého patra je studovna a společenská místnost s TV SAT s 99 programy, sociální zázemí, sprchy a čajová kuchyňka s lednicí, mikrovlnnou troubou a rychlovarnou konvicí. Žáci mohou využívat připojení k bezdrátové vysokorychlostní síti. \r\n");
INSERT INTO `wp_postmeta` VALUES("2175", "199", "_text_2", "field_5d79faf8142b7");
INSERT INTO `wp_postmeta` VALUES("2176", "199", "obrazek_2", "16");
INSERT INTO `wp_postmeta` VALUES("2177", "199", "_obrazek_2", "field_5d79faf82c95d");
INSERT INTO `wp_postmeta` VALUES("2178", "199", "titulek_3", "Poplatky za ubytování a stravu");
INSERT INTO `wp_postmeta` VALUES("2179", "199", "_titulek_3", "field_5d79faf838cb0");
INSERT INTO `wp_postmeta` VALUES("2180", "199", "text_3", "Cena ubytování je 1 110 Kč pro dvoulůžkový pokoj.\r\nCena ubytování je 1 440 Kč nadstandartní jednolůžkový pokoj.\r\nCelodenní strava za měsíc činí 1 680 Kč (výběr ze dvou druhů jídel).\r\n");
INSERT INTO `wp_postmeta` VALUES("2181", "199", "_text_3", "field_5d79faf863c3a");
INSERT INTO `wp_postmeta` VALUES("2182", "199", "obrazek_3", "20");
INSERT INTO `wp_postmeta` VALUES("2183", "199", "_obrazek_3", "field_5d79faf87e9f0");
INSERT INTO `wp_postmeta` VALUES("2184", "199", "titulek_4", "Volnočasové a sportovní aktivity ");
INSERT INTO `wp_postmeta` VALUES("2185", "199", "_titulek_4", "field_5d79faf88e3f4");
INSERT INTO `wp_postmeta` VALUES("2186", "199", "text_4", "Žáci mohou navštěvovat:\r\n\r\n• školní kroužky – ROBOTIKA, CNC STROJÍRENSTVÍ, SPORTOVNÍ HRY,\r\n• kolektivní míčové sporty,\r\n• turnaj v bowlingu,\r\n• stolní tenis,\r\n• moderně vybavená posilovna,\r\n• boxovací místnost a rukavice,\r\n• šipkový automat,\r\n• půjčovna tenisových potřeb a venkovní hřiště,\r\n• půjčovna stolních her ad.\r\n\r\nVíce informací na: <a href=\"https://intr.spsoa.cz/\">https://intr.spsoa.cz/</a>");
INSERT INTO `wp_postmeta` VALUES("2187", "199", "_text_4", "field_5d79faf89e1e0");
INSERT INTO `wp_postmeta` VALUES("2188", "199", "obrazek_4", "18");
INSERT INTO `wp_postmeta` VALUES("2189", "199", "_obrazek_4", "field_5d79faf8aeb84");
INSERT INTO `wp_postmeta` VALUES("2190", "199", "titulek_5", "");
INSERT INTO `wp_postmeta` VALUES("2191", "199", "_titulek_5", "field_5d79faf8d7fb5");
INSERT INTO `wp_postmeta` VALUES("2192", "199", "text_5", "");
INSERT INTO `wp_postmeta` VALUES("2193", "199", "_text_5", "field_5d79faf8e79b9");
INSERT INTO `wp_postmeta` VALUES("2194", "199", "obrazek_5", "");
INSERT INTO `wp_postmeta` VALUES("2195", "199", "_obrazek_5", "field_5d79faf91ac6a");
INSERT INTO `wp_postmeta` VALUES("2196", "8", "slider_0_slider-titulek", "Škola s přidanou hodnotou");
INSERT INTO `wp_postmeta` VALUES("2197", "8", "_slider_0_slider-titulek", "field_5d9333b08e276");
INSERT INTO `wp_postmeta` VALUES("2198", "8", "slider_1_slider-titulek", "Jsme jiní, jdeme s dobou");
INSERT INTO `wp_postmeta` VALUES("2199", "8", "_slider_1_slider-titulek", "field_5d9333b08e276");
INSERT INTO `wp_postmeta` VALUES("2200", "8", "slider_2_slider-titulek", "Propojení teorie s praxí");
INSERT INTO `wp_postmeta` VALUES("2201", "8", "_slider_2_slider-titulek", "field_5d9333b08e276");
INSERT INTO `wp_postmeta` VALUES("2202", "8", "slider_3_slider-titulek", "Vstřícné a přátelské prostředí");
INSERT INTO `wp_postmeta` VALUES("2203", "8", "_slider_3_slider-titulek", "field_5d9333b08e276");
INSERT INTO `wp_postmeta` VALUES("2204", "208", "sekce_leva", "2");
INSERT INTO `wp_postmeta` VALUES("2205", "208", "_sekce_leva", "field_5d5d07b4d479a");
INSERT INTO `wp_postmeta` VALUES("2206", "208", "slider_0_slider_image", "136");
INSERT INTO `wp_postmeta` VALUES("2207", "208", "_slider_0_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("2208", "208", "slider_1_slider_image", "133");
INSERT INTO `wp_postmeta` VALUES("2209", "208", "_slider_1_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("2210", "208", "slider", "4");
INSERT INTO `wp_postmeta` VALUES("2211", "208", "_slider", "field_5d5d0c0f3fabf");
INSERT INTO `wp_postmeta` VALUES("2212", "208", "slider_2_slider_image", "135");
INSERT INTO `wp_postmeta` VALUES("2213", "208", "_slider_2_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("2214", "208", "slider_3_slider_image", "134");
INSERT INTO `wp_postmeta` VALUES("2215", "208", "_slider_3_slider_image", "field_5d5d0c1f3fac0");
INSERT INTO `wp_postmeta` VALUES("2216", "208", "sekce_leva_0_obrazek", "16");
INSERT INTO `wp_postmeta` VALUES("2217", "208", "_sekce_leva_0_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("2218", "208", "sekce_leva_0_titulek", "1.	Náš druhý domov");
INSERT INTO `wp_postmeta` VALUES("2219", "208", "_sekce_leva_0_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("2220", "208", "sekce_leva_0_text", "Pokoje jsou dvoulůžkové (spolubydlícího stejného pohlaví si můžeš vybrat) nebo nadstandardní jednolůžkové.\r\n\r\nVolnočasové aktivity, bezdrátová síť, společenská místnost s TV SAT s 99 programy jsou samozřejmostí.\r\n\r\nP.S.: Holky jsou o patro níž/kluci jsou o patro výš ?");
INSERT INTO `wp_postmeta` VALUES("2221", "208", "_sekce_leva_0_text", "field_5d5d07e3d479c");
INSERT INTO `wp_postmeta` VALUES("2222", "208", "sekce_leva_1_obrazek", "15");
INSERT INTO `wp_postmeta` VALUES("2223", "208", "_sekce_leva_1_obrazek", "field_5d5d07d5d479b");
INSERT INTO `wp_postmeta` VALUES("2224", "208", "sekce_leva_1_titulek", "Tady chillujem");
INSERT INTO `wp_postmeta` VALUES("2225", "208", "_sekce_leva_1_titulek", "field_5d5d08c6d6570");
INSERT INTO `wp_postmeta` VALUES("2226", "208", "sekce_leva_1_text", "Dobíjíme baterky, posloucháme hudbu a řešíme spoustu důležitého … mimoškolního.\r\n\r\nNěkteří jedinci řeší výsledek matematické olympiády, ostatní, co si dají zítra na o