<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function understrap_remove_scripts() {
    wp_dequeue_style( 'understrap-styles' );
    wp_deregister_style( 'understrap-styles' );

    wp_dequeue_script( 'understrap-scripts' );
    wp_deregister_script( 'understrap-scripts' );

    // Removes the parent themes stylesheet and scripts from inc/enqueue.php
}
add_action( 'wp_enqueue_scripts', 'understrap_remove_scripts', 20 );

add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {

	// Get the theme data
	$the_theme = wp_get_theme();
    wp_enqueue_style( 'child-understrap-styles', get_stylesheet_directory_uri() . '/css/child-theme.min.css', array(), $the_theme->get( 'Version' ) );
    
    wp_enqueue_style( 'layout', get_stylesheet_directory_uri() . '/css/layout.css',false,'1.1','all');
    wp_enqueue_style( 'flickity', get_stylesheet_directory_uri() . '/css/flickity.css',false,'1.1','all');
    wp_enqueue_style( 'yamm', get_stylesheet_directory_uri() . '/css/yamm.css',false,'1.1','all');

    wp_enqueue_script( 'jquery');
    wp_enqueue_script( 'child-understrap-scripts', get_stylesheet_directory_uri() . '/js/child-theme.min.js', array(), $the_theme->get( 'Version' ), true );
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}

function add_child_theme_textdomain() {
    load_child_theme_textdomain( 'understrap-child', get_stylesheet_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'add_child_theme_textdomain' );


function flickity_slider() {
    wp_register_script('flickity_slide', get_stylesheet_directory_uri() . '/js/flickity.js', array('jquery'),'1.1', true);
    wp_enqueue_script('flickity_slide');
} 

add_action( 'wp_enqueue_scripts', 'flickity_slider', 999 );

function flickity_carousel() {
    wp_register_script('flickity_slide_top', get_stylesheet_directory_uri() . '/js/carousel.js', array('jquery'),'1.1', true);
    wp_enqueue_script('flickity_slide_top');
} 

add_action( 'wp_enqueue_scripts', 'flickity_carousel', 999 );


function smooth() {
    wp_register_script('smooth_sc', get_stylesheet_directory_uri() . '/js/smooth.js', array('jquery'),'1.1', true);
    wp_enqueue_script('smooth_sc');
} 

add_action( 'wp_enqueue_scripts', 'smooth', 999 );

function simplepara() {
    wp_register_script('simplepara', get_stylesheet_directory_uri() . '/js/simpleParallax.min.js', array('jquery'),'1.1', true);
    wp_enqueue_script('simplepara');
} 

add_action( 'wp_enqueue_scripts', 'simplepara', 999 );


function parallax() {
    wp_register_script('parallax', get_stylesheet_directory_uri() . '/js/parallax.js', array('jquery'),'1.1', true);
    wp_enqueue_script('parallax');
} 

add_action( 'wp_enqueue_scripts', 'parallax', 999 );

function scrollpos() {
    wp_register_script('scrollpos', get_stylesheet_directory_uri() . '/js/scrollPosStyler.min.js', array('jquery'),'1.1', true);
    wp_enqueue_script('scrollpos');
} 

add_action( 'wp_enqueue_scripts', 'scrollpos', 999 );


function flick() {
    wp_register_script('flick', get_stylesheet_directory_uri() . '/js/flick.js', array('jquery'),'1.1', true);
    wp_enqueue_script('flick');
} 

add_action( 'wp_enqueue_scripts', 'flick', 999 );


function video() {
    wp_register_script('video', get_stylesheet_directory_uri() . '/js/video.js', array('jquery'),'1.1', true);
    wp_enqueue_script('video');
} 

add_action( 'wp_enqueue_scripts', 'video', 999 );
