<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package understrap
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$container = get_theme_mod( 'understrap_container_type' );
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="profile" href="http://gmpg.org/xfn/11">

    <link rel="apple-touch-icon" sizes="76x76" href="/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
    <link rel="manifest" href="/site.webmanifest">
    <link rel="mask-icon" href="/safari-pinned-tab.svg" color="#5bbad5">
    <meta name="msapplication-TileColor" content="#da532c">
    <meta name="theme-color" content="#000">


    <?php wp_head(); ?>
    <script>
        var $ = jQuery.noConflict();

    </script>

</head>

<body <?php body_class(); ?>>
    <?php do_action( 'wp_body_open' ); ?>
    <div class="site" id="page">

        <!-- ******************* The Navbar Area ******************* -->
        <div id="wrapper-navbar" itemscope itemtype="http://schema.org/WebSite">

            <a class="skip-link sr-only sr-only-focusable" href="#content">
                <?php esc_html_e( 'Skip to content', 'understrap' ); ?></a>

            <nav class="navbar fixed-top  sps-nav-obor navbar-expand-lg">
                <a class="navbar-brand" href="<?php echo get_site_url(); ?>"><img class="img-fluid sps-nav-logo" src="<?php echo get_stylesheet_directory_uri(); ?>/img/sps-logo.png"></a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#nv-navbar" aria-controls="nv-navbar" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"><svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="#fff" stroke-width="2" stroke-linecap="round" stroke-linejoin="arcs">
                            <line x1="3" y1="12" x2="21" y2="12"></line>
                            <line x1="3" y1="6" x2="21" y2="6"></line>
                            <line x1="3" y1="18" x2="21" y2="18"></line>
                        </svg></span>
                </button>

                <div class="collapse navbar-collapse" id="nv-navbar">
                    <ul class="navbar-nav ml-auto">
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo get_site_url(); ?>/o-skole">O škole</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo get_site_url(); ?>/obory">Obory</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo get_site_url(); ?>/internat">Internát</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo get_site_url(); ?>/kontakty">Kontakty</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href=""><img class="img-fluid sps-nav-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/img/fb.svg"></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href=""><img class="img-fluid sps-nav-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/img/you.svg"></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href=""><img class="img-fluid sps-nav-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/img/ig.svg"></a>
                        </li>
                    </ul>
                </div>
            </nav>

        </div>
